<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
//---------------------------------------------------------------------------------------------------

function display_grn_summary(&$po)
{
	global $Refs;
    /*Start Chnages for Wrkmash*/
	start_row_div($extra="");
	row_col_div($cols=12,$number=1,$extra="");
	echo "<tr><td valign=top>"; // outer table
	echo '<div class="table-responsive">';
	/*End Chnages for Wrkmash*/
	start_table(TABLESTYLE2, "width='90%'");

    start_row();
	label_cells(_("Supplier : "), $po->supplier_name, "class='tableheader2'");

    if (!is_company_currency($po->curr_code))
    	label_cells(_("Order Currency : "), $po->curr_code, "class='tableheader2'");
	/*Start Chnages for Wrkmash*/
	else
	label_cells("", "", "class='tableheader2'");
	/*End Chnages for Wrkmash*/		

    label_cells(_("For Purchase Order : "), get_trans_view_str(ST_PURCHORDER, $po->order_no),
    	"class='tableheader2'");

	label_cells(_("Ordered On : "), $po->orig_order_date, "class='tableheader2'");
	end_row();

   	start_row();
   	label_cells(_("Reference : "), $po->reference, "class='tableheader2'");
   	label_cells(_("Deliver Into Location : "), get_location_name($po->Location), "class='tableheader2'");
	label_cells(_("Supplier's Reference : "), $po->supp_ref, "class='tableheader2'");
	label_cells("", "", "class='tableheader2'");
    end_row();

   	label_row(_("Delivery Address : "), $po->delivery_address, "class='tableheader2'", "colspan=9");

    if ($po->Comments != "")
    	label_row(_("Order Comments : "), $po->Comments, "class='tableheader2'", "colspan=9");
	/*Start Chnages for Wrkmash*/
	//end_table(1);
	end_table(0);
	echo "</div></td></tr>";
	end_row_div($extra="");
	/*End Chnages for Wrkmash*/
}

function edit_grn_summary(&$po)
{
	global $Refs;

	/*Start Wrkmash Changes */
	//start_outer_table(TABLESTYLE2, "width='80%'");
	start_row_div();
	/*Start Wrkmash Changes */

	/*Start Wrkmash Changes */
	//table_section(1);
	row_col_div(4,1);
	/*Start Wrkmash Changes */
		label_row(_("Supplier"), $po->supplier_name);

    	if (!is_company_currency($po->curr_code))
    		label_row(_("Order Currency"), $po->curr_code);

	    label_row(_("For Purchase Order"), get_trans_view_str(ST_PURCHORDER, $po->order_no));

		label_row(_("Ordered On"), $po->orig_order_date);

	/*Start Wrkmash Changes */
	//table_section(2);
	row_col_div(4,2);
	/*Start Wrkmash Changes */
    	if (!isset($_POST['ref']))
    	    $_POST['ref'] = $Refs->get_next(ST_SUPPRECEIVE);
    	ref_row(_("Reference"), 'ref', '', null);

        if (!isset($_POST['Location']))
        	$_POST['Location'] = $po->Location;

        locations_list_row(_("Deliver Into Location"), "Location", $_POST['Location']);

    	if (!isset($_POST['DefaultReceivedDate']))
     	  	$_POST['DefaultReceivedDate'] = new_doc_date();

    	date_row(_("Date Items Received"), 'DefaultReceivedDate', '', true, 0, 0, 0, '', true);

	/*Start Wrkmash Changes */
	//table_section(3);
	row_col_div(4,3);
	/*Start Wrkmash Changes */
		// currently this is related order supp reference
//		ref_row(_("Supplier's Reference"), 'supp_ref', _("Supplier's Reference"));
		label_row(_("Supplier's Reference"), $po->supp_ref);

	   	label_row(_("Delivery Address"), $po->delivery_address);

    	if ($po->Comments != "")
    		label_row(_("Order Comments"), $po->Comments, "class='tableheader2'", "colspan=9");

	    if (!is_company_currency($po->curr_code))
			exchange_rate_display(get_company_currency(), $po->curr_code, get_post('DefaultReceivedDate'));
	/*Start Wrkmash Changes */
	//end_outer_table(1); // outer table
	end_row_div();
	echo "<hr>";
	/*Start Wrkmash Changes */
}

?>