<?php
require_once ("secure_area.php");
require_once ("interfaces/idata_controller.php");
class Items extends Secure_area implements iData_controller
{
	public $store;
	function __construct()
	{
		parent::__construct('items');
		$this->load->library('pagination');
		
		list($store_id,$store_name) = explode(",",$this->session->userdata('store'));
		
		if($store_name=="main" || $store_name=="")
		$this->store = "items";
		else
		$this->store = $store_name.'_storeitems';
		
		$this->Item->setStore($this->store);
		
	}

	function index()
	{
		//echo $this->store;
		$data['controller_name']=strtolower($this->uri->segment(1));
		$data['form_width']=$this->get_form_width();
		
		if($this->input->post('source_store')!="")
		{
			//list($source_store_id,$source_store)=split("_",$this->input->post('source_store'));
			//$data['manage_table']=get_items_manage_table($this->Item->get_StoreItems($source_store),$this,$source_store);
			//$total_rows = $this->Item->get_StoreItems($source_store)->num_rows();
			$all_items = $this->Item->get_StoreItems($source_store);
			if(!empty($all_items))
			$total_rows = $all_items->num_rows();//print_r($total_rows);
			else
			$total_rows = 0;
		}
		else
		{
			//$source_store="";
			//$data['manage_table']=get_items_manage_table($this->Item->get_all(),$this);
			$all_items = $this->Item->get_all();
			if(!empty($all_items))
			$total_rows = $all_items->num_rows();//print_r($total_rows);
			else
			$total_rows = 0;
;		}
		
		$config['base_url'] = site_url($this->uri->segment(1)."/index");
		//$config['base_url'] = base_url() . $this->uri->segment(1)."/index";
		$config['total_rows'] = $total_rows;
		$config['per_page'] = 20;
		$config['num_links'] = 5;
		$config['uri_segment'] = 3;
		$config['use_page_numbers'] = TRUE;
		$config['page_query_string'] = FALSE;
		$config['enable_query_strings']  = FALSE;
		
		$this->pagination->initialize($config);
		
		$page = ($this->uri->segment(3))? $this->uri->segment(3) : 0;
		
		//$data["results"] = $this->Countries->fetch_countries($config["per_page"], $page);
		if($this->input->post('source_store')!="")
		{
			list($source_store_id,$source_store)=split("_",$this->input->post('source_store'));
			$data['manage_table']=get_items_manage_table($this->Item->get_StoreItems($source_store),$this,$source_store);
		}
		else
		{
			$source_store="";
			$data['manage_table']=get_items_manage_table($this->Item->get_all($config["per_page"], $page,1),$this);
		}

		$data['source_store']=$source_store;
		
		$this->config->set_item('enable_query_strings', FALSE);
		$data['pagination']= $this->pagination->create_links();
		
		
		$this->load->view('items/manage',$data);
	}

	function printlabels()
	{
		//echo $this->store;
		$data['controller_name']=strtolower($this->uri->segment(1));
		$data['form_width']=$this->get_form_width();
		//print_r($this->Item->get_all());
		if($this->input->post('source_store')!="")
		{
			list($source_store_id,$source_store)=split("_",$this->input->post('source_store'));
			$data['manage_table']=get_printlabelsitems_manage_table($this->Item->get_StoreItems($source_store),$this,$source_store);
		}
		else
		{
			$source_store="";
			$data['manage_table']=get_printlabelsitems_manage_table($this->Item->get_all(),$this);
		}
		
		$data['source_store']=$source_store;
		
		$this->load->view('items/manage_printlabels',$data);
	}
	
	function print_export()
	{
		$temp = $this->input->post('html_content');
		$pdfFilePath = FCPATH."/downloads/reports/a.pdf";
		if (file_exists($pdfFilePath) == FALSE)
		{
			//ini_set('memory_limit','32M');
			$html = $temp;//print_r($html);exit;
			$this->load->library('pdf');
			$pdf = $this->pdf->load();
			//$pdf->SetFooter($_SERVER['HTTP_HOST'].'|{PAGENO}|'.date(DATE_RFC822));
			//$pdf->WriteHTML('<pagebreak sheet-size="Letter" />');
			$pdf->WriteHTML($html); // write the HTML into the PDF
			$pdf->Output('opos_label.pdf'); // save to file because we can
			exit;
		}
		redirect("/downloads/reports/$filename.pdf");
	}


	function refresh()
	{
		$low_inventory=0;
	
		$is_serialized=0;
		$no_description=0;
		$instock=0;
		$outstock=0;
		$negstock=0;
		$fastmov=0;
		$slowmov=0;
		$nonmov=0;
		$all_mov=0;
		
	/*	$this->output->enable_profiler(TRUE);*/
		
		
		
		
	/*	$low_inventory=$this->input->post('low_inventory');
		$low_inventory=$this->input->post('low_inventory');
		$is_serialized=$this->input->post('is_serialized');
		$no_description=$this->input->post('no_description');
		$instock=$this->input->post('in_stock');
		$outstock=$this->input->post('out_stock');
		$negstock=$this->input->post('neg_stock');
		$fastmov=$this->input->post('fast_mov');
		$slowmov=$this->input->post('slow_mov');
		$nonmov=$this->input->post('no_mov');
		*/
/*
		$data['search_section_state']=$this->input->post('search_section_state');
		$data['low_inventory']=$this->input->post('low_inventory');
		$data['is_serialized']=$this->input->post('is_serialized');
		$data['no_description']=$this->input->post('no_description');
		$data['in_stock']=$this->input->post('in_stock');
		$data['out_stock']=$this->input->post('out_stock');
		$data['neg_stock']=$this->input->post('neg_stock');
		$data['fast_mov']=$this->input->post('fast_mov');
		$data['slow_mov']=$this->input->post('slow_mov');
		$data['no_mov']=$this->input->post('no_mov');*/
		
		if($this->input->post('manage_inventory')=='all_mov')
		 {
		 
		 $all_mov=1;
		 }
	
	else	 if($this->input->post('manage_inventory')=='low_inventory')
		 {
		
		 $low_inventory=1;
		 }
	
	       else  if($this->input->post('manage_inventory')=='is_serialized')
		   {
		
		 $is_serialized=1;
		 
		   }
		   
	
		else if($this->input->post('manage_inventory')=='no_description')
		{
		
		 $no_description=1;
		}
		
		
		else  if($this->input->post('manage_inventory')=='in_stock')
		{
		
		 
		 $instock=1;
		}
		 
		  if($this->input->post('manage_inventory')=='out_stock') 
		  {
		
		$outstock=1;
		  }
		  
		  
		 
		else  if($this->input->post('manage_inventory')=='neg_stock')
		{
			
		 
		$negstock=1;
		}
		
		
		else  if($this->input->post('manage_inventory')=='fast_mov')
		{
		
		$fastmov=1;
		}
		
		
		else  if($this->input->post('manage_inventory')=='slow_mov')
		{
		
		$slowmov=1;
		}
		
		else if($this->input->post('manage_inventory')=='no_mov')
		{
		
		 $nonmov=1;
		 
		}
		
		
		$data['low_inventory']=$low_inventory;
		$data['is_serialized']=$is_serialized;
		$data['no_description']=$no_description;
		$data['in_stock']=	$instock;
		$data['out_stock']=$outstock;
		$data['neg_stock']=$negstock;
		$data['fast_mov']=$fastmov;
		$data['slow_mov']=$slowmov;
		$data['no_mov']=$nonmov;
		$data['all_mov']=$all_mov;
		
		
		$data['search_section_state']=$this->input->post('search_section_state');
		
		
	
		
		$data['controller_name']=strtolower($this->uri->segment(1));
		$data['form_width']=$this->get_form_width();
		
		if($this->input->post('manage_inventory')=='all_mov')
		 {
		$data['manage_table']=get_items_manage_table($this->Item->get_all(),$this);
		
		$this->load->view('items/manage',$data);

		 }
		 else {
		
		$this->Item->getfiltered($low_inventory,$is_serialized,$no_description,$instock,$outstock,$negstock,$fastmov,$slowmov,$nonmov);
		
	$data['manage_table']=get_items_manage_table($this->Item->getfiltered($low_inventory,$is_serialized,$no_description,$instock,$outstock,$negstock,$fastmov,$slowmov,$nonmov),$this);
		$this->load->view('items/manage',$data);
		
		 }
	}

	function find_item_info()
	{
		$item_number=$this->input->post('scan_item_number');
		echo json_encode($this->Item->find_item_info($item_number));
	}

	function search()
	{
		$search=$this->input->post('search');
		$source_store=$this->input->post('source_store');
		if($source_store=="None" || $source_store=="main")
		{
		$data_rows=get_items_manage_table_data_rows($this->Item->search($search),$this);
		}
		else
		{
		$data_rows=get_items_manage_table_data_rows($this->Item->searchStoreItem($source_store,$search),$this,$source_store);	
		}
		//$data_rows=get_items_manage_table_data_rows($this->Item->search($search),$this);
		echo $data_rows;
	}

	/*
	Gives search suggestions based on what is being searched for
	*/
	function suggest()
	{
		$suggestions = $this->Item->get_search_suggestions($this->input->post('q'),$this->input->post('limit'));
		echo implode("\n",$suggestions);
	}

	/*
	Gives search suggestions based on what is being searched for
	*/
	function suggest_category()
	{
		$suggestions = $this->Item->get_category_suggestions($this->input->post('q'));
		echo implode("\n",$suggestions);
	}

	function get_row()
	{
		$item_id = $this->input->post('row_id');
		$source_store = $this->input->post('source_store');
		if($source_store=="None" || $source_store=="main")
		{
		$data_row=get_item_data_row($this->Item->get_info($item_id),$this,$source_store);
		}
		else
		{
		$data_row=get_item_data_row($this->Item->get_Store_info($source_store,$item_id),$this,$source_store);	
		//$data['item_info']=$this->Item->get_Store_info($source_store,$item_id);
		}
		
		echo $data_row;
	}

	function view($item_id=-1,$width=-1,$source_store=-1)
	{
		//echo $source_store;
		if($source_store=="None" || $source_store=="main")
		{
		$data['item_info']=$this->Item->get_info($item_id);	
		}
		else
		{
		$data['item_info']=$this->Item->get_Store_info($source_store,$item_id);
		}
		$data['item_tax_info']=$this->Item_taxes->get_info($item_id);
		$suppliers = array('' => $this->lang->line('items_none'));
		foreach($this->Supplier->get_all()->result_array() as $row)
		{
			$suppliers[$row['person_id']] = $row['company_name'] .' ('.$row['first_name'] .' '. $row['last_name'].')';
		}

		$data['suppliers']=$suppliers;
		$data['selected_supplier'] = $this->Item->get_info($item_id)->supplier_id;
		
		
		
		$categories = array('' => $this->lang->line('items_none'));
		foreach($this->Item->get_category()->result_array() as $row)
		{
			$categories[$row['id']] = $row['title'];
		}

		$data['categories']=$categories;
		$data['selected_category'] = $this->Item->get_info($item_id)->category_id;
		
		
		///// get Attribute for form /////////////
		
		
		//$attributes = array('' => $this->lang->line('items_none'));
		//$data['attributes']=$this->Item->get_attributes()->result();
		
		
		
	     foreach($this->Item->get_attributes()->result() as $row)
		  {
			
	    
		 
		  	$fields = array('id' , 'title' ,'parent','deleted');
		  
		   	foreach ($fields as $field) 
		   		{ 
                	$attributes[$row->id][$field] = $row->$field; 					 
                } 
		  
				  foreach($this->Item->get_option($row->id)->result() as $row2)
				  {
				
						foreach ($fields as $field) 
							{ 
							$attributes[$row->id]['option'][$row2->id][$field] = $row2->$field;
							
							} 
					
					
					//print_r($attributes_val);
					$data['attributes']=$attributes;
					$data['selected_attributes_val'] = $this->Item->get_info($item_id)->attribute_id;
				  }
		
		
	    }
		//echo "<pre>";	   
//		print_r($attributes);	
//		echo "</pre>";   
		/////////////////////////////////////////
		
		
		
		
		$data['default_tax_1_rate']=($item_id==-1) ? $this->Appconfig->get('default_tax_1_rate') : '';
		$data['default_tax_2_rate']=($item_id==-1) ? $this->Appconfig->get('default_tax_2_rate') : '';
		$data['source_store']=($source_store!=-1) ? $source_store : '';
		//$data['source_store_item']=($source_store!=-1) ? $this->Item->get_Store_Item($source_store,$item_id) : '';
		
		
		$this->load->view("items/form",$data);
	}
	
	//Ramel Inventory Tracking
	function inventory($item_id=-1)
	{
		$data['item_info']=$this->Item->get_info($item_id);
		$this->load->view("items/inventory",$data);
	}
	
	function count_details($item_id=-1)
	{
		$data['item_info']=$this->Item->get_info($item_id);
		$this->load->view("items/count_details",$data);
	} //------------------------------------------- Ramel
	
	function barcodesoptions($width=-1,$height=-1)
	{
		$result = array();

		/*$item_ids = explode(',', $item_ids);
		foreach ($item_ids as $item_id)
		{
			$item_info = $this->Item->get_info($item_id);

			$result[] = array('name' =>$item_info->name, 'id'=> $item_id,'item_number'=> $item_info->item_number,'item_price'=> $item_info->cost_price);
		}*/

		$data['items'] = array();
		$this->load->view("items/barcodesoptions", $data);
	}
	
	function generate_barcodes($item_ids)
	{
		$result = array();

		$item_ids = explode(',', $item_ids);
		foreach ($item_ids as $item_id)
		{
			$item_info = $this->Item->get_info($item_id);

			$result[] = array('name' =>$item_info->name, 'id'=> $item_id,'item_number'=> $item_info->item_number,'item_price'=> $item_info->cost_price);
			
		}

		$data['items'] = $result;
		$this->load->view("barcode_sheet", $data);
	}
	
	function generate_barcodes_withoptions()
	{
		$result = array();

		$barcode_type = $this->input->post('barcode_type');
		$optional_item = $this->input->post('optional_item');
		$optional_item_quantity = $this->input->post('optional_item_quantity');//exit;
		$item_ids = explode(',', $this->input->post('items_ids'));
		$items_ids_number = explode(',', $this->input->post('items_ids_number'));
		//print_r($items_ids_number);
		foreach ($items_ids_number as $item_id)
		{
			
			$itemArray = explode('|', $item_id);
			$item_info = $this->Item->get_info($itemArray[0]);

			$result[] = array('name' =>$item_info->name, 'id'=> $itemArray[0],'item_number'=> $item_info->item_number,'item_price'=> $item_info->cost_price,'barcode_type'=> $barcode_type,'printlabels_number'=> $itemArray[1]);
		}
		//echo "<pre>";
		//print_r($result);
		$data['barcode_type'] = $barcode_type;
		$data['optional_item'] = $optional_item;
		$data['optional_item_quantity'] = $optional_item_quantity;
		$data['items'] = $result;
		
		$this->load->view("barcode_sheet", $data);
	}
	
	function savebarcodeimages()
	{
		$result = array();

		$barcode_type = $this->input->post('barcode_type');
		$item_ids = explode(',', $this->input->post('items_ids'));
		$items_ids_number = explode(',', $this->input->post('items_ids_number'));
		//print_r($items_ids_number);
		
		foreach ($items_ids_number as $item_id)
		{
			
			$itemArray = explode('|', $item_id);
			$item_info = $this->Item->get_info($itemArray[0]);

			$result[] = array('name' =>$item_info->name, 'id'=> $itemArray[0],'item_number'=> $item_info->item_number,'item_price'=> $item_info->cost_price,'barcode_type'=> $barcode_type,'printlabels_number'=> $itemArray[1]);
		}
		//echo "<pre>";
		//print_r($result);
		$data['barcode_type'] = $barcode_type;
		$data['items'] = $result;
		$shopname = $this->session->userdata('shopname');
		foreach($result as $key=>$item)
		{
			
			$barcode = $item['id'];
			$text = $item['name'];
			//$text = ereg_replace("'","&#39;",$text);
			$UPC = $item['item_number'];
			$item_price = $item['item_price'];
			$barcode_type = $item['barcode_type'];
				
			
			
			//echo $barcodeimage = "<img src='index.php?c=barcode&barcode=$barcode&text=$text&UPC=$UPC&item_price=$item_price&shopname=$shopname&width=247&height=85'   style='margin-top:3px;margin-left:2px'/>";
			$folderpath = $_SERVER['DOCUMENT_ROOT'].'/app/application/barcodimages/'.$shopname;
			if (!file_exists($folderpath)) 
			{
			
				mkdir($folderpath);
			
			} 
			require_once($_SERVER['DOCUMENT_ROOT'].'/app/application/views/barcode.php');
			Barcode39 ($barcode, $width="247", $height="85", $quality="100", $format="JPEG", $text,$UPC,$item_price,$shopname);
			
			
			
			
		}
		
		//$this->load->view("generate_barcode_images", $data);
	}


	function bulk_edit()
	{
		$data = array();
		$suppliers = array('' => $this->lang->line('items_none'));
		foreach($this->Supplier->get_all()->result_array() as $row)
		{
			$suppliers[$row['person_id']] = $row['first_name'] .' '. $row['last_name'];
		}
		$data['suppliers'] = $suppliers;
		$data['allow_alt_desciption_choices'] = array(
			''=>$this->lang->line('items_do_nothing'), 
			1 =>$this->lang->line('items_change_all_to_allow_alt_desc'),
			0 =>$this->lang->line('items_change_all_to_not_allow_allow_desc'));
				
		$data['serialization_choices'] = array(
			''=>$this->lang->line('items_do_nothing'), 
			1 =>$this->lang->line('items_change_all_to_serialized'),
			0 =>$this->lang->line('items_change_all_to_unserialized'));
		$this->load->view("items/form_bulk", $data);
	}

	function save($item_id=-1)
	{
		$item_data = array(
		'name'=>$this->input->post('name'),
		'description'=>$this->input->post('description'),
		'category'=>$this->input->post('category'),
		'category_id'=>$this->input->post('category_id')=='' ? null:$this->input->post('category_id'),
		'attribute_id'=>$this->input->post('attributes_str'),
		'supplier_id'=>$this->input->post('supplier_id')=='' ? null:$this->input->post('supplier_id'),
		'item_number'=>$this->input->post('item_number')=='' ? null:$this->input->post('item_number'),
		'cost_price'=>$this->input->post('cost_price'),
		'retailprice'=>$this->input->post('retailprice'),
	//	'unit_price'=>$this->input->post('retailprice'),
		'unit_price'=>$this->input->post('unit_price'),
		'quantity'=>$this->input->post('quantity'),
		'reorder_level'=>$this->input->post('reorder_level'),
		'allow_alt_description'=>$this->input->post('allow_alt_description'),
		'is_serialized'=>$this->input->post('is_serialized')
		);
		
		$source_store = $this->input->post('source_store');
		
		$employee_id=$this->Employee->get_logged_in_employee_info()->person_id;
		$cur_item_info = $this->Item->get_info($item_id);
		//print_r($this->Item->save($item_data,$item_id,$source_store));exit;
		if($this->Item->save($item_data,$item_id,$source_store))
		{
			//New item
			if($item_id==-1)
			{
				echo json_encode(array('success'=>true,'message'=>$this->lang->line('items_successful_adding').' '.
				$item_data['name'],'item_id'=>$item_data['item_id'],'source_store'=>$source_store));
				$item_id = $item_data['item_id'];
			}
			else //previous item
			{
				echo json_encode(array('success'=>true,'message'=>$this->lang->line('items_successful_updating').' '.
				$item_data['name'],'item_id'=>$item_id,'source_store'=>$source_store));
			}
			
			$inv_data = array
			(
				'trans_date'=>date('Y-m-d H:i:s'),
				'trans_items'=>$item_id,
				'trans_user'=>$employee_id,
				'trans_price'=>$this->input->post('retailprice'),
				'trans_comment'=>$this->lang->line('items_manually_editing_of_quantity'),
				'trans_inventory'=>$cur_item_info ? $this->input->post('quantity') - $cur_item_info->quantity : $this->input->post('quantity')
			);
			$this->Inventory->insert($inv_data);
			$items_taxes_data = array();
			$tax_names = $this->input->post('tax_names');
			$tax_percents = $this->input->post('tax_percents');
			for($k=0;$k<count($tax_percents);$k++)
			{
				if (is_numeric($tax_percents[$k]))
				{
					$items_taxes_data[] = array('name'=>$tax_names[$k], 'percent'=>$tax_percents[$k] );
				}
			}
			
			$this->Item_taxes->save($items_taxes_data, $item_id);
		}
		else//failure
		{
			echo json_encode(array('success'=>false,'message'=>$this->lang->line('items_error_adding_updating').' '.
			$item_data['name'],'item_id'=>-1,'source_store'=>$source_store));
		}

	}
	
	//Ramel Inventory Tracking
	function save_inventory($item_id=-1)
	{	
		$employee_id=$this->Employee->get_logged_in_employee_info()->person_id;
		$cur_item_info = $this->Item->get_info($item_id);
		$inv_data = array
		(
			'trans_date'=>date('Y-m-d H:i:s'),
			'trans_items'=>$item_id,
			'trans_user'=>$employee_id,
			'trans_comment'=>$this->input->post('trans_comment'),
			'trans_inventory'=>$this->input->post('newquantity')
		);
		$this->Inventory->insert($inv_data);
		
		//Update stock quantity
		$item_data = array(
		'quantity'=>$cur_item_info->quantity + $this->input->post('newquantity')
		);
		if($this->Item->save($item_data,$item_id))
		{			
			echo json_encode(array('success'=>true,'message'=>$this->lang->line('items_successful_updating').' '.
			$cur_item_info->name,'item_id'=>$item_id));
		}
		else//failure
		{	
			echo json_encode(array('success'=>false,'message'=>$this->lang->line('items_error_adding_updating').' '.
			$cur_item_info->name,'item_id'=>-1));
		}

	}//---------------------------------------------------------------------Ramel

	function bulk_update()
	{
		$items_to_update=$this->input->post('item_ids');
		$item_data = array();

		foreach($_POST as $key=>$value)
		{
			//This field is nullable, so treat it differently
			if ($key == 'supplier_id')
			{
				$item_data["$key"]=$value == '' ? null : $value;
			}
			elseif($value!='' and !(in_array($key, array('item_ids', 'tax_names', 'tax_percents'))))
			{
				$item_data["$key"]=$value;
			}
		}

		//Item data could be empty if tax information is being updated
		if(empty($item_data) || $this->Item->update_multiple($item_data,$items_to_update))
		{
			$items_taxes_data = array();
			$tax_names = $this->input->post('tax_names');
			$tax_percents = $this->input->post('tax_percents');
			for($k=0;$k<count($tax_percents);$k++)
			{
				if (is_numeric($tax_percents[$k]))
				{
					$items_taxes_data[] = array('name'=>$tax_names[$k], 'percent'=>$tax_percents[$k] );
				}
			}
			$this->Item_taxes->save_multiple($items_taxes_data, $items_to_update);

			echo json_encode(array('success'=>true,'message'=>$this->lang->line('items_successful_bulk_edit')));
		}
		else
		{
			echo json_encode(array('success'=>false,'message'=>$this->lang->line('items_error_updating_multiple')));
		}
	}

	function delete()
	{
		$items_to_delete=$this->input->post('ids');

		if($this->Item->delete_list($items_to_delete))
		{
			echo json_encode(array('success'=>true,'message'=>$this->lang->line('items_successful_deleted').' '.
			count($items_to_delete).' '.$this->lang->line('items_one_or_multiple')));
		}
		else
		{
			echo json_encode(array('success'=>false,'message'=>$this->lang->line('items_cannot_be_deleted')));
		}
	}
	
	
	function deletecate()
	{
		 $items_to_delete=$this->input->post('ids');
		 
		// print_r($this->input->post('ids'));

		if($this->Item->deletecate_list($items_to_delete))
		{
			echo json_encode(array('success'=>true,'message'=>$this->lang->line('items_successful_deleted').' '.
			count($items_to_delete).' '.$this->lang->line('items_one_or_multiple')));
		}
		else
		{
			echo json_encode(array('success'=>false,'message'=>$this->lang->line('items_cannot_be_deleted')));
		}
	}
	
	
		function deletecategory()
	{
		//echo $items_to_delete=$cate_id;
		
		$items_to_delete=$this->input->post('id');
		 
		// print_r($this->input->post('ids'));

		if($this->Item->deletecate_list($items_to_delete))
		{
			echo json_encode(array('success'=>true,'message'=>$this->lang->line('items_successful_deleted').' '.
			count($items_to_delete).' '.$this->lang->line('items_one_or_multiple')));
		}
		else
		{
			echo json_encode(array('success'=>false,'message'=>$this->lang->line('items_cannot_be_deleted')));
		}
		
	}
	

	/**
	 * Display form: Import data from an excel file
	 * @author: Nguyen OJB
	 * @since: 10.1
	 */
	function excel_export($width=-1,$source_store=-1)
	{
		header("Content-type:text/octect-stream");
   		header("Content-Disposition:attachment;filename=Iventory-".date("Y-n-j").".csv");
		if($source_store=="None" || $source_store=="main")$table = "opos_".$this->store; else $table = "opos_".$source_store."_storeitems";
		$query="SELECT item_id, item_number, name, category, supplier_id, cost_price, retailprice, quantity, description, reorder_level
				FROM $table
				WHERE deleted =0";
		
		$exp = array();
		$result = mysql_query($query) or die("Query failed : " . mysql_error());

		echo "\r\nCODE|ITEM NAME|CATEGORY|SUPPLIER CODE|COST PRICE|UNIT PRICE|TAX1|TAX2|QUANTITY|REORDER LEVEL|DESCRIPTION\r\n"; //header
	//exit();
		if(is_array(mysql_fetch_array($result))){
		
		while($row = mysql_fetch_array($result)){
		 $item_id = $row[0];			
		 $sql="SELECT percent FROM opos_items_taxes WHERE item_id = '$item_id'";		
		 $res=mysql_query($sql) or die("Query failed : " . mysql_error());
		 $data = "";
		 	
		  		
				 while($rec=mysql_fetch_assoc($res))
				 {
				  //global $data; 
				  if($rec['percent']=="")
				  $percent= "0.00";
				  else
				  $percent= $rec['percent'];
				  
				  $data.= "".$percent."-";
				 }
				 
				 //echo $var;
				 //echo "<pre>";
				 //echo $data;
				 //echo "</pre>";
				 $exp=explode('-',$data);
				 echo "$row[1]|$row[2]|$row[3]|$row[4]|$row[5]|$row[6]|";
				 if(mysql_num_rows($res)>1)		 
				 echo "".$exp[0]."|".$exp[1]."|$row[7]|$row[9]|$row[8]\r\n"; //data
				 elseif(mysql_num_rows($res)==1)
				 echo "".$exp[0]."|0.00|$row[7]|$row[9]|$row[8]\r\n"; //data
				 else if(mysql_num_rows($res)==0)
				 echo "0.00|0.00|$row[7]|$row[9]|$row[8]\r\n"; //data
				 
				 //}
				 //echo "<br>";
		 //}
			 
			
		
		//echo '<pre>';print_r($row);exit;
		//echo "$row[1],$row[2],$row[3],$row[10],$row[4],$row[5],0,0,$row[6],$row[8],$row[7]\r\n"; //data
		//echo "$x[0],$x[0]\r\n"; //data

		}
	}
	
	}
	
	function excel_import($width=-1,$source_store=-1)
	{
		$data['source_store']=$source_store;
		$this->load->view("items/excel_import", $data);
	}

	/**
	 * Read data from excel file -> save it to databse
	 * @author: Nguyen OJB
	 * @since: 10.1
	 */
	function do_excel_import()
	{
		$msg = 'do_excel_import';
		$source_store = $this->input->post('source_store');
		$file_type = $this->input->post('file_type');
		$file_type = $file_type[0];
		$fileparts = explode('.',$_FILES['file_path']['name']);
		$extension = $fileparts[1];
		//print_r($_FILES['file_path']);
		//exit();
		$allowedExtentions = array("xls","csv");
		if (!in_array($extension,$allowedExtentions))
		{
			$msg = $this->lang->line('items_excel_import_failed');
			echo json_encode( array('success'=>false,'message'=>$msg) );
			return;
		}
		//exit;
		$failCodes = array();
		$item_numbers = "";
		
		if ($_FILES['file_path']['error']!=UPLOAD_ERR_OK)
		{
			$msg = $this->lang->line('items_excel_import_failed');
			echo json_encode( array('success'=>false,'message'=>$msg) );
			return;
		}
		else
		{
			
			if($file_type == 1)
			{
			$this->load->library('spreadsheetexcelreader');
			$this->spreadsheetexcelreader->store_extended_info = false;
			//echo $this->data = @file_get_contents($_FILES['file_path']['tmp_name']);exit();
			$success = $this->spreadsheetexcelreader->read($_FILES['file_path']['tmp_name']);

			$rowCount = $this->spreadsheetexcelreader->rowcount(0);
			if($rowCount > 2){
			//$this->db->update('items', array('deleted' => 1));	
				for($i = 3; $i<=$rowCount; $i++){

					$item_data = array(
					'item_number'	=>	$this->spreadsheetexcelreader->val($i, 'A'),
					'name'			=>	$this->spreadsheetexcelreader->val($i, 'B'),
					'description'	=>	$this->spreadsheetexcelreader->val($i, 'K'),
					'category'		=>	$this->spreadsheetexcelreader->val($i, 'C'),
					'cost_price'	=>	$this->spreadsheetexcelreader->val($i, 'E'),
					'unit_price'	=>	$this->spreadsheetexcelreader->val($i, 'F'),
					'retailprice'	=>	$this->spreadsheetexcelreader->val($i, 'F'),
					'quantity'		=>	$this->spreadsheetexcelreader->val($i, 'I'),
					'reorder_level'	=>	$this->spreadsheetexcelreader->val($i, 'J'),
					'supplier_id'	=>  $this->Supplier->exists($this->spreadsheetexcelreader->val($i, 'D')) ? $this->spreadsheetexcelreader->val($i, 'D') : null
					);
					$item_number = $this->spreadsheetexcelreader->val($i, 'A');
					
					if ($item_number != "")
					{
						$item_data['item_number'] = $item_number;
					}
					//echo $item_data['item_number']; 
					$this->db->from('items');
					$this->db->where('item_number',$item_number);
					$query = $this->db->get();
					if($query->num_rows())$item_numbers.= $item_number.",";
					
					if($this->Item->save_importdata($item_data,$item_number,$source_store)) {
						
						
						$items_taxes_data = null;
						//tax 1
						if( is_numeric($this->spreadsheetexcelreader->val($i, 'G')) ){
							
							$items_taxes_data[] = array('name'=>'Sales Tax 1', 'percent'=>$this->spreadsheetexcelreader->val($i, 'G') ,'store'=>$source_store );
						}

						//tax 2
						if( is_numeric($this->spreadsheetexcelreader->val($i, 'H')) ){
							$items_taxes_data[] = array('name'=>'Sales Tax 2', 'percent'=>$this->spreadsheetexcelreader->val($i, 'H') ,'store'=>$source_store );
						}

						// save tax values
						if(count($items_taxes_data) > 0){
							
							$this->Item_taxes->save($items_taxes_data, $item_data['item_id']);
						}
						
									
						$employee_id=$this->Employee->get_logged_in_employee_info()->person_id;
						$emp_info=$this->Employee->get_info($employee_id);
						$comment ='Qty Excel Imported: means BEGIN/RESET/ACTUAL count';
							
						$excel_data = array
							(
							'trans_items'=>$item_data['item_id'],
							'trans_user'=>$employee_id,
							'trans_comment'=>$comment,
							'trans_inventory'=>$this->spreadsheetexcelreader->val($i, 'I'),
							'store'=>$source_store
							);
						
							$this->db->insert('inventory',$excel_data);
					
						//------------------------------------------------Ramel
						
					}
					else//insert or update item failure
					{
						$failCodes[] = $i;
					}
					
				}

			} else {
				// rowCount < 2
				echo json_encode( array('success'=>true,'message'=>'Your upload file has no data or not in supported format.') );
				return;
			}
			
			}
			else
			{
			
				if ($_FILES['file_path']['size'] > 0) 
				{
					//get the csv file 
    				$file = $_FILES['file_path']['tmp_name'];
					if (($handle = fopen($file,"r")) !== FALSE) 
					{
						$i = 0;
						while (!feof($handle))
						{
						   
						   $csv_data[] = fgets($handle, 1024);
						   $csv_array = explode("|", $csv_data[$i]);
						   if($i!=0)
						   {
							   /*echo "<pre>";
							   print_r($csv_array);
							   echo "</pre>";*/
							   //$insert_csv = array();
							   //$insert_csv['ID'] = $csv_array[0];
							   //$insert_csv['name'] = $csv_array[1];
							   //$insert_csv['email'] = $csv_array[2];
							   //$query = "INSERT INTO csvdata(ID,name,email)VALUES('','".$insert_csv['name']."','".$insert_csv['email']."')";
							   //$n=mysql_query($query, $connect );
							   isset($csv_array[3])?$supplier_id = $csv_array[9] = 0 : $supplier_id = NULL;
							   $item_data = array(
									'item_number'	=>	isset($csv_array[0])?$csv_array[0]:NULL,
									'name'		   =>    isset($csv_array[1])?$csv_array[1]:NULL,
									'description'	=>	isset($csv_array[10])?$csv_array[10]:NULL,
									'category'	   =>    isset($csv_array[2])?$csv_array[2]:NULL,
									'cost_price'	 =>	isset($csv_array[4])?$csv_array[4]:0,
									'unit_price'	 =>	isset($csv_array[5])?$csv_array[5]:0,
									'retailprice'	=>	isset($csv_array[5])?$csv_array[5]:0,
									'quantity'	   =>    isset($csv_array[8])?$csv_array[8]:0,
									'reorder_level'  =>	isset($csv_array[9])?$csv_array[9]:0,
									'supplier_id'	=>    $this->Supplier->exists($supplier_id) ? $supplier_id : NULL
									);
							  		
							  /*echo "<pre>";
							  print_r($item_data);
							  echo "</pre>";*/
							  $item_number = isset($csv_array[0])?$csv_array[0]:NULL;
							  
							  if ($item_number != "")
							  {
								  $item_data['item_number'] = $item_number;
							  }
							  //echo $item_data['item_number']; 
							  $this->db->from('items');
							  $this->db->where('item_number',$item_number);
							  $query = $this->db->get();
							  if($query->num_rows())$item_numbers.= $item_number.",";
							  
							  if($this->Item->save_importdata($item_data,$item_number,$source_store)) {
							
							
							  $items_taxes_data = null;
							  //tax 1
							  if( is_numeric($csv_array[6]) ){
								  
								  $items_taxes_data[] = array('name'=>'Sales Tax 1', 'percent'=>isset($csv_array[6])?$csv_array[6]:NULL ,'store'=>$source_store );
							  }
	  
							  //tax 2
							  if( is_numeric($csv_array[7]) ){
								  $items_taxes_data[] = array('name'=>'Sales Tax 2', 'percent'=>isset($csv_array[7])?$csv_array[7]:NULL ,'store'=>$source_store );
							  }
	  
							  // save tax values
							  if(count($items_taxes_data) > 0){
								  
								  $this->Item_taxes->save($items_taxes_data, $item_data['item_id']);
							  }
							
										
							  $employee_id=$this->Employee->get_logged_in_employee_info()->person_id;
							  $emp_info=$this->Employee->get_info($employee_id);
							  $comment ='Qty Excel Imported: means BEGIN/RESET/ACTUAL count';
								  
							  $excel_data = array
								  (
								  'trans_items'=>$item_data['item_id'],
								  'trans_user'=>$employee_id,
								  'trans_comment'=>$comment,
								  'trans_inventory'=>isset($csv_array[8])?$csv_array[8]:0,
								  'store'=>$source_store
								  );
								
							   $this->db->insert('inventory',$excel_data);
							   
							   
							   
							  }
							  else//insert or update item failure
							  {
									$failCodes[] = $i;
							  } 
						   
						   
						   }
						   
						   
						   $i++;
						}
						fclose($handle);
					}
				}
				else
				{
					echo json_encode( array('success'=>true,'message'=>'Your upload file has no data or not in supported format.') );
					return;
				}
			}
		}
		
		$success = true;
		if(count($failCodes) > 1){
			$msg = "Most items imported. But some were not, here is list of their CODE (" .count($failCodes) ."): ".implode(", ", $failCodes);
			//$success = false;
			$success = true;
		}else{
			//$item_numbers = substr_replace($item_numbers ,"",-1);
			$exp = explode(',',$item_numbers);	
			
			if(sizeof($exp)>1)
			$msg = "Import new items and update existing items successful";
			else
			$msg = "Import items successful"; 
		}
		//echo json_encode( array('success'=>true,'message'=>$this->Item->save_importdata($item_data,$item_number).$success) );exit;
		
		//return ($query->num_rows()==1);
		echo json_encode( array('success'=>$success,'message'=>$msg) );
	}

	
	function assign()
	{
		$data['controller_name']=strtolower($this->uri->segment(1));
		$data['form_width']=$this->get_form_width();
		
		if($this->input->post('source_store')!="")
		{
		
		list($source_store_id,$source_store)=split("_",$this->input->post('source_store'));
		$total_rows = $this->Item->get_StoreItems($source_store)->num_rows;
		
		}
		else
		{
			$source_store="";
			$total_rows = $this->Item->get_all()->num_rows;
		}
		
		
		$config['base_url'] = site_url($this->uri->segment(1)."/assign");
		//$config['base_url'] = base_url() . $this->uri->segment(1)."/index";
		$config['total_rows'] = $total_rows;
		$config['per_page'] = 20;
		$config['num_links'] = 5;
		$config['uri_segment'] = 3;
		$config['use_page_numbers'] = TRUE;
		$config['page_query_string'] = FALSE;
		$config['enable_query_strings']  = FALSE;
		
		$this->pagination->initialize($config);
		
		$page = ($this->uri->segment(3))? $this->uri->segment(3) : 0;
		
		
		
		
		$des_store_one=$this->input->post('des_store_one');
		$des_store_two=$this->input->post('des_store_two');
		$data['source_store']=$source_store;
		$data['des_store_one']=$des_store_one;
		$data['des_store_two']=$des_store_two;
	
	
	//	$data['manage_table']=get_assign_items_manage_table($this->Item->get_Assign_Items($source_store,$des_store_one,$des_store_two ,$config["per_page"], $page,1 ),$this,$source_store,$des_store_one,$des_store_two);
		
		
		
		if($this->input->post('source_store')!="")
		{ 
			list($source_store_id,$source_store)=split("_",$this->input->post('source_store'));
			$data['manage_table']=get_assign_items_manage_table($this->Item->get_Assign_Items($source_store,$des_store_one,$des_store_two ,$config["per_page"], $page,1 ),$this,$source_store,$des_store_one,$des_store_two);
		}
		else
		{
			$source_store="";
			$data['manage_table']=get_assign_items_manage_table($this->Item->get_Assign_Items($source_store,$des_store_one,$des_store_two ,$config["per_page"], $page,1 ),$this,$source_store,$des_store_one,$des_store_two);
			
			//print_r($data['manage_table']);
		}
		
		
		$this->config->set_item('enable_query_strings', FALSE);
		
		if($source_store != '')
		{
		$data['pagination']= $this->pagination->create_links();
		
		}
		else
		{
			$data['pagination']= '';
			
		}
		
		$this->load->view('items/manage_assign',$data);
	}
	
	function saveStoreQuantity()
	{
		list($source_store_id,$source_store)=split("_",$this->input->post('source_store'));
		$source_store_id."_".$source_store;
		$des_store_one=$this->input->post('des_store_one');
		$des_store_two=$this->input->post('des_store_two');
		$item_ids=$this->input->post('item_ids');//print_r($item_ids);
		$successCodes = array();
		$failCodes = array();
		if(is_array($item_ids))
		{
		foreach($item_ids as $key=>$item_id_string)
		{
			
			list($item_id,$quantity_one,$quantity_two,$old_quantity)=split("_",$item_id_string);
			$item_data_one = array
					  (
					  'item_id'=>$item_id,
					  'quantity'=>$quantity_one,
					  'source_store_id'=>$source_store_id
					  );
			$item_data_two = array
					  (
					  'item_id'=>$item_id,
					  'quantity'=>$quantity_two,
					  'source_store_id'=>$source_store_id
					  );		  
			//echo $this->Item->saveStoreQuantity($item_id,$des_store_one,$des_store_two,$item_data_one,$item_data_two);
			if($this->Item->saveStoreQuantity($item_id,$des_store_one,$des_store_two,$item_data_one,$item_data_two))
			{
			if($source_store=="main")$item_info = $this->Item->get_info($item_id); else $item_info = $this->Item->get_Store_info($source_store,$item_id);	
			//$item_info = $this->Item->get_info($item_id);
			//$item_info->quantity;	
			$quantity = $item_info->quantity-$old_quantity;	
			$item_data = array('quantity'=>$quantity);	
			$this->Item->changeSourceQuantity($item_id,$item_data,$source_store);	
			//echo json_encode(array('success'=>true,'message'=>"Stores saved successfully"));
			$successCodes[] = $key;
			}
			else
			{
			//echo json_encode(array('success'=>false,'message'=>"Stores are not saved successfully"));
			$failCodes[] = $key;
			}
		}
		}
		if(count($failCodes) > 0){
			echo "0|Data not updated successfully.|".implode(", ", $failCodes)."|".count($failCodes)."|".implode(", ", $successCodes)."|".count($successCodes);
		}else{
			echo "1|Data updated successfully|".implode(", ", $successCodes)."|".count($successCodes);
		}
		//print_r($item_ids);
		
	}
	
	function get_Stores_Items()
	{
		$data['controller_name']=strtolower($this->uri->segment(1));
		$data['form_width']=$this->get_form_width();
		if($this->input->post('source_store')!="")
		{
		list($source_store_id,$source_store)=split("_",$this->input->post('source_store'));
		}
		else
		{
			$source_store="";
		}
		
		$des_store_one=$this->input->post('des_store_one');
		$des_store_two=$this->input->post('des_store_two');
		$data['source_store']=$source_store;
		$data['des_store_one']=$des_store_one;
		$data['des_store_two']=$des_store_two;
		echo $data['manage_table']=get_assign_items_manage_table($this->Item->get_Assign_Items($source_store,$des_store_one,$des_store_two),$this,$source_store,$des_store_one,$des_store_two);
	}
	
	/*
	get the width for the add/edit form
	*/
	function get_form_width() 
	{
		return 500;
	}
	
	
	
	/*function category()
	{
		//echo $this->store;
		$data['manage_table']=get_category_manage_table($this->Item->get_category(),$this);
	
		$this->load->view('items/category' ,$data);
	}*/
	
	function dropdown_categories()
	{
		//echo $this->store;
		//$category->result();
		$data['manage_dropdown']=$this->Item->get_category()->result();
	
		$this->load->view('items/categories' ,$data);
	}
	
	
	function categories()
	{
		//echo $this->store;
		
		
		$total_rows = $this->Item->get_category()->num_rows;
		
			
		$config['base_url'] = site_url($this->uri->segment(1)."/categories");
		//$config['base_url'] = base_url() . $this->uri->segment(1)."/index";
		$config['total_rows'] = $total_rows;
		$config['per_page'] = 20;
		$config['num_links'] = 5;
		$config['uri_segment'] = 3;
		$config['use_page_numbers'] = TRUE;
		$config['page_query_string'] = FALSE;
		$config['enable_query_strings']  = FALSE;
		
		$this->pagination->initialize($config);
		
		$page = ($this->uri->segment(3))? $this->uri->segment(3) : 0;
		
		$data['manage_table']=get_category_manage_table($this->Item->get_category($config["per_page"], $page,1),$this);
		
		
		$data['manage_category']=$this->Item->get_category()->result();
		
		
		$this->config->set_item('enable_query_strings', FALSE);
		$data['pagination']= $this->pagination->create_links();
	
		$this->load->view('items/categories' ,$data);
	}
	
	
	
	function add_category()
	{
		//$data['controller_name']=strtolower($this->uri->segment(1));
		//$data['form_width']=$this->get_form_width();
		
		//$data['form_width']='350';
		
		//$data['source_store']=$source_store;
		$this->load->view("items/category_form");
	}
	
	
	
	function category_save($id=-1)
	{
		
		
		 $cate_data = array(
			'title'=>$this->input->post('cate_name'),
			'parent'=>$this->input->post('category')
			
			//'timestamp'=>'CURRENT_TIMESTAMP',
	     );
		
		
			//$this->Item->save($cate_data);
		if($id == '' || $id == -1)
		{
		
			$this->db->insert("category",$cate_data);
		    echo json_encode(array('success'=>true,'message'=>$this->lang->line('items_successful_adding_category')));
		
		}
		
		else
		{
			$id = $this->input->post('id');
			
			$this->db->where('id', $id);
			$this->db->update("category", $cate_data);
			echo json_encode(array('success'=>true,'message'=>$this->lang->line('items_successful_updating_category')));
			
		}
		//$this->Item->insert($item_data);

	}
	
	function view_cate($cate_id=-1,$width=-1)
	{
		
		//echo $cate_id;
		//echo $source_store;
		
		$data['cate_info']=$this->Item->get_category_by_id($cate_id) ;	
		
		

	//	$data['category']=$category;
		
		
		
		$this->load->view("items/category_form",$data);
	}
	
	
	
	function view_img($item_id=-1,$width=-1)
	{
		
		$images = $this->Item->get_item_images($item_id);	
		//print_r($images);
		//$iteminfo = $this->Item->get_info($item_id);
		//print_r($iteminfo);
		$data['item_id']=$item_id;
		$data['item_images']=$images;
		$this->load->view("items/images_form"  ,$data);
	}
	
	
	
	
	function attributes()
	{
		//echo $this->store;
		
		$total_rows = $this->Item->get_attributes()->num_rows;
		
			
		$config['base_url'] = site_url($this->uri->segment(1)."/attributes");
		//$config['base_url'] = base_url() . $this->uri->segment(1)."/index";
		$config['total_rows'] = $total_rows;
		$config['per_page'] = 20;
		$config['num_links'] = 5;
		$config['uri_segment'] = 3;
		$config['use_page_numbers'] = TRUE;
		$config['page_query_string'] = FALSE;
		$config['enable_query_strings']  = FALSE;
		
		$this->pagination->initialize($config);
		
		$page = ($this->uri->segment(3))? $this->uri->segment(3) : 0;
		
		
	$data['manage_table']=get_attributes_manage_table($this->Item->get_attributes($config["per_page"], $page,1),$this);
		
		
		$data['manage_attr']=$this->Item->get_attributes()->result();
		
		
		$this->config->set_item('enable_query_strings', FALSE);
		$data['pagination']= $this->pagination->create_links();
	
		
	
		$this->load->view('items/attributes' ,$data);
	}
	
	
	
	function attributes_save($id=-1)
	{
		
	//echo 	$this->input->post('attri');
		
		 $attr_data = array(
			'title'=>$this->input->post('attributes_name'),
			'parent'=>$this->input->post('attri')
			
			
			//'timestamp'=>'CURRENT_TIMESTAMP',
	     );
		
		
			//$this->Item->save($cate_data);
		if($id == '' || $id == -1)
		{
		
			$this->db->insert("attributes",$attr_data);
		    echo json_encode(array('success'=>true,'message'=>$this->lang->line('items_successful_adding_attributes')));
		
		}
		
		else
		{
			$id = $this->input->post('id');
			
			$this->db->where('id', $id);
			$this->db->update("attributes", $attr_data);
			echo json_encode(array('success'=>true,'message'=>$this->lang->line('items_successful_updating_attributes')));
			
		}
		//$this->Item->insert($item_data);

	}
	
	
	
	function deleteattributes()
	{
		//echo $items_to_delete=$cate_id;
		
		$items_to_delete=$this->input->post('id');
		 
		// print_r($this->input->post('ids'));

		if($this->Item->deleteattributes_list($items_to_delete))
		{
			echo json_encode(array('success'=>true,'message'=>$this->lang->line('items_successful_deleted_attr').' '.
			count($items_to_delete).' '.$this->lang->line('items_one_or_multiple')));
		}
		else
		{
			echo json_encode(array('success'=>false,'message'=>$this->lang->line('items_cannot_be_deleted_attr')));
		}
		
	}
	
	
	
	function deleteattr()
	{
		 $items_to_delete=$this->input->post('ids');
		 
		// print_r($this->input->post('ids'));

		if($this->Item->deleteattributes_list($items_to_delete))
		{
			echo json_encode(array('success'=>true,'message'=>$this->lang->line('items_successful_deleted_attr').' '.
			count($items_to_delete).' '.$this->lang->line('items_one_or_multiple')));
		}
		else
		{
			echo json_encode(array('success'=>false,'message'=>$this->lang->line('items_cannot_be_deleted_attr')));
		}
	}
	
	
	
	
	function deleteoption()
	{
		//echo $items_to_delete=$cate_id;
		
		$items_to_delete=$this->input->post('id');
		 
		// print_r($this->input->post('ids'));

		if($this->Item->deleteoption_list($items_to_delete))
		{
			echo json_encode(array('success'=>true,'message'=>$this->lang->line('items_successful_deleted_attr').' '.
			count($items_to_delete).' '.$this->lang->line('items_one_or_multiple')));
		}
		else
		{
			echo json_encode(array('success'=>false,'message'=>$this->lang->line('items_cannot_be_deleted_attr')));
		}
		
	}
	
	
	
	//function getattributes()
//	{
//		//echo $this->store;
//		$data['manage_attr']=$this->Item->get_attributes();
//	
//		$this->load->view('items/attributes' ,$data);
//	}
	
		
	
	
			

}
?>