<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/*
|	Call it by doing this:
|
|		$this->load->library('my_payment');
|		$params->cc = '1293081309812039812039' ;//etc... you get the idea
|		
|		$result = $this->my_payment->authorize($params);
|		print_r($result); //response codes from authorize.net*/

class paypal_payment {
 
	protected $paypal_username = "";
	protected $paypal_password = "";
	protected $paypal_environment = "";
	protected $paypal_signature = "";
	
	public function __construct()
	{
		$CI =& get_instance();
		$CI->load->model('Gateways'); 
 		//print_r($CI->Gateways->get_default_gateway()->result());exit();
		$data['gateway_info']= $CI->Gateways->get_default_gateway();
  		foreach ($data['gateway_info']->result() as $gateways){
			  $this->paypal_username = $gateways->MUinfo;
			  $this->paypal_password = $gateways->MUkey;
			  $this->paypal_environment = $gateways->MUenvironment;
			  $this->paypal_signature = $gateways->signature;
 		}
	}
	
	public function PPHTTPPost($params) 
	{
 
		$paypal_environment = urlencode($this->paypal_environment);  //live or sandbox 
		$API_UserName = urlencode($this->paypal_username);			//paypal api username
		$API_Password = urlencode($this->paypal_password); 			//paypal api password
		$API_Signature = urlencode($this->paypal_signature);	      //paypal api signature
		$nvp_string = $params->nvp_string;
		$nvp_method = $params->nvp_method;
	
		if ($paypal_environment == 'live')
		$subenvi = '';
		else
		$subenvi = $paypal_environment.'.';

		$API_Endpoint = 'https://api-3t.'.$subenvi.'paypal.com/nvp';
		$version = urlencode('51.0'); 								//paypal version
		//$version = urlencode('124.0'); 									//paypal version
	
		// Set the curl parameters.
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $API_Endpoint);
		curl_setopt($ch, CURLOPT_VERBOSE, 1);
	
		// Turn off the server and peer verification (TrustManager Concept).
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
	
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);
	
		// Set the API operation, version, and API signature in the request.
		$nvpreq = "METHOD=$nvp_method&VERSION=$version&PWD=$API_Password&USER=$API_UserName&SIGNATURE=$API_Signature$nvp_string";
	
		// Set the request as a POST FIELD for curl.
		curl_setopt($ch, CURLOPT_POSTFIELDS, $nvpreq);
	
		// Get response from the server.
		$httpResponse = curl_exec($ch);

		$paypal_error = "";
		if(!$httpResponse) {
			//exit("$methodName_ failed: ".curl_error($ch).'('.curl_errno($ch).')');
			$paypal_error = 1;
			$paypal_response = "$methodName_ failed: ".curl_error($ch).'('.curl_errno($ch).')';
		}

		//Extract the response details.
		$httpResponseAr = explode("&", $httpResponse);
	
		$httpParsedResponseAr = array();
		foreach ($httpResponseAr as $i => $value) {
			$tmpAr = explode("=", $value);
			if(sizeof($tmpAr) > 1) {
				$httpParsedResponseAr[$tmpAr[0]] = $tmpAr[1];
			}
		}
		
		$paypal_response = $httpParsedResponseAr;

		if((0 == sizeof($httpParsedResponseAr)) || !array_key_exists('ACK', $httpParsedResponseAr))
		{
			$paypal_error = 1;
			//exit("Invalid HTTP Response for POST request($nvpreq) to $API_Endpoint.");
			$paypal_response = "Invalid HTTP Response for POST request to $API_Endpoint";
		}
		//print_r($httpParsedResponseAr);exit();
		//return $httpParsedResponseAr;
		//if($httpParsedResponseAr["ACK"] == 'Failure'){$paypal_error = 1;}
		if($httpParsedResponseAr["ACK"] == 'Success' || $httpParsedResponseAr["ACK"] == 'SuccessWithWarning') 
		{
		  //$paypal_response = $httpParsedResponseAr['TRANSACTIONID'];
		  $paypal_response = $httpParsedResponseAr;
        }
		else 
		{
		  $paypal_error = 1;
		  //echo '|0|' .urldecode($httpParsedResponseAr["L_SHORTMESSAGE0"]).'|';
		  if($httpParsedResponseAr["L_SEVERITYCODE0"] == 'Error')
		  $paypal_response = urldecode($httpParsedResponseAr["L_LONGMESSAGE0"]);
		  elseif($httpParsedResponseAr["L_SEVERITYCODE1"] == 'Error')
		  $paypal_response = urldecode($httpParsedResponseAr["L_LONGMESSAGE1"]);
		  elseif($httpParsedResponseAr["L_SEVERITYCODE2"] == 'Error')
		  $paypal_response = urldecode($httpParsedResponseAr["L_LONGMESSAGE2"]);
		  
		  if($httpParsedResponseAr["L_ERRORCODE0"]==10002)
		  $paypal_response = urldecode("This transaction cannot be processed because your API credentials are invalid");
        }
		$responseArray = array();
		$responseArray['PP_Error'] = $paypal_error;
		$responseArray['PP_Response'] = $paypal_response;
		
		return $responseArray;
		

	} // end function

}
?>