<?php
class Employee extends Person
{
	/*
	Determines if a given person_id is an employee
	*/
	function exists($person_id)
	{
		$this->db->from('employees');	
		$this->db->join('people', 'people.person_id = employees.person_id');
		$this->db->where('employees.person_id',$person_id);
		$query = $this->db->get();
		
		return ($query->num_rows()==1);
	}	
	
	 
	function salesuser($person_id, $refcode )
	{
		
		$this->db->from('employees');	
		$this->db->join('people', 'people.person_id = employees.person_id');
 
 		$this->db->where('employees.person_id',$person_id);
		$query = $this->db->get();
		
		if($query->num_rows()==1)
		{
			return $query->row();
		}
		else
		{
			//Get empty base parent object, as $customer_id is NOT an customer
	//		$gateway_obj=parent::get_info1(-1);
			
			//Get all the fields from customer table
			$fields = $this->db->list_fields('employees');
			
			//append those fields to base parent object, we we have a complete empty object
			foreach ($fields as $field)
			{
				$employees_obj->$field='';
			}
			
			return $employees_obj;
		} 
			
  	}
	
	/*
	Returns all the employees
	*/
	function get_all($limit="",$offset="",$limited=0)
	{
		$this->db->from('employees');
		$this->db->where('deleted',0);
		//$this->db->where('username',$username,'status',$status);		
		$this->db->join('people','employees.person_id=people.person_id');			
		$this->db->order_by("last_name", "asc");
		if($limited==1)$this->db->limit($limit, $offset);
		return $this->db->get();		
	}
	
	/*
	Gets information about a particular employee
	*/
	function get_info($employee_id)
	{
		$this->db->from('employees');	
		$this->db->join('people', 'people.person_id = employees.person_id');
		$this->db->where('employees.person_id',$employee_id);
		$query = $this->db->get();
		
		if($query->num_rows()==1)
		{
			return $query->row();
		}
		else
		{
			//Get empty base parent object, as $employee_id is NOT an employee
			$person_obj=parent::get_info(-1);
			
			//Get all the fields from employee table
			$fields = $this->db->list_fields('employees');
			
			//append those fields to base parent object, we we have a complete empty object
			foreach ($fields as $field)
			{
				$person_obj->$field='';
			}
			
			return $person_obj;
		}
	}
	
	/*
	Gets information about a logged in user data
	*/
	function get_user_info($employee_id,$employee_username)
	{
		$this->db->from('employees');	
		$this->db->join('people', 'people.person_id = employees.person_id');
		$this->db->where('employees.person_id',$employee_id);
		$query = $this->db->get();
		
		if($query->num_rows()==1)
		{
			$this->db->dbprefix = "usermanagement_";
			$this->db->from('users');	
			$this->db->where('users.username',$query->row()->username);
			$query_user = $this->db->get();
			if($query_user->num_rows()==1)
			{
				if($query_user->row()->type!=0)
				{
					$this->db->from('usergroups');	
					$this->db->where('usergroups.group_id',$query_user->row()->type);
					$query_usergroup = $this->db->get();
					if($query_usergroup->num_rows()==1)
					{
						$query_user->row()->designation = $query_usergroup->title;
					}
				}
				else
				{$query_user->row()->designation = "Administrator";}
				
				$this->db->dbprefix = "opos_";
				return $query_user->row();
			}
		}
		else
		{
			//Get empty base parent object, as $employee_id is NOT an employee
			$person_obj = parent::get_user_info(-1);
			
			//Get all the fields from employee table
			$fields = $this->db->list_fields('employees');
			
			//append those fields to base parent object, we we have a complete empty object
			foreach ($fields as $field)
			{
				$person_obj->$field='';
			}
			
			return $person_obj;
		}
	}
	
	function ifexistsuserdetails($employid)
	{
		//$query = $this->db->get_where('employees', array('person_id' =>$employid ), 1);
		
		$this->db->from('employees');	
		$this->db->join('people', 'people.person_id = employees.person_id');
		$this->db->where('employees.person_id',$employid);
		$query = $this->db->get();
		
		$row=$query->row();
		//print_r($row);
			
		return $query->row();	
	}
	
	/*
	Gets information about multiple employees
	*/
	function get_multiple_info($employee_ids)
	{
		$this->db->from('employees');
		$this->db->join('people', 'people.person_id = employees.person_id');		
		$this->db->where_in('employees.person_id',$employee_ids);
		$this->db->order_by("last_name", "asc");
		return $this->db->get();		
	}
	
	/*
	Inserts or updates an employee
	*/
	function save(&$person_data, &$employee_data,&$permission_data,$employee_id=false)
	{
 		$success=false;
 		//Run these queries as a transaction, we want to make sure we do all or nothing
		$this->db->trans_start();
			
		if(parent::save($person_data,$employee_id))
		{
			if (!$employee_id or !$this->exists($employee_id))
			{
				$employee_data['person_id'] = $employee_id = $person_data['person_id'];
				$success = $this->db->insert('employees',$employee_data);
			}
			else
			{
				$this->db->where('person_id', $employee_id);
				$success = $this->db->update('employees',$employee_data);		
			}
			
			//We have either inserted or updated a new employee, now lets set permissions. 
			if($success)
			{
				//First lets clear out any permissions the employee currently has.
					
				$success=$this->db->delete('permissions', array('person_id' => $employee_id));
				
				//Now insert the new permissions
				if($success)
				{
					foreach($permission_data as $allowed_module)
					{
						$success = $this->db->insert('permissions',
						array(
						'module_id'=>$allowed_module,
						'person_id'=>$employee_id));
					}
				}
			}
			
		}
		
		$this->db->trans_complete();		
		return $success;
	}
	
	/*
	Deletes one employee
	*/
	function delete($employee_id)
	{
		$success=false;
		
		//Don't let employee delete their self
		if($employee_id==$this->get_logged_in_employee_info()->person_id)
			return false;
		
		//Run these queries as a transaction, we want to make sure we do all or nothing
		$this->db->trans_start();
		
		//Delete permissions
		if($this->db->delete('permissions', array('person_id' => $employee_id)))
		{	
			$this->db->where('person_id', $employee_id);
			$success = $this->db->update('employees', array('deleted' => 1));
		}
		$this->db->trans_complete();		
		return $success;
	}
	
	/*
	Deletes a list of employees
	*/
	function delete_list($employee_ids)
	{
		$success=false;
		
		//Don't let employee delete their self
		if(in_array($this->get_logged_in_employee_info()->person_id,$employee_ids))
			return false;

		//Run these queries as a transaction, we want to make sure we do all or nothing
		$this->db->trans_start();

		$this->db->where_in('person_id',$employee_ids);
		//Delete permissions
		if ($this->db->delete('permissions'))
		{
			//delete from employee table
			$this->db->where_in('person_id',$employee_ids);
			$success = $this->db->update('employees', array('deleted' => 1));
		}
		$this->db->trans_complete();		
		return $success;
 	}
	
	function ifexistsuser($username)
	{
		$query = $this->db->get_where('employees', array('username' => $username), 1);
		if ($query->num_rows() ==1)
		{
			
			$row=$query->row();
			
			return true;
		}
		return false;
	}
	
	/*
	Get search suggestions to find employees
	*/
	function get_search_suggestions($search,$limit=5)
	{
		$suggestions = array();
		
		$this->db->from('employees');
		$this->db->join('people','employees.person_id=people.person_id');	
		$this->db->where("(first_name LIKE '%".$this->db->escape_like_str($search)."%' or 
		last_name LIKE '%".$this->db->escape_like_str($search)."%' or 
		CONCAT(`first_name`,' ',`last_name`) LIKE '%".$this->db->escape_like_str($search)."%') and deleted=0 and type !=0");
		$this->db->order_by("last_name", "asc");		
		$by_name = $this->db->get();
		foreach($by_name->result() as $row)
		{
			$suggestions[]=$row->first_name.' '.$row->last_name;		
		}
		
		$this->db->from('employees');
		$this->db->join('people','employees.person_id=people.person_id');
		$this->db->where('deleted', 0);
		$this->db->like("email",$search);
		$this->db->order_by("email", "asc");		
		$by_email = $this->db->get();
		foreach($by_email->result() as $row)
		{
			$suggestions[]=$row->email;		
		}
		
		$this->db->from('employees');
		$this->db->join('people','employees.person_id=people.person_id');	
		$this->db->where('deleted', 0);
		$this->db->like("username",$search);
		$this->db->order_by("username", "asc");		
		$by_username = $this->db->get();
		foreach($by_username->result() as $row)
		{
			$suggestions[]=$row->username;		
		}


		$this->db->from('employees');
		$this->db->join('people','employees.person_id=people.person_id');	
		$this->db->where('deleted', 0);
		$this->db->like("phone_number",$search);
		$this->db->order_by("phone_number", "asc");		
		$by_phone = $this->db->get();
		foreach($by_phone->result() as $row)
		{
			$suggestions[]=$row->phone_number;		
		}
		
		
		//only return $limit suggestions
		if(count($suggestions > $limit))
		{
			$suggestions = array_slice($suggestions, 0,$limit);
		}
		return $suggestions;
	
	}
	
	/*
	Preform a search on employees
	*/
	function search($search)
	{
		$this->db->from('employees');
		$this->db->join('people','employees.person_id=people.person_id');		
		$this->db->where("(first_name LIKE '%".$this->db->escape_like_str($search)."%' or 
		last_name LIKE '%".$this->db->escape_like_str($search)."%' or 
		email LIKE '%".$this->db->escape_like_str($search)."%' or 
		phone_number LIKE '%".$this->db->escape_like_str($search)."%' or 
		username LIKE '%".$this->db->escape_like_str($search)."%' or 
		CONCAT(`first_name`,' ',`last_name`) LIKE '%".$this->db->escape_like_str($search)."%') and deleted=0");		
		$this->db->order_by("last_name", "asc");
		
		return $this->db->get();	
	}
	
	/*
	Attempts to login employee and set session. Returns boolean based on outcome.
	*/
	function login($username, $password,$shopname="")
	{
		//$query = $this->db->get_where('employees', array('username' => $username,'password'=>md5($password), 'deleted'=>0), 1);
		$query = $this->db->get_where('employees', array('username' => $username,'password'=>($password), 'deleted'=>0), 1);
		if ($query->num_rows() ==1)
		{
			
			$row=$query->row();
			$this->session->set_userdata('person_id', $row->person_id);
			$this->session->set_userdata('shopname', $shopname);
			return true;
		}
		return false;
	}
	
	/*
	Logs out a user by destorying all session data and redirect to login
	*/
	function logout()
	{
		$this->session->sess_destroy();
		unset($_SESSION['shopname']);
		redirect('login');
	}
	
	/*
	Determins if a employee is logged in
	*/
	function is_logged_in()
	{
		return $this->session->userdata('person_id')!=false;
	}
	
	/*
	Gets information about the currently logged in employee.
	*/
	function get_logged_in_employee_info()
	{
		if($this->is_logged_in())
		{
			return $this->get_info($this->session->userdata('person_id'));
		}
		
		return false;
	}
	
	/*
	Determins whether the employee specified employee has access the specific module.
	*/
	function has_permission($module_id,$person_id)
	{
		//if no module_id is null, allow access
		if($module_id==null)
		{
			return true;
		}
		
		$query = $this->db->get_where('permissions', array('person_id' => $person_id,'module_id'=>$module_id), 1);
		return $query->num_rows() == 1;
		
		
		return false;
	}
	
	function update($id)
	{
	   
		$this->db->where('username',$id);
		$this->db->update('employees', array('deleted' => 0));
			 
        return true;
	}
	
	function userinfo($id)
	{
	   
		$row=array();
	    $this->db->from('employees');
	    $this->db->join('people', 'people.person_id = employees.person_id');
	    $this->db->where('username',$id);
		$query=$this->db->get();
			
			
		//return $query->row();
			
			
		if ($query->num_rows() >0)
		{
			
			$row=$query->row();
			//$this->session->set_userdata('person_id', $row->person_id);
			//print_r($row);exit;
			return $row->email;
		}
		return -1;
			
		
	}
	
	function userinfo1($id,$email1)
	{
	   

		$this->db->from('employees');
		//$this->db->join('people', 'people.person_id = employees.person_id');
		$this->db->where('username',$id);
		$query1=$this->db->get();
		$r['data']=$query1->row();
			
		$query = $this->db->get_where('people', array('email' => $email1,'person_id'=>$r['data']->person_id), 1);
	
		
		
		if ($query->num_rows() >0)
		{
			
			$row=$query->row();
			
			return $r['data'];
		}
			// print_r($query->row());exit;
        
	}
	
	function updatepassword($id,$password)
	{
	   
	 	$this->db->where('person_id',$id);			 
		$result= $this->db->update('employees',  array('password' => md5($password)));		
		return $result;	 
        
	}

	
	function find($id)
	{
		$this->db->from('employees');
		$this->db->where('username',$id);
		$query=$this->db->get();
		return $query->row();
	}
	
	function get_user_activity($user_id)
	{
		$this->db->dbprefix = "usermanagement_";
		$this->db->from('users_activitylog');
		$this->db->where(array('uid' => $user_id,'activity'=>"Login to pointofsale", 'application'=>"Applications Login"));
		$this->db->order_by("id","desc");
		$this->db->limit(1);
		$query=$this->db->get();
		$this->db->dbprefix = "opos_";
		return $query;		
	}
	

}
?>
