/***********************************************************
sift-config.js
**********************************************************/

/*  fonts
**********************************************************/
var sans = { src: '/fonts/sifr_sans.swf' };
var sansb = { src: '/fonts/sifr_sansb.swf' };
var sansbc = { src: '/fonts/sifr_sansbc.swf' };
var sansi = { src: '/fonts/sifr_sansi.swf' };
var sanssb = { src: '/fonts/sifr_sanssb.swf' };
var sanssbc = { src: '/fonts/sifr_sanssbc.swf' };

/*  method calls
**********************************************************/
sIFR.repaintOnResize = true;
sIFR.useDomLoaded = true;
sIFR.forceSingleLine = true;

sIFR.activate(
	sans,
	sansb,
	sansbc,
	sansi,
	sanssb,
	sanssbc
);

/*  deactivate sifr
**********************************************************/
if(typeof sIFR == "object"){
    sIFR.rollback = function(){
        function rollback(sSelector){
            if(sSelector == null){
                sSelector = "";
            } else {
                sSelector += ">";
            };

            sIFR.removeFlashClass();

            if(doRollback(sSelector+"embed") == false){
                doRollback(sSelector+"object");
            };
        };

        function doRollback(sSelector){
            var node, nodeParent, nodeAlternate, nodeAlternateChild, nodeAlternateNextChild, indexNodeToRemove;
            var listNodes = parseSelector(sSelector);
            var i = listNodes.length - 1;
            var bHasRun = false;

            while(i >= 0){
                node = listNodes[i];
                listNodes.length--;
                nodeParent = node.parentNode;

                if(node.className == 'sIFR-flash'){
                    /*  Flash blockers may add other nodes as siblings to the Flash element. 
                        Thus, we remove all children of nodeParent, and look for nodeAlternate at the same time */
                    indexNodeToRemove = 0;

                    while(indexNodeToRemove < nodeParent.childNodes.length){
                        node = nodeParent.childNodes[indexNodeToRemove];
                        if(node.className == "sIFR-alternate"){
                            nodeAlternate = node;
                            indexNodeToRemove++;
                            continue;
                        };
                        nodeParent.removeChild(node);
                    };

                    if(nodeAlternate != null){
                        nodeAlternateChild = nodeAlternate.firstChild;
                        while(nodeAlternateChild != null){
                            nodeAlternateNextChild = nodeAlternateChild.nextSibling;
                            nodeParent.appendChild(nodeAlternate.removeChild(nodeAlternateChild));
                            nodeAlternateChild = nodeAlternateNextChild;
                        };
                        nodeParent.removeChild(nodeAlternate);
                    };

                    nodeParent.className = nodeParent.className.replace(/\bsIFR\-replaced\b/, "");
                    bHasRun = true;
                };

                i--;
            };

            return bHasRun;
        };

        return rollback;
    }();
};


/*  font replacements
**********************************************************/
//h2
sIFR.replace(sanssb, {
	selector: 'h2.sifr',
	css: { 
		'.sIFR-root': { 'font-size': '20px', 'color': '#398ebc', 'leading': 3, ratios: [7, 1.35, 9, 1.29, 10, 1.23, 11, 1.21, 12, 1.19, 15, 1.22, 18, 1.19, 20, 1.17, 22, 1.16, 23, 1.15, 24, 1.14, 28, 1.16, 29, 1.15, 30, 1.14, 31, 1.15, 39, 1.14, 44, 1.13, 57, 1.12, 82, 1.11, 86, 1.1, 88, 1.11, 96, 1.1, 97, 1.11, 1.1] }
	},
	wmode: 'transparent'
}); 

//h3
sIFR.replace(sanssb, {
	selector: 'h3.sifr',
	css: { 
		'.sIFR-root': { 'font-size': '20px', 'color': '#398ebc', 'leading': 3, ratios: [7, 1.35, 9, 1.29, 10, 1.23, 11, 1.21, 12, 1.19, 15, 1.22, 18, 1.19, 20, 1.17, 22, 1.16, 23, 1.15, 24, 1.14, 28, 1.16, 29, 1.15, 30, 1.14, 31, 1.15, 39, 1.14, 44, 1.13, 57, 1.12, 82, 1.11, 86, 1.1, 88, 1.11, 96, 1.1, 97, 1.11, 1.1] }
	},
	wmode: 'transparent'
}); 

sIFR.replace(sanssb, {
	selector: 'h1.entry-title',
	css: { 
		'.sIFR-root': { 'font-size': '20px', 'color': '#398ebc', 'leading': 3, ratios: [7, 1.35, 9, 1.29, 10, 1.23, 11, 1.21, 12, 1.19, 15, 1.22, 18, 1.19, 20, 1.17, 22, 1.16, 23, 1.15, 24, 1.14, 28, 1.16, 29, 1.15, 30, 1.14, 31, 1.15, 39, 1.14, 44, 1.13, 57, 1.12, 82, 1.11, 86, 1.1, 88, 1.11, 96, 1.1, 97, 1.11, 1.1] }
	},
	wmode: 'transparent'
});

//h4
sIFR.replace(sanssbc, {
	selector: 'h3.sifr_alt',
	css: { 
		'.sIFR-root': { 'font-size': '13px', 'color': '#398ebc', 'letter-spacing': 1, ratios: [9, 1.27, 14, 1.19, 21, 1.16, 28, 1.13, 38, 1.12, 53, 1.11, 60, 1.1, 61, 1.11, 94, 1.1, 96, 1.09, 101, 1.1, 102, 1.09, 103, 1.1, 108, 1.09, 110, 1.1, 1.09] }
	},
	wmode: 'transparent'
});

//h5
sIFR.replace(sanssbc, {
	selector: 'h5.sifr',
	css: { 
		'.sIFR-root': { 'font-size': '13px', 'color': '#75664c', 'text-transform': 'uppercase', 'font-weight': 'bold', ratios: [9, 1.27, 14, 1.19, 21, 1.16, 28, 1.13, 38, 1.12, 53, 1.11, 60, 1.1, 61, 1.11, 94, 1.1, 96, 1.09, 101, 1.1, 102, 1.09, 103, 1.1, 108, 1.09, 110, 1.1, 1.09] }
	},
	wmode: 'transparent'
});

//blockquote p.quote
sIFR.replace(sanssb, {
	selector: 'blockquote p.quote',
	css: { 
		'.sIFR-root': { 'font-size': '15px', 'color': '#398ebc', 'leading': 4, ratios: [7, 1.47, 11, 1.31, 14, 1.24, 19, 1.23, 23, 1.19, 30, 1.18, 32, 1.17, 34, 1.16, 43, 1.15, 47, 1.14, 48, 1.13, 53, 1.14, 59, 1.13, 60, 1.12, 65, 1.13, 81, 1.12, 84, 1.11, 87, 1.12, 118, 1.11, 120, 1.1, 123, 1.11, 1.1] }
	},
	wmode: 'transparent'
});

//blockquote p.author
sIFR.replace(sanssbc, {
	selector: 'blockquote p.author',
	css: { 
		'.sIFR-root': { 'font-size': '11px', 'color': '#398ebc', 'text-transform': 'uppercase', ratios: [9, 1.27, 14, 1.19, 21, 1.16, 28, 1.13, 38, 1.12, 53, 1.11, 60, 1.1, 61, 1.11, 94, 1.1, 96, 1.09, 101, 1.1, 102, 1.09, 103, 1.1, 108, 1.09, 110, 1.1, 1.09] }
	},
	wmode: 'transparent'
});

//blockquote p.title
sIFR.replace(sansi, {
	selector: 'blockquote p.title',
	css: { 
		'.sIFR-root': { 'font-size': '11px', 'color': '#398ebc', ratios: [6, 1.24, 7, 1.21, 8, 1.18, 10, 1.16, 11, 1.13, 12, 1.12, 13, 1.11, 15, 1.1, 17, 1.09, 19, 1.08, 22, 1.07, 26, 1.06, 32, 1.05, 41, 1.04, 58, 1.03, 97, 1.02, 1.01] }
	},
	wmode: 'transparent'
});