<?php
if(!empty($payments_history))
{
?>
<script type="text/javascript">
  $(function () {
	//alert("Test");
	//$("#example1").dataTable();
	var table = $('#payments_list_table').DataTable({
	  "bPaginate": <?=$pagination?>,
	  "bLengthChange": true,
	  "pageLength": <?=$limit?>,
	  'displayStart': <?=$displayStart?>,
	  "bFilter": true,
	  "bSort": true,
	  "bInfo": true,
	  "bAutoWidth": false,
	  "order": [[0, "asc"]],
	  //"aoColumnDefs" : [ {'bSortable' : false,'aTargets' : [ 4,5 ]} ]
	});
	
	$('.footable').footable({
	  calculateWidthOverride: function() {
		return { width: $(window).width() };
	  }
	});
	
	$( "#payments_list_table" ).wrap( "<div class='table-responsive'></div>" );
	
  });
</script>
<?php
}
?>

<div class="box-header">
  <h3 class="box-title">List of Payments</h3>
</div>
<!-- /.box-header -->
<div class="box-body">
	<input type="hidden" name="curpage" id="curpage" value="<?=$curpage?>">
    <table id="payments_list_table" class="table table-bordered table-striped table-hover footable responsive">
        <thead>
            <tr>
               <th class="valign-center text-center" style="width:15%;">Transactions ID</th>
               <th data-hide="phone" class="valign-center text-center" style="width:15%;" >Amount</th>
               <th data-hide="phone" class="valign-center text-center" style="width:15%;" >Date</th>
               <th data-hide="phone" class="valign-center text-center" style="width:15%;" >Status</th>
               <th data-hide="phone" class="valign-center text-center" style="width:15%;" >Gateway</th>
               <th data-hide="phone" class="valign-center text-left" style="width:25%;" >Summary</th>
            </tr>
        </thead>     
        <tbody>
		  <?php
          if(!empty($payments_history))
          { 
              foreach($payments_history as $key=>$eachPayment)
			  {
				$transaction_id = drop_multiple_slashes($eachPayment['transaction_id']);
			    $transaction_id = strReplace("|","&#124;",$transaction_id); 
				$amount = drop_multiple_slashes($eachPayment['amount']);
			    $amount = strReplace("|","&#124;",$amount); 
				$date = drop_multiple_slashes($eachPayment['date']);
			    $date = strReplace("|","&#124;",$date); 
				$status = drop_multiple_slashes($eachPayment['status']);
			    $status = strReplace("|","&#124;",$status);
				$gateway = drop_multiple_slashes($eachPayment['gateway']);
			    $gateway = strReplace("|","&#124;",$gateway);
				$summary = drop_multiple_slashes($eachPayment['summary']);
			    $summary = strReplace("|","&#124;",$summary);
				?>
                <tr style="height:35px;">
                  <td class="valign-center text-center"><?=!empty($transaction_id)?$transaction_id:"N/A"?></td>
                  <td class="valign-center text-center"><?=$currency_symbol?>&nbsp;<?=numberFormatDsiplay($amount)?></td>
                  <td class="valign-center text-center"><?=!empty($date)?$date:"N/A"?></td>
                  <td class="valign-center text-center"><?=!empty($status)?$status:"N/A"?></td>
                  <td class="valign-center text-center"><?=!empty($gateway)?ucfirst($gateway):"N/A"?></td>
                  <td class="valign-center text-left"><?=!empty($summary)?$summary:"N/A"?></td>
                </tr>
                <?php
              } 
          }
          else
          {
              echo '<tr><td colspan="6" class="text-center valign-center"><br /><br />No records found.<br /><br /></td></tr>';
          }
          ?>
        </tbody>
        <tfoot>
            <tr>
               <td class="valign-center text-center font-bold">Transactions ID</td>
               <td class="valign-center text-center font-bold">Amount</td>
               <td class="valign-center text-center font-bold">Date</td>
               <td class="valign-center text-center font-bold">Status</td>
               <td class="valign-center text-center font-bold">Gateway</td>
               <td class="valign-center text-left font-bold">Summary</td>
            </tr>
        </tfoot>
	</table>
</div>