<?php
include("InventoryManagement.class.php");
class  IMSuppliers extends InventoryManagement{
	
private $conn;
public $tableprefix;

	
public function  __construct()
	 {
		 $this->conn = $this->connect(DBHOST, DBUSER, DBPASSWORD);
		 $this->usedatabase(CUSTOMERDB);
	 }
	 
/*Function to get Suppliers*/
public function getSuppliers($condition="",$orderby="",$limit="")
	{
		$tbl_opos_people    = TBLPREFIX_OPOS."people";
		$tbl_opos_suppliers = TBLPREFIX_OPOS."suppliers";
		$fields = "$tbl_opos_people.first_name,
				   $tbl_opos_people.last_name	,
				   $tbl_opos_people.phone_number,
				   $tbl_opos_people.email,
				   $tbl_opos_people.address_1,
				   $tbl_opos_people.address_2,
				   $tbl_opos_people.city,
				   $tbl_opos_people.state,
				   $tbl_opos_people.zip,
				   $tbl_opos_people.country,
				   $tbl_opos_people.comments,
				   $tbl_opos_people.curjid	,
				   $tbl_opos_people.login,
				   $tbl_opos_people.person_id,
				   $tbl_opos_people.m_name	,
				   $tbl_opos_suppliers.person_id,
				   $tbl_opos_suppliers.company_name,
				   $tbl_opos_suppliers.account_number,
				   $tbl_opos_suppliers.deleted,
				   $tbl_opos_suppliers.status
				   ";
			   
		$join_suppliers = " LEFT JOIN $tbl_opos_people ON $tbl_opos_people.person_id = $tbl_opos_suppliers.person_id ";
		$suppliers_people = $this->getRows($fields,$tbl_opos_suppliers, " ".$join_suppliers." ".$condition." ".$orderby." ".$limit);
		return $suppliers_people;
		   
	}

/*Function to add Supplier*/	
public function addSupplierPersonid($person_id,$data)
	{
		$data1 = array();
		$table = TBLPREFIX_OPOS."suppliers";
	    $data1['person_id']  = $person_id;
		$data1['company_name'] = cleanSQL($data['company_name']);
		$data1['account_number'] = cleanSQL($data['account_number']);
	    return   $this->addData($data1,$table);
	}
	
public function addSupplier($data)
	{
		global $currency_code;
		$tbl_people = TBLPREFIX_OPOS."people";
		$tbl_suppliers = TBLPREFIX_OPOS."suppliers";
		$tbl_accounting_suppliers = TBLPREFIX_ACCOUNTING."suppliers";
		$tbl_accounting_crm_persons = TBLPREFIX_ACCOUNTING."crm_persons";
		$tbl_accounting_crm_contacts = TBLPREFIX_ACCOUNTING."crm_contacts";
	    
		/*Add data in POS people table*/
		$data_people = array();
		$data_people['email'] = $data['email'];
		$data_people['last_name'] = $data['last_name'];
		$data_people['first_name'] = $data['first_name'];
		$data_people['address_1'] = $data['address_1'];
		$data_people['address_2'] = $data['address_2'];
		$data_people['phone_number'] = $data['phone_number'];
		$data_people['state'] = $data['state'];
		$data_people['country'] = $data['country'];
		$data_people['city'] = $data['city'];
		$data_people['comments'] = $data['comments'];
		$data_people['zip'] = $data['zip'];
	    $person_id = $this->addData($data_people,$tbl_people);
		
		/*Add data in POS supplier table*/
		$data_supplier = array();
		$data_supplier['person_id']  = $person_id;
		$data_supplier['company_name'] = $data['company_name'];
		if(!empty($data['account_number']))
		{$data_supplier['account_number'] = $data['account_number'];}
	    $this->addData($data_supplier,$tbl_suppliers);
		
		/*Sync data with Accounting*/
		/*Add data in supplier table*/
		$data_accounting_supplier = array();
		$data_accounting_supplier['cp_supplier_id']  = $person_id;
		$data_accounting_supplier['supp_name'] = $data['company_name'];
		$data_accounting_supplier['supp_ref'] = $data['company_name'];
		/*$data_accounting_supplier['address'] = ($data['address_1']."\n".$data['address_2']);
		$data_accounting_supplier['supp_address'] = ($data['address_1']."\n".$data['address_2']);*/
		$data_accounting_supplier['address'] = ($data['address_1']);
		$data_accounting_supplier['supp_address'] = ($data['address_2']);
		$data_accounting_supplier['contact'] = $data['first_name']." ".$data['last_name'];
		$data_accounting_supplier['supp_account_no'] = $data['account_number'];
		$data_accounting_supplier['curr_code'] = $currency_code;
		$data_accounting_supplier['payment_terms'] = 4;
		$data_accounting_supplier['tax_included'] = 0;
		$data_accounting_supplier['dimension_id'] = 0;
		$data_accounting_supplier['dimension2_id'] = 0;
		$data_accounting_supplier['credit_limit'] = 0;
		$data_accounting_supplier['payable_account'] = 2100;
		$data_accounting_supplier['payment_discount_account'] = 5060;
		$data_accounting_supplier['tax_group_id'] = 1;
		$data_accounting_supplier['notes'] = $data['comments'];
		$data_accounting_supplier['inactive'] = 0;
	    $accounting_supplier_id = $this->addData($data_accounting_supplier,$tbl_accounting_suppliers);
		
		/*Add data in crm_persons table*/
		$data_accounting_crm_persons = array();
		$data_accounting_crm_persons['pos_supplier_id']  = $person_id;
		$data_accounting_crm_persons['ref'] = $data['company_name'];
		$data_accounting_crm_persons['name'] = $data['first_name'];
		$data_accounting_crm_persons['name2'] = $data['last_name'];
		$data_accounting_crm_persons['address'] = ($data['address_1']."\n".$data['address_2']);
		$data_accounting_crm_persons['phone'] = $data['phone_number'];
		$data_accounting_crm_persons['phone2'] = $data['phone_number'];
		$data_accounting_crm_persons['email'] = $data['email'];
		$data_accounting_crm_persons['notes'] = $data['comments'];
		$data_accounting_crm_persons['application'] = 2;
		$data_accounting_crm_persons['inactive'] = 0;
	    $accounting_crmperson_id = $this->addData($data_accounting_crm_persons,$tbl_accounting_crm_persons);
		
		/*Add data in crm_contacts table*/
		$data_accounting_crm_contacts = array();
		$data_accounting_crm_contacts['person_id']  = $accounting_crmperson_id;
		$data_accounting_crm_contacts['type'] = "supplier";
		$data_accounting_crm_contacts['action'] = "general";
		$data_accounting_crm_contacts['entity_id'] = $accounting_supplier_id;
	    $accounting_crmperson_id = $this->addData($data_accounting_crm_contacts,$tbl_accounting_crm_contacts);
		
		/*Update data in POS supplier table*/
		$this->updateRow($tbl_suppliers,"accounting_supplier_id='$accounting_supplier_id'","WHERE person_id='$person_id'");
		
		return $person_id;
	}	
	
/*Function to update Suppliers*/	
public function updateSupplierPersonid($data1)
	{
		$table = TBLPREFIX_OPOS."suppliers";
        $person_id =  $data1['person_id']  = cleanSQL($_REQUEST['person_id']);
		$data1['company_name'];
		$data1['account_number'] ;
	    return   $this->updateData($person_id,$data1,$table,"person_id");
	}
	
public function updateSupplier($person_id,$data)
	{
		global $currency_code;
		$tbl_people = TBLPREFIX_OPOS."people";
		$tbl_suppliers = TBLPREFIX_OPOS."suppliers";
		$tbl_accounting_suppliers = TBLPREFIX_ACCOUNTING."suppliers";
		$tbl_accounting_crm_persons = TBLPREFIX_ACCOUNTING."crm_persons";
	    
		/*Update data in POS people table*/
		$data_people = array();
		$data_people['email'] = $data['email'];
		$data_people['last_name'] = $data['last_name'];
		$data_people['first_name'] = $data['first_name'];
		$data_people['address_1'] = $data['address_1'];
		$data_people['address_2'] = $data['address_2'];
		$data_people['phone_number'] = $data['phone_number'];
		$data_people['state'] = $data['state'];
		$data_people['country'] = $data['country'];
		$data_people['city'] = $data['city'];
		$data_people['comments'] = $data['comments'];
		$data_people['zip'] = $data['zip'];
	    $this->updateData($person_id,$data_people,$tbl_people,"person_id");
		
		/*Update data in POS supplier table*/
		$data_supplier = array();
		$data_supplier['company_name'] = $data['company_name'];
		$data_supplier['account_number'] = $data['account_number'];
		$this->updateData($person_id,$data_supplier,$tbl_suppliers,"person_id");
		
		/*Sync data with Accounting*/
		/*Update data in supplier table*/
		$data_accounting_supplier = array();
		$data_accounting_supplier['supp_name'] = $data['company_name'];
		$data_accounting_supplier['supp_ref'] = $data['company_name'];
		/*$data_accounting_supplier['address'] = ($data['address_1']."\n".$data['address_2']);
		$data_accounting_supplier['supp_address'] = ($data['address_1']."\n".$data['address_2']);*/
		$data_accounting_supplier['address'] = ($data['address_1']);
		$data_accounting_supplier['supp_address'] = ($data['address_2']);
		$data_accounting_supplier['contact'] = $data['first_name']." ".$data['last_name'];
		$data_accounting_supplier['supp_account_no'] = $data['account_number'];
		$data_accounting_supplier['curr_code'] = $currency_code;
		$data_accounting_supplier['notes'] = $data['comments'];
		$this->updateData($person_id,$data_accounting_supplier,$tbl_accounting_suppliers,"cp_supplier_id");
		
		/*Update data in crm_persons table*/
		$data_accounting_crm_persons = array();
		$data_accounting_crm_persons['ref'] = $data['company_name'];
		$data_accounting_crm_persons['name'] = $data['first_name'];
		$data_accounting_crm_persons['name2'] = $data['last_name'];
		$data_accounting_crm_persons['address'] = ($data['address_1']."\n".$data['address_2']);
		$data_accounting_crm_persons['phone'] = $data['phone_number'];
		$data_accounting_crm_persons['phone2'] = $data['phone_number'];
		$data_accounting_crm_persons['email'] = $data['email'];
		$data_accounting_crm_persons['notes'] = $data['comments'];
		$this->updateData($person_id,$data_accounting_crm_persons,$tbl_accounting_crm_persons,"pos_supplier_id");
	}		

/*Function to close db connection*/	
public function close()
	{
		$this->close_db($this->conn);
	}
	
}
?>