<?php
include("IMSuppliers.class.php");
class  Items extends Main{
	
private $conn;
public $tableprefix;
public $store;
public $store_name;
public $account_name;
	
public function  __construct($CUSTOMERDB="")
	{
		$this->conn = $this->connect(DBHOST, DBUSER, DBPASSWORD);
		$customer_db = "";
		if(!empty($CUSTOMERDB))
		{
			$this->usedatabase($CUSTOMERDB);
			$customer_db = $CUSTOMERDB;
		}
		else
		{
			$this->usedatabase(CUSTOMERDB);
			$customer_db = CUSTOMERDB;
		}

		$this->account_name = explode("_applications_", $customer_db)[1];


		$this->tableprefix = TBLPREFIX_OPOS;
		 
		if(!getSession('item_store') || empty(getSession('item_store')))
		$this->store = "items";
		else
		$this->store = getSession('item_store');
		 
		$this->store_name = str_replace("_storeitems","",$this->store);
	}

/***************************/
/***Categories Functions****/
/***************************/

/*Function to get Categories*/
public function getCategories($where="",$orderby="",$limit="")
	{
		$fields =  " * ";
		$categories =  $this->getRows($fields,$this->tableprefix."category",  "  ".$where." ".$orderby." ".$limit);	
		//$eshopsetting = $this->selectallwhere("eshop_general_settings", $fields," ".$cond);	
		return $categories;
	}
	
/*Function to get All Categories*/	
public function getAllCategories($condition="",$orderby="",$limits="")
	{
		/*$fields = " * ";*/
		$fields = "id,title,parent,timestamp,editable,deleted,status";
		$categories = $this->selectallCategories($this->tableprefix."category", $fields, $condition." ".$orderby." ".$limits);	
		return $categories;
	}

/*Function to Single Category*/	
public function getCategoy($id="")
	{
		$fields =  " * ";
		$category =  $this->getRow($fields,$this->tableprefix."category", " WHERE id='$id' ");	
		//$eshopsetting = $this->selectallwhere("eshop_general_settings", $fields," ".$cond);	
		return $category;
	}
	
/*Function to get Sub Categories*/
public function getSubCategories($where="",$orderby="",$limit="")
	{
		$fields =  " * ";
		$categories =  $this->getRows($fields,$this->tableprefix."category",  "  ".$where." ".$orderby." ".$limit);	
		//$eshopsetting = $this->selectallwhere("eshop_general_settings", $fields," ".$cond);	
		return $categories;
	}
	
/*Function to save Category*/
public function saveCategory($data)
	{
		//print_r($data);exit();
		$category_id = cleanSQL($data['category_id']);
		$data_category['title'] = drop_multiple_slashes($data['title']);
		$data_category['parent'] = $data['parent'];
		$data_category['status'] = $data['status'];
		
		$table_category = TBLPREFIX_OPOS."category";
		$table_c5_productgroup = "VividStoreGroups";
		$table_accounting_category = TBLPREFIX_ACCOUNTING."stock_category";
		
		if(empty($category_id)) 
		{
			$action = 1;
			$category_id = $this->addData($data_category,$table_category);
		}
		else
		{  
			$action = 2;
			$this->updateData($category_id,$data_category,$table_category,"id");
		}
		
		/*Save Product in Sitebuilder(Concrete5)*/
		$data_c5 = $data;
		$data_c5['action'] = $action;//1 For Add and 2 For Update
		$data_c5['category_id'] = $category_id;
		$c5_pgID = $this->saveC5ProductGroup($data_c5);
		
		/*Save Product in Accounting Stock*/
		$data_accounting = $data;
		$data_accounting['action'] = $action;//1 For Add and 2 For Update
		$data_accounting['category_id'] = $category_id;
		$data_accounting['c5_pgID'] = $c5_pgID;
		$accounting_category_id = $this->saveAccountingStockCategory($data_accounting);
		
		if($action == 1)
		{
			/*Update POS Category*/
			$this->updateRow($table_category,"c5_pgID='$c5_pgID',accounting_category_id='$accounting_category_id'","WHERE id='$category_id'");
				
			/*Update C5 Product Group*/
			/*$checkPackageEcommerce = $this->getRow("*","Packages"," WHERE pkgHandle='vivid_store' ");
			if(!empty($checkPackageEcommerce))*/
			if(checkTableFromDB($table_c5_productgroup,$this)==1)
			{
				$this->updateRow($table_c5_productgroup,"accounting_category_id='$accounting_category_id'","WHERE cp_category_id='$category_id'");
			}
		}
		
		return $category_id;
		
	}	
	
/*Save Category in Concrete5*/
public function saveC5ProductGroup($data)
	{
		/*Check Packages Table for Sitebuilder*/
		if(checkTableFromDB("Packages",$this)==1)
		{
			/*Check Ecommerce Activation in Sitebuilder(Concrete5)*/
			/*$checkPackageEcommerce = $this->getRow("*","Packages"," WHERE pkgHandle='vivid_store' ");
			if(!empty($checkPackageEcommerce))*/
			$table_c5_productgroup = "VividStoreGroups";
			if(checkTableFromDB($table_c5_productgroup,$this)==1)
			{
				
				$datetime = date('Y-m-d H:i:s');
				
				/*Check Column (cp_category_id) in VividStoreGroups in Sitebuilder(Concrete5)*/
				$exists = $this->dbcountrows("SHOW COLUMNS FROM $table_c5_productgroup LIKE 'cp_category_id'")?TRUE:FALSE;
				if(!$exists) {
				   $this->dbqueryexe("ALTER TABLE $table_c5_productgroup ADD `cp_category_id` INT(11) NOT NULL AFTER `groupName`;");
				}
				
				/*Check Column (accounting_category_id) in VividStoreGroups in Sitebuilder(Concrete5)*/
				$exists = $this->dbcountrows("SHOW COLUMNS FROM $table_c5_productgroup LIKE 'accounting_category_id'")?TRUE:FALSE;
				if(!$exists) {
				   $this->dbqueryexe("ALTER TABLE $table_c5_productgroup ADD `accounting_category_id` INT(11) NOT NULL AFTER `cp_category_id`;");
				}
				
				//print_r($data);exit();

				$category_id = $data['category_id'];
				
				if($data['action'] == 1) 
				{
					/*Add Data in Sitebuilder Product Group*/
					$c5_productgroup_data = array();
					$c5_productgroup_data['cp_category_id'] = $category_id;
					$c5_productgroup_data['groupName'] = $data['title'];
					$c5_pgID = $this->addData($c5_productgroup_data,$table_c5_productgroup);
					return $c5_pgID;
				}
				else
				{
					/*Check Product Group*/
					$checkProductGroup = $this->getRow("*",$table_c5_productgroup," WHERE cp_category_id='$category_id' ");
					
					if(!empty($checkProductGroup))
					{
						/*Update Data in Sitebuilder Product Group*/
						$this->updateRow($table_c5_productgroup,"groupName='".$data['title']."'","WHERE cp_category_id='$category_id'");
					}
					return $checkProductGroup['gID'];
				}
				
			}

		}

	}
	
/*Save Category in Accounting*/
public function saveAccountingStockCategory($data)
	{
		$table_accounting_category = TBLPREFIX_ACCOUNTING."stock_category";
			
		//print_r($data);exit();
		
		$category_id = $data['category_id'];
		if($data['status']==1){$inactive=0;}else{$inactive=1;}
		if($data['action'] == 1) 
		{
			/*Add Data in Accounting Stock Category*/
			$accounting_category_data = array();
			$accounting_category_data['cp_category_id'] = $category_id;
			$accounting_category_data['c5_pgID'] = $data['c5_pgID'];
			$accounting_category_data['description'] = $data['title'];
			$accounting_category_data['dflt_tax_type'] = 1;
			$accounting_category_data['dflt_units'] = "each";
			$accounting_category_data['dflt_mb_flag'] = "B";
			$accounting_category_data['dflt_sales_act'] = 4010;
			$accounting_category_data['dflt_cogs_act'] = 5010;
			$accounting_category_data['dflt_inventory_act'] = 1510;
			$accounting_category_data['dflt_adjustment_act'] = 5040;
			$accounting_category_data['dflt_assembly_act'] = 1530;
			$accounting_category_data['dflt_dim1'] = 0;
			$accounting_category_data['dflt_dim2'] = 0;
			$accounting_category_data['inactive'] = 0;
			$accounting_category_data['dflt_no_sale'] = 0;
			$accounting_category_data['inactive'] = $inactive;
			$accounting_category_id = $this->addData($accounting_category_data,$table_accounting_category);
			return $accounting_category_id;
		}
		else
		{
			/*Check Product Group*/
			$checkAccountingCategory = $this->getRow("*",$table_accounting_category," WHERE cp_category_id='$category_id' ");
			
			if(!empty($checkAccountingCategory))
			{
				/*Update Data in Accounting Stock Category*/
				$this->updateRow($table_accounting_category,"inactive='$inactive',description='".$data['title']."'","WHERE cp_category_id='$category_id'");
			}
			return $checkAccountingCategory['category_id'];
		}
		
	}				
	
/***************************/
/***Attributes Functions****/
/***************************/	
	
/*Function to get Attributes*/	
public function getAttributes($where="",$orderby="",$limit="")
	{
		$fields = " * ";
		$attributes =  $this->getRows($fields,$this->tableprefix."attributes",  "  ".$where." ".$orderby." ".$limit);	
		//$eshopsetting = $this->selectallwhere("eshop_general_settings", $fields," ".$cond);	
		return $attributes;
	}
	
/*Function to get Single Attribute*/	
public function getAttribute($id="")
	{
		$fields =  " * ";
		$attributes =  $this->getRow($fields,$this->tableprefix."attributes", " WHERE id='$id' ");	
		//$eshopsetting = $this->selectallwhere("eshop_general_settings", $fields," ".$cond);	
		return $attributes;
	}		
	
/*Function to get Sub Attributes*/	
public function getSubAttributes($where="",$orderby="",$limit="")
	{
		$fields =  " * ";
		$attributes =  $this->getRows($fields,$this->tableprefix."attributes",  "  ".$where." ".$orderby." ".$limit);	
		//$eshopsetting = $this->selectallwhere("eshop_general_settings", $fields," ".$cond);	
		return $attributes;
	}

/***************************/
/****Suppliers Functions****/
/***************************/

/*Function to get Suppliers*/	
public function getSuppliers($where="",$orderby="",$limit="")
	{
		$fields = " * ";
		$suppliers =  $this->getRows($fields,$this->tableprefix."suppliers",  "  ".$where." ".$orderby." ".$limit);	
		//$eshopsetting = $this->selectallwhere("eshop_general_settings", $fields," ".$cond);	
		return $suppliers;
	}
/*Function to get Suppliers*/	
public function getSupplier($supplier_id)
	{
		$fields = " * ";
		//$supplier =  $this->getRow($fields,$this->tableprefix."suppliers",  " WHERE person_id='$supplier_id ");
		$supplier =  $this->getRow($fields,$this->tableprefix."suppliers", " WHERE person_id='$supplier_id' ");	
		//$eshopsetting = $this->selectallwhere("eshop_general_settings", $fields," ".$cond);	
		return $supplier;
	}	
	
/***************************/
/******Items Functions******/
/***************************/	

/*Function to get Items*/	
public function getItems($where="",$orderby="",$limit="")
	{
		$fields =  " * ";
		$items =  $this->getRows($fields,$this->tableprefix.$this->store,"  ".$where." ".$orderby." ".$limit);
		//$eshopsetting = $this->selectallwhere("eshop_general_settings", $fields," ".$cond);	
		return $items;
	}
	
/*Function to get Single Item*/	
public function getItem($id="")
	{
		$fields =  " * ";
		$items =  $this->getRow($fields,$this->tableprefix.$this->store, " WHERE item_id='$id' ");	
		//$eshopsetting = $this->selectallwhere("eshop_general_settings", $fields," ".$cond);	
		return $items;
	}
	
/*Function to get Item Sale Tax*/	
public function getItemSaleTax($where="",$orderby="",$limit="")
	{
		$fields =  " * ";
		$itemsSaleTax =  $this->getRows($fields,$this->tableprefix."items_taxes",  "  ".$where." ".$orderby." ".$limit);	
		//$eshopsetting = $this->selectallwhere("eshop_general_settings", $fields," ".$cond);	
		return $itemsSaleTax;
	}

/*Function to get Item Images*/	
public function getItemImages($id="")
	{
		$fields =  " * ";
		//$itemsItemImages =  $this->getRow($fields,$this->tableprefix."item_images", " WHERE item_id='$id' ");
		$itemsItemImages =  $this->getRow($fields,$this->tableprefix."item_images", " WHERE item_id='$id' AND store = '".$this->store_name."' ");	
		return $itemsItemImages;
	}
	
/*Function to Save Item*/
public function saveItem($data)
	{
		//print_r($data);exit();
		$item_id = cleanSQL($data['item_id']);
		$data_item['name']            = drop_multiple_slashes($data['name']);
		$data_item['category_id']     = $data['category_id'];
		if(!empty($data['item_number']))
		{$data_item['item_number']    = drop_multiple_slashes($data['item_number']);}
		$data_item['quantity']        = $data['quantity'];
		$data_item['cost_price']      = $data['cost_price'];
		$data_item['unit_price']      = $data['unit_price'];
		$data_item['retailprice']     = $data['retailprice'];
		$data_item['description']     = drop_multiple_slashes(strip_tags($data['description']));
		$data_item['supplier_id']     = $data['supplier_id'];
		$data_item['shandle']     	 = $data['shandle'];
		$data_item = $this->cleanData($data_item);
		
		$item_store = cleanSQL($this->store);
		$item_store_name = cleanSQL($this->store_name);//exit();
		
		/*include(ZROOT."wpsitebuilder\wp-includes\post.php:");	
		 $post_id = wp_insert_post( array(
                'post_title' =>'samtest',
                'post_type' => 'product',
                'post_status' => 'publish',
                'post_content' => 'test content',
            ));
		return  $post_id;
		 exit();*/

		$table = TBLPREFIX_OPOS.$item_store;
		$table_tax = TBLPREFIX_OPOS."items_taxes";
		$table_images = TBLPREFIX_OPOS."item_images";
		
		if(empty($item_id)) 
		{
			/*$checkItem = $this->getRow("*",$table," WHERE item_number='".$data['item_number']."' ");
			if(!empty($checkItem) && $checkItem['item_number'] == $data['item_number'])
			{
				  echo "|0|Item UPC/EAN/ISBN already exists|";
				  exit();
			}*/
			$data_item['wp_pid'] = $this->addUpdateWPSitebuilderItem($this->account_name,'add',$data_item);


			$item_id = $this->addData($data_item,$table);
			$action = 1;
		}
		else
		{  
			/*$checkItem = $this->getRow("*",$table," WHERE item_number='".$data['item_number']."' AND item_id!='$item_id' ");
			if(!empty($checkItem) && $checkItem['item_number'] == $data['item_number'])
			{
				  echo "|0|Item UPC/EAN/ISBN already exists|";
				  exit();
			}*/
			$this->updateData($item_id,$data_item,$table,"item_id");
			$action = 2;
		}
		
		$taxes = cleanSQL($data['taxes']);
		if(!empty($taxes)) {
				
			//echo substr($taxes,0,-1);exit();
			$taxes_array = explode("|" , substr($taxes,0,-1));
			$this->delete($table_tax, " WHERE item_id='$item_id' ");
			
			foreach ($taxes_array as $key=>$row)
			{
				 $taxes_subarray =   explode("-" , $row);
				 $data_tax = array();
				 $data_tax['name'] =  drop_multiple_slashes($taxes_subarray[0]);
				 $data_tax['percent'] =  $taxes_subarray[1];
				 $data_tax['item_id']  = $item_id;
				 $data_tax['store'] = $item_store_name;
				 $this->delete($table_tax, " WHERE item_id='$item_id' AND name='".$data_tax['name']."' ");
				 $data_tax = $this->cleanData($data_tax);
				 $this->addData($data_tax,$table_tax);
			}
			
		}
		
		/*Items Images */
		global $SESSION_CUSTOMER;
		if (!empty($SESSION_CUSTOMER)) {
			
			$items_images =  $this->getRow("*",$table_images, " WHERE item_id='$item_id' ");	
							
			$isimage_upload = 0;
			if(!empty($data['main_image_file']))
			{
				$main_image_file = $data['main_image_file'];
				if(!empty($main_image_file['name']))
				{
					$item_image_status = $this->uploadItemImages($main_image_file,$item_id,"main_image",$SESSION_CUSTOMER);
					$item_image_status_Array = explode("|",$item_image_status);//print_r($item_image_status_Array);
					/*if($item_image_status_Array[2] == 0)
					{
						echo "|0|".$item_image_status_Array[1]."|".$item_id."|";
						$item_image = $item_image_status_Array[1];
					}*/

					$this->uploadWPSitebuilderItemImage($this->account_name,$item_id);
				}
				
				$isimage_upload = 1;
				
			}
			
			if(!empty($data['image_path']))
			{
				$item_image_status = $this->copyItemImagesFromPath($data['image_path'],$item_id,"main_image",$SESSION_CUSTOMER);
				$item_image_status_Array = explode("|",$item_image_status);//print_r($item_image_status_Array);
				/*if($item_image_status_Array[2] == 0)
				{
					$item_image = $item_image_status_Array[1];
				}*/
				$isimage_upload = 1;
			}
			
		}
		
		$isimage_upload = 0;
		/*Save Product in Sitebuilder(Concrete5)*/
		$data_c5 = $data;
		$data_c5['action'] = $action;//1 For Add and 2 For Update
		$data_c5['item_id'] = $item_id;
		$data_c5['cp_store'] = $item_store_name;
		$data_c5['isimage_upload'] = $isimage_upload;//1 For Copy Item Image to C5 Product
		$data_c5['user_id'] = $data['user_id'];
		$data_c5['account_name'] = $data['account_name'];
		$c5_pID = $this->saveConcreteProduct($data_c5);
		//exit();
		
		/*Save Item in Accounting Stock*/
		$data_accounting = $data;
		$data_accounting['action'] = $action;//1 For Add and 2 For Update
		$data_accounting['item_id'] = $item_id;
		$data_accounting['c5_pID'] = $c5_pID;
		$data_accounting['cp_store'] = $item_store_name;
		$data_accounting['isimage_upload'] = $isimage_upload;//1 For Copy Item Image to C5 Product
		$data_accounting['user_id'] = $data['user_id'];
		$data_accounting['account_name'] = $data['account_name'];
		$accounting_category_id = $this->saveAccountingStock($data_accounting);
		
		//return $item_id;
		return $response = array("item_id"=>$item_id,"item_image_status"=>$item_image_status_Array); 
	}

/*Function to Upload Item Images*/	
public function uploadItemImages($image,$item_id,$image_field,$SESSION_CUSTOMER)
	{
		//echo ZROOT;exit();
		$image_tmpname = $image['tmp_name'];
		//$fileparts = explode('.',$image['name']);
		//$extension = $fileparts[1];
		$extension = end(explode(".",$image['name']));
		$image_name = $image_field.$item_id.".".$extension;//exit;	
		
		$itemImagesPath = ZROOT ."pointofsale/uploads/itemimages/".$SESSION_CUSTOMER['account_name']."/".$this->store_name."/";//exit();
		
		if (file_exists($itemImagesPath) == false) 
		{ 
		  mkdir($itemImagesPath, 0775, true);
		  mkdir($itemImagesPath.'/listings', 0775, true);
		  mkdir($itemImagesPath.'/thumbs', 0775, true);
		}
		
		$uploadfile_main = $itemImagesPath."".$image_name;//exit;
		$itemImagesPath_listings = $itemImagesPath ."listings/";
		$itemImagesPath_thumbs = $itemImagesPath ."thumbs/";
		$uploadfile_listings = $itemImagesPath_listings."".$image_name;
		$uploadfile_thumbs = $itemImagesPath_thumbs."".$image_name;
		
		$allowedExtentions = array("gif", "jpeg", "jpg", "png","pdf","JPEG","PNG","GIF","JPG");
		$extensions = end(explode(".",$image_name));
		if (!empty($image) && in_array($extensions,$allowedExtentions)) 
		{
			
			if (move_uploaded_file($image_tmpname, $uploadfile_main)) 
			{
			
			
				/*// *** Include the class  
				include("resize-class.php");  
		
				 // *** 1) Initialize / load image  
				$resizeObj = new resize($targetFile);
				
				// *** 2) Resize image (options: exact, portrait, landscape, auto, crop)  
				$resizeObj->resizeImage(800, 600, 'auto');
		
				// *** 3) Save image  
				$resizeObj->saveImage($targetFile, 100);*/
				
				include(ZROOT."source/lib/resize-class.php");	
				$resizeObj = new resize($uploadfile_main);
				//include("../../config.php");
				//include("image-class.php");
				//$imgproc = new imageprocessing();
				// *** 2) Resize image (options: exact, portrait, landscape, auto, crop)
				$resizeObj -> resizeImage(200, 200, 'auto');	
				// *** 3) Save image
				$resizeObj -> saveImage($uploadfile_listings, 100);
				
				// *** 2) Resize image (options: exact, portrait, landscape, auto, crop)
				$resizeObj -> resizeImage(100, 100, 'auto');	
				// *** 3) Save image
				$resizeObj -> saveImage($uploadfile_thumbs, 100);
				
				/*include("image-class.php");
				$imgproc = new imageprocessing();
				list($width, $height) = getimagesize($targetFile); 
				list($rw,$rh) = $imgproc->getImgthumbresoluttion($width,$height);
				list($imw,$imh) = $imgproc->getImgresoluttion($width,$height,$rw,$rh);*/
				
				
				$image_id = $this->saveItemImages($image_name,$item_id,$image_field);
				return "|".$image_name."?".time()."|1|".$image_name;
				
			} 
			else
			{
				return $error = "|".("There has been an error while uploading the image, make sure that the image is not bigger than 3000px or 3MB.")."|0|";
			}
			
		}
		else
		{
			return $error = "|".("File type is not supported.")."|0|";
		}
	}
	
/*Function to Copy Item Images from URL*/	
public function copyItemImagesFromPath($image_path,$item_id,$image_field,$SESSION_CUSTOMER)
	{
		
		$extension = explode("?",end(explode(".",$image_path)));
		$extension = strtolower($extension[0]);
		$image_name = $image_field.$item_id.".".$extension;//exit;	
		
		$itemImagesPath = ZROOT ."pointofsale/uploads/itemimages/".$SESSION_CUSTOMER['account_name']."/".$this->store_name."/";//exit();
		
		if (file_exists($itemImagesPath) == false) 
		{ 
		  mkdir($itemImagesPath, 0775, true);
		  mkdir($itemImagesPath.'/listings', 0775, true);
		  mkdir($itemImagesPath.'/thumbs', 0775, true);
		}
		
		$uploadfile_main = $itemImagesPath."".$image_name;//exit;
		
		$itemImagesPath_listings = $itemImagesPath ."listings/";
		$itemImagesPath_thumbs = $itemImagesPath ."thumbs/";
		$uploadfile_listings = $itemImagesPath_listings."".$image_name;
		$uploadfile_thumbs = $itemImagesPath_thumbs."".$image_name;
		
		$allowedExtentions = array("gif", "jpeg", "jpg", "png","pdf","JPEG","PNG","GIF","JPG");
		$extensions = end(explode(".",$image_name));
		if (!empty($image_path) && in_array($extensions,$allowedExtentions)) 
		{
			
			/*Start Copy Image from Url*/
			copyImageFromUrl($image_path,$uploadfile_main);
			/*ini_set('upload_max_filesize', '10M');
			$content = file_get_contents($image_path);
			file_put_contents($uploadfile_main,$content);*/
			/*End Copy Image from Url*/
			
			if (file_exists($uploadfile_main))
			{
			
				/*// *** Include the class  
				include("resize-class.php");  
		
				 // *** 1) Initialize / load image  
				$resizeObj = new resize($targetFile);
				
				// *** 2) Resize image (options: exact, portrait, landscape, auto, crop)  
				$resizeObj->resizeImage(800, 600, 'auto');
		
				// *** 3) Save image  
				$resizeObj->saveImage($targetFile, 100);*/
				
				/*include(ZROOT."source/lib/resize-class.php");	
				$resizeObj = new resize($uploadfile_main);*/

				// *** 2) Resize image (options: exact, portrait, landscape, auto, crop)
				//$resizeObj -> resizeImage(200, 200, 'auto');	
				// *** 3) Save image
				//$resizeObj -> saveImage($uploadfile_listings, 100);
				//copy($uploadfile_main,$uploadfile_listings);
				resizeImages($extension,200,$uploadfile_listings, $uploadfile_main);
				
				// *** 2) Resize image (options: exact, portrait, landscape, auto, crop)
				//$resizeObj -> resizeImage(100, 100, 'auto');	
				// *** 3) Save image
				//$resizeObj -> saveImage($uploadfile_thumbs, 100);
				//copy($uploadfile_main,$uploadfile_thumbs);
				resizeImages($extension,100,$uploadfile_thumbs, $uploadfile_main);
				
				$image_id = $this->saveItemImages($image_name,$item_id,$image_field);
				return $image_name."?".time()."|1|".$image_id;
				
			} 
			else
			{
				return $error = ("There has been an error while copy the image, make sure that the image is not bigger than 3000px or 3MB.")."|0";
			}
			
		}
		else
		{
			return $error = ("File type is not supported.")."|0";
		}
	}	

/*Function to Save Item Images*/	
public function saveItemImages($image_name,$item_id,$image_field)
	{
		$table_images = TBLPREFIX_OPOS."item_images";
		$items_images =  $this->getRow("*",$table_images, " WHERE item_id='$item_id' AND store = '".$this->store_name."' ");
		$data_images = array();
		$data_images[$image_field] = $image_name;
		$data_images = $this->cleanData($data_images);
		if(empty($items_images))
		{
			$data_images['item_id'] = $item_id;
			$data_images['store'] = $this->store_name;
			return $this->addData($data_images,$table_images);
		}
		else
		{
			$this->updateData($item_id,$data_images,$table_images,"item_id");
			return $items_images['id'];
		}
	}		

/*Function to get Assigned Items*/	
public function getItemAssign($source_store,$where="",$orderby="",$limit="")
	{
	   $fields =  " * ";
	   $table_items = $this->tableprefix.$source_store;
	   //return "SELECT table_name FROM INFORMATION_SCHEMA.TABLES WHERE table_schema = '".CUSTOMERDB."' and table_name='$table_name'"; 
	   $exists = $this->dbqueryexe("SELECT table_name FROM INFORMATION_SCHEMA.TABLES WHERE table_schema = '".CUSTOMERDB."' AND table_name='$table_items'");
	   $exists = mysql_fetch_array($exists);//print_r($exists);
	   if(!empty($exists))
	   {
	   		$items =  $this->getRows($fields,$table_items,  "  ".$where." ".$orderby." ".$limit);
	   }else{$items = array();}
	   return $items;
		
	}

/*Function to get Imported Items*/
public function saveImportData(&$item_data,$item_number=false)
	{
		//print_r($item_data);exit();
		$table = $this->tableprefix.$this->store;
		
		/*Check and Save Category*/
		$category = cleanSQL(drop_multiple_slashes(($item_data['category'])));
		if(!empty($category))
		{
			$tbl_pos_category = $this->tableprefix."category";
			$categoryCheck = $this->getRow("*",$tbl_pos_category, " WHERE title = '".$category."' ");
			if(!empty($categoryCheck)){$category_id = $categoryCheck['id'];}
			else
			{
				$data_category = array();
				$data_category['title'] = $category;
				$data_category['parent'] = 0;
				$data_category['status'] = 1;
				$data_category = $this->cleanData($data_category);
				$category_id = $this->saveCategory($data_category);
			}
			unset($item_data['category']);
		}
		
		$itemCheck = $this->getRow("*",$table, " WHERE item_number = '".$item_number."' ");
		//print_r($itemCheck);
		/*$this->db->from($table);
		$this->db->where('item_number',$item_number);
		$query = $this->db->get();
		$exist = $query->num_rows();*/
		//if (empty($item_number) or empty($itemCheck))
		if (empty($itemCheck))
		{//return "Insert";
			//if($this->db->insert($table,$item_data))
			$item_data['category_id'] = $category_id;

			$item_data['wp_pid'] = $this->addUpdateWPSitebuilderItem($this->account_name,'add',$item_data);

			$item_id = $this->addData($item_data,$table);
			if(!empty($item_id))
			{
				//$item_data['item_id']=$this->db->insert_id();
				$item_data['item_id'] = $item_id;
				return true;
			}
			return false;
		}
		else
		{
			//$this->db->where('item_number', $item_number);
			//if($this->db->update($this->store,$item_data))
			//return "UPDATE".$this->updateData($itemCheck['item_id'],$item_data,$table,"item_id");
			/*if($this->updateData($itemCheck['item_id'],$item_data,$table,"item_id"))
			{			
				//$item_data['item_id'] = $this->get_item_id($item_number);
				echo $item_data['item_id'] = $itemCheck['item_id'];
				return true;
			}
			return false;*/
			$item_data['category_id'] = $category_id;
			$item_data['deleted'] = 0;
			$this->updateData($itemCheck['item_id'],$item_data,$table,"item_id");
			$item_data['item_id'] = $itemCheck['item_id'];
			return true;
		}
		
		
	}

/*Function to get Item Taxes*/	
public function saveItemTaxes(&$items_taxes_data, $item_id)
	{
	
		//Run these queries as a transaction, we want to make sure we do all or nothing
		//$this->db->trans_start();
		$table = $this->tableprefix."items_taxes";
		//$this->delete($item_id);
		$this->removeData(" WHERE item_id = '$item_id' ",$table);
		//print_r($items_taxes_data);
		foreach ($items_taxes_data as $row)
		{
			$row['item_id'] = $item_id;
			$row['store'] = $this->store_name;
			//$this->db->insert('items_taxes',$row);
			$this->addData($row,$table);		
		}
		
		//$this->db->trans_complete();
		return true;
	}
	
/*Function to get Tax Value*/	
public function getTaxValue($where="",$orderby="",$limit="")
	{
		$fields =  " * ";
		$taxvalue =  $this->getRows($fields,$this->tableprefix."app_config","  ".$where." ".$orderby." ".$limit);
		return $taxvalue;
	}	

/*Function to Delete Item From POS ,Accounting and Concrete5*/
public function deleteItemData($data)
	{
		
		$item_id = $data['item_id'];
		$item_store = $data['item_store'];

		if(!isset($_REQUEST['delete_action_called_from_wp_sitebuilder']))
			$this->deleteWPSitebuilderItem($data['account_name'],$item_id);
		
		/*Delete From POS Tables*/
		$table_pos_items = TBLPREFIX_OPOS.$this->store;
	  	
		/*Remove From POS Item Tax*/
		$table_pos_itemtaxes = TBLPREFIX_OPOS."items_taxes";
		$this->removeData(" WHERE item_id='$item_id' AND store = '".$this->store_name."'",$table_pos_itemtaxes);
		
		/*Remove From POS Item Images*/
		$item_images = $this->getItemImages($item_id);
		if(!empty($item_images))
		{
		  
		  $targetfilePathPOS = ZROOT."pointofsale/uploads/itemimages/".$data['account_name']."/".$this->store_name."/";
		  
		  $main_image = $item_images['main_image'];
		  if (file_exists($targetfilePathPOS."/".$main_image))unlink($targetfilePathPOS."/".$main_image);
		  if (file_exists($targetfilePathPOS."/listings/".$main_image))unlink($targetfilePathPOS."/listings/".$main_image);
		  if (file_exists($targetfilePathPOS."/thumbs/".$main_image))unlink($targetfilePathPOS."/thumbs/".$main_image);
		  
		  $image1 = $item_images['image1'];
		  if (file_exists($targetfilePathPOS."/".$image1))unlink($targetfilePathPOS."/".$image1);
		  if (file_exists($targetfilePathPOS."/listings/".$image1))unlink($targetfilePathPOS."/listings/".$image1);
		  if (file_exists($targetfilePathPOS."/thumbs/".$image1))unlink($targetfilePathPOS."/thumbs/".$image1);
		  
		  $image2 = $item_images['image2'];
		  if (file_exists($targetfilePathPOS."/".$image2))unlink($targetfilePathPOS."/".$image2);
		  if (file_exists($targetfilePathPOS."/listings/".$image2))unlink($targetfilePathPOS."/listings/".$image2);
		  if (file_exists($targetfilePathPOS."/thumbs/".$image2))unlink($targetfilePathPOS."/thumbs/".$image2);
		  
		  $image3 = $item_images['image3'];
		  if (file_exists($targetfilePathPOS."/".$image3))unlink($targetfilePathPOS."/".$image3);
		  if (file_exists($targetfilePathPOS."/listings/".$image3))unlink($targetfilePathPOS."/listings/".$image3);
		  if (file_exists($targetfilePathPOS."/thumbs/".$image3))unlink($targetfilePathPOS."/thumbs/".$image3);
		  
		  $image4 = $item_images['image4'];
		  if (file_exists($targetfilePathPOS."/".$image4))unlink($targetfilePathPOS."/".$image4);
		  if (file_exists($targetfilePathPOS."/listings/".$image4))unlink($targetfilePathPOS."/listings/".$image4);
		  if (file_exists($targetfilePathPOS."/thumbs/".$image4))unlink($targetfilePathPOS."/thumbs/".$image4);
		  
		  /*Remove From POS Item Images*/
		  $table_pos_itemimages = TBLPREFIX_OPOS."item_images";
		  $this->removeData(" WHERE item_id='$item_id' AND store='".$this->store_name."' ",$table_pos_itemimages);
		}
		
		/*Delete From Accounting Tables*/
		$table_accounting_stockmaster = TBLPREFIX_ACCOUNTING."stock_master";
		$get_accounting_iteminfo = $this->getRow("*",$table_accounting_stockmaster," WHERE cp_item_id='$item_id' ");
		$targetPathAccounting = ZROOT."accounting/company/".$data['account_name']."/";
		if (!empty($get_accounting_iteminfo))
		{
			$fileparts = explode('.',$item_images['main_image']);
			$extension = strtolower($fileparts[1]);
			$accounting_image = $get_accounting_iteminfo['stock_id'].".". $extension;
			if (file_exists($targetPathAccounting."/images/".$accounting_image))unlink($targetPathAccounting."/images/".$accounting_image);
			
			/*Delete From Accounting Master Stock Tables*/
			$this->removeData(" WHERE stock_id='".$get_accounting_iteminfo['stock_id']."' ",TBLPREFIX_ACCOUNTING."loc_stock");
		
			$this->removeData(" WHERE stock_id='".$get_accounting_iteminfo['stock_id']."' ",TBLPREFIX_ACCOUNTING."item_codes");
			
			$this->removeData(" WHERE stock_id='".$get_accounting_iteminfo['stock_id']."' ",TBLPREFIX_ACCOUNTING."prices");
		}
		
		/*Delete From Accounting Master Stock Table*/
		$this->removeData(" WHERE cp_item_id='$item_id'",$table_accounting_stockmaster);
		
		/*Check Packages Table for Sitebuilder*/
		if(checkTableFromDB("Packages",$this)==1)
		{
		
			/*Check Ecommerce Activation in Sitebuilder(Concrete5)*/
			/*$checkPackageEcommerce = $this->getRow("*","Packages"," WHERE pkgHandle='vivid_store' ");
			if(!empty($checkPackageEcommerce))*/
			$table_products = "VividStoreProducts";
			if(checkTableFromDB($table_products,$this)==1)
			{
				
				/*Delete From Sitebuilder(Concrete5) Tables*/
				
				/*Check Column (cp_item_id) in VividStoreProducts in Sitebuilder(Concrete5)*/
				$exists = $this->dbcountrows("SHOW COLUMNS FROM $table_products LIKE 'cp_item_id'")?TRUE:FALSE;
				if(!$exists) {
				   $this->dbqueryexe("ALTER TABLE $table_products ADD `cp_item_id` INT(121) NOT NULL AFTER `pExclusive`;");
				}
				
				/*Check Column (cp_store) in VividStoreProducts in Sitebuilder(Concrete5)*/
				$exists = $this->dbcountrows("SHOW COLUMNS FROM $table_products LIKE 'cp_store'")?TRUE:FALSE;
				if(!$exists) {
				   $this->dbqueryexe("ALTER TABLE $table_products ADD `cp_store` VARCHAR(255) NOT NULL AFTER `cp_item_id`;");
				}
				
				/*Check Column (accounting_stock_id) in VividStoreProducts in Sitebuilder(Concrete5)*/
				$exists = $this->dbcountrows("SHOW COLUMNS FROM $table_products LIKE 'accounting_stock_id'")?TRUE:FALSE;
				if(!$exists) {
				   $this->dbqueryexe("ALTER TABLE $table_products ADD `accounting_stock_id` VARCHAR(20) NOT NULL AFTER `cp_store`;");
				}
				
				/*Get C5 Product Data*/
				$get_c5_productinfo = $this->getRow("*",$table_products," WHERE cp_item_id='$item_id' AND cp_store='$item_store' ");
				$pID = $get_c5_productinfo['pID'];
				$cID = $get_c5_productinfo['cID'];
			
				/*Get Target CID*/
				$getTargetCID = $this->getRow("cID","PagePaths", "WHERE cPath = '/product-detail'");
				$targetCID = $getTargetCID['cID'];
			
				/*Get Parent Page Data*/
				$parentPage = $this->getRow("*","Pages", "WHERE cID = '$targetCID'");
			
				/*Delete From C5 Product Option Groups*/
				$this->removeData(" WHERE pID='$pID' ","VividStoreProductOptionGroups");
			
			
				/*Delete From C5 Product Option Items*/
				$this->removeData(" WHERE pID='$pID' ","VividStoreProductOptionItems");
			
				/*Delete From C5 Product Images*/
				$this->removeData(" WHERE pID='$pID' ","VividStoreProductImages");
			
				/*Delete From C5 Product Groups*/
				$this->removeData(" WHERE pID='$pID' ","VividStoreProductGroups");
			
				/*Delete From C5 Collections*/
				$this->removeData(" WHERE cID='$cID' ","Collections");
			
				/*Delete From C5 CollectionVersions*/
				$this->removeData(" WHERE cID='$cID' ","CollectionVersions");
			
				/*Delete From C5 AttributeValues*/
				$get_collectionattributevalues = $this->getRow("*","CollectionAttributeValues", "WHERE cID = '$cID' AND akID=5");
				$this->removeData(" WHERE avID='".$get_collectionattributevalues['avID']."' ","AttributeValues");
			
				$get_collectionattributevalues = $this->getRow("*","CollectionAttributeValues", "WHERE cID = '$cID' AND akID=2");
				$this->removeData(" WHERE avID='".$get_collectionattributevalues['avID']."' ","AttributeValues");
			
				/*Delete From C5 CollectionAttributeValues*/
				$this->removeData(" WHERE cID='$cID' ","CollectionAttributeValues");
			
				/*Delete From C5 CollectionSearchIndexAttributes*/
				$this->removeData(" WHERE cID='$cID' ","CollectionSearchIndexAttributes");
			
				/*Delete From C5 CollectionVersionBlocks*/
				$this->removeData(" WHERE cID='$cID' ","CollectionVersionBlocks");
			
				/*Delete From C5 Pages*/
				$this->removeData(" WHERE cID='$cID' ","Pages");
				/*Update Data in Pages*/
				$pages_increment_data = array();
				$pages_increment_data['cChildren'] = $parentPage['cChildren']-1;
				$this->updateData($targetCID,$pages_increment_data,"Pages","cID");
			
				/*Delete From C5 PageSearchIndex*/
				$this->removeData(" WHERE cID='$cID' ","PageSearchIndex");
			
				/*Delete From C5 PagePaths*/
				$this->removeData(" WHERE cID='$cID' ","PagePaths");
			
				/*Delete From C5 Areas*/
				$this->removeData(" WHERE cID='$cID' ","Areas");
			
				/*Delete From C5 Products*/
				$this->removeData(" WHERE pID='$pID' ",$table_products);
			}
		
		}
		
		/*Delete From POS Items*/
		$this->removeData(" WHERE item_id='$item_id' ",$table_pos_items);
		
		
	}
	
/*Function to Save Item in Concrete5*/
public function saveConcreteProduct($data)
	{

		/*Check Packages Table for Sitebuilder*/
		if(checkTableFromDB("Packages",$this)==1)
		{
			/*Check Ecommerce Activation in Sitebuilder(Concrete5)*/
			/*$checkPackageEcommerce = $this->getRow("*","Packages"," WHERE pkgHandle='vivid_store' ");
			if(!empty($checkPackageEcommerce))*/
			$checkPackageEcommerce = $this->getRow("*","Packages"," WHERE pkgHandle='vivid_store' ");
			$product_table = "VividStoreProducts";
			if(checkTableFromDB($product_table,$this)==1)
			{
				//$product_table = "VividStoreProducts";
				$fileversion_table = "FileVersions";
				$pagepaths_table = "PagePaths";
				$pages_table = "Pages";
				$collections_table = "Collections";
				$collection_versions_table = "CollectionVersions";
				$collection_attributevalues_table = "CollectionAttributeValues";
				
				$data = $this->cleanData($data);
				
				$datetime = date('Y-m-d H:i:s');
				
				/*Check Column (cp_item_id) in VividStoreProducts in Sitebuilder(Concrete5)*/
				$exists = $this->dbcountrows("SHOW COLUMNS FROM $product_table LIKE 'cp_item_id'")?TRUE:FALSE;
				if(!$exists) {
				   $this->dbqueryexe("ALTER TABLE $product_table ADD `cp_item_id` INT(121) NOT NULL AFTER `pExclusive`;");
				}
				
				/*Check Column (cp_store) in VividStoreProducts in Sitebuilder(Concrete5)*/
				$exists = $this->dbcountrows("SHOW COLUMNS FROM $product_table LIKE 'cp_store'")?TRUE:FALSE;
				if(!$exists) {
				   $this->dbqueryexe("ALTER TABLE $product_table ADD `cp_store` VARCHAR(255) NOT NULL AFTER `cp_item_id`;");
				}
				
				/*Check Column (accounting_stock_id) in VividStoreProducts in Sitebuilder(Concrete5)*/
				$exists = $this->dbcountrows("SHOW COLUMNS FROM $product_table LIKE 'accounting_stock_id'")?TRUE:FALSE;
				if(!$exists) {
				   $this->dbqueryexe("ALTER TABLE $product_table ADD `accounting_stock_id` VARCHAR(20) NOT NULL AFTER `cp_store`;");
				}
				
				/*Check Column (is_recurring_payment) in VividStoreProducts in Sitebuilder(Concrete5)*/
				$exists = $this->dbcountrows("SHOW COLUMNS FROM $product_table LIKE 'is_recurring_payment'")?TRUE:FALSE;
				if(!$exists) {
				   $this->dbqueryexe("ALTER TABLE $product_table ADD `is_recurring_payment` TINYINT(1) NULL DEFAULT NULL AFTER `pExclusive`;");
				}
				
				/*Check Column (recurring_payment_amount) in VividStoreProducts in Sitebuilder(Concrete5)*/
				$exists = $this->dbcountrows("SHOW COLUMNS FROM $product_table LIKE 'recurring_payment_amount'")?TRUE:FALSE;
				if(!$exists) {
				   $this->dbqueryexe("ALTER TABLE $product_table ADD `recurring_payment_amount` DOUBLE NULL DEFAULT NULL AFTER `is_recurring_payment`;");
				}
				
				/*Check Column (recurring_payment_period) in VividStoreProducts in Sitebuilder(Concrete5)*/
				$exists = $this->dbcountrows("SHOW COLUMNS FROM $product_table LIKE 'recurring_payment_period'")?TRUE:FALSE;
				if(!$exists) {
				   $this->dbqueryexe("ALTER TABLE $product_table ADD `recurring_payment_period` VARCHAR(30) NULL DEFAULT NULL COMMENT 'days For Days,months For Monthly,years For Yearly' AFTER `recurring_payment_amount`;");
				}
				
				/*Check Column (recurring_payment_frequency) in VividStoreProducts in Sitebuilder(Concrete5)*/
				$exists = $this->dbcountrows("SHOW COLUMNS FROM $product_table LIKE 'recurring_payment_frequency'")?TRUE:FALSE;
				if(!$exists) {
				   $this->dbqueryexe("ALTER TABLE $product_table ADD `recurring_payment_frequency` INT(10) NULL DEFAULT NULL AFTER `recurring_payment_period`;");
				}
				
				/*Check Column (recurring_payment_total_cycles) in VividStoreProducts in Sitebuilder(Concrete5)*/
				$exists = $this->dbcountrows("SHOW COLUMNS FROM $product_table LIKE 'recurring_payment_total_cycles'")?TRUE:FALSE;
				if(!$exists) {
				   $this->dbqueryexe("ALTER TABLE $product_table ADD `recurring_payment_total_cycles` INT(10) NULL DEFAULT NULL AFTER `recurring_payment_frequency`;");
				}
				
				/*Check Column (recurring_payment_trial_cycles) in VividStoreProducts in Sitebuilder(Concrete5)*/
				$exists = $this->dbcountrows("SHOW COLUMNS FROM $product_table LIKE 'recurring_payment_trial_cycles'")?TRUE:FALSE;
				if(!$exists) {
				   $this->dbqueryexe("ALTER TABLE $product_table ADD `recurring_payment_trial_cycles` INT(10) NULL DEFAULT NULL AFTER `recurring_payment_total_cycles`;");
				}
				
				/*Check Column (recurring_payment_trial_amount) in VividStoreProducts in Sitebuilder(Concrete5)*/
				$exists = $this->dbcountrows("SHOW COLUMNS FROM $product_table LIKE 'recurring_payment_trial_amount'")?TRUE:FALSE;
				if(!$exists) {
				   $this->dbqueryexe("ALTER TABLE $product_table ADD `recurring_payment_trial_amount` DOUBLE NULL DEFAULT NULL AFTER `recurring_payment_trial_cycles`;");
				}
				
				/*Check Column (c5_pID) in POS Store Items*/
				$table_pos_items = TBLPREFIX_OPOS.$this->store;
				$exists = $this->dbcountrows("SHOW COLUMNS FROM `$table_pos_items` LIKE 'c5_pID'")?TRUE:FALSE;
				if(!$exists) {
				   $this->dbqueryexe("ALTER TABLE `$table_pos_items` ADD `c5_pID` INT(11) NOT NULL AFTER `item_id`;");
				}
				
				//print_r($data);exit();
				
				$item_id = $data['item_id'];
				$handle = drop_multiple_slashes($data['name']);
				$handle = preg_replace('/[^\\p{L}\\p{Nd}\-_]+/u', ' ', $handle); // remove unneeded chars
				$handle = preg_replace('/[-\s]+/', '-', $handle); // convert spaces to hyphens
				$handle = trim(substr($handle, 0, 128), '-'); // trim to first $max_length chars
				$handle = strtolower(str_replace(" ", "-", $handle));//exit();
					
				if($data['action'] == 1) 
				{
					
					/*Generate Detail Page*/
					/*Get Package Id*/
					$pkgID = $checkPackageEcommerce['pkgID'];
					
					/*Get Target CID*/
					$getTargetCID = $this->getRow("cID","PagePaths", "WHERE cPath = '/product-detail'");
					$targetCID = $getTargetCID['cID'];
					
					/*Get Parent Page Data*/
					$parentPage = $this->getRow("*","Pages", "WHERE cID = '$targetCID'");
					//print_r($parentPage);
					
					/*Get Collection Data*/
					$parentPageCollectionVersion = $this->getRow("*","CollectionVersions", "WHERE cID = '$targetCID'");
					//print_r($parentPageCollectionVersion);
					
					/*Get Page Type Data*/
					$pageType = $this->getRow("*","PageTypes", "WHERE ptHandle = 'store_product'");
					//print_r($pageType);
					
					$templateID = 6;
					
					/*Add Data in Collections*/
					$collections_data = array();
					$collections_data['cHandle'] = $handle;
					$collections_data['cDateAdded'] = $datetime;
					$collections_data['cDateModified'] = $datetime;
					$collections_data = $this->cleanData($collections_data);
					$cID = $this->addData($collections_data,$collections_table);
					
					/*Add Data in Collection Versions*/
					$collection_versions_data = array();
					$collection_versions_data['cID'] = $cID;
					$collection_versions_data['cvID'] = 1;
					$collection_versions_data['pTemplateID'] = $templateID;
					$collection_versions_data['cvName'] = drop_multiple_slashes($data['name']);
					$collection_versions_data['cvHandle'] = $handle;
					$collection_versions_data['cvDescription'] = drop_multiple_slashes($data['description']);
					$collection_versions_data['cvDatePublic'] = $datetime;
					$collection_versions_data['cvDateCreated'] = $datetime;
					$collection_versions_data['cvComments'] = "Initial Version";
					$collection_versions_data['cvAuthorUID'] = $data['user_id'];
					$collection_versions_data['cvIsApproved'] = 1;
					$collection_versions_data['cvIsNew'] = 0;
					$collection_versions_data['pThemeID'] = $parentPageCollectionVersion['pThemeID'];
					$collection_versions_data = $this->cleanData($collection_versions_data);
					$cvID = $this->addData($collection_versions_data,$collection_versions_table);
					
					/*Add Data in Pages*/
					$pages_data = array();
					$pages_data['cID'] = $cID;
					$pages_data['ptID'] = $pageType['ptID'];
					$pages_data['cParentID'] = $targetCID;
					$pages_data['uID'] = $data['user_id'];
					$pages_data['cInheritPermissionsFrom'] = "PARENT";
					$pages_data['cOverrideTemplatePermissions'] = 1;
					$pages_data['cInheritPermissionsFromCID'] = 1;
					$cDisplayOrder = $this->getRow("MAX(cDisplayOrder) as cDisplayOrder","Pages", "WHERE cParentID = '$targetCID'");
					$pages_data['cDisplayOrder'] = $cDisplayOrder['cDisplayOrder']+1;
					$pages_data['pkgID'] = $pkgID;
					$pages_data = $this->cleanData($pages_data);
					$pageID = $this->addData($pages_data,$pages_table);
					
					/*Update Data in Pages*/
					$pages_increment_data = array();
					$pages_increment_data['cChildren'] = $parentPage['cChildren']+1;
					$pages_increment_data = $this->cleanData($pages_increment_data);
					$this->updateData($targetCID,$pages_increment_data,$pages_table,"cID");
					
					/*Add Data in PageSearchIndex*/
					$pagesearchindex_data = array();
					$pagesearchindex_data['cID'] = $cID;
					$pagesearchindex_data['cName'] = drop_multiple_slashes($data['name']);
					$pagesearchindex_data['cDescription'] = drop_multiple_slashes($data['description']);
					$pagesearchindex_data['cPath'] = '/product-detail/'.$handle;
					$pagesearchindex_data['cDatePublic'] = $datetime;
					$pagesearchindex_data['cDateLastIndexed'] = $datetime;
					$pagesearchindex_data['cRequiresReindex'] = 0;
					$pagesearchindex_data = $this->cleanData($pagesearchindex_data);
					$this->addData($pagesearchindex_data,"PageSearchIndex");
					
					/*Add Data in AttributeValues For Exclude Nav*/
					$attributevalues_exclude_nav_data = array();
					$attributevalues_exclude_nav_data['akID'] = 5;
					$attributevalues_exclude_nav_data['avDateAdded'] = $datetime;
					$attributevalues_exclude_nav_data['uID'] = $data['user_id'];
					$attributevalues_exclude_nav_data['atID'] = 3;
					$attributevalues_exclude_nav_data = $this->cleanData($attributevalues_exclude_nav_data);
					$avID_exclude_nav = $this->addData($attributevalues_exclude_nav_data,"AttributeValues");
					$collection_attributevalues_exclude_nav_data = array();
					$collection_attributevalues_exclude_nav_data['cID'] = $cID;
					$collection_attributevalues_exclude_nav_data['cvID'] = 1;
					$collection_attributevalues_exclude_nav_data['akID'] = 5;
					$collection_attributevalues_exclude_nav_data['avID'] = $avID_exclude_nav;
					$collection_attributevalues_exclude_nav_data = $this->cleanData($collection_attributevalues_exclude_nav_data);
					$this->addData($collection_attributevalues_exclude_nav_data,"CollectionAttributeValues");
					
					/*Add Data in AttributeValues For Meta Description*/
					$attributevalues_description_data = array();
					$attributevalues_description_data['akID'] = 2;
					$attributevalues_description_data['avDateAdded'] = $datetime;
					$attributevalues_description_data['uID'] = $data['user_id'];
					$attributevalues_description_data['atID'] = 2;
					$attributevalues_description_data = $this->cleanData($attributevalues_description_data);
					$avID_description = $this->addData($attributevalues_description_data,"AttributeValues");
					$collection_attributevalues_description_data = array();
					$collection_attributevalues_description_data['cID'] = $cID;
					$collection_attributevalues_description_data['cvID'] = 1;
					$collection_attributevalues_description_data['akID'] = 2;
					$collection_attributevalues_description_data['avID'] = $avID_description;
					$collection_attributevalues_description_data = $this->cleanData($collection_attributevalues_description_data);
					$this->addData($collection_attributevalues_description_data,"CollectionAttributeValues");
					
					/*Add Data in CollectionSearchIndexAttributes*/
					$collectionsearchindexattributes_data = array();
					$collectionsearchindexattributes_data['cID'] = $cID;
					$collectionsearchindexattributes_data['ak_meta_description'] = drop_multiple_slashes($data['description']);
					$collectionsearchindexattributes_data['ak_exclude_nav'] = 1;
					$collectionsearchindexattributes_data = $this->cleanData($collectionsearchindexattributes_data);
					$this->addData($collectionsearchindexattributes_data,"CollectionSearchIndexAttributes");
					
					/*Add Data in CollectionVersionBlocks*/
					/*Get Block Type ID*/
					$blockType = $this->getRow("*","BlockTypes", "WHERE btHandle = 'vivid_product' AND pkgID='$pkgID'");
					/*Get Block ID*/
					$blockData = $this->getRows("*","Blocks", "WHERE btID = '".$blockType['btID']."' ORDER BY bID ASC LIMIT 0,1");
					//print_r($blockData);
					$collectionversionblocks_data = array();
					$collectionversionblocks_data['cID'] = $cID;
					$collectionversionblocks_data['cvID'] = 1;
					$collectionversionblocks_data['bID'] = $blockData[0]['bID'];
					$collectionversionblocks_data['arHandle'] = 'Main';
					$collectionversionblocks_data = $this->cleanData($collectionversionblocks_data);
					$this->addData($collectionversionblocks_data,"CollectionVersionBlocks");
					
					/*Add Data in PagePaths*/
					/*Get Block Type ID*/
					$page_path = '/product-detail/'.$handle;
					$countPagePaths = $this->getRow("COUNT(ppID) as total_path","PagePaths", "WHERE cPath LIKE '%$page_path%'");
					if($countPagePaths['total_path']>0){$page_path = $page_path."-".$countPagePaths['total_path'];}else{$page_path = $page_path;}
					$pagepaths_data = array();
					$pagepaths_data['cID'] = $cID;
					$pagepaths_data['cPath'] = $page_path;
					$pagepaths_data['ppIsCanonical'] = 1;
					$pagepaths_data['ppGeneratedFromURLSlugs'] = 1;
					$pagepaths_data = $this->cleanData($pagepaths_data);
					$this->addData($pagepaths_data,"PagePaths");
					
					/*Add Data in Areas*/
					$areas_data = array();
					$areas_data['cID'] = $cID;
					$areas_data['arHandle'] = "Main";
					$areas_data['arOverrideCollectionPermissions'] = 0;
					$areas_data['arInheritPermissionsFromAreaOnCID'] = 0;
					$areas_data['arIsGlobal'] = 0;
					$areas_data['arParentID'] = 0;
					$areas_data = $this->cleanData($areas_data);
					$this->addData($areas_data,"Areas");
					
					/*Save C5 Product Images*/
					if($data['isimage_upload'] == 1)
					{$pfID = $this->copyC5ProductImages($data);}
					
					/*Get POS Category Data*/
					$get_pos_category = $this->getRow("*",TBLPREFIX_OPOS."category", "WHERE id ='".$data['category_id']."'");//print_r($getCID);
					
					/*Save C5 Product Data*/
					$product_data = array();
					$product_data['pName'] = drop_multiple_slashes($data['name']);
					$product_data['pDesc'] = drop_multiple_slashes($data['description']);
					//$product_data['pDetail'] = drop_multiple_slashes($data['description']);
					$product_data['pPrice'] = $data['retailprice'];
					$product_data['cPrice'] = $data['cost_price'];
					$product_data['pSalePrice'] = $data['unit_price'];
					$product_data['pFeatured'] = 0;
					$product_data['pQty'] = $data['quantity'];
					$product_data['pActive'] = 1;
					$product_data['pTaxClass'] = 1;
					$product_data['pShippable'] = (!empty($data['isshipable']))?$data['isshipable']:1;
					$product_data['pTaxable'] = (!empty($data['taxable']))?$data['taxable']:"";
					$product_data['pWeight'] = (!empty($data['weight']))?$data['weight']:"";
					$product_data['pDateAdded'] = $datetime;
					$product_data['is_recurring_payment'] = $data['is_recurring_payment'];
					$product_data['recurring_payment_amount'] = $data['recurring_payment_amount'];
					$product_data['recurring_payment_period'] = $data['recurring_payment_period'];
					$product_data['recurring_payment_frequency'] = $data['recurring_payment_frequency'];
					$product_data['recurring_payment_total_cycles'] = $data['recurring_payment_total_cycles'];
					$product_data['recurring_payment_trial_cycles'] = $data['recurring_payment_trial_cycles'];
					$product_data['recurring_payment_trial_amount'] = $data['recurring_payment_trial_amount'];
					$product_data['cp_item_id'] = $item_id;
					$product_data['cp_store'] = $data['cp_store'];
					$product_data['cID'] = $cID;
					$product_data['pfID'] = $pfID;
					$product_data['gID'] = $get_pos_category['c5_pgID'];
					$product_data = $this->cleanData($product_data);
					$pID = $this->addData($product_data,$product_table);
					
					/*Save C5 Product Group*/
					//$get_pos_category = $this->getRow("*",TBLPREFIX_OPOS."category", "WHERE id ='".$data['category_id']."'");//print_r($getCID);
					$productgroup_data = array();
					$productgroup_data['pID'] = $pID;
					$productgroup_data['gID'] = $get_pos_category['c5_pgID'];
					$productgroup_data = $this->cleanData($productgroup_data);
					$this->addData($productgroup_data,"VividStoreProductGroups");
					
					/*Update C5 Product ID in POS Items*/
					$table_pos_items = TBLPREFIX_OPOS.$this->store;
					/*Check Column (c5_pID) in POS Store Items*/
					/*$exists = $this->dbcountrows("SHOW COLUMNS FROM `$table_pos_items` LIKE 'c5_pID'")?TRUE:FALSE;
					if(!$exists) {
					   $this->dbqueryexe("ALTER TABLE `$table_pos_items` ADD `c5_pID` INT(11) NOT NULL AFTER `item_id`;");
					}*/
					$positems_data = array();
					$positems_data['c5_pID'] = $pID;
					$positems_data = $this->cleanData($positems_data);
					$this->updateData($item_id,$positems_data,$table_pos_items,"item_id");
					
					return $pID;
					
				}
				else
				{
					/*Save C5 Product Images*/
					if($data['isimage_upload'] == 1)
					{$pfID = $this->copyC5ProductImages($data);}
					
					/*Get Target CID*/
					$getCID = $this->getRow("*",$product_table, "WHERE cp_item_id = '$item_id' AND cp_store='".$data['cp_store']."'");//print_r($getCID);
					$pID = $getCID['pID'];
					$cID = $getCID['cID'];
					
					/*Update C5 Collections Data*/
					$collections_data = array();
					$collections_data['cHandle'] = $handle;
					$collections_data['cDateModified'] = $datetime;
					$collections_data = $this->cleanData($collections_data);
					$this->updateData($cID,$collections_data,$collections_table,"cID");
					
					/*Update C5 Collection Versions Data*/
					$collection_versions_data = array();
					$collection_versions_data['cvName'] = $data['name'];
					$collection_versions_data['cvHandle'] = $handle;
					$collection_versions_data['cvDescription'] = drop_multiple_slashes($data['description']);
					$collection_versions_data = $this->cleanData($collection_versions_data);
					$this->updateData($cID,$collection_versions_data,$collection_versions_table,"cID");
					
					/*Update C5 Collections Data*/
					$collections_data = array();
					$collections_data['cHandle'] = $handle;
					$collections_data['cDateModified'] = $datetime;
					$collections_data = $this->cleanData($collections_data);
					$this->updateData($cID,$collections_data,$collections_table,"cID");
					
					/*Update C5 CollectionSearchIndexAttributes Data*/
					$collectionsearchindexattributes_data = array();
					$collectionsearchindexattributes_data['ak_meta_description'] = drop_multiple_slashes($data['description']);
					$collectionsearchindexattributes_data = $this->cleanData($collectionsearchindexattributes_data);
					$this->updateData($cID,$collectionsearchindexattributes_data,"CollectionSearchIndexAttributes","cID");
					
					/*Update Data in PagePaths*/
					/*Get Block Type ID*/
					$page_path = '/product-detail/'.$handle;
					$countPagePaths = $this->getRow("COUNT(ppID) as total_path,cPath","PagePaths", "WHERE cPath LIKE '%$page_path%' AND cID!='$cID'");
					if($countPagePaths['total_path']>0){$page_path = $page_path."-".$countPagePaths['total_path'];}else{$page_path = $page_path;}
					$pagepaths_data = array();
					$pagepaths_data['cPath'] = $page_path;
					$pagepaths_data = $this->cleanData($pagepaths_data);
					$this->updateData($cID,$pagepaths_data,"PagePaths","cID");
					
					/*Update Data in PageSearchIndex*/
					$pagesearchindex_data = array();
					$pagesearchindex_data['cName'] = drop_multiple_slashes($data['name']);
					$pagesearchindex_data['cDescription'] = drop_multiple_slashes($data['description']);
					$pagesearchindex_data['cPath'] = '/product-detail/'.$handle;
					$pagesearchindex_data = $this->cleanData($pagesearchindex_data);
					$this->updateData($cID,$pagesearchindex_data,"PageSearchIndex","cID");
					
					/*Get POS Category Data*/
					$get_pos_category = $this->getRow("*",TBLPREFIX_OPOS."category", "WHERE id ='".$data['category_id']."'");//print_r($getCID);
					
					/*Update C5 Product Data*/
					$product_data = array();
					$product_data['pName'] = drop_multiple_slashes($data['name']);
					$product_data['pDesc'] = drop_multiple_slashes($data['description']);
					//$product_data['pDetail'] = drop_multiple_slashes($data['description']);
					$product_data['pPrice'] = $data['retailprice'];
					$product_data['cPrice'] = $data['cost_price'];
					$product_data['pSalePrice'] = $data['unit_price'];
					$product_data['pQty'] = $data['quantity'];
					$product_data['pShippable'] = (!empty($data['isshipable']))?$data['isshipable']:1;
					$product_data['pTaxable'] = (!empty($data['taxable']))?$data['taxable']:"";
					$product_data['pWeight'] = (!empty($data['weight']))?$data['weight']:"";
					$product_data['is_recurring_payment'] = $data['is_recurring_payment'];
					$product_data['recurring_payment_amount'] = $data['recurring_payment_amount'];
					$product_data['recurring_payment_period'] = $data['recurring_payment_period'];
					$product_data['recurring_payment_frequency'] = $data['recurring_payment_frequency'];
					$product_data['recurring_payment_total_cycles'] = $data['recurring_payment_total_cycles'];
					$product_data['recurring_payment_trial_cycles'] = $data['recurring_payment_trial_cycles'];
					$product_data['recurring_payment_trial_amount'] = $data['recurring_payment_trial_amount'];
					$product_data['pfID'] = $pfID;
					$product_data['gID'] = $get_pos_category['c5_pgID'];
					$product_data = $this->cleanData($product_data);
					$this->updateData($pID,$product_data,$product_table,"pID");
					
					/*Save C5 Product Group*/
					//$get_pos_category = $this->getRow("*",TBLPREFIX_OPOS."category", "WHERE id ='".$data['category_id']."'");//print_r($getCID);
					$productgroup_data = array();
					$productgroup_data['pID'] = $pID;
					$productgroup_data['gID'] = $get_pos_category['c5_pgID'];
					$this->removeData(" WHERE pID='$pID' ","VividStoreProductGroups");
					$productgroup_data = $this->cleanData($productgroup_data);
					$this->addData($productgroup_data,"VividStoreProductGroups");
					
					return $pID;
				}
				
			}
		}
		
	}
	
/*Save Product Option Group in Concrete5*/
public function saveC5ProductOptionGroup($data)
	{
		/*Check Packages Table for Sitebuilder*/
		if(checkTableFromDB("Packages",$this)==1)
		{
			/*Check Ecommerce Activation in Sitebuilder(Concrete5)*/
			/*$checkPackageEcommerce = $this->getRow("*","Packages"," WHERE pkgHandle='vivid_store' ");
			if(!empty($checkPackageEcommerce))*/
			$table_c5_productoptiongroups = "VividStoreProductOptionGroups";
			if(checkTableFromDB($table_c5_productoptiongroups,$this)==1)
			{
				
				/*Remove Data from c5 Product Option Group*/
				//$this->removeData(" WHERE pID='".$data['pID']."' ",$table_c5_productoptiongroups);
				
				//print_r($data);exit();
				/*Add Data in c5 Product Option Group*/
				$c5_productoptiongroups_data = array();
				$c5_productoptiongroups_data['pID'] = $data['pID'];
				$c5_productoptiongroups_data['pogName'] = $data['pogName'];
				$c5_productoptiongroups_data['pogSort'] = $data['pogSort'];
				$c5_pogID = $this->addData($c5_productoptiongroups_data,$table_c5_productoptiongroups);
				return $c5_pogID;
			}
		}
	}
	
/*Delete Product Option Group from Concrete5*/
public function deleteC5ProductOptionGroup($pID)
	{
		/*Check Packages Table for Sitebuilder*/
		if(checkTableFromDB("Packages",$this)==1)
		{
			/*Check Ecommerce Activation in Sitebuilder(Concrete5)*/
			/*$checkPackageEcommerce = $this->getRow("*","Packages"," WHERE pkgHandle='vivid_store' ");
			if(!empty($checkPackageEcommerce))*/
			if(checkTableFromDB("VividStoreProductOptionGroups",$this)==1)
			{
				$this->removeData(" WHERE pID='".$pID."' ","VividStoreProductOptionGroups");
			}
		}
	}
	
/*Save Product Option Item in Concrete5*/
public function saveC5ProductOptionItem($data)
	{
		/*Check Packages Table for Sitebuilder*/
		if(checkTableFromDB("Packages",$this)==1)
		{
			/*Check Ecommerce Activation in Sitebuilder(Concrete5)*/
			/*$checkPackageEcommerce = $this->getRow("*","Packages"," WHERE pkgHandle='vivid_store' ");
			if(!empty($checkPackageEcommerce))*/
			$table_c5_productoptionitems = "VividStoreProductOptionItems";
			if(checkTableFromDB($table_c5_productoptionitems,$this)==1)
			{
				
				/*Remove Data from c5 Product Option Group*/
				//$this->removeData(" WHERE pID='".$data['pID']."' ",$table_c5_productoptionitems);
				
				//print_r($data);exit();
				/*Add Data in c5 Product Option Items*/
				$c5_productoptionitems_data = array();
				$c5_productoptionitems_data['pID'] = $data['pID'];
				$c5_productoptionitems_data['pogID'] = $data['pogID'];
				$c5_productoptionitems_data['poiName'] = $data['poiName'];
				$c5_productoptionitems_data['poiSort'] = $data['poiSort'];
				$c5_poiID = $this->addData($c5_productoptionitems_data,$table_c5_productoptionitems);
				return $c5_poiID;
			}
		}
	}

/*Delete Product Option Item from Concrete5*/
public function deleteC5ProductOptionItem($pID)
	{
		/*Check Packages Table for Sitebuilder*/
		if(checkTableFromDB("Packages",$this)==1)
		{
			/*Check Ecommerce Activation in Sitebuilder(Concrete5)*/
			/*$checkPackageEcommerce = $this->getRow("*","Packages"," WHERE pkgHandle='vivid_store' ");
			if(!empty($checkPackageEcommerce))*/
			if(checkTableFromDB("VividStoreProductOptionItems",$this)==1)
			{
				$this->removeData(" WHERE pID='".$pID."' ","VividStoreProductOptionItems");
			}
		}
	}					

public function copyC5ProductImages($data)
	{
		$item_id = $data['item_id'];
		$item_images = $this->getItemImages($item_id);
		if(!empty($item_images['main_image']))
		{
			$sourcePOSImagePath = ZROOT."pointofsale/uploads/itemimages/".$data['account_name']."/".$this->store_name."/".$item_images['main_image'];
			if (file_exists($sourcePOSImagePath))
			{
				$fileparts = explode('.',$item_images['main_image']);
				$extension = strtolower($fileparts[1]);
				
				/*Copy Product Image in Sitebuilder(Concrete5)*/
				$fvPrefix = rand(10, 99) . time();
				$fvPrefix_array = str_split($fvPrefix,4);
				$targetPathC5 = ZROOT."sitebuilder/".$data['account_name']."/files";
				$targetPathC5_files = $targetPathC5.sprintf('/%s/%s/%s', $fvPrefix_array[0], $fvPrefix_array[1], $fvPrefix_array[2]);
				$targetPathC5_files_small = $targetPathC5."/thumbnails/small".sprintf('/%s/%s/%s', $fvPrefix_array[0], $fvPrefix_array[1], $fvPrefix_array[2]);
				$targetPathC5_files_small_2x = $targetPathC5."/thumbnails/small_2x".sprintf('/%s/%s/%s', $fvPrefix_array[0], $fvPrefix_array[1], $fvPrefix_array[2]);
				$targetPathC5_files_medium = $targetPathC5."/thumbnails/medium".sprintf('/%s/%s/%s', $fvPrefix_array[0], $fvPrefix_array[1], $fvPrefix_array[2]);
				$targetPathC5_files_large = $targetPathC5."/thumbnails/large".sprintf('/%s/%s/%s', $fvPrefix_array[0], $fvPrefix_array[1], $fvPrefix_array[2]);
				$targetPathC5_files_manage_listings = $targetPathC5."/thumbnails/file_manager_listing".sprintf('/%s/%s/%s', $fvPrefix_array[0], $fvPrefix_array[1], $fvPrefix_array[2]);
				$targetPathC5_files_manage_listings2x = $targetPathC5."/thumbnails/file_manager_listing_2x".sprintf('/%s/%s/%s', $fvPrefix_array[0], $fvPrefix_array[1], $fvPrefix_array[2]);
				$targetPathC5_files_manage_detail = $targetPathC5."/thumbnails/file_manage_detail".sprintf('/%s/%s/%s', $fvPrefix_array[0], $fvPrefix_array[1], $fvPrefix_array[2]);
				$targetPathC5_files_manage_detail2x = $targetPathC5."/thumbnails/file_manage_detail_2x".sprintf('/%s/%s/%s', $fvPrefix_array[0], $fvPrefix_array[1], $fvPrefix_array[2]);

				if (file_exists($targetPathC5_files) == false)
				{ 
					 mkdir($targetPathC5_files, 0775, true);
					 $targetPathC5_files_image = $targetPathC5_files."/".$item_images['main_image'];
					 copy($sourcePOSImagePath,$targetPathC5_files_image);
					 //resizeImages($extension,200,$targetPathC5_files_image, $targetPathC5_files_image);
				}
				
				if (file_exists($targetPathC5_files_small) == false)
				{ 
					 mkdir($targetPathC5_files_small, 0775, true);
					 $targetPathC5_files_small_image = $targetPathC5_files_small."/".$item_images['main_image'];
					 copy($sourcePOSImagePath,$targetPathC5_files_small_image);
					 resizeImages($extension,740,$targetPathC5_files_small_image, $targetPathC5_files_small_image);
				}
				
				if (file_exists($targetPathC5_files_small_2x) == false)
				{ 
					 mkdir($targetPathC5_files_small_2x, 0775, true);
					 $targetPathC5_files_small_2x_image = $targetPathC5_files_small_2x."/".$item_images['main_image'];
					 copy($sourcePOSImagePath,$targetPathC5_files_small_2x_image);
					 resizeImages($extension,940,$targetPathC5_files_small_2x_image, $targetPathC5_files_small_2x_image);
				}
				
				if (file_exists($targetPathC5_files_medium) == false)
				{ 
					 mkdir($targetPathC5_files_medium, 0775, true);
					 $targetPathC5_files_medium_image = $targetPathC5_files_medium."/".$item_images['main_image'];
					 copy($sourcePOSImagePath,$targetPathC5_files_medium_image);
					 resizeImages($extension,940,$targetPathC5_files_medium_image, $targetPathC5_files_medium_image);
				}
				
				if (file_exists($targetPathC5_files_large) == false)
				{ 
					 mkdir($targetPathC5_files_large, 0775, true);
					 $targetPathC5_files_large_image = $targetPathC5_files_large."/".$item_images['main_image'];
					 copy($sourcePOSImagePath,$targetPathC5_files_large_image);
					 resizeImages($extension,1024,$targetPathC5_files_large_image, $targetPathC5_files_large_image);
				}
				
				if (file_exists($targetPathC5_files_manage_listings) == false)
				{ 
					 mkdir($targetPathC5_files_manage_listings, 0775, true);
					 $targetPathC5_files_manage_listings_image = $targetPathC5_files_manage_listings."/".$item_images['main_image'];
					 copy($sourcePOSImagePath,$targetPathC5_files_manage_listings_image);
					 resizeImages($extension,60,$targetPathC5_files_manage_listings_image, $targetPathC5_files_manage_listings_image);
				}
				
				if (file_exists($targetPathC5_files_manage_listings2x) == false)
				{ 
					 mkdir($targetPathC5_files_manage_listings2x, 0775, true);
					 $targetPathC5_files_manage_listings2x_image = $targetPathC5_files_manage_listings2x."/".$item_images['main_image'];
					 copy($sourcePOSImagePath,$targetPathC5_files_manage_listings2x_image);
					 resizeImages($extension,120,$targetPathC5_files_manage_listings2x_image, $targetPathC5_files_manage_listings2x_image);
				}
				
				if (file_exists($targetPathC5_files_manage_detail) == false)
				{ 
					 mkdir($targetPathC5_files_manage_detail, 0775, true);
					 $targetPathC5_files_manage_detail_image = $targetPathC5_files_manage_detail."/".$item_images['main_image'];
					 copy($sourcePOSImagePath,$targetPathC5_files_manage_detail_image);
					 resizeImages($extension,400,$targetPathC5_files_manage_detail_image, $targetPathC5_files_manage_detail_image);
				}
				
				if (file_exists($targetPathC5_files_manage_detail2x) == false)
				{ 
					 mkdir($targetPathC5_files_manage_detail2x, 0775, true);
					 $targetPathC5_files_manage_detail2x_image = $targetPathC5_files_manage_detail2x."/".$item_images['main_image'];
					 copy($sourcePOSImagePath,$targetPathC5_files_manage_detail2x_image);
					 resizeImages($extension,800,$targetPathC5_files_manage_detail2x_image, $targetPathC5_files_manage_detail2x_image);
				}
				
				$datetime = date('Y-m-d H:i:s');
				
				$files_table = "Files";
				$files_data = array();
				$files_data['fDateAdded'] = $datetime;
				$files_data['uID'] = $data['user_id'];
				$files_data['fslID'] = 1;
				$files_data['ocID'] = 1;
				$files_data['fOverrideSetPermissions'] = 0;
				$files_data = $this->cleanData($files_data);
				$fID = $this->addData($files_data,$files_table);
				
				$fileversion_table = "FileVersions";
				$fileversion_data = array();
				$fileversion_data['fID'] = $fID;
				$fileversion_data['fvID'] = 1;
				$fileversion_data['fvFilename'] = $item_images['main_image'];
				$fileversion_data['fvPrefix'] = $fvPrefix;
				$fileversion_data['fvGenericType'] = 0;
				$fileversion_data['fvSize'] = filesize($sourcePOSImagePath);
				$fileversion_data['fvTitle'] = $item_images['main_image'];
				$fileversion_data['fvIsApproved'] = 1;
				$fileversion_data['fvDateAdded'] = $datetime;
				$fileversion_data['fvApproverUID'] = 1;	
				$fileversion_data['fvAuthorUID'] = $data['user_id'];
				$fileversion_data['fvActivateDatetime'] = $datetime;
				$fileversion_data['fvHasListingThumbnail'] = 1;
				$fileversion_data['fvHasDetailThumbnail'] = 1;
				$fileversion_data['fvExtension'] = $extension;
				$fileversion_data['fvType'] = 1;
				$fileversion_data = $this->cleanData($fileversion_data);
				$this->addData($fileversion_data,$fileversion_table);
				return $pfID = $fID;
				
			}
			
		}
		
	}
	
/*Function to Save Item in Accounting Stock*/
public function saveAccountingStock($data)
	{
		global $currency_code;
		$item_id = $data['item_id'];
		$c5_pID = $data['c5_pID'];
		$cp_store = $data['cp_store'];
		$account_name = $data['account_name'];
		$table_stockmaster = TBLPREFIX_ACCOUNTING."stock_master";
		$table_locations = TBLPREFIX_ACCOUNTING."locations";
		$table_locstock = TBLPREFIX_ACCOUNTING."loc_stock";
		$table_itemcodes = TBLPREFIX_ACCOUNTING."item_codes";
		$table_itemprices = TBLPREFIX_ACCOUNTING."prices";
		
		/*Get Data From POS Category*/
		$get_pos_category = $this->getRow("*",TBLPREFIX_OPOS."category", "WHERE id ='".$data['category_id']."'");//print_r($getCID);
		
		/*Check Column (accounting_category_id) in POS Store Items*/
		$table_pos_items = TBLPREFIX_OPOS.$this->store;
		$exists = $this->dbcountrows("SHOW COLUMNS FROM `$table_pos_items` LIKE 'accounting_stock_id'")?TRUE:FALSE;
		if(!$exists) {
		   $this->dbqueryexe("ALTER TABLE `$table_pos_items` ADD `accounting_stock_id` VARCHAR(20) NOT NULL AFTER `c5_pID`;");
		}
		
		if($data['action'] == 1) 
		{
			/*Save Data in Accounting Stock Master*/
			$stockmaster_data = array();
			//$stockmaster_data['stock_id'] = $c5_pID.$item_id;
			$max_stock_id = getTableMaxID($table_stockmaster,"stock_id");
			$stockmaster_data['stock_id'] = $max_stock_id;
			$stockmaster_data['category_id'] = $get_pos_category['accounting_category_id'];
			$stockmaster_data['tax_type_id'] = 1;
			$stockmaster_data['description'] = drop_multiple_slashes($data['name']);
			//$stockmaster_data['long_description'] = drop_multiple_slashes($data['description']);
			$stockmaster_data['long_description'] = ($data['description']);
			$stockmaster_data['units'] = "each";
			$stockmaster_data['mb_flag'] = "B";
			$stockmaster_data['sales_account'] = 4010;
			$stockmaster_data['cogs_account'] = 5010;
			$stockmaster_data['inventory_account'] = 1510;
			$stockmaster_data['adjustment_account'] = 5040;	
			$stockmaster_data['assembly_account'] = 1530;
			$stockmaster_data['dimension_id'] = 0;
			$stockmaster_data['dimension2_id'] = 0;
			$stockmaster_data['actual_cost'] = $data['retailprice'];
			$stockmaster_data['last_cost'] = 0;
			$stockmaster_data['material_cost'] = 0;
			$stockmaster_data['labour_cost'] = 0;
			$stockmaster_data['overhead_cost'] = 0;
			$stockmaster_data['inactive'] = 0;
			$stockmaster_data['no_sale'] = 0;
			$stockmaster_data['editable'] = 0;
			$stockmaster_data['is_recurring_payment'] = $data['is_recurring_payment'];
			$stockmaster_data['recurring_payment_amount'] = $data['recurring_payment_amount'];
			$stockmaster_data['recurring_payment_period'] = $data['recurring_payment_period'];
			$stockmaster_data['recurring_payment_frequency'] = $data['recurring_payment_frequency'];
			$stockmaster_data['recurring_payment_total_cycles'] = $data['recurring_payment_total_cycles'];
			$stockmaster_data['recurring_payment_trial_cycles'] = $data['recurring_payment_trial_cycles'];
			$stockmaster_data['recurring_payment_trial_amount'] = $data['recurring_payment_trial_amount'];
			$stockmaster_data['wp_pid'] = $data['wp_pid'];
			$stockmaster_data['c5_pID'] = $c5_pID;
			$stockmaster_data['cp_item_id'] = $item_id;
			$stockmaster_data['cp_store'] = $cp_store;
			$stockmaster_data = $this->cleanData($stockmaster_data);
			$this->addData($stockmaster_data,$table_stockmaster);
			//$stock_id = $c5_pID.$item_id;
			$stock_id = $max_stock_id;
			
			/*Get Data From Accouting Locations*/
			$get_locations = $this->getRow("*",$table_locations, "");
			
			/*Save Data in Accounting Loc Stock*/
			$locstock_data = array();
			$locstock_data['loc_code'] = $get_locations['loc_code'];
			$locstock_data['stock_id'] = $stock_id;
			$locstock_data = $this->cleanData($locstock_data);
			$this->addData($locstock_data,$table_locstock);
			
			/*Save Data in Accounting Item Codes*/
			$itemcodes_data = array();
			$itemcodes_data['item_code'] = $stock_id;
			$itemcodes_data['stock_id'] = $stock_id;
			$itemcodes_data['description'] = drop_multiple_slashes($data['name']);
			$itemcodes_data['category_id'] = $get_pos_category['accounting_category_id'];
			$itemcodes_data['quantity'] = $data['quantity'];
			$itemcodes_data['is_foreign'] = 0;
			$itemcodes_data['inactive'] = 0;
			$itemcodes_data = $this->cleanData($itemcodes_data);
			$this->addData($itemcodes_data,$table_itemcodes);
			
			/*Save Data in Accounting Item Prices*/
			$itemprices_data = array();
			$itemprices_data['stock_id'] = $stock_id;
			$itemprices_data['sales_type_id'] = 1;
			// $itemprices_data['price'] = $data['unit_price'];
			$item_price = $data['unit_price']; // sale price
			if($item_price == "" || $item_price == 0)
				$item_price = $data['retailprice'];
			$itemprices_data['price'] = $item_price;
			$itemprices_data['curr_abrev'] = $currency_code;
			$itemprices_data = $this->cleanData($itemprices_data);
			$this->addData($itemprices_data,$table_itemprices);
			
			/*Update Accounting Stock ID in POS Items*/
			$table_pos_items = TBLPREFIX_OPOS.$this->store;
			
			/*Check Column (accounting_category_id) in POS Store Items*/
			/*$exists = $this->dbcountrows("SHOW COLUMNS FROM `$table_pos_items` LIKE 'accounting_stock_id'")?TRUE:FALSE;
			if(!$exists) {
			   $this->dbqueryexe("ALTER TABLE `$table_pos_items` ADD `accounting_stock_id` VARCHAR(20) NOT NULL AFTER `c5_pID`;");
			}*/
	
			$positems_data = array();
			$positems_data['accounting_stock_id'] = $stock_id;
			$this->updateData($item_id,$positems_data,$table_pos_items,"item_id");
			
			/*Update Accounting Stock ID in C5 Product*/
			/*$checkPackageEcommerce = $this->getRow("*","Packages"," WHERE pkgHandle='vivid_store' ");
			if(!empty($checkPackageEcommerce))*/
			if(checkTableFromDB("VividStoreProducts",$this)==1)
			{
				$c5_product_data = array();
				$c5_product_data['accounting_stock_id'] = $stock_id;
				$this->updateData($item_id,$c5_product_data,"VividStoreProducts","cp_item_id");
			}
			
			/*Save Accounting Stock Images*/
			if($data['isimage_upload'] == 1)
			{$this->saveAccountingStockImage($data);}
			
			return $stock_id;
		}
		else
		{
			/*Get Accounting Stock Master Data*/
			$getAccountingStockMaster = $this->getRow("stock_id",$table_stockmaster, "WHERE cp_item_id = '$item_id' AND cp_store='$cp_store'");
			$stock_id = $getAccountingStockMaster['stock_id'];
			/*Update Data in Accounting Stock Master*/
			$stockmaster_data = array();
			$stockmaster_data['description'] = drop_multiple_slashes($data['name']);
			//$stockmaster_data['long_description'] = drop_multiple_slashes($data['description']);
			$stockmaster_data['long_description'] = ($data['description']);
			$stockmaster_data['actual_cost'] = $data['retailprice'];
			$stockmaster_data['category_id'] = $get_pos_category['accounting_category_id'];
			$stockmaster_data['is_recurring_payment'] = $data['is_recurring_payment'];
			$stockmaster_data['recurring_payment_amount'] = $data['recurring_payment_amount'];
			$stockmaster_data['recurring_payment_period'] = $data['recurring_payment_period'];
			$stockmaster_data['recurring_payment_frequency'] = $data['recurring_payment_frequency'];
			$stockmaster_data['recurring_payment_total_cycles'] = $data['recurring_payment_total_cycles'];
			$stockmaster_data['recurring_payment_trial_cycles'] = $data['recurring_payment_trial_cycles'];
			$stockmaster_data['recurring_payment_trial_amount'] = $data['recurring_payment_trial_amount'];
			$stockmaster_data = $this->cleanData($stockmaster_data);
			$this->updateData($stock_id,$stockmaster_data,$table_stockmaster,"stock_id");
			
			/*Update Data in Accounting Item Codes*/
			$itemcodes_data = array();
			$itemcodes_data['description'] = drop_multiple_slashes($data['name']);
			$itemcodes_data['category_id'] = $get_pos_category['accounting_category_id'];
			$itemcodes_data['quantity'] = $data['quantity'];
			$itemcodes_data = $this->cleanData($itemcodes_data);
			$this->updateData($stock_id,$itemcodes_data,$table_itemcodes,"stock_id");
			
			/*Update Data in Accounting Item Prices*/
			$itemprices_data = array();
			$item_price = $data['unit_price']; // sale price
			if($item_price == "" || $item_price == 0)
				$item_price = $data['retailprice'];
			$itemprices_data['price'] = $item_price;
			// $itemprices_data['price'] = $data['unit_price'];
			$itemprices_data['curr_abrev'] = $currency_code;
			$itemprices_data = $this->cleanData($itemprices_data);
			$this->updateData($stock_id,$itemprices_data,$table_itemprices,"stock_id");
			
			/*Save Accounting Stock Images*/
			if($data['isimage_upload'] == 1)
			{$this->saveAccountingStockImage($data);}
			
			return $stock_id;
		}
		
	}
	
/*Function to Copy Accounting Stock Master Image*/
public function saveAccountingStockImage($data)
	{
		$item_id = $data['item_id'];
		$stock_id = $data['stock_id'];
		$item_images = $this->getItemImages($item_id);
		if(!empty($item_images['main_image']))
		{
			$sourcePOSImagePath = ZROOT."pointofsale/uploads/itemimages/".$data['account_name']."/".$this->store_name."/".$item_images['main_image'];
			if (file_exists($sourcePOSImagePath))
			{
				$fileparts = explode('.',$item_images['main_image']);
				$extension = strtolower($fileparts[1]);
				
				$targetPathAccounting = ZROOT."accounting/company/".$data['account_name'];
				
				if (file_exists($targetPathAccounting) == false)
				{ 
					 mkdir($targetPathAccounting, 0775, true);
					 
					 $imagesPath = $targetPathAccounting."/images";
					 if (file_exists($imagesPath) == false)
					 { 
						 mkdir($imagesPath, 0775, true);
					 }
				}
				
				$accounting_image = $stock_id.".". $extension;
				copy($sourcefilePath,$targetPathAccounting."/images/".$accounting_image);
				
			}
		}
	}
	
/*Function to Save Shopify Import Items*/
public function saveShopifyImport($data_import)
	{
		
		//print_r($data_import);//exit();
		/*Import Data*/
		$handle = $data_import['handle'];
		$name = $data_import['name'];
		$description = $data_import['description'];
		$supplier = $data_import['supplier'];
		$category = $data_import['category'];
		$item_options = $data_import['item_options'];
		$weight = $data_import['weight'];
		$quantity = $data_import['quantity'];
		$price = $data_import['price'];
		$isshipable = $data_import['isshipable'];
		$taxable = $data_import['taxable'];
		$item_number = $data_import['item_number'];
		$image = $data_import['image'];
		$weight_lb = $data_import['weight_lb'];
		$user_id = $data_import['user_id'];
		$comment = $data_import['comment'];
		$account_name = $data_import['account_name'];
		
		/*Tables Name*/
		$tbl_pos_items = $this->tableprefix.$this->store;
		$tbl_pos_people = $this->tableprefix."people";
		$tbl_pos_suuplier = $this->tableprefix."suppliers";
		$tbl_pos_category = $this->tableprefix."category";
		
		/*Check Handle Column in POS Items Table*/
		$exists = $this->dbcountrows("SHOW COLUMNS FROM `$tbl_pos_items` LIKE 'shandle'")?TRUE:FALSE;
		if(!$exists) {
		   $this->dbqueryexe("ALTER TABLE `$tbl_pos_items` ADD `shandle` VARCHAR(100) NOT NULL AFTER `retailprice`;");
		}
		
		/*Check and Save Supplier*/
		$supplier = drop_multiple_slashes($supplier);
		if(!empty($supplier))
		{
			$supplierCheck = $this->getRow("*",$tbl_pos_suuplier, " WHERE company_name = '".cleanSQL($supplier)."' ");
			if(!empty($supplierCheck)){$supplier_id = $supplierCheck['person_id'];}
			else
			{
				/*include(CLASSES .'IMSuppliers.class.php');*/
				$sqlIMSuppliersClass = new IMSuppliers();
				$data_supplier = array();
				$data_supplier['company_name'] = $supplier;
				$data_supplier = $this->cleanData($data_supplier);
				$supplier_id = $sqlIMSuppliersClass->addSupplier($data_supplier);
			}
		}
		
		/*Check and Save Category*/
		$category = drop_multiple_slashes($category);
		if(!empty($category))
		{
			$categoryCheck = $this->getRow("*",$tbl_pos_category, " WHERE title = '".cleanSQL($category)."' ");
			if(!empty($categoryCheck)){$category_id = $categoryCheck['id'];}
			else
			{
				$data_category = array();
				$data_category['title'] = $category;
				$data_category['parent'] = 0;
				$data_category['status'] = 1;
				$data_category = $this->cleanData($data_category);
				$category_id = $this->saveCategory($data_category);
			}
		}
		
		/*Check and Save Item*/
		$response = array();
		$data_item = array(
							//'item_number'	=>	$item_number,
							'name'		   =>    $name,
							'description'	=>	$description,
							'category_id'	=>    $category_id,
							'cost_price'	 =>	$price,
							'unit_price'	 =>	$price,
							'retailprice'	=>	$price,
							'quantity'	   =>    $quantity,
							'supplier_id'	=>    $supplier_id,
							'shandle'		=>    $handle,
							'weight'		 =>    $weight,
							'isshipable'	 =>    $isshipable,
							'taxable'		=>    $taxable,
							'image_path'	 =>    $image,
							'user_id'		=>    $user_id,
							'account_name'   =>    $account_name
						 );
		$itemCheck = $this->getRow("*",$tbl_pos_items, " WHERE shandle = '".cleanSQL($handle)."' ");
		if(!empty($itemCheck))
		{
			$data_item['item_id'] = $itemCheck['item_id'];
			$response['updated_item'] = $itemCheck['item_id'];
		}
		
		$data_item = $this->cleanData($data_item);//print_r($data_item);//exit();
		//$item_id = $this->saveItem($data_item);
		$response_save_item = $this->saveItem($data_item);
		$item_id = $response_save_item['item_id'];
		$item_image_status = $response_save_item['item_image_status'];
		
		if(!empty($item_id))
		{
			/*Save Data in POS Inventory*/
			$data_inventory = array
			  (
				  'trans_items'=>$item_id,
				  'trans_user'=>$user_id,
				  'trans_comment'=>$comment,
				  'trans_inventory'=>!empty($quantity)?$quantity:0,
				  'store'=>$this->store
			  );
			$data_inventory = $this->cleanData($data_inventory); 
			$this->addData($data_inventory,TBLPREFIX_OPOS."inventory");
			//$response['item_id'] = $item_id;
			
			/*Save Data in c5 Product Option Groups and their Items*/
			$get_item_data = $this->getRow("*",$tbl_pos_items, " WHERE item_id = '".cleanSQL($item_id)."' ");
			$c5_pID = $get_item_data['c5_pID'];
			$this->deleteC5ProductOptionGroup($c5_pID);
			$this->deleteC5ProductOptionItem($c5_pID);
			if(!empty($item_options))
			{
				foreach($item_options as $key=>$item_option)
				{
					if(!empty($item_option['group']))
					{
						/*Save c5 Product Option Group*/
						$data_c5productoptiongroup = array();
						$data_c5productoptiongroup['pID'] = $c5_pID;
						$data_c5productoptiongroup['pogName'] = $item_option['group'];
						$data_c5productoptiongroup['pogSort'] = $key;
						$pogID = $this->saveC5ProductOptionGroup($data_c5productoptiongroup);
						
						if(!empty($item_option['items']))
						{
							foreach($item_option['items'] as $key_item=>$item_option_item)
							{
								if(!empty($item_option_item))
								{
									/*Save c5 Product Option Group Item*/
									$data_c5productoptiongroup_item = array();
									$data_c5productoptiongroup_item['pID'] = $c5_pID;
									$data_c5productoptiongroup_item['pogID'] = $pogID;
									$data_c5productoptiongroup_item['poiName'] = $item_option_item;
									$data_c5productoptiongroup_item['poiSort'] = $key_item;
									$this->saveC5ProductOptionItem($data_c5productoptiongroup_item);
								}
							}
						}
					}
				}
			}
			
			$response['item_id'] = $item_id;
			$response['item_image_status'] = $item_image_status;
		}
		else
		{
			$response['failed_item'] = $item_id;
		}
		
		return $response;
		
	}
	
/***************************/
/******Store Functions******/
/***************************/	
		 
/*Function to Get POS Store*/	 
public function get_store()
	{
		if(!getSession('item_store'))
			$this->set_store("items");

		return getSession('item_store');
	}

/*Function to Set POS Store*/
public function set_store($store)
	{
		setSession('item_store',$store);
	}
	
/*Function to call Functions Statically */
public static function call_static($method,$arguments) 
	{
		return $this->getItems($arguments = "");
	}
	
/*Close to MySQL Connection*/	
public function close()
	{
		$this->close_db($this->conn);
	}


/*WP Sitebuilder Functions*/
public function addUpdateWPSitebuilderItem($account_name,$action,$data,$item_id="")
{
  $category_title = "";
  if($data['category_id'] != "" && $data['category_id'] != "0")
  {
	  $category_info   = $this->getCategoy($data['category_id']);
	  $category_title = $category_info['title'];
  }
  $wp_data = $data;
  $wp_data['category'] = $category_title;
  $wp_data['product_action'] = $action;

  if($action == "update")
  {
  	$opos_item = $this->getItem($item_id);
  	$wp_data['update_post_id'] = $opos_item['wp_pid'];
  }

  $wp_sitebuilder_product = runWPSitebuilderCurl($account_name,'wrkmash_add_update_product',$wp_data);
  return $wp_sitebuilder_product['post_id'];
}	


public function activeDeactiveWPSitebuilderItem($account_name,$item_id,$status)
{
	$wp_data = [];
	$opos_item = $this->getItem($item_id);
	$wp_data['post_id'] = $opos_item['wp_pid'];
	$wp_data['status'] = $status;
	if($wp_data['post_id'] != "" && $wp_data['post_id'] != 0)
	{
		$wp_sitebuilder_product = runWPSitebuilderCurl($account_name,'wrkmash_product_active_deactive',$wp_data);
	}

	return 1;
}	

public function deleteWPSitebuilderItem($account_name,$item_id)
{
	$wp_data = [];
	$opos_item = $this->getItem($item_id);
	$wp_data['post_id'] = $opos_item['wp_pid'];
	if($wp_data['post_id'] != "" && $wp_data['post_id'] != 0)
	{
		$wp_sitebuilder_product = runWPSitebuilderCurl($account_name,'wrkmash_product_delete',$wp_data);
	}

	return 1;	
}

public function uploadWPSitebuilderItemImage($account_name,$item_id)
{
	$item_images = $this->getItemImages(cleanSQL($item_id));
	if(!empty($item_images['main_image']))
	{
		$item_images_path = ZBPATH ."pointofsale/uploads/itemimages/".$account_name."/";//exit();
		$item_store_name = $this->store_name;

		$image = $item_images_path.$item_store_name."/".$item_images['main_image'];

		$wp_data = ['img_url'=>$image];
		$opos_item = $this->getItem($item_id);
		$wp_data['post_id'] = $opos_item['wp_pid'];
		if($wp_data['post_id'] != "" && $wp_data['post_id'] != 0)
		{
			$wp_sitebuilder_product = runWPSitebuilderCurl($account_name,'wrkmash_upload_product_thumbnail',$wp_data);
		}
	}
	return 1;
}	

}
?>