<?php namespace Listener;

require('PaypalIPN.php');

use PaypalIPN;

$ipn = new PaypalIPN();

// Use the sandbox endpoint during testing.
$ipn->useSandbox();
$verified = $ipn->verifyIPN();
if ($verified) {
    /*
     * Process IPN
     * A list of variables is available here:
     * https://developer.paypal.com/webapps/developer/docs/classic/ipn/integration-guide/IPNandPDTVariables/
     */
	 @mail("waseeansari@gmail.com","Test Paypal Notification Subject","Test Paypal Notification Message");
}

// Reply with an empty 200 response to indicate to paypal the IPN was received correctly.
header("HTTP/1.1 200 OK");

<?php

// instantiate the IpnListener class
require('PaypalIPN.php');

//use PaypalIPN;

$ipn = new PaypalIPN();

$ipn->use_sandbox = false;

try {
	$verified = $ipn->verifyIPN();
} catch (Exception $e) {
	error_log($e->getMessage());
	exit(0);
}


if ($verified) {
	$errmsg = '';   // stores errors from fraud checks

	// 1. Make sure the payment status is "Completed"
	if ($_POST['payment_status'] != 'Completed') {
		// simply ignore any IPN that is not completed
		exit(0);
	}
	if ($_POST['txn_type'] != 'recurring_payment') {
		//this ipn listener is for recurring_payment only
		exit(0);
	}

	// 2. Make sure seller email matches your primary account email.
	if ($_POST['receiver_email'] != 'xxx@xxx.eu') {
		$errmsg .= "'receiver_email' does not match: ";
		$errmsg .= $_POST['receiver_email']."\n";
	}

	$payment = payments::constructByPaymentId($_POST['recurring_payment_id']);
	if ($payment === false) {
		$errmsg .= "'recurring_payment_id' does not match: ";
		$errmsg .= $_POST['recurring_payment_id']."\n";
	} else {
		// 3. Make sure the amount(s) paid match
		if ($_POST['mc_gross'] != $payment->getData()['amount']) {
			$errmsg .= "'mc_gross' does not match: ";
			$errmsg .= $_POST['mc_gross']."\n";
		}

		// 4. Make sure the currency code matches
		if ($_POST['mc_currency'] != $payment->getData()['currency']) {
			$errmsg .= "'mc_currency' does not match: ";
			$errmsg .= $_POST['mc_currency']."\n";
		}
	}
	// TODO: Check for duplicate txn_id
	$pr = payments_recurring::constructByTxnid($_POST['txn_id']);
	if (!($pr === false)) {
		$errmsg .= "'txn_id' already processed: ";
		$errmsg .= $_POST['txn_id']."\n";
	}

	if (!empty($errmsg)) {
		// manually investigate errors from the fraud checking
		$body = "IPN failed fraud checks: \n$errmsg\n\n";
		$body .= $ipn->getTextReport();
		//mail('YOUR EMAIL ADDRESS', 'IPN Fraud Warning', $body);

	} else {

		// TODO: process order here
		$data = array();
		$data['payments_id'] = $payment->id();
		$data['txn_id'] = $_POST['txn_id'];
		$data['txn_type'] = $_POST['txn_type'];
		$data['payer_email'] = $_POST['payer_email'];
		$data['payer_id'] = $_POST['payer_id'];
		$data['mc_gross'] = $_POST['mc_gross'];
		$data['payment_date'] = strtotime($_POST['payment_date']);
		$pr = payments_recurring::add($data);		
		
		$subscription = new subscriptions($payment->subscription_id);
		foreach ($subscription->getProducts() as $pid) {
			$paid = user_paid::constructByUserAndProduct($payment->getData()['user_id'], $pid);
			if ($paid === false){
				$data = array();
				$data['user_id'] = $payment->getData()['user_id'];
				$data['product_id'] = $pid;
				$paid = user_paid::add($data);
			} else {
				$paid->incrementAmount();
			}
		}
		echo "accepted";
		
	}


	mail('YOUR EMAIL ADDRESS', 'Verified IPN', $listener->getTextReport());

} else {
	/*
	 An Invalid IPN *may* be caused by a fraudulent transaction attempt. It's
	a good idea to have a developer or sys admin manually investigate any
	invalid IPN.
	*/
	mail('YOUR EMAIL ADDRESS', 'Invalid IPN', $listener->getTextReport());
	//r($listener->getTextReport());
}

?>
