<?php
//error_reporting(0);
require_once ("secure_area.php");
class Sales extends Secure_area
{
	function __construct()
	{
		parent::__construct('sales');
		
		$this->load->library('sale_lib');
		//$this->load->library('paypal');
		//$this->load->library('authorize_payment');
		$this->load->model('Gateways');
		$this->config->load('config');
		
		if ($this->Appconfig->get('cmandatory') )
		{
			$this->sale_lib->set_cmandatory('1');
		}
		else 
		{
			$this->sale_lib->set_cmandatory('-1');
		}
	 		
		if ($this->Appconfig->get('sales_comm') )
		{
			$this->sale_lib->set_salescomm('1');
		}
		else 
		{
			$this->sale_lib->set_salescomm('-1');
		}
		
		/*if(($this->input->post('source_store') !="" ))
		{$this->session->set_userdata('store', $this->input->post('source_store'));}*/
		if(($this->input->post('source_store') !="" ))
		{
			if($this->session->userdata('store') != $this->input->post('source_store'))
			{
				$this->sale_lib->clear_all();
				$this->sale_lib->set_empid("");
			}
			$this->session->set_userdata('store', $this->input->post('source_store'));
		}
		
		list($store_id,$store_name) = explode(",",$this->session->userdata('store'));
		
		if($store_name=="main" || $store_name=="")
		{
			$this->store = "items";
			$this->store_name = "items";
		}
		else
		{
			$this->store = $store_name.'_storeitems';
			$this->store_name = $store_name;
		}
		
		//echo $this->store;
		$this->Item->setStore($this->store);
		
		/*Load and Use Mobile Detect Libraries*/
		$this->load->library('Mobile_Detect');

 	}

	function index()
	{
		$this->_reload();
	}

	function item_search()
	{
		$suggestions = $this->Item->get_item_search_suggestions($this->input->post('q'),$this->input->post('limit'));
		echo implode("\n",$suggestions);
	}

	function customer_search()
	{
		$suggestions = $this->Customer->get_customer_search_suggestions($this->input->post('q'),$this->input->post('limit'));
		echo implode("\n",$suggestions);
	}

	function select_customer()
	{
	    $customer_id = $this->input->post("customer");
		$this->sale_lib->set_customer($customer_id);
		$this->sale_lib->get_cust(); 
		$customer_info = $this->sale_lib->get_customer();
		if($customer_info!=-1)
		{
			$info = $this->Customer->get_info($customer_id);
			$data['customer'] = $info->first_name.' '.$info->last_name;
		}
		//print_r();

		$this->load->view("sales/customer_info_html",$data);
		
		/*$this->_reload();*/
	}

	function send_email()
	{
		//$Email="noreply@onlinepos.com";
		$email = $this->config->item('email');
		$subject = "Receipt for your purchase at ".$this->config->item('company'); 
		
		$headers  = 'MIME-Version: 1.0' . "\r\n";
		$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
		$headers .= 'From: '.$email . "\r\n" . 'Reply-To: '.$email . "\r\n" . 'X-Mailer: PHP/' . phpversion();
		
		$msg = $_SESSION["receipt_email_string"];//echo $msg;exit();
		
		//echo $customer_id=$this->sale_lib->get_customer();
		$to = $this->sale_lib->get_custEmail();
		$ok = @mail($to,$subject,$msg,$headers); 
		//$ZCPPATH_new = str_replace('/pointofsale/','/',base_url());
		/*echo '<script> alert("Email delivered successfully"); </script>';*/
	    $data['success_message'] = "Email delivered successfully.";
	    //$this->load->view("sales/register",$data); 
	    $this->_reload($data);
	}
	
	function return_type()
	{
		$return_type = $this->input->post("return_type");
		$this->sale_lib->set_return_type($return_type);
		if($return_type!="with_receipt"){	
			
			echo $this->sale_lib->clear_cart();
		}

	}

	function change_mode()
	{
		$mode = $this->input->post("mode");
		$this->sale_lib->set_mode($mode);
		$this->sale_lib->set_return_type('with_receipt');
		
		/*update the qty in cart according to mode*/ 
		// code start
		$cart_data = $this->sale_lib->get_cart();
		if(count($cart_data) > 0)
		{
			foreach ($cart_data as $key => $item) 
			{
				if(($mode == "sale" && $item['quantity'] < 0) || ($mode == "return" && $item['quantity'] >= 0))
					$cart_data[$key]['quantity'] = $item['quantity'] * -1;
			}
		}
		$this->sale_lib->set_cart($cart_data);
		// code end

		$empid = $this->input->post("emp_id");
		$this->sale_lib->set_empid($empid);
		//$this->_reload();
	}

	//Add Payment Type
	function add_payment_type()
	{		
		$payment_type = $this->input->post('payment_type');		
		
		/*Start Payment Device Changes*/
		/*if($payment_type == "Debit Card" || $payment_type == "Credit Card")
		{
			$this->load->library('chargeitpro_lib');
			$base_amount = $this->sale_lib->get_total();
			$external_tran_id = $this->chargeitpro_lib->GUID();
			$this->sale_lib->clear_external_transaction_id();
			$this->sale_lib->set_external_transaction_id($external_tran_id);
			
			$params->transaction_type = "CreditSale";
			$params->transaction_method = 'hostedFields';
			$params->transaction_fields = array(
											array('id' => 'base_amount', 'value' => $base_amount),
											array('id' => 'external_tran_id', 'value' => $external_tran_id),
											array('id' => 'device_name', 'value' => 'wrkmash1')
										  );
			$result = $this->chargeitpro_lib->StartTransaction($params);//print_r($result);
			if(!empty($result['CIP_Error']) && $result['CIP_Error']==1)
			{
				//Error
				echo "|0|".$result['CIP_Response']."|";
				exit();
			}
			else
			{
				//Success
				$transaction_token = $result['CIP_Response'];
				$params->transaction_token = $transaction_token;
				$result = $this->chargeitpro_lib->InitiateDevice($params);//print_r($result);
				if(!empty($result['CIP_Error']) && $result['CIP_Error']==1)
    			{
    				//Error
    				echo "|0|".$result['CIP_Response']."|";
    				exit();
    			}
				else
				{
					echo "|1|".$transaction_token."|";	
				}
			}
		}*/
		/*End Payment Device Changes*/		
		
		$this->sale_lib->set_payment_type($payment_type);
	} 
	
	//Add Single Payment
	function add_payment_data()
	{		
		$data=array();
		$this->sale_lib->empty_payments();//For empty or unset payments session
		$this->form_validation->set_rules('amount_tendered', 'lang:sales_amount_tendered', 'numeric');
		
		if ($this->form_validation->run() == FALSE)
		{
			/*if ( $this->input->post('payment_type') == $this->lang->line('sales_gift_card') )
				$data['error']=$this->lang->line('sales_must_enter_numeric_giftcard');
			else
				$data['error']=$this->lang->line('sales_must_enter_numeric');*/
			if ( $this->input->post('payment_type') == $this->lang->line('sales_gift_card') )
				echo "|0|".$this->lang->line('sales_must_enter_numeric_giftcard')."|";
			else
				echo "|0|".$this->lang->line('sales_must_enter_numeric')."|";
				
 			//$this->_reload($data);
 			//return;
			exit();
		}
		
		$payment_type = $this->input->post('payment_type');
		if ( $payment_type == $this->lang->line('sales_giftcard') )
		{
			$payments = $this->sale_lib->get_payments();
			$payment_type=$this->input->post('payment_type').':'.$payment_amount=$this->input->post('amount_tendered');
			$current_payments_with_giftcard = isset($payments[$payment_type]) ? $payments[$payment_type]['payment_amount'] : 0;
			$cur_giftcard_value = $this->Giftcard->get_giftcard_value( $this->input->post('amount_tendered') ) - $current_payments_with_giftcard;
			if ( $cur_giftcard_value <= 0 )
			{
				//$data['error']='Giftcard balance is '.to_currency( $this->Giftcard->get_giftcard_value( $this->input->post('amount_tendered') ) ).' !';
				echo '|0|Giftcard balance is '.to_currency( $this->Giftcard->get_giftcard_value( $this->input->post('amount_tendered') ) ).' !|';
				/*$this->_reload($data);
				return;*/
				exit();
			}
			elseif ( ( $this->Giftcard->get_giftcard_value( $this->input->post('amount_tendered') ) - $this->sale_lib->get_total() ) > 0 )
			{
				//$data['warning']='Giftcard balance is '.to_currency( $this->Giftcard->get_giftcard_value( $this->input->post('amount_tendered') ) - $this->sale_lib->get_total() ).' !';
				echo '|1|Giftcard balance is '.to_currency( $this->Giftcard->get_giftcard_value( $this->input->post('amount_tendered') ) - $this->sale_lib->get_total() ).' !|';
			}
			$payment_amount=min( $this->sale_lib->get_total(), $this->Giftcard->get_giftcard_value( $this->input->post('amount_tendered') ) );
		}
		else
		{
			$payment_amount=$this->input->post('amount_tendered');
		}
		
		if( !$this->sale_lib->add_payment( $payment_type, $payment_amount ) )
		{
			//$data['error']='Unable to Add Payment! Please try again!';
			echo '|0|Unable to Add Payment! Please try again!|';
			exit();
		}
		
		//print_r($this->sale_lib->get_payments());
		$this->sale_lib->set_payment_type($payment_type);
		//echo '|2|Payment addedd|';
		exit();
		//$this->_reload($data);
	}
	
	//Multiple Payments
	function add_payment()
	{		
		$data=array();
		$this->form_validation->set_rules('amount_tendered', 'lang:sales_amount_tendered', 'numeric');
		
		if ($this->form_validation->run() == FALSE)
		{
			if ( $this->input->post('payment_type') == $this->lang->line('sales_gift_card') )
				$data['error']=$this->lang->line('sales_must_enter_numeric_giftcard');
			else
				$data['error']=$this->lang->line('sales_must_enter_numeric');
				
 			$this->_reload($data);
 			return;
		}
		
		$payment_type = $this->input->post('payment_type');
		if ( $payment_type == $this->lang->line('sales_giftcard') )
		{
			$payments = $this->sale_lib->get_payments();
			$payment_type=$this->input->post('payment_type').':'.$payment_amount=$this->input->post('amount_tendered');
			$current_payments_with_giftcard = isset($payments[$payment_type]) ? $payments[$payment_type]['payment_amount'] : 0;
			$cur_giftcard_value = $this->Giftcard->get_giftcard_value( $this->input->post('amount_tendered') ) - $current_payments_with_giftcard;
			if ( $cur_giftcard_value <= 0 )
			{
				$data['error']='Giftcard balance is '.to_currency( $this->Giftcard->get_giftcard_value( $this->input->post('amount_tendered') ) ).' !';
				$this->_reload($data);
				return;
			}
			elseif ( ( $this->Giftcard->get_giftcard_value( $this->input->post('amount_tendered') ) - $this->sale_lib->get_total() ) > 0 )
			{
				$data['warning']='Giftcard balance is '.to_currency( $this->Giftcard->get_giftcard_value( $this->input->post('amount_tendered') ) - $this->sale_lib->get_total() ).' !';
			}
			$payment_amount=min( $this->sale_lib->get_total(), $this->Giftcard->get_giftcard_value( $this->input->post('amount_tendered') ) );
		}
		else
		{
			$payment_amount=$this->input->post('amount_tendered');
		}
		
		if( !$this->sale_lib->add_payment( $payment_type, $payment_amount ) )
		{
			$data['error']='Unable to Add Payment! Please try again!';
		}
		
		$this->sale_lib->set_payment_type($payment_type);
		
		$this->_reload($data);
	}

	//Alain Multiple Payments
	function delete_payment($payment_id)
	{
		$this->sale_lib->delete_payment($payment_id);
		$this->_reload();
	}

	function checkReceiptReturnDays()
	{
		$receipt_no = $this->input->post("receipt_no");

		$data = [];
		
		$this->db->dbprefix = "opos_"; 
		$this->db->from('sales');
		$this->db->select('sale_time');
		$this->db->where('sale_id',$receipt_no);
		$query_sales = $this->db->get();
		$return_payment_data = $query_sales->row_array();
		if(count($return_payment_data) == 0)
		{
			$data['error'] = 1;
			$data['msg'] = 'Receipt No is not valid!';
		}
		else
		{
			$sale_time = $return_payment_data['sale_time']; 

			$this->db->from('app_config');
			$this->db->select('value');
			$this->db->where('key','return_within_days');
			$return_days = $this->db->get();
			$return_days = $return_days->row_array();
			if(count($return_days) == 0)
			{
				$data['error'] = 0;
			}
			else
			{
				$return_days = $return_days['value'];
				if($return_days == "")
				{
					$data['error'] = 0;
				}
				else
				{
					$return_ts = strtotime(date('Y-m-d h:i:s', strtotime($sale_time.' + '.$return_days.' days')));
					$current_ts = strtotime(date('Y-m-d h:i:s'));

					if($return_ts < $current_ts)
					{
						$data['error'] = 1;
						$data['msg'] = "This receipt can't returned, due to receipt being over ".$return_days." days!";
					}
					else
					{
						$data['error'] = 0;
					}
				}
			}
		}

		echo json_encode($data);
	}

	function add()
	{
		$data=array();
		$mode = $this->sale_lib->get_mode();
		$return_type = $this->sale_lib->get_return_type();
		$item_id_or_number_or_receipt = $this->input->post("item");
		$receipt_no = $this->input->post("receipt_no");
		$quantity = $mode=="sale" ? 1:-1;
		$data['error'] = "";
		$return_payment_data = $this->session->userdata('return_payment_data');
		if( $mode=='return' && $item_id_or_number_or_receipt == "receipt_no")
		{
			if($this->sale_lib->is_valid_receipt($receipt_no))
			{
				$sale_items_response = $this->sale_lib->return_entire_sale($receipt_no);
				if($sale_items_response == "all_items_already_returned")
				{
					$data['error']='all_items_already_returned';
				}
				else
				{				
					// $this->setReturnReceiptData($receipt_no);	
					$sale_id = explode(" ",$receipt_no);
					$this->db->dbprefix = "opos_"; 
					$this->db->from('sales');
					$this->db->select('sale_id,gateway_id,gateway_response_data');
					$this->db->where('sale_id',$sale_id[1]);
					$query_sales = $this->db->get();
					$return_payment_data = $query_sales->row_array();
					// echo "<pre>";
					// print_r($return_payment_data);
					// exit;
					// echo json_encode($return_payment_data);
					$this->session->set_userdata('return_payment_data',$return_payment_data);		
				}
			}
			else
			{
				$data['error']='receipt_error';
			}
		}
		else if($mode=='return' && $item_id_or_number_or_receipt == "receipt_no_set_data")
		{
			// $this->setReturnReceiptData($receipt_no);	
			$sale_id = explode(" ",$receipt_no);
			$this->db->dbprefix = "opos_"; 
			$this->db->from('sales');
			$this->db->select('sale_id,gateway_id,gateway_response_data');
			$this->db->where('sale_id',$sale_id[1]);
			$query_sales = $this->db->get();
			$return_payment_data = $query_sales->row_array();
			$this->session->set_userdata('return_payment_data',$return_payment_data);	
		}
		elseif(!$this->sale_lib->add_item($item_id_or_number_or_receipt,$quantity))
		{
			$data['error']=$this->lang->line('sales_unable_to_add_item');
		}
		
		if($this->sale_lib->out_of_stock($item_id_or_number_or_receipt))
		{
			$data['warning'] = $this->lang->line('sales_quantity_less_than_zero');
		}
		//print_r($item_id_or_number_or_receipt);
		//$this->_reload($data);
		$person_info = $this->Employee->get_logged_in_employee_info();//print_r($person_info);exit();
		$data['cart'] = $this->sale_lib->get_cart();//print_r($data['cart']);exit();
		$data['modes'] = array('sale'=>$this->lang->line('sales_sale'),'return'=>$this->lang->line('sales_return'));
		$data['mode'] = $this->sale_lib->get_mode();
		$data['return_type'] = $this->sale_lib->get_return_type();
		$data['subtotal'] = $this->sale_lib->get_subtotal();
		$data['taxes'] = $this->sale_lib->get_taxes();
		$data['total'] = $this->sale_lib->get_total();
		$data['items_module_allowed'] = $this->Employee->has_permission('items', $person_info->person_id);
		//Alain Multiple Payments
		$data['payments_total'] = $this->sale_lib->get_payments_total();
		$data['amount_due'] = $this->sale_lib->get_amount_due();
		$data['payments'] = $this->sale_lib->get_payments();//print_r($data['payments']);exit();
		$data['get_taxmode'] = $this->sale_lib->get_taxmode();
		$gateway_check = $this->Gateways->get_default_gateway()->num_rows();
		if($gateway_check>0)
		{
			$data['payment_options'] = array(
			//$this->lang->line('sales_aim') => $this->lang->line('sales_aim'),
			$this->lang->line('sales_cash') => $this->lang->line('sales_cash'),
			$this->lang->line('sales_check') => $this->lang->line('sales_check'),
			$this->lang->line('sales_giftcard') => $this->lang->line('sales_giftcard'),
			$this->lang->line('sales_debit') => $this->lang->line('sales_debit'),
			$this->lang->line('sales_credit') => $this->lang->line('sales_credit')
			);
		}
		else
		{
			$data['payment_options'] = array(
			//$this->lang->line('sales_aim') => $this->lang->line('sales_aim'),
			$this->lang->line('sales_cash') => $this->lang->line('sales_cash'),
			$this->lang->line('sales_check') => $this->lang->line('sales_check'),
			$this->lang->line('sales_giftcard') => $this->lang->line('sales_giftcard')
		);
		}

		$customer_id = $this->sale_lib->get_customer();
		//print_r($customer_id);exit;
		if($customer_id!=-1)
		{
			$info = $this->Customer->get_info($customer_id);
			$data['customer'] = $info->first_name.' '.$info->last_name;
		}
		//print_r($data['customer']);exit;
		$data['gateway_info'] = $this->Gateways->get_default_gateway();
		foreach ($data['gateway_info']->result() as $gateways){
			$data['gateway_id'] = $gateways->gateway_id;
			$data['gateway_name'] = $gateways->gateway_name;
			$data['MUinfo'] = $gateways->MUinfo;
			$data['MUkey'] = $gateways->MUkey;
			$data['MUenvironment'] = $gateways->MUenvironment;
			$data['MUsellerid'] = $gateways->MUsellerid;
			$data['MUpublishablekey'] = $gateways->MUpublishablekey;
			$data['MUprivatekey'] = $gateways->MUprivatekey;
			$data['signature'] = $gateways->signature;
		}
		//print_r($data['gateway_info']->result());
		$data['payment_type'] = $this->sale_lib->get_payment_type();
		$data['source_store'] = $this->store_name;

		/*Initialize Mobile Detect Class*/
		$Mobile_Detect = new Mobile_Detect;
		/*Calling Mobile Detect Methods*/
		$data['device_detect_type'] = ($Mobile_Detect->isMobile() ? ($Mobile_Detect->isTablet() ? 'tablet' : 'phone') : 'computer');//Check Device Type
		//print_r($data);
		$data['return_payment_data'] = $return_payment_data;

		$this->load->view("sales/item_inner_html",$data);

		// print_r($return_payment_data);


	}

	

	function edit_item($line)
	{
		$data= array();

		$this->form_validation->set_rules('price', 'lang:items_price', 'required|numeric');
		$this->form_validation->set_rules('quantity', 'lang:items_quantity', 'required|numeric');

        $description = $this->input->post("description");
        $serialnumber = $this->input->post("serialnumber");
		$price = $this->input->post("price");
		$quantity = $this->input->post("quantity");
		$discount = $this->input->post("discount");
		$discount_amount = $this->input->post("discount_amount");
		$select_reason = $this->input->post("select_reason");
		$line = $this->input->post("line");

		if ($this->form_validation->run() != FALSE)
		{
			$this->sale_lib->edit_item($line,$description,$serialnumber,$quantity,$discount,$discount_amount,$price,$select_reason);
		}
		else
		{
			$data['error']=$this->lang->line('sales_error_editing_item');
		}
		
		if($this->sale_lib->out_of_stock($this->sale_lib->get_item_id($line)))
		{
			$data['warning'] = $this->lang->line('sales_quantity_less_than_zero');
		}
		//print_r($data);

		//$this->_reload($data);
	}

	function delete_item($item_number)
	{
		//$this->sale_lib->delete_item($item_number);
		//$this->_reload();
		$line = $this->input->post('line');
	    $this->sale_lib->delete_item($line);
	}

	function delete_customer()
	{
		$this->sale_lib->delete_customer();
		//$this->_reload();
	}


	function complete()
	{
		//print_r($_REQUEST);exit();
		$customer_id = $this->sale_lib->get_customer();
		
		if ($this->Appconfig->get('cmandatory') && ($customer_id==-1))
		{
			/*echo "<script>alert('Sales can not be completed,to select customer  is mandatory');</script>";*/
			/*echo '<script>jAlert("Sales can not be completed,to select customer  is mandatory", "Warning")</script>';*/
			//$data['error'] = 'Sales can not be completed,to select customer is mandatory';
			/* Start POS Pay Now */
			/*$data['error'] = 'Sales can not be completed, to complete sale customer is mandatory';
			$this->_reload($data);
			return false;*/
			echo '|0|Sales can not be completed, to complete sale customer is mandatory|';
			exit();
			/* End POS Pay Now */
		}
		
		$data['cart'] = $this->sale_lib->get_cart();
		$data['subtotal'] = $this->sale_lib->get_subtotal();
		$data['taxes'] = $this->sale_lib->get_taxes();
		$data['total'] = $this->sale_lib->get_total();
		$data['receipt_title'] = $this->lang->line('sales_receipt');
		$data['transaction_time'] = date('m/d/Y h:i:s a');
		$customer_id = $this->sale_lib->get_customer();
		$employee_id = $this->Employee->get_logged_in_employee_info()->person_id;
		
		if ($this->Appconfig->get('sales_comm'))
		{
			$employee_id = $this->sale_lib->get_empid();
		}
		else 
		{
			$employee_id = $this->Employee->get_logged_in_employee_info()->person_id;
		}
		
		$comment = $this->input->post('comment');
		$tax_comment = $this->input->post('tax_comment');
		$signature_data = $this->input->post('signature_data');
		$emp_info = $this->Employee->get_info($employee_id);
		$payment_type = $this->input->post('payment_type');
		$data['payment_type'] = $this->input->post('payment_type');
		
		//Alain Multiple payments
		$data['payments'] = $this->sale_lib->get_payments();
		$data['amount_change'] = to_currency($this->sale_lib->get_amount_due() * -1);
		$data['emp_info'] = $emp_info;
		$data['employee'] = $emp_info->first_name.' '.$emp_info->last_name;
		
		if($customer_id!=-1)
		{
			$cust_info = $this->Customer->get_info($customer_id);
			$data['cust_info'] = $cust_info;
			$data['customer'] = $cust_info->first_name.' '.$cust_info->last_name;
		}

		$total_payments = 0;
		foreach($data['payments'] as $payment)
		{
			$total_payments += $payment['payment_amount'];
		}

		/* Changed the conditional to account for floating point rounding */
		if ( ( $this->sale_lib->get_mode() == 'sale' ) && ( ( to_currency_no_money( $data['total'] ) - $total_payments ) > 1e-6 ) )
		{
			/* Start POS Pay Now */
			/*$data['error'] = $this->lang->line('sales_payment_not_cover_total');
			$this->_reload($data);
			return false;*/
			echo '|0|'.$this->lang->line('sales_payment_not_cover_total').'|';
			exit();
			/* End POS Pay Now */
		}
		
		$data['gateway_info'] = $this->Gateways->get_default_gateway();
		
		foreach ($data['gateway_info']->result() as $gateways){
  			$config['gateway_id'] = $gateways->gateway_id;  
		}
		
		//Get Tip Amount
		$data['tips'] = $this->sale_lib->get_tips();		
 		
		$payment_type_value = $this->input->post('payment_type_value');//exit();
		if($payment_type_value == 4 || $payment_type_value == 5)
		{
			$data['cc_type'] =  $this->input->post('cc_type');
			$data['cc_month'] =  $this->input->post('cc_month');
			$data['cc_year'] =  $this->input->post('cc_year');
			$data['cc_no'] =  $this->input->post('cc_no'); 
			$data['cc_cvv'] =  $this->input->post('cc_cvv');  
			$data['cc_name'] =  $this->input->post('cc_name');
			
			/*Start Payment Device Changes*/
			/*Get Payment Device Details*/
			//$payment_device = $this->Appconfig->get_payment_device();
			//$payment_device_activation = false;
			//if(!empty($payment_device) && $payment_device->device_status == 1)
			/*if(!empty($config['gateway_id']) && $config['gateway_id'] == 7)
			{
				$payment_device_activation = true;
			}*/
			/*End Payment Device Changes*/
			
			//Payment Through Paypal API
			/*Start Payment Device Changes*/ 
			if($config['gateway_id'] == 1)
			//if($config['gateway_id'] == 1 && !($payment_device_activation))
			/*End Payment Device Changes*/
			{
				$this->load->library('paypal_payment');
				if($this->input->post('cc_no') && $this->input->post('cc_month'))
				{ 		
				  $cc_type =  $this->input->post('cc_type');
				  $cc_month =  $this->input->post('cc_month');
				  $cc_year =  $this->input->post('cc_year');
				  $cc_no =  $this->input->post('cc_no'); 
				  $cc_cvv =  $this->input->post('cc_cvv');  
				  //$FIRSTNAME =  $this->input->post('cc_name'); 
				  $CREDITCARDTYPE = urlencode($cc_type); 				 // credit card type: Visa, Mastercard, American Express etc.
				  $ACCT = urlencode($cc_no);	                         // credit card number
				  $EXPDATE = urlencode($cc_month.$cc_year);			  // expiry month
				  //$expDateYear = urlencode($year);					  // expiry year
				  $CVV2 = urlencode($cc_cvv);	                        // credit card CVV code
				  $FIRSTNAME = urlencode($cust_info->first_name);		// first name on credit card
				  $LASTNAME = urlencode($cust_info->last_name);         // last name on credit card
				  $STREET = urlencode($cust_info->address_1);
				  $CITY = urlencode($cust_info->city);	
				  $STATE = urlencode($cust_info->state);
				  $COUNTRYCODE = urlencode($cust_info->country);
				  $ZIP = urlencode($cust_info->zip);
				  $AMT = urlencode($total_payments); 					 //  total amount of sale	
				  // echo $paymentType = $changemode;                   //  get mode of sale either sale or return
				  //print_r($cust_info);
				  $PAYMENTACTION = urlencode('Sale');					// or 'Sale' or 'Authorization'
				  /*$creditCardType = urlencode('Visa'); 				  // credit card type: Visa, Mastercard, American Express etc.
				  $creditCardNumber = urlencode('4887399767254515');	// credit card number
				  $expDateMonth = urlencode('11');					    // expiry month
				  $expDateYear = urlencode('2016');					    // expiry year
				  $cvv2Number = urlencode('123');						// cvv2 or the last 3/4 digit at the back of credit card
				  $address1 = urlencode('no');						    // billing address1
				  $address2 = urlencode('no'); 						    // address2
				  $city = urlencode('us'); 							    // city
				  $state = 'CA'; 										// state
				  $zip = urlencode('23455');						    // zipcode
				  $country = urlencode('us');  						    // US or other valid country code
				  $amount = urlencode('200');*/
				  $CURRENCYCODE = urlencode('USD'); 	        // amount/rate
				  // Add request-specific fields to the request string.
				  /*$nvp_string = "&PAYMENTACTION=$PAYMENTACTION&AMT=$AMT&CREDITCARDTYPE=$CREDITCARDTYPE&ACCT=$ACCT".
							    "&EXPDATE=$EXPDATE&CVV2=$CVV2&FIRSTNAME=$FIRSTNAME&LASTNAME=$LASTNAME".
							    "&STREET=$STREET&CITY=$CITY&STATE=$STATE&ZIP=$ZIP&COUNTRYCODE=$COUNTRYCODE&CURRENCYCODE=$CURRENCYCODE";*/	
				  $nvp_string = "&PAYMENTACTION=$PAYMENTACTION&AMT=$AMT&CREDITCARDTYPE=$CREDITCARDTYPE&ACCT=$ACCT".
							    "&EXPDATE=$EXPDATE&CVV2=$CVV2&FIRSTNAME=$FIRSTNAME&LASTNAME=$LASTNAME&CURRENCYCODE=$CURRENCYCODE";				  
				  // Execute the API operation; see the PPHttpPost function above.
				  $params->nvp_string = $nvp_string;
				  $params->nvp_method = 'DoDirectPayment';
				  /*echo "<pre>";
				  print_r($params);
				  echo "</pre>";*/
				  $result = $this->paypal_payment->PPHTTPPost($params);  //TURN THIS ON TO MAKE THE PAYMENT LIVE
				  /*echo "<pre>";
				  print_r($result);
				  echo "</pre>";
				  exit();*/
			  
				  //if($httpParsedResponseAr["ACK"] == 'Success')
				  if(!empty($result['PP_Error']) && $result['PP_Error']==1)
				  {
						//$data['error_message'] = 'Unable to process your payment '.urldecode($httpParsedResponseAr["L_SHORTMESSAGE0"]);
						/*if($result['PP_Response']["L_SEVERITYCODE0"] == 'Error')
						$data['error'] = "".urldecode($result['PP_Response']["L_LONGMESSAGE0"]);
						elseif($result['PP_Response']["L_SEVERITYCODE1"] == 'Error')
						$data['error'] = "".urldecode($result['PP_Response']["L_LONGMESSAGE1"]);
						elseif($result['PP_Response']["L_SEVERITYCODE2"] == 'Error')
						$data['error'] = "".urldecode($result['PP_Response']["L_LONGMESSAGE2"]);
						
						if($result['PP_Response']["L_ERRORCODE0"]==10002)
						$data['error'] = "".urldecode("This transaction cannot be processed because your API credentials are invalid");*/
						
						//$data['error'] = "Sales Transaction Failed due to : ".urldecode($result['PP_Response']["L_SHORTMESSAGE0"]);
						/* Start POS Pay Now */
						/*$data['error'] = $result['PP_Response'];
						$this->_reload($data);
						return false;*/
						echo '|0|'.$result['PP_Response'].'|';
						exit();
						/* End POS Pay Now */
				  		//$this->load->view('sales/thankyou');
				  }
				  else
				  {
				  		//$data['error_message'] = 'Payment was successfully made';
						$gateway_id = $config['gateway_id'];
						$gateway_response_data = json_encode($result['PP_Response']);		
				  }
				}
			}
		 
			//Payment Through Authorize.Net API 
			/*Start Payment Device Changes*/  
			if($config['gateway_id'] == 2)
			//if($config['gateway_id'] == 2 && !($payment_device_activation))
			/*End Payment Device Changes*/ 
			{ 
				if($this->input->post('cc_no') && $this->input->post('cc_month'))
				{ 
					//	$this->load->library('authorize_payment');
					$params->x_card_num = $this->input->post('cc_no');
					//$params->x_exp_date = $this->input->post('cc_month').'/'.$this->input->post('cc_year');
					$params->x_exp_date = $this->input->post('cc_month').'/'.date("y",strtotime("01-01-".$this->input->post('cc_year')));
					$params->x_card_code =  $this->input->post('cc_cvv');
					//$params->description = 'POS';
					$params->total_amount = $total_payments;
					//$params->x_first_name = $this->input->post('cc_name');
					/*$params->x_first_name = urlencode($cust_info->first_name);		// first name on credit card
					$params->x_last_name = urlencode($cust_info->last_name);         // last name on credit card
					$params->x_address = urlencode($cust_info->address_1);
					$params->x_city = urlencode($cust_info->city);	
					$params->x_state = urlencode($cust_info->state);
					$params->x_country = urlencode($cust_info->country);
					$params->x_zip = urlencode($cust_info->zip);
					$params->x_email = urlencode($cust_info->email);*/
					//$params->firstName = $cust_info->first_name;
					//$params->lastName = $emp_info->last_name;
				    //$params->address = '1234 5th St.';
				    //$params->city = 'YourTown';
				    //$params->state = 'NM';
				    //$params->zip = '81225';
					/*$params->customerMonth = date('m');
					$params->customerDay = date('d');
					$params->customerYear = date('y');
					$params->specialCode = '000';*/	
						
					//$result = $this->authroize_payment->Authorize($params);
					// print_r($this->authroize_payment);
					// exit;
					$result = $this->authroize_payment->AIM($params);
					/*echo "<pre>";
					print_r($result);
					echo "</pre>";*/
					if(!empty($result['AT_Error']) && $result['AT_Error']==1)
					{
						  //$data['error'] = "Sales Transaction Failed due to : ".urldecode($result['AT_Response']);
						  /* Start POS Pay Now */
						  /*$data['error'] = "".urldecode($result['AT_Response']);
						  $this->_reload($data);
						  return false;*/
						  echo '|0|'.urldecode($result['AT_Response']).'|';
						  exit();
						  /* End POS Pay Now */
						  //$this->load->view('sales/thankyou');
					}
					else
					{
						  //$data['error_message'] = 'Payment was successfully made';
						  $gateway_id = $config['gateway_id'];
						  $gateway_response_data = json_encode($result['AT_Response']);		
					}
					//$this->load->view('sales/thankyou');
				}
			}

			// stripe
			if($config['gateway_id'] == 8)
			//if($config['gateway_id'] == 2 && !($payment_device_activation))
			/*End Payment Device Changes*/ 
			{ 
				$stripe_m2_response = $this->input->post('stripe_m2_response');
				if($stripe_m2_response != "")
				{
					  $gateway_id = $config['gateway_id'];
					  $gateway_response_data = $stripe_m2_response;//
				}
				else
				{

					$gateway_info = $this->Gateways->get_default_gateway()->row_array() ;
					// print_r($gateway_info['MUprivatekey']);
					// exit;
					if($this->input->post('cc_no') && $this->input->post('cc_month'))
					{ 
						$stripe_secret_key = $gateway_info['MUprivatekey'];//'sk_test_51MzAVvHN5knCLl3391JchRsCk0tnNCrnz0WtiW7gYbizlaNmIHd2JRwi2xpBI5j3U5A9GiYSNfgGmHYMR7Rt3bKG00pq4dMTs6';

						$stripe_publishable_key = $gateway_info['MUpublishablekey'];//'pk_test_51MzAVvHN5knCLl33WP29EEuEXEotLRlBNt90JkLmyLosgn8QGBEfU918MPWMAwv3mtZPriKroGvGVBvx0HJPHIoz00hMRvgYZX';

						$name = 'pos customer';
						$email = 'pos_customer@wrkmash.com';

						$refId = "ref" . time();

						$stripeToken = $this->input->post('stripe_token');

						try 
						{
							$stripe_response = $this->sale_lib->payWithStripe($stripe_publishable_key,$stripe_secret_key,$stripeToken,$name,$email,$total_payments,'POS Sale',$refId);

							$stripe_result = ['error'=>0];
							if($stripe_response->status != "succeeded")
							{
								$stripe_result['error'] = 1;
								$stripe_result['message'] = $response->failure_message;
							}
						
						} catch (Exception $e) {
						    // Handle exceptions
						    // echo "Caught exception: " . $e->getMessage();
							$stripe_result = ['error'=>1,'message'=>$e->getMessage()];

						} catch (Error $e) {
						    // Handle errors
						    // echo "Caught error: " . $e->getMessage();
							$stripe_result = ['error'=>1,'message'=>$e->getMessage()];
						}


							// echo json_encode($stripe_result);

						if(!empty($stripe_result['error']) && $stripe_result['error']==1)
						{
							  //$data['error'] = "Sales Transaction Failed due to : ".urldecode($stripe_result['AT_Response']);
							  /* Start POS Pay Now */
							  /*$data['error'] = "".urldecode($stripe_result['AT_Response']);
							  $this->_reload($data);
							  return false;*/
							  echo '|0|'.urldecode($stripe_result['message']).'|';
							  exit();
							  /* End POS Pay Now */
							  //$this->load->view('sales/thankyou');
						}
						else
						{
							  //$data['error_message'] = 'Payment was successfully made';
							  $gateway_id = $config['gateway_id'];
							  $gateway_response_data = json_encode($stripe_response);//json_encode($result['AT_Response']);		
						}
						//$this->load->view('sales/thankyou');
					}
				}
			}

			// echo $gateway_id;
			// echo $gateway_response_data;
			// exit;
	
			//Payment Through Linkpoint API  
			/*Start Payment Device Changes*/ 
			if($config['gateway_id'] == 3)
			//if($config['gateway_id'] == 3 && !($payment_device_activation))
			/*End Payment Device Changes*/
			{
				if($this->input->post('cc_no') && $this->input->post('cc_month'))
				{ 
					$myorder["host"]       = "secure.linkpt.net";
					$myorder["port"]       = "1129";
					$myorder["keyfile"]    = "/home/opost124/public_html/opostest/1243360.pem"; # Change this to the name and location of your certificate file 
					$myorder["configfile"] = "1243360";    
					   
					# transaction details
					$myorder["ordertype"]         =  'SALE';
					$myorder["result"]            = 'good';
					
					$myorder["terminaltype"]      = 'UNSPECIFIED';
					$myorder["ip"]                = $_SERVER['REMOTE_ADDR'];
				
					# totals
					
					$myorder["chargetotal"] = $total_payments;
				
					# card info
					$myorder["cardnumber"]   = $this->input->post('cc_no');
					$myorder["cardexpmonth"] = $this->input->post('cc_month');
					$myorder["cardexpyear"]  = $this->input->post('cc_year');
					$myorder["cvmindicator"] = 'provided';
					$myorder["cvmvalue"]     = '123';
					/*
					$myorder["cardnumber"]   = '4111111111111111';
					$myorder["cardexpmonth"] = '01';
					$myorder["cardexpyear"]  = '04';
					$myorder["cvmindicator"] = 'provided';
					$myorder["cvmvalue"]     = '123';*/
			 
					$this->load->library('lphp');
					$result=$this->lphp->curl_process($myorder);
						
					if ($result["r_approved"] != "APPROVED")    // transaction failed, print the reason
					{ 
							//echo json_encode(array('success'=>true,'message'=>'CC inValid'));
							echo 'success';
							print "Status:  $result[r_approved]<br>\n";
							print "Error:  $result[r_error]<br><br>\n";
							echo '<input type="button"  value="Back" onclick="javascript: history.back();">'; 
						 
					}
					else	// success
					{		
							//echo json_encode(array('success'=>true,'message'=>'CC Valid'));
							echo 'failure';
							print "Status: $result[r_approved]<br>\n";
							print "Transaction Code: $result[r_code]<br><br>\n"; 
							
					}
						
					$this->load->view('sales/thankyou');
				}
			}
			
			//Payment Through First Data API 
			/*Start Payment Device Changes*/  
			if($config['gateway_id'] == 5)
			//if($config['gateway_id'] == 5 && !($payment_device_activation))
			/*End Payment Device Changes*/
			{
				$this->load->library('firstdata_payment');
				if($this->input->post('cc_no') && $this->input->post('cc_month'))
				{
					//echo "First Data";
					//print_r($cust_info);
					$params->POSROOT = $this->input->post('POSROOT');
					$params->type = $this->input->post('cc_type');
					$params->name = $this->input->post('cc_name');
					$params->number = $this->input->post('cc_no');
					//$params->expiry = $this->input->post('cc_month').''.$this->input->post('cc_year');
					$params->expiry = $this->input->post('cc_month').''.date("y",strtotime("01-01-".$this->input->post('cc_year')));
					$params->cvv = $this->input->post('cc_cvv');
					//$params->zip = $cust_info->zip;
					//$params->address = $cust_info->address_1;
					$params->zip = "";
					$params->address = "";
					$params->amount = $total_payments;
					
					$result = $this->firstdata_payment->Purchase($params);
					//$result = json_decode($result);
					/*echo "<pre>";
					print_r($result);
					echo "</pre>";
					print_r(json_decode($result['FD_Response']));*/
					//$response = json_decode($result['FD_Response']);
					/*echo "<pre>";
					print_r($result);
					echo "</pre>";*/
					
					if(!empty($result['FD_Error']) && $result['FD_Error']==1)
					{
						$response = json_decode($result['FD_Response']);
						if($response->bank_resp_code==605)
						{
							//$data['error'] = "Sales Transaction Failed due to : ".$response->bank_message;
							$data['error'] = "".$response->bank_message;	
						}
						else
						{
							//$responseArray = explode("-",$result['FD_Response']);
							//$data['error'] = "Sales Transaction Failed due to : ".$result['FD_Response'];
							$data['error'] = "".$result['FD_Response'];
						}
						//exit();
						
						/* Start POS Pay Now */
						/*$this->_reload($data);
						return false;*/
						echo '|0|'.$data['error'].'|';
						exit();
						/* End POS Pay Now */
						//$this->_reload(array('error_message' => $this->lang->line('sales_transaction_failed').":".$responseArray[1]));
						//exit();
					}
					else
					{
						$gateway_id = $config['gateway_id'];
						$gateway_response_data = $result['FD_Response'];
						//$data['success'] = "Sale complete successfully";
					}
				}
			}
			
			//Payment Through 2Checkout API  
			/*Start Payment Device Changes*/ 
			if($config['gateway_id'] == 6)
			//if($config['gateway_id'] == 6 && !($payment_device_activation))
			/*End Payment Device Changes*/
			{
				$this->load->library('twocheckout_payment');
				if($this->input->post('cc_no') && $this->input->post('cc_month'))
				{
					//echo "2Checkout";exit();
					//print_r($cust_info);
					$params->token = $this->input->post('twocheckout_token');
					/*$params->type = $this->input->post('cc_type');
					$params->name = $this->input->post('cc_name');
					$params->number = $this->input->post('cc_no');
					$params->expiry = $this->input->post('cc_month').''.$this->input->post('cc_year');
					$params->cvv = $this->input->post('cc_cvv');*/
					/*$params->name = $cust_info->first_name."&nbsp;".$cust_info->last_name;
					$params->city = $cust_info->city;
					$params->state = $cust_info->state;
					$params->country = $cust_info->country;
					$params->zip = $cust_info->zip;
					$params->email = $cust_info->email;
					$params->phone_number = $cust_info->phone_number;
					$params->address = $cust_info->address_1;*/
					$params->currency = "USD";
					$params->total = $total_payments;
					//print_r($params);
					$result = $this->twocheckout_payment->Authorize($params);
					//print_r($result);
					/*echo "<pre>";
					print_r($result);
					echo "</pre>";*/
					//exit();
					if(!empty($result['CK_Error']) && $result['CK_Error']==1)
					{
						//$data['error'] = "Sales Transaction Failed due to : ".$result['CK_Response'];
						if($result['CK_Response'] == "Unauthorized")
						$data['error'] = "Seller unauthorized to use the API or incorrect publishable key";
						else
						$data['error'] = "".$result['CK_Response'];
						
						/* Start POS Pay Now */
						/*$this->_reload($data);
						return false;*/
						echo '|0|'.$data['error'].'|';
						exit();
						/* End POS Pay Now */
						//$this->_reload(array('error_message' => $this->lang->line('sales_transaction_failed').":".$responseArray[1]));
						//exit();
					}
					else
					{
						$gateway_id = $config['gateway_id'];
						$gateway_response_data = $result['CK_Response'];
						//$data['success'] = "Sale complete successfully";
					}
				}
			}
			
			/*Start Payment Device Changes*/ 
			//if($payment_device_activation)
			if($config['gateway_id'] == 7)
			{
				$this->load->library('chargeitpro_lib');
				$params->cip_external_tran_id = $this->sale_lib->get_external_transaction_id();
				
				$result = $this->chargeitpro_lib->RetrieveResults($params);//print_r($result);
				if(!empty($result['CIP_Error']) && $result['CIP_Error']==1)
				{
					//Error
					/* Start POS Pay Now */
					/*$data['error'] = "".$result['CIP_Response'];
					$this->_reload($data);
					return false;*/
					echo '|0|'.$result['CIP_Response'].'|';
					exit();
					/* End POS Pay Now */
				}
				else
				{
					//Success
					//$payment_device_id = $payment_device->device_id;
					//$payment_device_response = json_encode($result['CIP_Response']);
					if ($this->Appconfig->get('sales_tips'))
					{
						if (!empty($data['tips']) && ($data['tips']!=-1))
						{
							//echo $data['tips']['amount'];
							$uniqueTransId = $result['CIP_Response']->uniqueTransId;
							$params->cip_tip_amount = strval(round($data['tips']['amount'],2));
							$params->cip_unique_transaction_id = $uniqueTransId;
							$params->cip_external_transaction_id = $this->sale_lib->get_external_transaction_id();
							$result = $this->chargeitpro_lib->AdjustTransaction($params);//print_r($result);
							if(!empty($result['CIP_Error']) && $result['CIP_Error']==1)
							{
								//Error
								/* Start POS Pay Now */
								/*$data['error'] = "".$result['CIP_Response'];
								$this->_reload($data);
								return false;*/
								if($result['CIP_Response'] == "Failed validation")
								{
									$result['CIP_Response'] = "Amount can not be zero";
								}
								
								if($result['CIP_Response'] == "Unauthorized")
								{
									$result['CIP_Response'] = "Unauthorized HTTP Request. Invalid credentials";
								}
								echo '|0|'.$result['CIP_Response'].'|';
								exit();
								/* End POS Pay Now */
							}
						}
					}
					$gateway_id = $config['gateway_id'];
					$gateway_response_data = json_encode($result['CIP_Response']);
				}
			}
			/*End Payment Device Changes*/ 
		}
		//print_r($_POST);
		//exit();
		/*$data['sale_id'] = 'POS '.$this->Sale->save($data['cart'], $customer_id,$employee_id,$comment,$data['payments']);*/

		foreach ($data['payments'] as $key => $value) {
			$data['payments'][$key]['payment_amount'] = $data['total'];
		}

		// print_r($data['payments']);
		// exit;

		$return_payment_response = "";
		$return_gateway_id = 0;
		$return_sale_id = "";
		$mode = $this->sale_lib->get_mode();
		// $ZCPROOT = ZCPROOT;
		if($mode == "return")
		{
			$return_sale_id = $this->input->post('return_sale_id');
			$return_payment_type = $this->input->post('return_payment_type');
			$return_payment_transaction_id = $this->input->post('return_payment_transaction_id');

			if($return_payment_type == "card")
			{
				foreach ($data['payments'] as $key => $value) {
					$data['payments'][$key]['payment_amount'] = $data['total'];
					$data['payments'][$key]['payment_type'] = 'Credit Card';
				}
				$return_gateway_id = $this->input->post('return_gateway_id');
				$return_amount = (string)abs($data['total']);
				
				if($return_gateway_id == 7)
				{
					$this->load->library('chargeitpro_lib');
					$return_payment_response = $this->chargeitpro_lib->RefundTransaction($return_payment_transaction_id,$return_amount);

				
					if($return_payment_response['CIP_Error'] == 1)
					{
						$payment_error = "Payment refund failed!";
						if($return_payment_response['CIP_Response'] != "")
							$payment_error = $return_payment_response['CIP_Response'];

						echo '|0|'.$payment_error.'|';
						exit();
					}
					else
					{
						$return_payment_response = json_encode($return_payment_response['CIP_Response']);
					}
				}
				else if($return_gateway_id == 8)
				{

					$gateway_info = $this->Gateways->get_default_gateway()->row_array() ;

					$stripe_secret_key = $gateway_info['MUprivatekey'];//'sk_test_51MzAVvHN5knCLl3391JchRsCk0tnNCrnz0WtiW7gYbizlaNmIHd2JRwi2xpBI5j3U5A9GiYSNfgGmHYMR7Rt3bKG00pq4dMTs6';

					$stripe_publishable_key = $gateway_info['MUpublishablekey'];//'pk_test_51MzAVvHN5knCLl33WP29EEuEXEotLRlBNt90JkLmyLosgn8QGBEfU918MPWMAwv3mtZPriKroGvGVBvx0HJPHIoz00hMRvgYZX';
					// echo $return_amount;
					// exit;

					$return_payment_response = $this->sale_lib->returnWithStripe($stripe_publishable_key,$stripe_secret_key,$return_payment_transaction_id,$return_amount);

					// print_r($return_payment_response);
					// exit;
				
					if($return_payment_response['error'] == 1)
					{
						$payment_error = "Payment refund failed!";
						if($return_payment_response['msg'] != "")
							$payment_error = $return_payment_response['msg'];

						echo '|0|'.$payment_error.'|';
						exit();
					}
					else
					{
						$return_payment_response = json_encode($return_payment_response['response']);
					}
				}
				else if($return_gateway_id == 2)
				{
					$custom_defined_root = $_SERVER['DOCUMENT_ROOT']."/zcp/source/"; 
					include($custom_defined_root."lib/PaymentsAPI/anet_php_sdk/refund-transaction.php");
					
					
					$account_number = $this->input->post('return_account_number');
					
					$at_login = $this->authroize_payment->at_login;
					$at_password = $this->authroize_payment->at_password;
					$at_environment = $this->authroize_payment->at_environment;

					if($at_environment == 1)
						$at_environment = "SANDBOX";

					$expDate = 'XXXX';
					$cardNum = explode("XXXX", $account_number)[1];

					$return_amount = ($data['total']);

					$return_payment_response = refundTransaction($at_login,$at_password,$at_environment,$return_payment_transaction_id,$return_amount,$cardNum,$expDate);

					if($return_payment_response['error'] == 1)
					{
						$payment_error = "Payment refund failed!";
						if($return_payment_response['msg'] != "")
							$payment_error = $return_payment_response['msg'];

						$return_payment_response_arr = json_decode($return_payment_response['response'],true);
						if($return_payment_response_arr['Error code'] == "54")
						{
							$payment_error = "Payments settled via Credit Card are not allowed to be refunded on the same day."; // ref: https://mage2.pro/t/topic/5435
						}

						echo '|0|'.$payment_error.'|';
						exit();
					}
					else
					{
						$return_payment_response = $return_payment_response['response'];
					}
				}
			}
		}

		$account_name = $this->session->userdata('shopname');
		//echo $account_name;
		/*print_r($this->Sale->save($data['cart'], $customer_id,$employee_id,$comment,$data['payments'],"",$tax_comment,$data['total'],$return_payment_response,$return_gateway_id,$mode,$return_sale_id,$account_name));exit;*/
		$data['sale_id'] = 'POS '.$this->Sale->save($data['cart'], $customer_id,$employee_id,$comment,$data['payments'],"",$tax_comment,$data['total'],$return_payment_response,$return_gateway_id,$mode,$return_sale_id,$account_name); 
		$sale_id = $data['sale_id'];
		/* Start Set Sale Id */
		$sale_id_array = explode(" ",$sale_id);
		$paynow_sale_id = $sale_id_array[1];
		$this->sale_lib->set_sale_id($paynow_sale_id);
		/* End Set Sale Id */
		if ($sale_id == 'POS -1')
		{
			/* Start POS Pay Now */
			/*$data['error_message'] = $this->lang->line('sales_transaction_failed');
			redirect('sales/incomplete');*/
			echo '|0|'.$this->lang->line('sales_transaction_failed').'|';
			exit();
			/* End POS Pay Now */
		}
		else
		{
			$this->db->dbprefix = "opos_"; 
			$this->db->from('sales');
			$sale_id_array = explode(" ",$sale_id);
			$this->db->where('sale_id',$sale_id_array[1]);
			$query_sales = $this->db->get();
			$result_sales = $query_sales->row();//print_r($result_sales);
			
			$this->db->from('sales_items');
			$this->db->where('sale_id',$sale_id_array[1]);
			$query_sales_items = $this->db->get();
			$result_sales_items = $query_sales_items->row();//print_r($result_sales_items);
			
			$this->db->dbprefix = "accounting_"; 
			//$query_sales_orders = $this->db->query(" SELECT MAX(`order_no`)+1 AS `order_no` FROM `accounting_sales_orders` ");
			$query_sales_orders = $this->db->query(" SELECT MAX(`order_no`)+1 as order_no FROM (SELECT MAX(`order_no`) as order_no FROM accounting_sales_orders WHERE trans_type=30 UNION SELECT MAX(`id`) as order_no FROM accounting_voided WHERE type=30) a ");
			$result_sales_orders = $query_sales_orders->row();
			$order_no = $result_sales_orders->order_no;
			
			//$this->db->from('sales_orders');
			//echo $result = $query->row();
			//$this->db->where('sale_id',$sale_id);
			//$query = $this->db->get();
			/*Get debtor_no From Accounting*/
			$query_debtors_master = $this->db->query(" SELECT debtor_no FROM accounting_debtors_master WHERE pos_customer_id='$customer_id' ");
			$result_debtors_master = $query_debtors_master->row();
			$debtor_no = $result_debtors_master->debtor_no;
			
			/*Get branch_code From Accounting*/
			$query_cust_branch = $this->db->query(" SELECT branch_code FROM accounting_cust_branch WHERE pos_customer_id='$customer_id' ");
			$result_cust_branch = $query_cust_branch->row();
			$branch_code = $result_cust_branch->branch_code;
			
			/*Get next_reference From Accounting*/
			$query_sys_types = $this->db->query(" SELECT next_reference FROM accounting_sys_types WHERE type_id='30' ");
			$result_sys_types = $query_sys_types->row();
			$next_reference = $result_sys_types->next_reference;
			
			/*Get location_name From Accounting*/
			$query_locations = $this->db->query(" SELECT loc_code FROM accounting_locations ");
			$result_locations = $query_locations->row();
			$loc_code = $result_locations->loc_code;
			
			/*Get Company Fiscal Year From Accounting*/
			$query_sys_prefs = $this->db->query(" SELECT value FROM accounting_sys_prefs WHERE name ='f_year' ");
			$result_sys_prefs = $query_sys_prefs->row();
			$fiscal_year = $result_sys_prefs->value;
			
			/*Get Company Fiscal Year Date From Accounting*/
			$query_fiscal_year = $this->db->query(" SELECT end FROM accounting_fiscal_year WHERE id ='$fiscal_year' ");
			$result_fiscal_year = $query_fiscal_year->row();
			$fiscal_year_end = $result_fiscal_year->end;
			
			/*Save Data in Accounting Order Sales */
			$data_accounting_sales = array();
			$data_accounting_sales['order_no'] = $order_no;
			$data_accounting_sales['pos_sale_id'] = $sale_id_array[1];
			$data_accounting_sales['pos_store'] = $this->store_name;
			//$data_accounting_sales['trans_type'] = 130;
			$data_accounting_sales['trans_type'] = 30;
			$data_accounting_sales['version'] = 0;
			$data_accounting_sales['type'] = 0;
			$data_accounting_sales['debtor_no'] = $debtor_no;
			//$data_accounting_sales['branch_code'] = "-1";
			$data_accounting_sales['branch_code'] = $branch_code;
			$data_accounting_sales['reference'] = $next_reference;
			$data_accounting_sales['customer_ref'] = "";
			$data_accounting_sales['comments'] = "Sales from POS";
			$ord_date = explode(" ",$result_sales->sale_time);
			$data_accounting_sales['ord_date'] = $ord_date[0];
			$data_accounting_sales['order_type'] = 1;//Retail
			//$data_accounting_sales['ship_via'] = '-1';
			$data_accounting_sales['ship_via'] = '1';
			//$data_accounting_sales['delivery_address'] = "";
			$data_accounting_sales['delivery_address'] = ($cust_info->address_1."\n".$cust_info->address_2);
			$data_accounting_sales['contact_phone'] = $cust_info->phone_number;
			$data_accounting_sales['contact_email'] = $cust_info->email;
			$data_accounting_sales['deliver_to'] = ($cust_info->first_name." ".$cust_info->m_name." ".$cust_info->last_name);
			$data_accounting_sales['freight_cost'] = 0;
			$data_accounting_sales['from_stk_loc'] = $loc_code;
			$data_accounting_sales['delivery_date'] = date("Y-m-d");
			$data_accounting_sales['payment_terms'] = 4;
			//$data_accounting_sales['total'] = ($result_sales->totalSV);
			$data_accounting_sales['total'] = ($total_payments);
			$data_accounting_sales['net_total'] = ($total_payments);
			$data_accounting_sales['application'] = 2;
			//print_r($data_accounting_sales);//exit();
			//$sqlClass->addData($data_accounting_sales,$table_accounting_sales);
			//$this->db->dbprefix("sales_orders");
			$this->db->insert('sales_orders',$data_accounting_sales);
			
			/*Update Accounting Sys Types*/
			$this->db->where('type_id', 30);
			$data_accounting_sys_types = array();
			//$data_accounting_sys_types['type_no'] = 5;
			$data_accounting_sys_types['next_reference'] = $order_no;
			$this->db->update('sys_types',$data_accounting_sys_types);
			
			/*Save data in Accounting Audit Trial*/
			$data_accounting_audit_trail = array();
			$data_accounting_audit_trail['type'] = 30;
			$data_accounting_audit_trail['trans_no'] = $order_no;
			$data_accounting_audit_trail['user'] = $employee_id;
			$data_accounting_audit_trail['stamp'] = $result_sales->sale_time;
			$data_accounting_audit_trail['description'] = "";
			$data_accounting_audit_trail['fiscal_year'] = $fiscal_year;
			$data_accounting_audit_trail['gl_date'] = $fiscal_year_end;
			$data_accounting_audit_trail['gl_seq'] = 0;
			$this->db->insert('audit_trail',$data_accounting_audit_trail);
			
			/*Save data in Accounting Ref*/
			$data_accounting_refs = array();
			$data_accounting_refs['id'] = $order_no;
			$data_accounting_refs['type'] = 30;
			$data_accounting_refs['reference'] = $next_reference;
			$this->db->insert('refs',$data_accounting_refs);
			
			//$order_no = $this->db->insert_id();
			//exit();
			//$products_info = unserialize($order_detail['products_info']);
			$sub_total_amount = 0;
			//$table_accounting_sales_details = ACCOUNTINGTBLPREFIX."sales_order_details";//exit();
			//foreach($products_info as $eachProduct)
			foreach($query_sales_items->result() as $key=>$eachProduct)
			{
				$this->db->dbprefix = "opos_"; 
				$cur_item_info = $this->Item->get_info($eachProduct->item_id);
				
				/*Check Item in Accounting Stock Master Save if not Exists*/
				$this->db->dbprefix = "accounting_"; 
				$query_stock_master = $this->db->query(" SELECT * FROM accounting_stock_master WHERE cp_item_id ='".$eachProduct->item_id."' ");
				if($query_stock_master->num_rows()==1)
				{
					$result_stock_master = $query_stock_master->row();
					$stock_id = $result_stock_master->stock_id;
					$stk_code = $stock_id;
					$description = $result_stock_master->description;
				}
				else
				{
					
					/*Save Data in Accounting Stock Master*/
					$stockmaster_data = array();
					$query_stock_master = $this->db->query(" SELECT MAX(`stock_id`)+1 as stock_id FROM accounting_stock_master ");
					$result_stock_master = $query_stock_master->row();
					$max_stock_id = $result_stock_master->stock_id;
					$stockmaster_data['stock_id'] = $max_stock_id;
					$stockmaster_data['category_id'] = $cur_item_info->category_id;
					$stockmaster_data['tax_type_id'] = 1;
					$stockmaster_data['description'] = ($cur_item_info->name);
					$stockmaster_data['long_description'] = ($cur_item_info->description);
					$stockmaster_data['units'] = "each";
					$stockmaster_data['mb_flag'] = "B";
					$stockmaster_data['sales_account'] = 4010;
					$stockmaster_data['cogs_account'] = 5010;
					$stockmaster_data['inventory_account'] = 1510;
					$stockmaster_data['adjustment_account'] = 5040;	
					$stockmaster_data['assembly_account'] = 1530;
					$stockmaster_data['dimension_id'] = 0;
					$stockmaster_data['dimension2_id'] = 0;
					$stockmaster_data['actual_cost'] = $cur_item_info->unit_price;
					$stockmaster_data['last_cost'] = 0;
					$stockmaster_data['material_cost'] = 0;
					$stockmaster_data['labour_cost'] = 0;
					$stockmaster_data['overhead_cost'] = 0;
					$stockmaster_data['inactive'] = 0;
					$stockmaster_data['no_sale'] = 0;
					$stockmaster_data['editable'] = 0;
					$stockmaster_data['c5_pID'] = $cur_item_info->c5_pID;
					$stockmaster_data['cp_item_id'] = $cur_item_info->item_id;
					$storeArray = explode(",",$this->session->userdata('store'));
					$stockmaster_data['cp_store'] = $storeArray[1];
					$this->db->insert('stock_master',$stockmaster_data);
					$stock_id = $max_stock_id;
					
					/*Save Data in Accounting Loc Stock*/
					$locstock_data = array();
					$locstock_data['loc_code'] = $loc_code;
					$locstock_data['stock_id'] = $stock_id;
					$this->db->insert('loc_stock',$locstock_data);
					
					/*Save Data in Accounting Item Codes*/
					$itemcodes_data = array();
					$itemcodes_data['item_code'] = $stock_id;
					$itemcodes_data['stock_id'] = $stock_id;
					$itemcodes_data['description'] = ($cur_item_info->description);
					$itemcodes_data['category_id'] = $cur_item_info->category_id;
					$itemcodes_data['quantity'] = $cur_item_info->quantity;
					$itemcodes_data['is_foreign'] = 0;
					$itemcodes_data['inactive'] = 0;
					$this->db->insert('item_codes',$itemcodes_data);
					
					/*Save Data in Accounting Item Prices*/
					$itemprices_data = array();
					$itemprices_data['stock_id'] = $stock_id;
					$itemprices_data['sales_type_id'] = 1;
					$itemprices_data['price'] = $cur_item_info->unit_price;
					$itemprices_data['curr_abrev'] = 'USD';
					$this->db->insert('prices',$itemprices_data);
					
					$result_stock_master = $query_stock_master->row();
					$stk_code = $cur_item_info->item_id;
					$description = $cur_item_info->name;
				}
				
				//print_r($cur_item_info);
				/*Save data in Accounting Order Sales Detail*/
				$data_accounting_sales_details = array();
				$data_accounting_sales_details['order_no'] = $order_no;
				//$data_accounting_sales_details['trans_type'] = 230;
				$data_accounting_sales_details['trans_type'] = 30;
				$data_accounting_sales_details['stk_code'] = $cur_item_info->item_id;
				$data_accounting_sales_details['description'] = $cur_item_info->name;
				$data_accounting_sales_details['qty_sent'] = 0;
				$data_accounting_sales_details['unit_price'] = $eachProduct->item_unit_price;
				$data_accounting_sales_details['quantity'] = $eachProduct->quantity_purchased;
				$data_accounting_sales_details['discount_percent'] = 0;
				//$this->db->dbprefix = "accounting_"; 
				$this->db->insert('sales_order_details',$data_accounting_sales_details);
				//$sqlClass->addData($data_accounting_sales_details,$table_accounting_sales_details);
			}
			
			$this->db->dbprefix = "opos_";
			$data_update_sales = array();
			$data_update_sales['gateway_id'] = $gateway_id;
			$data_update_sales['store'] = $this->store_name;
			/*Start POS Pay Now Changes*/
			if (!empty($data['tips']) && ($data['tips']!=-1))
			{$data_update_sales['tips'] = json_encode($data['tips']);}
			$data_update_sales['mode'] = $this->sale_lib->get_mode();
			/*End POS Pay Now Changes*/
			$data_update_sales['payment_type_id'] = $payment_type_value;
			$data_update_sales['gateway_response_data'] = $gateway_response_data;

			// print_r($data_update_sales);
			// exit;
			
			/*Add Signature in Sales Table*/
			if(!empty($signature_data))$data_update_sales['signature'] = $signature_data;
			/*Start Payment Device Changes*/ 
			/*Add Payment Device Data in Sales Table*/
			//$data_update_sales['payment_device_id'] = $payment_device_id;
			//$data_update_sales['payment_device_response'] = $payment_device_response;			
			/*End Payment Device Changes*/ 
			$data_update_sales['is_complete'] = 1;
			$data_update_sales['drawer_id'] = $this->input->post('drawer_id');
			$data_update_sales['drawer_balance_id'] = $this->input->post('drawer_balance_id');
			$this->db->where('sale_id',$sale_id_array[1]);
			$this->db->update('sales', $data_update_sales);
			//$data['success_message'] = "Sale complete successfully";
			$data['mode'] = $this->sale_lib->get_mode();
			if($data['mode'] == "return")
			{
				$data['success_message'] = "Refund complete successfully";
			}
			else
			{
				$data['success_message'] = "Sale complete successfully";
			}
			/*Signature Data*/
			if(!empty($signature_data))$data['signature']=$signature_data;
			$account_name = $this->session->userdata('shopname');
		    require_once(APPPATH.'libraries/barcode.php');
			Barcode39 ($barcode=$sale_id,$width="250",$height="50",$quality="100",$format="JPEG",$text=$sale_id,"","",$account_name,$folder="sales");
			//exit();
			/*Start Receipt*/
			
			/* Start POS Pay Now */
			/*$this->load->view("partial/header");
			$this->load->view("sales/receipt",$data);
			$this->load->view("partial/footer");*/
			echo '|1|'.$data['success_message'].'|'.$sale_id_array[1].'|';
			//exit();
			/* End POS Pay Now */ 
			/*End Receipt*/
		}
 		
		/*****************/
		/*********************************/
		//kamalhere
 		// $this->sale_lib->clear_all();
		$this->sale_lib->set_empid("");
		exit();
	}	
	
	function incomplete()
	{
		$data['error_message'] = $this->lang->line('sales_transaction_failed');
		$this->_reload($data);
	}
	
	function thankyou()
	{
		$this->load->view('sales/thankyou');
	}
	
	function receipt($sale_id)
	{
		$sale_info = $this->Sale->get_info($sale_id)->row_array();
		$this->sale_lib->copy_entire_sale($sale_id);
		$data['cart']=$this->sale_lib->get_cart();
		$data['payments']=$this->sale_lib->get_payments();
		$data['subtotal']=$this->sale_lib->get_subtotal();
		$data['taxes']=$this->sale_lib->get_taxes();
		$data['total']=$this->sale_lib->get_total();
		$data['receipt_title']=$this->lang->line('sales_receipt');
		$data['transaction_time']= date('m/d/Y h:i:s a', strtotime($sale_info['sale_time']));
		$data['payment_type']=$sale_info['payment_type'];
		$data['amount_change']=to_currency($this->sale_lib->get_amount_due($sale_info) * -1);
		$emp_info=$this->Employee->get_info($sale_info['employee_id']);
		$data['emp_info']=$emp_info;
		$data['employee']=$emp_info->first_name.' '.$emp_info->last_name;
		$customer_id=$this->sale_lib->get_customer();
		if($customer_id!=-1)
		{
			$cust_info=$this->Customer->get_info($customer_id);
			$data['cust_info']=$cust_info;
			$data['customer']=$cust_info->first_name.' '.$cust_info->last_name;
		}
		
		/*Signature Data*/
		$data['signature']=$sale_info['signature'];
		
		/*Tips Data*/
		$data['tips']=$sale_info['tips'];
		
		/*Gateway Data*/
		$data['gateway_info'] = $this->Gateways->get_default_gateway();
		
		$data['mode'] = $this->sale_lib->get_mode();
		if($data['mode'] == "return")
		{
			$data['success_message'] = "Sale complete successfully";
		}
		
		$data['sale_id']='POS '.$sale_id;
		//$this->load->view("sales/receipt",$data);
		$this->load->view("partial/header");
		$this->load->view("sales/receipt",$data);
		$this->load->view("partial/footer"); 
		$this->sale_lib->clear_all();
		//$this->sale_lib->set_empid("");
	}
	
	function edit($sale_id)
	{
		$data = array();

		$data['customers'] = array('' => 'No Customer');
		foreach ($this->Customer->get_all()->result() as $customer)
		{
			$data['customers'][$customer->person_id] = $customer->first_name . ' '. $customer->last_name;
		}

		$data['employees'] = array();
		foreach ($this->Employee->get_all()->result() as $employee)
		{
			$data['employees'][$employee->person_id] = $employee->first_name . ' '. $employee->last_name;
		}

		$data['sale_info'] = $this->Sale->get_info($sale_id)->row_array();
		
		$this->load->view('sales/edit', $data);
	}
	
	function delete($sale_id)
	{
		$data = array();
		
		if ($this->Sale->delete($sale_id))
		{
			$data['success'] = true;
		}
		else
		{
			$data['success'] = false;
		}
		
		$this->load->view('sales/delete', $data);
	}
	
	function save($sale_id)
	{
		$sale_data = array(
			'sale_time' => date('Y-m-d', strtotime($this->input->post('date'))),
			'customer_id' => $this->input->post('customer_id') ? $this->input->post('customer_id') : null,
			'employee_id' => $this->input->post('employee_id'),
			'comment' => $this->input->post('comment')
		);
		
		if ($this->Sale->update($sale_data, $sale_id))
		{
			echo json_encode(array('success'=>true,'message'=>$this->lang->line('sales_successfully_updated')));
		}
		else
		{
			echo json_encode(array('success'=>false,'message'=>$this->lang->line('sales_unsuccessfully_updated')));
		}
	}
	
	function _reload($data=array())
	{
		//print_r($data);exit();
		if(isset($data['error']) && !empty($data['error']))
		{
			$this->sale_lib->empty_payments();//For empty or unset payments session
		}
		$person_info = $this->Employee->get_logged_in_employee_info();//print_r($person_info);exit();
		$data['cart'] = $this->sale_lib->get_cart();//print_r($data['cart']);exit();
		$data['modes'] = array('sale'=>$this->lang->line('sales_sale'),'return'=>$this->lang->line('sales_return'));
		$data['mode'] = $this->sale_lib->get_mode();
		$data['return_type'] = $this->sale_lib->get_return_type();
		$data['subtotal'] = $this->sale_lib->get_subtotal();
		$data['taxes'] = $this->sale_lib->get_taxes();
		$data['total'] = $this->sale_lib->get_total();
		$data['items_module_allowed'] = $this->Employee->has_permission('items', $person_info->person_id);
		//Alain Multiple Payments
		$data['payments_total'] = $this->sale_lib->get_payments_total();
		$data['amount_due'] = $this->sale_lib->get_amount_due();
		$data['payments'] = $this->sale_lib->get_payments();//print_r($data['payments']);exit();
		$gateway_check = $this->Gateways->get_default_gateway()->num_rows();
		if($gateway_check>0)
		{
			$data['payment_options'] = array(
				//$this->lang->line('sales_aim') => $this->lang->line('sales_aim'),
				$this->lang->line('sales_cash') => $this->lang->line('sales_cash'),
				$this->lang->line('sales_check') => $this->lang->line('sales_check'),
				$this->lang->line('sales_giftcard') => $this->lang->line('sales_giftcard'),
				$this->lang->line('sales_debit') => $this->lang->line('sales_debit'),
				$this->lang->line('sales_credit') => $this->lang->line('sales_credit')
			);
	    }
		else
		{
		    $data['payment_options'] = array(
				//$this->lang->line('sales_aim') => $this->lang->line('sales_aim'),
				$this->lang->line('sales_cash') => $this->lang->line('sales_cash'),
				$this->lang->line('sales_check') => $this->lang->line('sales_check'),
				$this->lang->line('sales_giftcard') => $this->lang->line('sales_giftcard')
			);	
		}

		$customer_id = $this->sale_lib->get_customer();
		if($customer_id!=-1)
		{
			$info = $this->Customer->get_info($customer_id);
			$data['customer'] = $info->first_name.' '.$info->last_name;
		}
		
		$data['gateway_info'] = $this->Gateways->get_default_gateway();
		foreach ($data['gateway_info']->result() as $gateways){
  			  $data['gateway_id'] = $gateways->gateway_id;
			  $data['gateway_name'] = $gateways->gateway_name;
			  $data['MUinfo'] = $gateways->MUinfo;
			  $data['MUkey'] = $gateways->MUkey;
			  $data['MUenvironment'] = $gateways->MUenvironment;  
			  $data['MUsellerid'] = $gateways->MUsellerid;  
			  $data['MUpublishablekey'] = $gateways->MUpublishablekey;  
			  $data['MUprivatekey'] = $gateways->MUprivatekey;
			  $data['signature'] = $gateways->signature;  
		}
		//print_r($data['gateway_info']->result());
		$data['payment_type'] = $this->sale_lib->get_payment_type();
		
		/*Start Payment Device Changes*/
		/*Get Payment Device Details*/
		//$data['payment_device'] = $this->Appconfig->get_payment_device();
		//$data['payment_device_external_transaction_id'] = $this->sale_lib->get_external_transaction_id();
		/*End Payment Device Changes*/
		
		//list($store_id,$store_name) = explode(",",$this->session->userdata('store'));
		//$data['source_store'] = $store_name;
		$data['source_store'] = $this->store_name;

		$return_payment_data = $this->session->userdata('return_payment_data');
		$data['return_payment_data'] = $return_payment_data;

		/*Initialize Mobile Detect Class*/
		$Mobile_Detect = new Mobile_Detect;
		/*Calling Mobile Detect Methods*/
		$data['device_detect_type'] = ($Mobile_Detect->isMobile() ? ($Mobile_Detect->isTablet() ? 'tablet' : 'phone') : 'computer');//Check Device Type
		
		$this->load->view("partial/header");
		$this->load->view("sales/register",$data);
		$this->load->view("partial/footer");
	}

	function new_sale()
    {
    	$this->sale_lib->clear_all();
    	$this->_reload();
		
    }
	
	function clear_sale()
    {
    	$this->sale_lib->clear_all();
    }
    
	function cancel_sale()
    {
    	$this->sale_lib->clear_all();
    	//$this->_reload();
    }
	
	function suspend()
	{
		$data['cart'] = $this->sale_lib->get_cart();
		$data['subtotal'] = $this->sale_lib->get_subtotal();
		$data['taxes'] = $this->sale_lib->get_taxes();
		$data['total'] = $this->sale_lib->get_total();
		$data['receipt_title'] = $this->lang->line('sales_receipt');
		$data['transaction_time'] = date('m/d/Y h:i:s a');
		$customer_id = $this->sale_lib->get_customer();
		$employee_id = $this->Employee->get_logged_in_employee_info()->person_id;
		$comment = $this->input->post('comment');
		$emp_info = $this->Employee->get_info($employee_id);
		$payment_type = $this->input->post('payment_type');
		$data['payment_type'] = $this->input->post('payment_type');
		//Alain Multiple payments
		$data['payments'] = $this->sale_lib->get_payments();
		$data['amount_change'] = to_currency($this->sale_lib->get_amount_due() * -1);
		$data['employee'] = $emp_info->first_name.' '.$emp_info->last_name;

		if($customer_id!=-1)
		{
			$cust_info = $this->Customer->get_info($customer_id);
			$data['customer'] = $cust_info->first_name.' '.$cust_info->last_name;
		}

		$total_payments = 0;

		foreach($data['payments'] as $payment)
		{
			$total_payments += $payment['payment_amount'];
		}

		//SAVE sale to database
		$data['sale_id']='POS '.$this->Sale_suspended->save($data['cart'], $customer_id,$employee_id,$comment,$data['payments']);
		if ($data['sale_id'] == 'POS -1')
		{
			$data['error_message'] = $this->lang->line('sales_transaction_failed');
		}
		$this->sale_lib->clear_all();
		$this->_reload(array('success' => $this->lang->line('sales_successfully_suspended_sale')));
	}
	
	function suspended()
	{
		$data = array();
		$data['suspended_sales'] = $this->Sale_suspended->get_all()->result_array();
		$this->load->view('sales/suspended', $data);
	}
	
	function unsuspend()
	{
		$sale_id = $this->input->post('suspended_sale_id');
		$this->sale_lib->clear_all();
		$this->sale_lib->copy_entire_suspended_sale($sale_id);
		$this->Sale_suspended->delete($sale_id);
    	$this->_reload();
	}
	
	/*Function to Hold Sale*/
	function hold()
	{
		$data['cart']=$this->sale_lib->get_cart();
		$data['subtotal']=$this->sale_lib->get_subtotal();
		$data['taxes']=$this->sale_lib->get_taxes();
		$data['total']=$this->sale_lib->get_total();
		$data['receipt_title']=$this->lang->line('sales_receipt');
		$data['transaction_time']= date('m/d/Y h:i:s a');
		$customer_id=$this->sale_lib->get_customer();
		$employee_id=$this->Employee->get_logged_in_employee_info()->person_id;
		$comment = $this->input->post('comment');
		$emp_info=$this->Employee->get_info($employee_id);
		$payment_type = $this->input->post('payment_type');
		$data['payment_type']=$this->input->post('payment_type');
		//Alain Multiple payments
		$data['payments']=$this->sale_lib->get_payments();
		$data['amount_change']=to_currency($this->sale_lib->get_amount_due() * -1);
		$data['employee']=$emp_info->first_name.' '.$emp_info->last_name;

		if($customer_id!=-1)
		{
			$cust_info=$this->Customer->get_info($customer_id);
			$data['customer']=$cust_info->first_name.' '.$cust_info->last_name;
		}

		$total_payments = 0;

		foreach($data['payments'] as $payment)
		{
			$total_payments += $payment['payment_amount'];
		}

		//print_r($data);exit();
		//SAVE sale to database
		$data['sale_id']='POS '.$this->Sale_helded->save($data['cart'], $customer_id,$employee_id,$comment,$data['payments']);
		if ($data['sale_id'] == 'POS -1')
		{
			$data['error_message'] = $this->lang->line('sales_transaction_failed');
		}
		$this->sale_lib->clear_all();
		$this->_reload(array('success' => $this->lang->line('sales_successfully_helded_sale')));
	}
	
	/*Function to get Helded Sales*/
	function helded()
	{
		$data = array();
		$data['helded_sales'] = $this->Sale_helded->get_all()->result_array();
		//print_r("test");
		$this->load->view('sales/helded', $data);
	}
	
	/*Function to Unhold Sale*/
	function unhold()
	{
		$sale_id = $this->input->post('helded_sale_id');
		$this->sale_lib->clear_all();
		$this->sale_lib->copy_entire_helded_sale($sale_id);
		$this->Sale_helded->delete($sale_id);
		//$this->_reload();
		redirect('sales');
	}
	
	function set_new_total($line)
	{	
		$get_taxmode = $this->sale_lib->get_taxmode();
		$old_subtotal_amount = $this->sale_lib->get_subtotal();
		$old_total_amount = $this->sale_lib->get_total();
	    $new_total_amount = $this->input->post('new_total_amount');
		
		$taxes = $this->sale_lib->get_taxes();//print_r($taxes);exit();
		$item_total_taxamount = $this->input->post('item_total_taxamount');
		
		$data= array();
		$cart = $this->sale_lib->get_cart();//print_r($cart);//exit();
		foreach($cart as $line=>$item)
		{
				
			$description = $item['description'];
			$serialnumber = $item['serialnumber'];
			$quantity = $item['quantity'];
			$discount = $item['discount'];
			$discount_amount = $item['discount_amount'];
			$item_total = (($item['price']*$quantity)-((($item['price']*$quantity)*$discount)/100)-$discount_amount);
			$tax_info = $this->Item_taxes->get_info($item['item_id']);
			$item_tax = $tax_info[0]['percent'];
			/*if($get_taxmode != 2)
			$item_total = $item_total + ($item_total*$item_tax/100);
			else
			$item_total = $item_total;*/
			$item_tax_amount = 0;
			foreach($tax_info as $tax)
			{
				$item_tax_percent = $tax['percent'];
				$item_tax_amount += (($item_total*$item_tax_percent)/100);
			}
			if($get_taxmode != 2)
			$item_total = $item_total + ($item_tax_amount);
			else
			$item_total = $item_total;
			//print_r($item_total);
			
			$percentage = $item_total /$old_total_amount;
			$new_individual_subtotal = ($percentage * $new_total_amount)+((($item_total)*$discount)/100)+$discount_amount;
			//echo $new_individual_subtotal = ($percentage * $new_total_amount);echo "/";
			//print_r($new_individual_subtotal);exit();
			
			/*if($get_taxmode != 2)
			$new_item_price = round($new_individual_subtotal / (1+($item_tax/100)),2);
			else
			$new_item_price = round($new_individual_subtotal,2);*/
			
			$item_tax_amount = 0;
			foreach($tax_info as $tax)
			{
				$item_tax_percent = $tax['percent'];
				$item_tax_amount += (($new_individual_subtotal*$item_tax_percent)/100);
			}
			
			if($get_taxmode != 2)
			$new_item_price = $new_individual_subtotal -($item_tax_amount);
			else
			$new_item_price = $new_individual_subtotal;
			 
			//$new_tax_amount = $new_individual_subtotal - ($new_item_price);
			//$new_item_price = round((($new_item_price+((($new_item_price)*$discount)/100)+$discount_amount)/$quantity),2);
			$new_item_price = round(($new_item_price/$quantity),2);
				
			/*echo 'line'.$line;'<br>';
			echo 'description'.$description;
			echo'<br>';
			echo 'serialnumber'.$serialnumber;
			echo '<br>';
			echo 'quantity'.$quantity;
			echo '<br>';
			echo 'new_item_price'.$new_item_price;exit();*/

			$this->sale_lib->edit_item($line,$description,$serialnumber,$quantity,$discount,$discount_amount,$new_item_price);
		}

		redirect('sales');
		//$this->_reload();
	}
	
	function remove_taxes()
	{
		$this->sale_lib->set_taxmode(2);
		//redirect('sales');
	}
	
	function add_taxes()
	{
		$this->sale_lib->set_taxmode(1);
		//redirect('sales');
	}
	
	function add_tips()
	{
		$tips = array();
		$value = $this->input->post("value");
		$amount = $this->input->post("amount");
		if(!empty($value) && !empty($amount))
		{
			$tips = array(
					"value"=>$value,
					"amount"=>$amount
					);
		}
		$this->sale_lib->set_tips($tips);
	}
	
	/*Start Payment Device Changes*/ 
	/*function start_payment_device_sale()
	{
		$payment_type = $this->input->post('payment_type');
		if($payment_type == 4 || $payment_type == 5)
		{
		  $this->load->library('chargeitpro_lib');
		  $base_amount = $this->sale_lib->get_total();
		  $external_tran_id = $this->chargeitpro_lib->GUID();
		  
		  $this->sale_lib->clear_external_transaction_id();
		  $this->sale_lib->set_external_transaction_id($external_tran_id);

		  $params->transaction_type = "CreditSale";
		  $params->transaction_method = 'hostedFields';
		  $params->transaction_fields = array(
										  array('id' => 'base_amount', 'value' => $base_amount),
										  array('id' => 'external_tran_id', 'value' => $external_tran_id),
										  array('id' => 'device_name', 'value' => 'wrkmash1')
										);//print_r($params->transaction_fields);						
		  $result = $this->chargeitpro_lib->StartTransaction($params);//print_r($result);
		  if(!empty($result['CIP_Error']) && $result['CIP_Error']==1)
		  {
			  //Error
			  echo "|0|".$result['CIP_Response']."|";
			  exit();
		  }
		  else
		  {
			  //Success
			  $transaction_token = $result['CIP_Response'];
			  $params->transaction_token = $transaction_token;
			  $result = $this->chargeitpro_lib->InitiateDevice($params);//print_r($result);
			  if(!empty($result['CIP_Error']) && $result['CIP_Error']==1)
			  {
				  //Error
				  echo "|0|".$result['CIP_Response']."|";
				  exit();
			  }
			  else
			  {
				  echo "|1|".$transaction_token."|";	
			  }
		  }
		}
	}*/
	/*End Payment Device Changes*/ 
	
	/*Start Gravity Payments Gateway Changes*/
	function process_gravity_payments_transaction()//kamal
	{
		$payment_type = $this->input->post('payment_type');
		$device_name = $this->input->post('device_name');

		if($payment_type == 4 || $payment_type == 5)
		{
		  $this->load->library('chargeitpro_lib');
		  $base_amount = $this->sale_lib->get_total();
		  $external_tran_id = $this->chargeitpro_lib->GUID();
		  $account_name = $this->session->userdata('shopname');

		  $gateway_info = $this->Gateways->get_default_gateway();

		  foreach ($gateway_info->result() as $gateways){
				$gateway_id = $gateways->gateway_id;
				$gateway_name = $gateways->gateway_name;
				$MUinfo = $gateways->MUinfo;
				$MUkey = $gateways->MUkey;
				$MUenvironment = $gateways->MUenvironment;  
				$MUsellerid = $gateways->MUsellerid;  
				$MUpublishablekey = $gateways->MUpublishablekey;  
				$MUprivatekey = $gateways->MUprivatekey;
				$signature = $gateways->signature;  
		  }
		  
		  $this->sale_lib->clear_external_transaction_id();
		  $this->sale_lib->set_external_transaction_id($external_tran_id);
		  
		  //Save Data in Payment Gateway Transactions Table
		  $data_gateways_transactions = array();
		  $data_gateways_transactions['gateway_id'] = $gateway_id;
		  $data_gateways_transactions['transaction_id'] = $external_tran_id;
		  $this->db->insert('gateways_transactions',$data_gateways_transactions);
		  $gateway_transaction_reference = $this->db->insert_id();
		  $this->sale_lib->clear_gateway_transaction_reference();
		  $this->sale_lib->set_gateway_transaction_reference($gateway_transaction_reference);
		  
		  $params->transaction_type = "CreditSale";
		  $params->transaction_method = 'hostedFields';
		  /*$params->transaction_fields = array(
										  array('id' => 'base_amount', 'value' => $base_amount),
										  array('id' => 'external_tran_id', 'value' => $external_tran_id),
										  array('id' => 'device_name', 'value' => 'wrkmash1')
										);*/
		  $params->transaction_fields = array(
										  array('id' => 'base_amount', 'value' => $base_amount),
										  array('id' => 'external_tran_id', 'value' => $external_tran_id),
										  array('id' => 'device_name', 'value' => $device_name),
			  							  // array('id' => 'device_name', 'value' => $MUsellerid),
										  array('id' => 'transaction_reference', 'value' => "REF-".$gateway_transaction_reference),//Optional
										  array('id' => 'cashier_id', 'value' => $account_name)//Optional
										);//print_r($params->transaction_fields);						
		  $result = $this->chargeitpro_lib->StartTransaction($params);//print_r($result);
		  if(!empty($result['CIP_Error']) && $result['CIP_Error']==1)
		  {
			  //Error
			  echo "|0|".$result['CIP_Response']."|";
			  exit();
		  }
		  else
		  {
			  //Success
			  $transaction_token = $result['CIP_Response'];
			  $params->transaction_token = $transaction_token;
			  $result = $this->chargeitpro_lib->InitiateDevice($params);//print_r($result);
			  if(!empty($result['CIP_Error']) && $result['CIP_Error']==1)
			  {
				  //Error
				  echo "|0|".$result['CIP_Response']."|";
				  exit();
			  }
			  else
			  {
				  echo "|1|".$transaction_token."|";	
			  }
		  }
		}
	}
	
	function check_gravity_payments_transaction()
	{
		$gateway_id = $this->input->post('gateway_id');
		$transaction_token = $this->input->post('transaction_token');
		$external_transaction_id = $this->sale_lib->get_external_transaction_id();
		$transaction_reference = $this->sale_lib->get_gateway_transaction_reference();
		$this->db->from('gateways_transactions');
		$this->db->where('gateway_id',$gateway_id);
		$this->db->where('id',$transaction_reference);
		$this->db->where('transaction_id',$external_transaction_id);
		$check_gateways_transaction = $this->db->get();
		$check_gateways_transaction = $check_gateways_transaction->row();//print_r($check_gateways_transaction);
		//if(!empty($check_gateways_transaction) && ($check_gateways_transaction->status == 1))
		if(!empty($check_gateways_transaction))
		{
			/*if($check_gateways_transaction->status == 2)*/
			if($check_gateways_transaction->status == 1)
			{
				$this->load->library('chargeitpro_lib');
				/*$params->cip_transaction_token = $transaction_token;
				$result = $this->chargeitpro_lib->PatchTransaction($params);*/ // this method use to convert nocard
				$params->cip_external_tran_id = $external_transaction_id;//"A4C36C8E-ABF9-4BB1-9747-A96578C79015";////$transaction_token;
				$result = $this->chargeitpro_lib->RetrieveResults($params);//print_r($result);
				if(!empty($result['CIP_Error']) && $result['CIP_Error']==1)
				{
					//Error
					echo "|2|".$result['CIP_Response']."|";
					exit();
				}
				else if(!empty($result['CIP_Error']) && $result['CIP_Error']==0)
				{
					echo "|1|".$result['CIP_Response']."|";
					exit();
				}
			}
			echo "|".$check_gateways_transaction->status."|".$check_gateways_transaction->transaction_message."|";
		}
		exit();
	}
	
	function cancel_gravity_payments_transaction()
	{
		$this->load->library('chargeitpro_lib');
		$transaction_token = $this->input->post('transaction_token');

		$params->transaction_token = $transaction_token;
		$result = $this->chargeitpro_lib->DeleteTransaction($params);//print_r($result);
		if(!empty($result['CIP_Error']) && $result['CIP_Error']==1)
		{
			//Error
			echo "|0|".$result['CIP_Response']."|";
			exit();
		}
		else
		{
			echo "|1|".$transaction_token."|";	
		}
		exit();
	}
	
	//Patch Transaction for Covert to Manul Entry
	function patch_gravity_payments_transaction()
	{
		$this->load->library('chargeitpro_lib');
		$transaction_token = $this->input->post('transaction_token');

		$params->transaction_token = $transaction_token;
		$result = $this->chargeitpro_lib->PatchTransaction($params);//print_r($result);
		if(!empty($result['CIP_Error']) && $result['CIP_Error']==1)
		{
			//Error
			echo "|0|".$result['CIP_Response']."|";
			exit();
		}
		else
		{
			echo "|1|".$transaction_token."|";	
		}
		exit();
	}
	
	function get_gravity_payments_transaction_token($return)
	{
		$this->load->library('chargeitpro_lib');
		$base_amount = $this->sale_lib->get_total();
		$external_tran_id = $this->chargeitpro_lib->GUID();
		$account_name = $this->session->userdata('shopname');

		$this->sale_lib->clear_external_transaction_id();
		$this->sale_lib->set_external_transaction_id($external_tran_id);
		
		$params->transaction_type = "CreditSale";
		$params->transaction_method = 'hostedFields';
		$params->transaction_fields = array(
										array('id' => 'base_amount', 'value' => $base_amount),
										array('id' => 'external_tran_id', 'value' => $external_tran_id)
									  );//print_r($params->transaction_fields);						
		$result = $this->chargeitpro_lib->StartTransaction($params);//print_r($result);
		if(!empty($result['CIP_Error']) && $result['CIP_Error']==1)
		{
			//Error
			$status = 0;
			$message = $result['CIP_Response'];
			$transactionToken = "";
		}
		else
		{
			//Success
			$status = 1;
			$message = $result['CIP_Response'];
			$transactionToken = $result['CIP_Response'];
		}
		
		if(!empty($return) && $return == 'json')
		{
			echo json_encode(array("status"=>$status,"message"=>$message,"transactionToken"=>$transactionToken));
		}
		else
		{
			echo "|".$status."|".$message."|".$transactionToken."|";
		}
		exit();
	}
	/*End Gravity Payments Gateway Changes*/
	
	/*Function to get Orders Sales*/
	function orders()
	{
		$data = array();
		$this->load->view('sales/orders', $data);
	}
	
	/*Function to send email receipt*/
	function paynow_send_email()
	{
		
		$sale_id = $this->sale_lib->get_sale_id();
		$person_data = array();
		$sale_info = $this->Sale->get_info($sale_id)->row_array();
		//$this->sale_lib->copy_entire_sale($sale_id);
		$cart =$this->sale_lib->get_cart();
		$payments =$this->sale_lib->get_payments();
		$subtotal =$this->sale_lib->get_subtotal();
		$taxes =$this->sale_lib->get_taxes();
		$total =$this->sale_lib->get_total();
		//$receipt_title =$this->lang->line('sales_receipt');
		$transaction_time = date('m/d/Y h:i:s a', strtotime($sale_info['sale_time']));
		$dt = new DateTime($transaction_time);
        $transaction_date =$dt->format('Y-m-d');
		$transaction_time = $dt->format('h:i:s');
		$payment_type =$sale_info['payment_type'];
		$amount_change =to_currency($this->sale_lib->get_amount_due($sale_info) * -1);
		$emp_info=$this->Employee->get_info($sale_info['employee_id']);
		$emp_info =$emp_info;
		/*if(!empty($emp_info->first_name))
		{
			$employee =$emp_info->first_name.' '.$emp_info->last_name;
		}
		else
		{ 
			
			$employee = $emp_info->username;
		}*/
		
		if($emp_info->status == 1)
		 { 
			if($emp_info->person_id ==1){$employee ='Admin';}
			else
			{
			   if(!empty($emp_info->first_name) || !empty($emp_info->last_name))
			   {
				   $employee =' '.$emp_info->first_name .' '. $emp_info->last_name;
			   }
			   else
			   {
				   $employee =' '.$emp_info->username;
			   }  
			}
		 }
		
		$customer_id=$this->sale_lib->get_customer();
		if($customer_id!=-1)
		{
			$cust_info=$this->Customer->get_info($customer_id);
			$cust_info =$cust_info;
			$customer =$cust_info->first_name.' '.$cust_info->last_name;
		}
		else
		{
			$person_id=$this->Sale->get_customer_email($this->input->post('pay_now_customer_email_address'));
			$person_data['first_name'] = $this->input->post('pay_now_customer_first_name');
			$person_data['last_name'] = $this->input->post('pay_now_customer_last_name');
			$person_data['phone_number'] = $this->input->post('pay_now_customer_phone');
			$person_data['email'] = $this->input->post('pay_now_customer_email_address');
			$person_data['person_id'] = $person_id;
			$customer =$this->input->post('pay_now_customer_first_name').' '.$this->input->post('pay_now_customer_last_name');
			$pay_now_customer_email = $this->input->post('pay_now_customer_email_address');
			$pay_now_customer_phone = $this->input->post('pay_now_customer_phone');
		}
		
		/*Signature Data*/
		$signature =$sale_info['signature'];
		
		/*Tips Data*/
		$tips =$sale_info['tips'];
		
		/*Gateway Data*/
		$gateway_info = $this->Gateways->get_default_gateway();
		
		$mode  = $this->sale_lib->get_mode();
		/*if($mode == "return")
		{
			$data['success_message'] = "Sale complete successfully";
		}*/
		$sale_id ='POS '.$sale_id;
		if($mode == "return")
		{
			$receipttime = "Refund Time";
			$receiptdate = "Refund Date";
			$receiptperson = "Refund Person";
			$receipt_title =$this->lang->line('refund_receipt');
			$receipt_id = $this->lang->line('refund_id');
			$data['success_message'] = "Refund complete successfully";
		}
		else
		{
			$receipttime = "Sale Time";
			$receiptdate = "Sale Date";
			$receiptperson = "Sales Person";
			$receipt_title = $this->lang->line('sales_receipt');
			$receipt_id = $this->lang->line('sales_id');
			$data['success_message'] = "Sale complete successfully";
		}
		$string_receipt_sale_from = '';
		$string_receipt_sale_from .= '
			  <h4>Receipt From</h4>
			  <address>
				<strong>'.drop_multiple_slashes($this->config->item('company')).'</strong><br>
				<!--795 Folsom Ave, Suite 600--><!--<?php echo nl2br($this->config->item("address")); ?>-->'.drop_multiple_slashes($this->config->item('address')).'<br>
				<!--San Francisco, CA 94107<br>-->
				<b>Phone: </b><!--(804) 123-5432-->'.$this->config->item('phone').'<br>
				<b>Email: </b><!--info@almasaeedstudio.com-->'.$this->config->item('email').'
			  </address>';
			  
		$string_receipt_sale_to = '';
		
		
		  if(empty($pay_now_customer_email))
		  {
			  $customer_address = (!empty($cust_info->address_1))?$cust_info->address_1:$cust_info->address_2;	
			  $string_receipt_sale_to .='
					<h4>Receipt To</h4>
					<address>
					  <strong><!--John Doe-->'.drop_multiple_slashes($customer).'</strong><br>
					  <!--795 Folsom Ave, Suite 600-->'.drop_multiple_slashes($customer_address).'<br>
					  <!--San Francisco-->'.$cust_info->city.', <!--CA-->'.$cust_info->state.' <!--94107-->'.$cust_info->zip.'<br>
					  <b>Phone: </b><!--(555) 539-1037-->'.$cust_info->phone_number.'<br>
					  <b>Email: </b><!--john.doe@example.com-->'.$cust_info->email.'
					</address>';
		  }
		  else
		  {
			 if(!empty($person_data['person_id']))
			 {
				 $cust_info = $this->Customer->get_info($person_data['person_id']);
				 $customer_address = (!empty($cust_info->address_1))?$cust_info->address_1:$cust_info->address_2;
				 $string_receipt_sale_to .='
					<h4>Receipt To</h4>
					<address>
					  <strong><!--John Doe-->'.drop_multiple_slashes($customer).'</strong><br>
					  <!--795 Folsom Ave, Suite 600-->'.drop_multiple_slashes($customer_address).'<br>
					  <!--San Francisco-->'.$cust_info->city.', <!--CA-->'.$cust_info->state.' <!--94107-->'.$cust_info->zip.'<br>
					  <b>Phone: </b><!--(555) 539-1037-->'.$pay_now_customer_phone.'<br>
					  <b>Email: </b><!--john.doe@example.com-->'.$pay_now_customer_email.'
					</address>';
			 }
			 else
			 {
				 $string_receipt_sale_to .='
					<h4>Receipt To</h4>
					<address>
					  <strong><!--John Doe-->'.drop_multiple_slashes($customer).'</strong><br>
					  <b>Phone: </b><!--(555) 539-1037-->'.$pay_now_customer_phone.'<br>
					  <b>Email: </b><!--john.doe@example.com-->'.$pay_now_customer_email.'
					</address>';
			 }
			  
			  
			  
		  }
		
		
		
		  $string_receipt_sale_details = '';
		  $string_receipt_sale_details .= '  
		
		  <!-- Table row -->
		  <div class="row">
			<div class="col-xs-12">
			  <div class="panel panel-default" style="border: 1px solid transparent;border-color: #ddd;">
				  <div class="panel-heading" style="background-color: #f4f4f4;padding: 10px 15px;border-bottom: 1px solid transparent;border-top-left-radius: 3px;border-top-right-radius: 3px;border-color: #ddd;"><h3 class="panel-title" style="margin: 0;"><h3 class="panel-title"><strong>Sale Summary</strong></h3></div>
				  <div class="panel-body">
					  <div class="row">
						<div class="col-xs-12"> 
						  <div class="table-responsive">
							<table class="table table-condensed" style="width:100%">
							  <thead>
								  <tr style="height:38px;">
									  <th style="width:6%;text-align:center;" class="valign-center text-center">'.$this->lang->line('sales_quantity').'</th>
									  <th style="width:18%;text-align:left;" class="valign-center text-left">'.$this->lang->line('items_item').'</th>
									  <th style="width:10%;text-align:center;" class="valign-center text-center">Serial #</th>
									  <th style="width:32%;text-align:left;" class="valign-center text-left">Description</th>
									  <th style="width:8%;text-align:center;" class="valign-center text-center">'.$this->lang->line('common_price').'</th>
									  <th style="width:8%;text-align:center;" class="valign-center text-center">'.$this->lang->line('sales_discount').'</th>
									  <th style="width:8%;text-align:center;" class="valign-center text-center">'.$this->lang->line('sales_discount_amount').'</th>
									  <th style="width:10%;text-align:right;" class="valign-center text-right"><!--<?php echo $this->lang->line("sales_total");?>-->Subtotal</th>
								  </tr>
							  </thead>
							  <tbody>
								  <!--<tr>
									  <td>1</td>
									  <td>Call of Duty</td>
									  <td>455-981-221</td>
									  <td>El snort testosterone trophy driving gloves handsome</td>
									  <td>$64.50</td>
								  </tr>-->
								  <tr><td colspan="8" class="no-padding" style="border-bottom: 1px solid #000;"></td></tr>';
								  
								  foreach($cart as $line=>$item)
								  {
								  
									  $table_border_top = ($line == 1)?"thick-line-top":"";
									  $string_receipt_sale_details .='
									  <tr style="height:38px;">
										  <td style="text-align:center;" class="valign-center text-center">'.$item['quantity'].'</td>
										  <td style="text-align:left;" class="valign-center text-left">'.$item['name'].'</td>
										  <td style="text-align:center;" class="valign-center text-center">'.$item['serialnumber'].'</td>
										  <td style="text-align:left;" class="valign-center text-left">'.character_limiter($item['description'],130).'</td>
										  <td style="text-align:center;" class="valign-center text-center">'.to_currency($item['price']).'</td>
										  <td style="text-align:center;" class="valign-center text-center">'.$item['discount'].'</td>
										  <td style="text-align:center;" class="valign-center text-center">'.$item['discount_amount'].'</td>
										  <td style="text-align:right;" class="valign-center text-right">'.to_currency($item['price']*$item['quantity']-($item['price']*$item['quantity']*$item['discount']/100)-$item['discount_amount']).'</td>
									  </tr>';
								  
								  }
								  
								  $string_receipt_sale_details .='
								  <tr><td colspan="8" class="no-padding" style="border-bottom: 2px solid #000;"></td></tr>	
							  </tbody>
							</table>
						  </div>
						</div>  
					  </div>
					  <div class="row">
						  <!-- accepted payments column -->
						  <div class="col-md-4">
							<!--<p class="lead">Payment Methods:</p>
							<img src="<?php echo PUBDIR;?>bootstrap/dist/img/credit/visa.png" alt="Visa">
							<img src="<?php echo PUBDIR;?>bootstrap/dist/img/credit/mastercard.png" alt="Mastercard">
							<img src="<?php echo PUBDIR;?>bootstrap/dist/img/credit/american-express.png" alt="American Express">
							<img src="<?php echo PUBDIR;?>bootstrap/dist/img/credit/paypal2.png" alt="Paypal">-->
							<!--<p class="text-muted well well-sm no-shadow" style="margin-top: 10px;">
							  Etsy doostang zoodles disqus groupon greplin oooj voxy zoodles, weebly ning heekya handango imeem plugg
							  dopplr jibjab, movity jajah plickers sifteo edmodo ifttt zimbra.
							</p>-->
						  </div>
						  <!-- /.col -->';
							
						  $string_receipt_sale_details .='
						  <div class="col-md-8 pull-right" style="border:none;width: 65%;margin-left: 35%;">
							<p class="lead"><h4 style="font-size: 14px;margin-top: 20px;"><strong>Amount Due</strong></h4> <!--2/22/2014--></p>
							<div class="table-responsive" style="margin-bottom:0px;">
							  <table class="table" style="width:100%;">
								<tr><td colspan="3" class="no-padding" style="border-bottom: 1px solid #000;"></td></tr>	
								<tr>
								  <th style="height:37px;width:50%;text-align:left;padding-top: 0px;border-bottom: 1px solid #f4f4f4;" class="valign-center text-left" colspan="2">Subtotal:</th>
								  <td style="text-align:right;padding-top: 0px;border-bottom: 1px solid #f4f4f4;" class="valign-center text-right font-bold">'.to_currency($subtotal).'</td>
								</tr>';
								 
								if($get_taxmode!=2){
									$count_taxes = 1;
									foreach($taxes as $name=>$value) { 
									$nameArray = explode("%",$name);
									$taxes_title = ($count_taxes==1)?"Taxes :":"";
									$string_receipt_sale_details .='
										<tr>
											<th style="height:37px;width:25%;text-align:left;padding-top: 0px;border-bottom: 1px solid #f4f4f4;" class="valign-center text-left">'.$taxes_title.'</th>
											<td style="width:35%;text-align:left;padding-top: 0px;border-bottom: 1px solid #f4f4f4;" class="valign-center text-left">'.$nameArray[1]."&nbsp;(".$nameArray[0].' %)</td>
											<td style="width:40%;text-align:right;padding-top: 0px;border-bottom: 1px solid #f4f4f4;" class="valign-center text-right">'.to_currency($value).'</td>
										</tr>';
									$count_taxes++;}
									$total_amount = $total;	
								}
								else
								{
									$total_amount = $subtotal;	
								}
								
								if($this->Appconfig->get('sales_tips') ==1){
									$tips = json_decode($tips);
									$tip_value = $tips->value;
									$tip_amount = $tips->amount;
									$total_amount = $total+$tip_amount;
									if($tip_value!=""){
									$string_receipt_sale_details .='	  
									  <tr>
										<th style="height:37px;width:25%;text-align:left;padding-top: 0px;border-bottom: 1px solid #f4f4f4;" class="valign-center text-left">Tips:</th>
										<td style="width:35%;text-align:left;padding-top: 0px;border-bottom: 1px solid #f4f4f4;" class="valign-center text-left">'.$tip_value.'&nbsp;%</td>
										<td style="width:40%;text-align:right;padding-top: 0px;border-bottom: 1px solid #f4f4f4;" class="valign-center text-right">'.to_currency($tip_amount).'</td>
									  </tr>';
									}
								}
								
								$string_receipt_sale_details .='
								<tr>
								  <th style="height:37px;text-align:left;padding-top: 0px;border-bottom: 1px solid #f4f4f4;" class="valign-center text-left" colspan="2">'.$this->lang->line('sales_total').' :</th>
								  <td style="text-align:right;padding-top: 0px;border-bottom: 1px solid #f4f4f4;" class="valign-center text-right font-bold">'.to_currency($total_amount).'</td>
								</tr>';
								
								$count_payments = 1;
								foreach($payments as $payment_id=>$payment)
								{ 
									$splitpayment=explode(':',$payment['payment_type']);
									$paymentstype_title = ($count_payments==1)?$this->lang->line('sales_payment')." :":""; 
									$string_receipt_sale_details .='
									<tr>
										<th style="height:37px;width:25%;text-align:left;padding-top: 0px;border-bottom: 1px solid #f4f4f4;" class="valign-center text-left">'.$paymentstype_title.'</th>
										<td style="width:35%;text-align:left;padding-top: 0px;border-bottom: 1px solid #f4f4f4;" class="valign-center text-left">'.$splitpayment[0].'</td>
										<td style="width:40%;text-align:right;padding-top: 0px;border-bottom: 1px solid #f4f4f4;" class="valign-center text-right">'.to_currency( $payment['payment_amount'] * -1 ).'</td>
									</tr>';
									$count_payments++;
								}
								$string_receipt_sale_details .='
								<tr>
									<th style="height:37px;text-align:left;padding-top: 0px;border-bottom: 1px solid #f4f4f4;" colspan="2" class="valign-center text-left">'.$this->lang->line('sales_change_due').' :</th>
									<td style="text-align:right;padding-top: 0px;border-bottom: 1px solid #f4f4f4;" class="valign-center text-right font-bold">'.$amount_change.'</td>
								</tr>
							  </table>
							</div>
						  </div>
						  <!-- /.col -->
					  </div>
					  <!-- /.row -->
				  </div>
			  </div> 
			</div>
			<!-- /.col -->
		  </div>
		  <!-- /.row --> ';
		
		if(!empty($signature))
		{
		$string_receipt_sale_details .='
		<div class="row">
			<!-- accepted payments column -->
			<div class="col-sm-6 pull-right">
			  <p style="border-bottom:1px dashed #e3e3e3;" ><img src="'.$signature.'" alt="Signature" class="img-responsive" style="margin-bottom:10px;"></p>
			  <p><strong>'.$customer.'</strong></p>
			</div>
			<!-- /.col -->
		</div>
		<!-- /.row -->';
		}
		
	  
	
		$receipt_email_string  = '';
		$receipt_email_string .='
		<html>
		<body style="font-family:Source Sans Pro, Helvetica Neue, Helvetica, Arial, sans-serif;font-size:14px;color:#333;background-color:#FFF;">
			
			<!-- Content Header (Page header) -->
			<section class="content-header">
			  <h1 style="text-align:center">
				'.$receipt_title.'
			  </h1>
			</section>
			
			<!-- Main content -->
			<section class="invoice">
				
				<!-- info row -->
				<div class="row invoice-info">
				  
				  <div class="col-sm-4 invoice-col" style="width:70%;float:left;">
					<!--<b>'.$this->lang->line('sales_id').': </b>'.$sale_id.'<br>-->
					<!--<b>Sales Person: </b> '. drop_multiple_slashes($employee).'-->
					<b>'.$receipt_id.': </b>'.$sale_id.'<br>
					<b>'.$receiptperson.': </b> '. drop_multiple_slashes($employee).'
				  </div>
				  <!-- /.col -->
				  <div class="col-sm-4 invoice-col" style="width:30%;float:right;">
					<!--<b>Sale Date: </b> '.date_format($transaction_date,"d/m/Y").'<br>
					<b>Sale Time: </b> '.date_format($transaction_time,"h:i a").'<br>-->
					<!--<b>Sale Date: </b> '.($transaction_date).'<br>
					<b>Sale Time: </b> '.($transaction_time).'<br>-->
					<b>'.$receipttime.': </b> '.($transaction_date).'<br>
					<b>'.$receiptdate.': </b> '.($transaction_time).'<br>
				  </div>
				  <!-- /.col -->
				  <div class="col-sm-4 invoice-col" style="width:70%;float:left;font-style:normal">
					'.$string_receipt_sale_from.'
				  </div>
				  <!-- /.col -->
				  <div class="col-sm-4 invoice-col" style="width:30%;float:right;font-style:normal">
					'.$string_receipt_sale_to.'
				  </div>
				  <!-- /.col -->
				  
				</div>
				<!-- /.row -->
				
				<div class="row"><div class="col-xs-12" style="clear:both;"></div></div>
				
				<!--  Sale Detail -->
				'.$string_receipt_sale_details.'
				<!-- /Sale Detail -->
				
				<div class="row">
				  <div class="col-xs-12">
					  <p class="text-muted well well-sm no-shadow text-center" style="padding-top: 30px;margin-bottom: 10px;text-align:center;border-top: 2px solid #000;">
						<!--Etsy doostang zoodles disqus groupon greplin oooj voxy zoodles, weebly ning heekya handango imeem plugg
						dopplr jibjab, movity jajah plickers sifteo edmodo ifttt zimbra.-->
						'.nl2br($this->config->item('return_policy')).'
					  </p>
				  </div>
				  <!-- /.col -->
				</div>
				<!-- /.row -->
				
			</section>
			<!-- /.content -->
		</body>
		</html>
		';
		
		$subject = "POS Visitor";
		$headers  = 'MIME-Version: 1.0' . "\r\n";
		$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
		$headers .= 'From:'.$Email . "\r\n" .'Reply-To:'.$Email . "\r\n" .'X-Mailer: PHP/' . phpversion();
		//$ok = mail($to,$subject,$msg,$headers);
		/*$_SESSION["receipt_email_string"] = $receipt_email_string;*/
			
		
		$email = $this->config->item('email');
		//$subject = "Receipt for your purchase at ".$this->config->item('company'); 
		if($mode == "return")
		{
			$subject = "Receipt for your refund at ".$this->config->item('company');
		}
		else
		{
			$subject = "Receipt for your purchase at ".$this->config->item('company');
		}
		$headers  = 'MIME-Version: 1.0' . "\r\n";
		$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
		$headers .= 'From: '.$email . "\r\n" . 'Reply-To: '.$email . "\r\n" . 'X-Mailer: PHP/' . phpversion();
		
		/*$msg = $_SESSION["receipt_email_string"];*/
		$msg = $receipt_email_string;//echo $msg;exit();
		if(empty($person_data['email']))
		  {
			  $to = $this->sale_lib->get_custEmail();
		  }
		  else
		  {
			  $to = $this->input->post('pay_now_customer_email_address');
		  }
		if($this->sale_lib->get_sale_id() !=-1)
		{
		  $ok = @mail($to,$subject,$msg,$headers); 
		}
		$data['success_message'] = "Email delivered successfully.";
		//$this->load->view("sales/register",$data); 
		
		$this->sale_lib->empty_sale_id();
		$this->sale_lib->clear_all();
		//$this->sale_lib->set_empid("");
		$this->_reload($data);
		$this->Sale->addCustomerData($person_data);
	}
	
	/*Function to cash sale print*/
	function paynow_cashsale_print()
	{
		$sale_id = $this->sale_lib->get_sale_id();
		$person_data = array();
		$sale_info = $this->Sale->get_info($sale_id)->row_array();
		//$this->sale_lib->copy_entire_sale($sale_id);
		$cart =$this->sale_lib->get_cart();
		// print_r($cart);
		// exit;
		$payments =$this->sale_lib->get_payments();
		$subtotal =$this->sale_lib->get_subtotal();
		$taxes =$this->sale_lib->get_taxes();
		$total =$this->sale_lib->get_total();
		$mode  = $this->sale_lib->get_mode();
		//$receipt_title =$this->lang->line('sales_receipt');
		$transaction_time = date('m/d/Y h:i:s a', strtotime($sale_info['sale_time']));
		$dt = new DateTime($transaction_time);
        $transaction_date =$dt->format('Y-m-d');
		$transaction_time = $dt->format('h:i:s');
		$payment_type =$sale_info['payment_type'];
		$amount_change =to_currency($this->sale_lib->get_amount_due($sale_info) * -1);
		$emp_info=$this->Employee->get_info($sale_info['employee_id']);
		/*print_r($emp_info);
		exit();*/
		/*if(!empty($emp_info->first_name))
 		{
			$employee =$emp_info->first_name.' '.$emp_info->last_name;
		}
		else
		{ 
			
 			$employee = $emp_info->username;
 		}*/
		//$employee =$emp_info->first_name.' '.$emp_info->last_name;
		
		if($emp_info->status == 1)
		 { 
			if($emp_info->person_id ==1){$employee ='Admin';}
			else
			{
			   if(!empty($emp_info->first_name) || !empty($emp_info->last_name))
			   {
				   $employee =' '.$emp_info->first_name .' '. $emp_info->last_name;
			   }
			   else
			   {
				   $employee =' '.$emp_info->username;
			   }  
			}
		 }
		 
		$customer_id=$this->sale_lib->get_customer();

		if($customer_id!=-1)
		{
			$cust_info=$this->Customer->get_info($customer_id);
			$cust_info =$cust_info;
			$customer =$cust_info->first_name.' '.$cust_info->last_name;
		}
		/*Signature Data*/
		$signature =$sale_info['signature'];
		
		/*Tips Data*/
		$tips =$sale_info['tips'];
		
		/*Gateway Data*/
		$gateway_info = $this->Gateways->get_default_gateway();
		
		//$mode  = $this->sale_lib->get_mode();
		/*if($mode == "return")
		{
			$data['success_message'] = "Sale complete successfully";
		}*/
		$sale_id ='POS '.$sale_id;
		if($mode == "return")
		{
			$receipttime = "Refund Time";
			$receiptdate = "Refund Date";
			$receiptperson = "Refund Person";
			$receipt_title =$this->lang->line('refund_receipt');
			$receipt_id =$this->lang->line('refund_id');
			$data['success_message'] = "Refund complete successfully";
		}
		else
		{
			$receipttime = "Sale Time";
			$receiptdate = "Sale Date";
			$receiptperson = "Sales Person";
			$receipt_title =$this->lang->line('sales_receipt');
			$receipt_id = $this->lang->line('sales_id');
			$data['success_message'] = "Sale complete successfully";
		}
		$string_receipt_sale_from = '';
		$string_receipt_sale_from .= '
			  <h4>Receipt From</h4>
			  <address>
				<strong>'.drop_multiple_slashes($this->config->item('company')).'</strong><br>
				<!--795 Folsom Ave, Suite 600--><!--<?php echo nl2br($this->config->item("address")); ?>-->'.drop_multiple_slashes($this->config->item('address')).'<br>
				<!--San Francisco, CA 94107<br>-->
				<b>Phone: </b><!--(804) 123-5432-->'.$this->config->item('phone').'<br>
				<b>Email: </b><!--info@almasaeedstudio.com-->'.$this->config->item('email').'
			  </address>';
			  
		$string_receipt_sale_to = '';
		if(isset($customer))
		{
		  $customer_address = (!empty($cust_info->address_1))?$cust_info->address_1:$cust_info->address_2;	
		  $string_receipt_sale_to .='
				<h4>Receipt To</h4>
				<address>
				  <strong><!--John Doe-->'.drop_multiple_slashes($customer).'</strong><br>
				  <!--795 Folsom Ave, Suite 600-->'.drop_multiple_slashes($customer_address).'<br>
				  <!--San Francisco-->'.$cust_info->city.', <!--CA-->'.$cust_info->state.' <!--94107-->'.$cust_info->zip.'<br>
				  <b>Phone: </b><!--(555) 539-1037-->'.$cust_info->phone_number.'<br>
				  <b>Email: </b><!--john.doe@example.com-->'.$cust_info->email.'
				</address>';
		}
		$string_receipt_sale_details = '';
		$string_receipt_sale_details .= '  
      
		<!-- Table row -->
		<div class="row">
		  <div class="col-xs-12">
			<div class="panel panel-default">
				<div class="panel-heading"><h3 class="panel-title"><strong>Sale Summary</strong></h3></div>
				<div class="panel-body">
					<div class="row">
					  <div class="col-xs-12"> 
						<div class="table-responsive">
						  <table class="table table-condensed" style="border: 0 !important;box-shadow: none !important;">
							<thead>
								<tr>
									<th style="width:6%;text-align:center;" class="valign-center text-center">'.$this->lang->line('sales_quantity').'</th>
									<th style="width:18%;text-align:left;" class="valign-center text-left">'.$this->lang->line('items_item').'</th>
									<th style="width:10%;text-align:center;" class="valign-center text-center">Serial #</th>
									<th style="width:32%;text-align:left;" class="valign-center text-left">Description</th>
									<th style="width:8%;text-align:center;" class="valign-center text-center">'.$this->lang->line('common_price').'</th>
									<th style="width:8%;text-align:center;" class="valign-center text-center">'.$this->lang->line('sales_discount').'</th>
									<th style="width:8%;text-align:center;" class="valign-center text-center">'.$this->lang->line('sales_discount_amount').'</th>
									<th style="width:10%;text-align:right;" class="valign-center text-right"><!--<?php echo $this->lang->line("sales_total");?>-->Subtotal</th>
								</tr>
							</thead>
							<tbody>
								<!--<tr>
									<td>1</td>
									<td>Call of Duty</td>
									<td>455-981-221</td>
									<td>El snort testosterone trophy driving gloves handsome</td>
									<td>$64.50</td>
								</tr>-->
								<tr><td colspan="8" class="no-padding" style="border-bottom: 1px solid #000;"></td></tr>';
								
								foreach($cart as $line=>$item)
								{
								
									$table_border_top = ($line == 1)?"thick-line-top":"";
									$string_receipt_sale_details .='
									<tr>
										<td style="text-align:center;" class="valign-center text-center">'.$item['quantity'].'</td>
										<td style="text-align:left;" class="valign-center text-left">'.$item['name'].'</td>
										<td style="text-align:center;" class="valign-center text-center">'.$item['serialnumber'].'</td>
										<td style="text-align:left;" class="valign-center text-left">'.character_limiter($item['description'],130).'</td>
										<td style="text-align:center;" class="valign-center text-center">'.to_currency($item['price']).'</td>
										<td style="text-align:center;" class="valign-center text-center">'.$item['discount'].'</td>
										<td style="text-align:center;" class="valign-center text-center">'.$item['discount_amount'].'</td>
										<td style="text-align:right;" class="valign-center text-right">'.to_currency($item['price']*$item['quantity']-($item['price']*$item['quantity']*$item['discount']/100)-$item['discount_amount']).'</td>
									</tr>';
								
								}
								
								$string_receipt_sale_details .='
								<tr><td colspan="8" class="no-padding" style="border-bottom: 2px solid #000;"></td></tr>	
							</tbody>
						  </table>
						</div>
					  </div>  
					</div>
					<div class="row">
						<!-- accepted payments column -->
						<div class="col-md-4">
						  <!--<p class="lead">Payment Methods:</p>
						  <img src="<?php echo PUBDIR;?>bootstrap/dist/img/credit/visa.png" alt="Visa">
						  <img src="<?php echo PUBDIR;?>bootstrap/dist/img/credit/mastercard.png" alt="Mastercard">
						  <img src="<?php echo PUBDIR;?>bootstrap/dist/img/credit/american-express.png" alt="American Express">
						  <img src="<?php echo PUBDIR;?>bootstrap/dist/img/credit/paypal2.png" alt="Paypal">-->
						  <!--<p class="text-muted well well-sm no-shadow" style="margin-top: 10px;">
							Etsy doostang zoodles disqus groupon greplin oooj voxy zoodles, weebly ning heekya handango imeem plugg
							dopplr jibjab, movity jajah plickers sifteo edmodo ifttt zimbra.
						  </p>-->
						</div>
						<!-- /.col -->';
						  
						$string_receipt_sale_details .='
						<div class="col-md-8 pull-right" style="border:none;">
						  <p class="lead"><h4><strong>Amount Due</strong></h4> <!--2/22/2014--></p>
						  <div class="table-responsive" style="margin-bottom:0px;">
							<table class="table" style="width:100%;">
							  <tr><td colspan="3" class="no-padding" style="border-bottom: 1px solid #000;"></td></tr>	
							  <tr>
								<th style="height:37px;width:50%;text-align:left;padding-top:15px;" class="valign-center text-left" colspan="2">Subtotal:</th>
								<td style="text-align:right;padding-top:15px;" class="valign-center text-right font-bold">'.to_currency($subtotal).'</td>
							  </tr>';
							   
							  if($get_taxmode!=2){
								  $count_taxes = 1;
								  foreach($taxes as $name=>$value) { 
								  $nameArray = explode("%",$name);
								  $taxes_title = ($count_taxes==1)?"Taxes :":"";
								  $string_receipt_sale_details .='
									  <tr>
										  <th style="height:37px;width:25%;text-align:left;" class="valign-center text-left">'.$taxes_title.'</th>
										  <td style="width:40%;text-align:left;" class="valign-center text-left">'.$nameArray[1]."&nbsp;(".$nameArray[0].' %)</td>
										  <td style="width:35%;text-align:right;" class="valign-center text-right">'.to_currency($value).'</td>
									  </tr>';
								  $count_taxes++;}
								  $total_amount = $total;	
							  }
							  else
							  {
								  $total_amount = $subtotal;	
							  }
							  
							  if($this->Appconfig->get('sales_tips') ==1){
								  $tips = json_decode($tips);
								  $tip_value = $tips->value;
								  $tip_amount = $tips->amount;
								  $total_amount = $total+$tip_amount;
								  if($tip_value!=""){
								  $string_receipt_sale_details .='	  
									<tr>
									  <th style="height:37px;width:25%;text-align:left;" class="valign-center text-left">Tips:</th>
									  <td style="width:40%;text-align:left;" class="valign-center text-left">'.$tip_value.'&nbsp;%</td>
									  <td style="width:35%;text-align:right;" class="valign-center text-right">'.to_currency($tip_amount).'</td>
									</tr>';
								  }
							  }
							  
							  $string_receipt_sale_details .='
							  <tr>
								<th style="height:37px;text-align:left;" class="valign-center text-left" colspan="2">'.$this->lang->line('sales_total').' :</th>
								<td style="text-align:right;" class="valign-center text-right font-bold">'.to_currency($total_amount).'</td>
							  </tr>';
							  
							  $count_payments = 1;
							  foreach($payments as $payment_id=>$payment)
							  { 
								  $splitpayment=explode(':',$payment['payment_type']);
								  $paymentstype_title = ($count_payments==1)?$this->lang->line('sales_payment')." :":""; 
								  $string_receipt_sale_details .='
								  <tr>
									  <th style="height:37px;width:25%;text-align:left;" class="valign-center text-left">'.$paymentstype_title.'</th>
									  <td style="width:35%;text-align:left;" class="valign-center text-left">'.$splitpayment[0].'</td>
									  <td style="width:40%;text-align:right;" class="valign-center text-right">'.to_currency( $payment['payment_amount'] * -1 ).'</td>
								  </tr>';
								  $count_payments++;
							  }
							  $string_receipt_sale_details .='
							  <tr>
								  <th style="height:37px;text-align:left;" colspan="2" class="valign-center text-left">'.$this->lang->line('sales_change_due').' :</th>
								  <td style="text-align:right;" class="valign-center text-right font-bold">'.$amount_change.'</td>
							  </tr>
							</table>
						  </div>
						</div>
						<!-- /.col -->
					</div>
					<!-- /.row -->
				</div>
			</div> 
		  </div>
		  <!-- /.col -->
		</div>
		<!-- /.row --> ';
		if(!empty($signature))
		{
		$string_receipt_sale_details .='
		<div class="row">
			<!-- accepted payments column -->
			<div class="col-sm-6 pull-right">
			  <p style="border-bottom:1px dashed #e3e3e3;" ><img src="'.$signature.'" alt="Signature" class="img-responsive" style="margin-bottom:10px;"></p>
			  <p><strong>'.$customer.'</strong></p>
			</div>
			<!-- /.col -->
		</div>
		<!-- /.row -->';
		}
	   $paynow_cashsale_print  = '';
	   echo $paynow_cashsale_print .='
	   <html>
		<body style="font-family:Source Sans Pro, Helvetica Neue, Helvetica, Arial, sans-serif;font-size:14px;color:#333;background-color:#FFF;">
			
			<!-- Content Header (Page header) -->
			<section class="content-header">
			  <h1>
				'.$receipt_title.'
			  </h1>
			</section>
			
			<!-- Main content -->
			<section class="invoice">
				
				<div class="row">
				  
				  <div class="col-xs-12">
					<h2 class="page-header">
						<i class="fa fa-globe"></i>'. $this->config->item('company').'
						<small class="pull-right">Date:'. date("d/m/Y").'</small>
					</h2>
				  </div>
				  
				</div>
				<!-- /.row -->
				
				<!-- info row -->
				<div class="row invoice-info">
				  
				  <div class="col-sm-4 invoice-col">
				    <!--<h4>'.$this->lang->line('sales_id').':'.$sale_id.'</h4><br>-->
					<!--<b>Sale Date: </b>'.$transaction_date.'<br>
					<b>Sale Time: </b>'.$transaction_time.'<br>
					<b>Sales Person: </b>'.$employee.'-->
					<h4>'.$receipt_id.':'.$sale_id.'</h4><br>
					<b>'.$receiptdate .': </b>'.$transaction_date.'<br>
					<b>'.$receipttime  .': </b>'.$transaction_time.'<br>
					<b>'.$receiptperson  .': </b>'.$employee.'
				  </div>
				  <!-- /.col -->
				  <div class="col-sm-4 invoice-col">
					'.$string_receipt_sale_from.'
				  </div>
				  <!-- /.col -->
				  <div class="col-sm-4 invoice-col">
					'.$string_receipt_sale_to.'
				  </div>
				  <!-- /.col -->
				  
				</div>
				<!-- /.row -->
				
				<div class="row"><div class="col-xs-12" style="clear:both;"></div></div>
				
				<!--  Sale Detail -->
				'.$string_receipt_sale_details.'
				<!-- /Sale Detail -->
				
				<div class="row">
				  <div class="col-xs-12">
					<p class="text-center" style="margin-top: 10px;margin-bottom: 10px;">
					<img src="'.base_url().'application/barcodimages/'.$this->session->userdata('shopname').'/sales/barcode_'.$sale_id.'.jpg?'.time().'" class="img-responsive" style="margin:0 auto;">
					</p>
				  </div>
				  <!-- /.col -->
				</div>  
			</section>
			<!-- /.content -->
		</body>
	  </html>
	  ';
	  
	}

function getquantity()
	{
		$item_id = $this->input->post("item");
		$cur_item_info = $this->Item->get_info($item_id);
		if($cur_item_info->non_inventory_item !=1)
		{
			echo $cur_item_info->quantity;
		}
		else
		{
			echo 1;
		}
	}

	function checkquantity()
	{
		$item_id = $this->input->post("item");
		$quantity = $this->input->post("quantity");
		$cur_item_info = $this->Item->get_info($item_id);

		if($cur_item_info->quantity >= $quantity)	
		{
			echo $cur_item_info->quantity;
		}
		else
		{
			echo 0;
		}
	}
	
	function scan_idynamo()
	{
		$idynamo_tbl = "opos_idynamo_payment_history_temp";
		$token = $this->input->post('token');
		$idynamo_data_query = $this->db->query(" SELECT * from $idynamo_tbl where token = '".$token."' ");
		$result_idynamo_data = $idynamo_data_query->row();
		
		$result = ['result_found'=>0];
		if(count($result_idynamo_data) > 0)
		{
			$result = ['result_found'=>1,'result'=>$result_idynamo_data];
		}

		// remove temp data
		$this->db->query(" delete from $idynamo_tbl where token = '".$token."' ");
	
		echo json_encode($result);
	}
}


?>