<?php
class Sale_lib
{
	var $CI;

  	function __construct()
	{
		$this->CI =& get_instance();
	}

	function get_cart()
	{
		if(!$this->CI->session->userdata('cart'))
			$this->set_cart(array());

		return $this->CI->session->userdata('cart');
	}

	function set_cart($cart_data)
	{
		$this->CI->session->set_userdata('cart',$cart_data);
	}

	//Alain Multiple Payments
	function get_payments()
	{
		if(!$this->CI->session->userdata('payments'))
			$this->set_payments(array());

		return $this->CI->session->userdata('payments');
	}

	//Alain Multiple Payments
	function set_payments($payments_data)
	{
		$this->CI->session->set_userdata('payments',$payments_data);
	}
	
	//Alain Payment Type
	function get_payment_type()
	{
		if(!$this->CI->session->userdata('payment_type'))
			$this->set_payment_type(array());

		return $this->CI->session->userdata('payment_type');
	}

	//Alain Payment Type
	function set_payment_type($payment_type)
	{
		$this->CI->session->set_userdata('payment_type',$payment_type);
	}

	function get_custEmail()
	{
		$customer_id = $this->get_customer();
		$customer = $this->CI->Customer->get_info($this->get_cID());
		return $customer->email; 
	}

	//Alain Multiple Payments
	function add_payment($payment_id,$payment_amount)
	{
		$payments=$this->get_payments();
		$payment = array($payment_id=>
		array(
			'payment_type'=>$payment_id,
			'payment_amount'=>$payment_amount
			)
		);

		//payment_method already exists, add to payment_amount
		if(isset($payments[$payment_id]))
		{
			$payments[$payment_id]['payment_amount']+=$payment_amount;
		}
		else
		{
			//add to existing array
			$payments+=$payment;
		}

		$this->set_payments($payments);
		return true;

	}

	//Alain Multiple Payments
	function edit_payment($payment_id,$payment_amount)
	{
		$payments = $this->get_payments();
		if(isset($payments[$payment_id]))
		{
			$payments[$payment_id]['payment_type'] = $payment_id;
			$payments[$payment_id]['payment_amount'] = $payment_amount;
			$this->set_payments($payment_id);
		}

		return false;
	}

	//Alain Multiple Payments
	function delete_payment($payment_id)
	{
		$payments=$this->get_payments();
		unset($payments[$payment_id]);
		$this->set_payments($payments);
	}

	//Alain Multiple Payments
	function empty_payments()
	{
		$this->CI->session->unset_userdata('payments');
	}

	//Alain Multiple Payments
	function get_payments_total()
	{
		$subtotal = 0;
		foreach($this->get_payments() as $payments)
		{
		    $subtotal+=$payments['payment_amount'];
		}
		return to_currency_no_money($subtotal);
	}

	//Alain Multiple Payments
	function get_amount_due($sale_info=null)
	{
		$tip_amount = 0;
		if($sale_info != null)
		{
			if(array_key_exists('tips', $sale_info) && $sale_info['tips'] != "" && ($sale_info['payment_type_id'] == 4 || $sale_info['payment_type_id'] == 5))
			{
				$tips = json_decode($sale_info['tips']);
			  	$tip_amount = $tips->amount;				
			}
		}
		$amount_due=0;
		$payment_total = $this->get_payments_total();
		if($this->get_taxmode()!=2){$sales_total=$this->get_total();}else{$sales_total=$this->get_subtotal();}
		$sales_total += $tip_amount;
		$amount_due=to_currency_no_money($sales_total - $payment_total);
		return $amount_due;
	}

	function get_customer()
	{
		if(!$this->CI->session->userdata('customer'))
			$this->set_customer(-1);

		return $this->CI->session->userdata('customer');
	}

	function set_customer($customer_id)
	{
		$this->CI->session->set_userdata('customer',$customer_id);
	}

	function set_cmandatory($customer_id)
	{
		$this->CI->session->set_userdata('cmandatory',$customer_id);
	}
	
	function get_cmandatory()
	{
		if(!$this->CI->session->userdata('cmandatory'))
			$this->set_cmandatory(-1);

		return $this->CI->session->userdata('cmandatory');
	}
	
	function get_cID()
	{
		if(!$this->CI->session->userdata('cID'))
			$this->set_cmandatory(-1);

		return $this->CI->session->userdata('cID');
	}
	
	function get_mode()
	{
		if(!$this->CI->session->userdata('sale_mode'))
			$this->set_mode('sale');

		return $this->CI->session->userdata('sale_mode');
	}

	function get_cust()
	{
		$customer_id = $this->get_customer();
		$customer = $this->CI->Customer->get_info($customer_id);
		//$this->CI->session->set_userdata('cust_detail',$customer);
		//Do not charge sales tax if we have a customer that is not taxable
		//print_r( $this->CI->session->userdata('cust_detail'));
	
		$this->CI->session->set_userdata('cID',$customer->person_id);
		//print($customer->person_id);
	}
	
	function set_mode($mode)
	{
		$this->CI->session->set_userdata('sale_mode',$mode);
	}

	function set_return_type($return_type)
	{
		$this->CI->session->set_userdata('return_type',$return_type);
	}

	/*function get_return_type()
	{
		if(!$this->CI->session->userdata('return_type'))
			$this->set_mode('sale');

		return $this->CI->session->userdata('return_type');
	}*/
	function get_return_type()
	{
		if(!$this->CI->session->userdata('return_type'))
			$this->set_return_type('return_type');

		return $this->CI->session->userdata('return_type');
	}

	function add_item($item_id,$quantity=1,$discount=0,$discount_amount=0,$price=null,$description=null,$serialnumber=null)
	{
		//make sure item exists
		if(!$this->CI->Item->exists($item_id))
		{
			//try to get item id given an item_number
			$item_id = $this->CI->Item->get_item_id($item_id);

			if(!$item_id)
				return false;
		}

		//Alain Serialization and Description

		//Get all items in the cart so far...
		$items = $this->get_cart();

        //We need to loop through all items in the cart.
        //If the item is already there, get it's key($updatekey).
        //We also need to get the next key that we are going to use in case we need to add the
        //item to the cart. Since items can be deleted, we can't use a count. we use the highest key + 1.

        $maxkey=0;                       //Highest key so far
        $itemalreadyinsale=FALSE;        //We did not find the item yet.
		$insertkey=0;                    //Key to use for new entry.
		$updatekey=0;                    //Key to use to update(quantity)

		foreach ($items as $item)
		{
            //We primed the loop so maxkey is 0 the first time.
            //Also, we have stored the key in the element itself so we can compare.

			if($maxkey <= $item['line'])
			{
				$maxkey = $item['line'];
			}

			if($item['item_id']==$item_id)
			{
				$itemalreadyinsale=TRUE;
				$updatekey=$item['line'];
			}
		}

		$insertkey=$maxkey+1;
		$description = ($description!=null) ? $description: $this->CI->Item->get_info($item_id)->description;
		$description = $this->drop_multiple_slashes(str_replace('\r\n','<br/>',$description));
		$description = str_replace(array("\n", "\r"), ' ',$description);
		$description = htmlspecialchars($description);
		//array/cart records are identified by $insertkey and item_id is just another field.
		/*$item_result = $this->CI->Item->get_info($item_id);
		return $item_result;*/
		$item_price = $this->CI->Item->get_info($item_id)->unit_price;

		$sale_start_from = $this->CI->Item->get_info($item_id)->sale_start_from;
		$sale_end_on = $this->CI->Item->get_info($item_id)->sale_end_on;


		$nowdate = date("Y-m-d");
	    
        if($item_price == "" || $item_price == 0 )
	    {
			$item_price = $this->CI->Item->get_info($item_id)->retailprice;
	    }
	       
	    else
	    {
	    	if ($nowdate >= $sale_start_from && $nowdate <= $sale_end_on ){$item_price = $item_price;}
	    	elseif($sale_start_from == "" || $sale_start_from == 0 || $sale_end_on == "" || $sale_end_on == 0){$item_price = $item_price;}
	    	else $item_price = $this->CI->Item->get_info($item_id)->retailprice;
			
	    }

		$item = array(($insertkey)=>
		array(
			'item_id'=>$item_id,
			'line'=>$insertkey,
			'name'=>$this->drop_multiple_slashes($this->CI->Item->get_info($item_id)->name),
			'item_number'=>$this->CI->Item->get_info($item_id)->item_number,
			'description'=>$description,
			'serialnumber'=>$serialnumber!=null ? $serialnumber: '',
			'allow_alt_description'=>$this->CI->Item->get_info($item_id)->allow_alt_description,
			'is_serialized'=>$this->CI->Item->get_info($item_id)->is_serialized,
			'quantity'=>$quantity,
            'discount'=>$discount,
			'discount_amount'=>$discount_amount,
			'price'=>$price!=null ? $price: $item_price
			)
		);

		//Item already exists and is not serialized, add to quantity
		if($itemalreadyinsale && ($this->CI->Item->get_info($item_id)->is_serialized ==0) )
		{
			$items[$updatekey]['quantity']+=$quantity;
		}
		else
		{
			//add to existing array
			$items+=$item;
		}
		
		//return $items;
		$this->set_cart($items);
		return true;
	}
	
	function out_of_stock($item_id)
	{
		//make sure item exists
		if(!$this->CI->Item->exists($item_id))
		{
			//try to get item id given an item_number
			$item_id = $this->CI->Item->get_item_id($item_id);

			if(!$item_id)
				return false;
		}
		
		$item = $this->CI->Item->get_info($item_id);
		$quanity_added = $this->get_quantity_already_added($item_id);
		
		if ($item->quantity - $quanity_added < 0)
		{
			return true;
		}
		
		return false;
	}
	
	function get_quantity_already_added($item_id)
	{
		$items = $this->get_cart();
		$quanity_already_added = 0;
		foreach ($items as $item)
		{
			if($item['item_id']==$item_id)
			{
				$quanity_already_added+=$item['quantity'];
			}
		}
		
		return $quanity_already_added;
	}
	
	function get_item_id($line_to_get)
	{
		$items = $this->get_cart();

		foreach ($items as $line=>$item)
		{
			if($line==$line_to_get)
			{
				return $item['item_id'];
			}
		}
		
		return -1;
	}

	function edit_item($line,$description,$serialnumber,$quantity,$discount,$discount_amount="",$price,$select_reason)
	{
		$items = $this->get_cart();
		if(isset($items[$line]))
		{
			$items[$line]['description'] = $description;
			$items[$line]['serialnumber'] = $serialnumber;
			$items[$line]['quantity'] = $quantity;
			$items[$line]['discount'] = $discount;
			$items[$line]['discount_amount'] = $discount_amount;
			$items[$line]['price'] = $price;
			$items[$line]['select_reason'] = $select_reason;
			$this->set_cart($items);
		}

		return false;
	}

	function is_valid_receipt($receipt_sale_id)
	{
		//POS #
		$pieces = explode(' ',$receipt_sale_id);

		if(count($pieces)==2)
		{
			return $this->CI->Sale->exists($pieces[1]);
		}

		return false;
	}

	function return_entire_sale($receipt_sale_id)
	{
		//POS #
		$pieces = explode(' ',$receipt_sale_id);
		$sale_id = $pieces[1];

		$this->empty_cart();
		$this->delete_customer();

		foreach($this->CI->Sale->get_sale_items($sale_id)->result() as $row)
		{
			$qty = ($row->quantity_purchased+($row->returned_qty));

			if($qty > 0)
			{
				$this->add_item($row->item_id,-($row->quantity_purchased+($row->returned_qty)),$row->discount_percent,$row->discount_amount,$row->item_unit_price,$row->description,$row->serialnumber);
			}
		}
		$this->set_customer($this->CI->Sale->get_customer($sale_id)->person_id);
	}

	function copy_entire_sale($sale_id)
	{
		$this->empty_cart();
		$this->delete_customer();
		
		/*Start POS Pay Now Changes*/
		$sale_info = $this->CI->Sale->get_info($sale_id)->row();
		/*End POS Pay Now Changes*/

		foreach($this->CI->Sale->get_sale_items($sale_id)->result() as $row)
		{
			$this->add_item($row->item_id,$row->quantity_purchased,$row->discount_percent,$row->discount_amount,$row->item_unit_price,$row->description,$row->serialnumber);
		}
		foreach($this->CI->Sale->get_sale_payments($sale_id)->result() as $row)
		{
			$this->add_payment($row->payment_type,$row->payment_amount);
		}
		/*Start POS Pay Now Changes*/
		$this->set_mode($sale_info->mode);
		/*End POS Pay Now Changes*/
		$this->set_customer($this->CI->Sale->get_customer($sale_id)->person_id);
	}
	
	function copy_entire_suspended_sale($sale_id)
	{
		$this->empty_cart();
		$this->delete_customer();

		foreach($this->CI->Sale_suspended->get_sale_items($sale_id)->result() as $row)
		{
			$this->add_item($row->item_id,$row->quantity_purchased,$row->discount_percent,$row->discount_amount,$row->item_unit_price,$row->description,$row->serialnumber);
		}
		foreach($this->CI->Sale_suspended->get_sale_payments($sale_id)->result() as $row)
		{
			$this->add_payment($row->payment_type,$row->payment_amount);
		}
		$this->set_customer($this->CI->Sale_suspended->get_customer($sale_id)->person_id);
	}
	
	function copy_entire_helded_sale($sale_id)
	{
		$this->empty_cart();
		$this->delete_customer();

		foreach($this->CI->Sale_helded->get_sale_items($sale_id)->result() as $row)
		{
			$this->add_item($row->item_id,$row->quantity_purchased,$row->discount_percent,$row->discount_amount,$row->item_unit_price,$row->description,$row->serialnumber);
		}
		foreach($this->CI->Sale_helded->get_sale_payments($sale_id)->result() as $row)
		{
			$this->add_payment($row->payment_type,$row->payment_amount);
		}
		$this->set_customer($this->CI->Sale_helded->get_customer($sale_id)->person_id);
	}

	function delete_item($line)
	{
		$items=$this->get_cart();
		unset($items[$line]);
		$this->set_cart($items);
	}

	function empty_cart()
	{
		$this->CI->session->unset_userdata('cart');
	}

	function delete_customer()
	{
		$this->CI->session->unset_userdata('customer');
	}

	function delete_payment_type()
	{
		$this->CI->session->unset_userdata('payment_type');
	}

	function clear_mode()
	{
		$this->CI->session->unset_userdata('sale_mode');
	}

	function clear_cart()
	{
		$this->CI->session->unset_userdata('return_payment_data');
		$this->empty_cart();
	}

	function clear_all()
	{
		$this->CI->session->unset_userdata('return_payment_data');
		$this->clear_mode();
		$this->empty_cart();
		//Alain Multiple Payments
		$this->empty_payments();
		$this->delete_payment_type();
		$this->delete_customer();
		/*Unset Tip Amount*/
		$this->clear_tips(); 
		/*Start Gravity Payment Gateway Changes*/
		/*Unset Gravity Payment Gateway External Transaction ID*/
		$this->clear_external_transaction_id();
		/*Unset Gravity Payment Gateway Transaction Reference ID*/
		$this->clear_gateway_transaction_reference();
		/*End Gravity Payment Gateway Changes*/
	}

	function get_taxes()
	{
		$customer_id = $this->get_customer();
		$customer = $this->CI->Customer->get_info($customer_id);

		//Do not charge sales tax if we have a customer that is not taxable
		if (!$customer->taxable and $customer_id!=-1)
		{
		   return array();
		}

		$taxes = array();
		foreach($this->get_cart() as $line=>$item)
		{
			$tax_info = $this->CI->Item_taxes->get_info($item['item_id']);

			foreach($tax_info as $tax)
			{
				$tax['name'] =  str_replace("%","&#37;",$tax['name']);
				$name = $tax['percent'].'% ' . $tax['name'];
				$tax_amount=(($item['price']*$item['quantity'])-($item['price']*$item['quantity']*$item['discount']/100)-($item['discount_amount']))*(($tax['percent'])/100);

				if (!isset($taxes[$name]))
				{
					$taxes[$name] = 0;
				}
				$taxes[$name] += $tax_amount;
			}
		}

		return $taxes;
	}

	function get_subtotal()
	{
		$subtotal = 0;
		foreach($this->get_cart() as $item)
		{
		    $subtotal+=(($item['price']*$item['quantity'])-($item['price']*$item['quantity']*$item['discount']/100)-($item['discount_amount']));
		}
		return to_currency_no_money($subtotal);
	}

	function get_total()
	{
		$total = 0;
		foreach($this->get_cart() as $item)
		{
            $total+=(($item['price']*$item['quantity'])-($item['price']*$item['quantity']*$item['discount']/100)-($item['discount_amount']));
		}

		$taxmode = $this->get_taxmode();
		if($taxmode != 2)
		{
			foreach($this->get_taxes() as $tax)
			{
				$total+=$tax;
			}
		}
		//return to_currency_no_money(round($total));
		return to_currency_no_money(($total));
	}
	
	/*Added By admin@wrkmash.com*/
	function get_empid()
	{
		if(!$this->CI->session->userdata('salesEmp'))
			$this->set_empid('salesEmp');

		return $this->CI->session->userdata('salesEmp');
	}
	
	function set_empid($mode)
	{
		$this->CI->session->set_userdata('salesEmp',$mode);
	}
	
	function set_salescomm($customer_id)
	{
		$this->CI->session->set_userdata('sales_comm',$customer_id);
	}
	
	function get_salescomm()
	{
		if(!$this->CI->session->userdata('sales_comm'))
			$this->set_salescomm(-1);

		return $this->CI->session->userdata('sales_comm');
	}
	
	function set_taxmode($mode)
	{
		$this->CI->session->set_userdata('tax_mode',$mode);
	}
	
	function get_taxmode()
	{
		if(!$this->CI->session->userdata('tax_mode'))
			$this->set_taxmode(-1);

		return $this->CI->session->userdata('tax_mode');
	}
	
	/*Start Tips*/ 
	//Set Tips
	function set_tips($tips)
	{
		$this->CI->session->set_userdata('tips',$tips);
	}
	
	//Get Tips
	function get_tips()
	{
		if(!$this->CI->session->userdata('tips'))
			$this->set_tips(-1);

		return $this->CI->session->userdata('tips');
	}
	
	//Unset Tips
	function clear_tips()
	{
		$this->CI->session->unset_userdata('tips');
	}
	
	/*Start Payment Device Changes*/ 
	//Set Payment Device External Transaction ID
	/*function set_external_transaction_id($external_transaction_id)
	{
		$this->CI->session->set_userdata('external_transaction_id',$external_transaction_id);
	}
	
	//Get Payment Device External Transaction ID
	function get_external_transaction_id()
	{
		if(!$this->CI->session->userdata('external_transaction_id'))
			$this->set_external_transaction_id(-1);

		return $this->CI->session->userdata('external_transaction_id');
	}
	
	//Unset Payment Device External Transaction ID
	function clear_external_transaction_id()
	{
		$this->CI->session->unset_userdata('external_transaction_id');
	}*/
	/*End Payment Device Changes*/ 
	
	/*Start Gravity Payment Gateway Changes*/ 
	//Set Gravity Payment Gateway External Transaction ID
	function set_external_transaction_id($external_transaction_id)
	{
		$this->CI->session->set_userdata('external_transaction_id',$external_transaction_id);
	}
	
	//Get Gravity Payment Gateway External Transaction ID
	function get_external_transaction_id()
	{
		if(!$this->CI->session->userdata('external_transaction_id'))
			$this->set_external_transaction_id(-1);

		return $this->CI->session->userdata('external_transaction_id');
	}
	
	//Unset Gravity Payment Gateway External Transaction ID
	function clear_external_transaction_id()
	{
		$this->CI->session->unset_userdata('external_transaction_id');
	}
	
	//Set Gravity Payment Gateway Transaction Reference
	function set_gateway_transaction_reference($gateway_transaction_reference)
	{
		$this->CI->session->set_userdata('gateway_transaction_reference',$gateway_transaction_reference);
	}
	
	//Get Gravity Payment Gateway External Transaction Reference
	function get_gateway_transaction_reference()
	{
		if(!$this->CI->session->userdata('gateway_transaction_reference'))
			$this->set_gateway_transaction_reference(-1);

		return $this->CI->session->userdata('gateway_transaction_reference');
	}
	
	//Unset Gravity Payment Gateway External Transaction Reference
	function clear_gateway_transaction_reference()
	{
		$this->CI->session->unset_userdata('gateway_transaction_reference');
	}
	/*End Gravity Payment Gateway Changes*/ 
	
	function drop_multiple_slashes($str)
	{
	  if(strpos($str,'//')!==false)
	  {
		 return $this->drop_multiple_slashes(str_replace('//','/',$str));
	  }
	  
	  if(strpos($str,'\\')!==false)
	  {
		 return $this->drop_multiple_slashes(str_replace('\\','',$str));
	  }
	  
	  return $str;
	}
	
	//Get Tips
	function get_sale_id()
	{
		if(!$this->CI->session->userdata('sale_id'))
			$this->set_sale_id(-1);

		return $this->CI->session->userdata('sale_id');
	}
	
	/*Start Tips*/ 
	//Set Tips
	function set_sale_id($sale_id)
	{
		$this->CI->session->set_userdata('sale_id',$sale_id);
	}
	//Unset Sale Id
	function empty_sale_id()
	{
		$this->CI->session->unset_userdata('sale_id');
	} 

	function runWPSitebuilderCurl($account_name,$action,$post)
	{

  	//define('SITEBUILDERDOMAIN', "https"."://"."sitebuilder.".$_SERVER['HTTP_HOST']);	 
	$url = "https"."://"."sitebuilder.".$_SERVER['HTTP_HOST']."?account_name=".$account_name."&wp_sitebuilder_direct_action=".$action;
	/*return $url;*/
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_URL,$url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post));
	$response = curl_exec($ch);
	$result = json_decode($response,true);
	curl_close($ch); // Close the connection	
	return $response;
	}

	public function payWithStripe($stripe_publishable_key,$stripe_secret_key,$stripeToken,$name,$email,$amount,$itemName,$orderNumber)
	{
		$custom_defined_root = $_SERVER['DOCUMENT_ROOT']."/zcp/source/"; 
		include($custom_defined_root."lib/PaymentsAPI/stripe_php_sdk/init.php");
		// echo $amount;
		// exit;
		//live keys
		// $stripe = array(
	    //   "secret_key"      => "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",
	    //   "publishable_key" => "pk_live_51MzAVvHN5knCLl33L4gB0VoRPTrfMVmQlUj20rIDfef5GBMUz8cM8ElO32xlI2vl3TM8CCzQmNdrZWbTZNIHlMbk00lz44ePRi"
	    // );  
		$stripe = array(
			"secret_key"      => $stripe_secret_key,
			"publishable_key" => $stripe_publishable_key
		  );  
		
	    \Stripe\Stripe::setApiKey($stripe['secret_key']);    
	    
		//add customer to stripe
	    $customer = \Stripe\Customer::create(array(
			'name' => $name,
			//'description' => 'test description',
	        'email' => $email,
	        'source'  => $stripeToken,
			// "address" => ["city" => $customerCity, "country" => $customerCountry, "line1" => $customerAddress, "line2" => "", "postal_code" => $customerZipcode, "state" => $customerState]
	    ));  


	    $payDetails = \Stripe\Charge::create(array(
	        'customer' => $customer->id,
	        'amount'   => $this->calculateRealNumber((int)$amount),
	        'currency' => 'USD',
	        'description' => $itemName,
	        'metadata' => array(
	            'order_id' => $orderNumber
	        )
	    ));  

	    return $payDetails;
	    // ['status']

		// return $subs->id;
	}


	public function returnWithStripe($stripe_publishable_key,$stripe_secret_key,$charge_id,$amount)
	{
		$custom_defined_root = $_SERVER['DOCUMENT_ROOT']."/zcp/source/"; 
		include($custom_defined_root."lib/PaymentsAPI/stripe_php_sdk/init.php");
		// echo $amount;
		// exit;
		//live keys
		// $stripe = array(
	    //   "secret_key"      => "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",
	    //   "publishable_key" => "pk_live_51MzAVvHN5knCLl33L4gB0VoRPTrfMVmQlUj20rIDfef5GBMUz8cM8ElO32xlI2vl3TM8CCzQmNdrZWbTZNIHlMbk00lz44ePRi"
	    // );  

	    $stripe = array(
			"secret_key"      => $stripe_secret_key,
			"publishable_key" => $stripe_publishable_key
		  );  


		\Stripe\Stripe::setApiKey($stripe['secret_key']);

		$error = 1;
		$msg = "";

		try {
		    // Replace 'ch_payment_id' with the actual charge/payment ID you want to refund
		    $charge = \Stripe\Refund::create([
		        'charge' => $charge_id,
        		'amount' => $this->calculateRealNumber((int)$amount)
		    ]);

		    // Check if the refund was successful
		    if ($charge->status === 'succeeded') 
		    {
		    	$error = 0;
		        $msg = "Refund was successful.";
		    } 
		    else 
		    {
		        $msg = "Refund failed.";
		    }
		} catch (\Stripe\Exception\InvalidRequestException $e) {
		    // Invalid parameters were supplied to Stripe's API
		    $msg = $e->getMessage();
		} catch (\Stripe\Exception\AuthenticationException $e) {
		    // Authentication with Stripe's API failed
		    $msg = $e->getMessage();
		} catch (\Stripe\Exception\ApiConnectionException $e) {
		    // Network communication with Stripe failed
		    $msg = $e->getMessage();
		} catch (\Stripe\Exception\ApiErrorException $e) {
		    // Stripe API returned an error
		    $msg = $e->getMessage();
		}

		return json_encode(['msg'=>$msg,'error'=>$error,'response'=>json_decode($charge,true)]);
	}

	public function calculateRealNumber($amount) {
	    return (($amount)*100);
	}
}
?>