<?php 
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

include 'FirstDataApi/FirstData.php';
use FirstDataApi\FirstData;


/*
|	Call it by doing this:
|
|		$this->load->library('my_payment');
|		$params->cc = '1293081309812039812039' ;//etc... you get the idea
|		
|		$result = $this->my_payment->authorize($params);
|		print_r($result); //response codes from authorize.net*/
 
class firstdata_payment {

	protected $fd_login = "";
	protected $fd_password = "";
	protected $fd_environment = "";
	
	public function __construct()
	{
		$CI =& get_instance();
		$CI->load->model('Gateways'); 
 		//print_r($CI->Gateways->get_default_gateway()->result());exit();
		$data['gateway_info']= $CI->Gateways->get_default_gateway();
  		foreach ($data['gateway_info']->result() as $gateways){
  			   	 
			  $this->fd_login = $gateways->MUinfo;
			  $this->fd_password = $gateways->MUkey;
			  $this->fd_environment = ($gateways->MUenvironment == "live")?false:true;
 							
 		}
	}
	
	public function PreAuthorize($params)
	{
		
		//include $params->POSROOT.'application/libraries/FirstDataApi/FirstData.php';
		//include $params->POSROOT.'application/libraries/FirstDataApi/fd_pre_auth.php';
		$firstData = new FirstData($this->fd_login, $this->fd_password, true);
		$data = array();
		/*$data['type'] = "Visa";
		$data['number'] = "4111111111111111";
		$data['name'] = "Muhammad Waseem";
		$data['exp'] = "0617";
		$data['amount'] = "100";
		$data['zip'] = "12345";
		$data['cvv'] = "234";
		$data['address'] = "New York";
		$orderId = time();*/
		$data['type'] = $params->type;
		$data['number'] = $params->number;
		$data['name'] = $params->name;
		$data['exp'] = $params->expiry;
		$data['amount'] = $params->amount;
		$data['zip'] = $params->zip;
		$data['cvv'] = $params->cvv;
		$data['address'] = $params->address;
		$orderId = time();
		
		// Charge
		$firstData->setTransactionType(FirstData::TRAN_PREAUTH);
		$firstData->setCreditCardType($data['type'])
				->setCreditCardNumber($data['number'])
				->setCreditCardName($data['name'])
				->setCreditCardExpiration($data['exp'])
				->setAmount($data['amount'])
				->setReferenceNumber($orderId);
		
		if(!empty($data['zip'])) {
			$firstData->setCreditCardZipCode($data['zip']);
		}
		
		if(!empty($data['cvv'])) {
			$firstData->setCreditCardVerification($data['cvv']);
		}
		
		if(!empty($data['address'])) {
			$firstData->setCreditCardAddress($data['address']);
		}
		
		$firstdata_process = $firstData->process();
		$firstdata_process = json_decode($firstdata_process);
		/*echo "<pre>";
		print_r($firstdata_process);
		echo "</pre>";*/
		// Check
		if($firstData->isError()) {
			// there was an error
			return "First Data Fail";
		} else {
			return "First Data Sucess";
			// transaction passed
		}

	}
	
	public function Purchase($params)
	{
		
		$firstData = new FirstData($this->fd_login, $this->fd_password, $this->fd_environment);
		$data = array();
		$data['type'] = $params->type;
		$data['number'] = $params->number;
		$data['name'] = $params->name;
		$data['exp'] = $params->expiry;
		$data['amount'] = $params->amount;
		$data['zip'] = $params->zip;
		$data['cvv'] = $params->cvv;
		$data['address'] = $params->address;
		$orderId = time();
		
		// Charge
		$firstData->setTransactionType(FirstData::TRAN_PURCHASE);
		$firstData->setCreditCardType($data['type'])
				->setCreditCardNumber($data['number'])
				->setCreditCardName($data['name'])
				->setCreditCardExpiration($data['exp'])
				->setAmount($data['amount'])
				->setReferenceNumber($orderId);
		
		if(!empty($data['zip'])) {
			$firstData->setCreditCardZipCode($data['zip']);
		}
		
		if(!empty($data['cvv'])) {
			$firstData->setCreditCardVerification($data['cvv']);
		}
		
		if(!empty($data['address'])) {
			$firstData->setCreditCardAddress($data['address']);
		}
		
		$firstdata_process = $firstData->process();
		/*$firstdata_process = json_decode($firstdata_process);
		echo "<pre>";
		print_r($firstdata_process);
		echo "</pre>";*/
		$responseArray = array();
		$responseArray['FD_Error'] = $firstData->isError();
		$responseArray['FD_Response'] = $firstdata_process;
		
		return $responseArray;
		// Check
		/*if($firstData->isError()) {
			// there was an error
			return "First Data Fail";
		} else {
			return "First Data Sucess";
			// transaction passed
		}*/

	}
	
	public function PurchaseWithTransArmorToken($params)
	{
		
		$firstData = new FirstData($this->fd_login, $this->fd_password, true);
		$data = array();
		$data['number'] = $params->number;
		$data['token'] = $params->token;
		$data['name'] = $params->name;
		$data['exp'] = $params->expiry;
		$data['amount'] = $params->amount;
		$orderId = time();
		
		// Charge
		$firstData->setTransactionType(FirstData::TRAN_PREAUTHCOMPLETE);
		$firstData->setCreditCardNumber($data['number'])
				->setTransArmorToken($data['token'])
				->setCreditCardName($data['name'])
				->setCreditCardExpiration($data['exp'])
				->setAmount($data['amount'])
				->setReferenceNumber($orderId);
		
		
		$firstdata_process = $firstData->process();
		$firstdata_process = json_decode($firstdata_process);
		/*echo "<pre>";
		print_r($firstdata_process);
		echo "</pre>";*/
		// Check
		if($firstData->isError()) {
			// there was an error
			return "First Data Fail";
		} else {
			return "First Data Sucess";
			// transaction passed
		}

	}
	
	public function PreAuthorizeComplete($params)
	{
		
		$firstData = new FirstData($this->fd_login, $this->fd_password, true);
		$data = array();
		$data['number'] = $params->number;
		$data['token'] = $params->token;
		$data['name'] = $params->name;
		$data['exp'] = $params->expiry;
		$data['auth_number'] = $params->auth_number;
		$data['amount'] = $params->amount;
		$orderId = time();
		
		// Charge
		$firstData->setTransactionType(FirstData::TRAN_PREAUTHCOMPLETE);
		$firstData->setCreditCardNumber($data['number'])
				->setTransArmorToken($data['token'])
				->setCreditCardName($data['name'])
				->setCreditCardExpiration($data['exp'])
				->setAuthNumber($dat['auth_number'])
				->setAmount($data['amount'])
				->setReferenceNumber($orderId);
		
		$firstdata_process = $firstData->process();
		$firstdata_process = json_decode($firstdata_process);
		/*echo "<pre>";
		print_r($firstdata_process);
		echo "</pre>";*/
		// Check
		if($firstData->isError()) {
			// there was an error
			return "First Data Fail";
		} else {
			return "First Data Sucess";
			// transaction passed
		}

	}
	
	public function Refund($params)
	{
		
		$firstData = new FirstData($this->fd_login, $this->fd_password, true);
		$data = array();
		$data['number'] = $params->number;
		$data['token'] = $params->token;
		$data['name'] = $params->name;
		$data['exp'] = $params->expiry;
		$data['amount'] = $params->amount;
		$orderId = time();
		
		// Charge
		$firstData->setTransactionType(FirstData::TRAN_REFUND);
		$firstData->setCreditCardNumber($data['number'])
				->setTransArmorToken($data['token'])
				->setCreditCardName($data['name'])
				->setCreditCardExpiration($data['exp'])
				->setAmount($data['amount'])
				->setReferenceNumber($orderId);
		
		$firstdata_process = $firstData->process();
		$firstdata_process = json_decode($firstdata_process);
		/*echo "<pre>";
		print_r($firstdata_process);
		echo "</pre>";*/
		// Check
		if($firstData->isError()) {
			// there was an error
			return "First Data Fail";
		} else {
			return "First Data Sucess";
			// transaction passed
		}

	}
	
	public function Void($params)
	{
		
		$firstData = new FirstData($this->fd_login, $this->fd_password, true);
		$data = array();
		$data['number'] = $params->number;
		$data['token'] = $params->token;
		$data['name'] = $params->name;
		$data['exp'] = $params->expiry;
		$data['amount'] = $params->amount;
		$orderId = time();
		
		// Charge
		$firstData->setTransactionType(FirstData::TRAN_VOID);
		$firstData->setCreditCardNumber($data['number'])
				->setTransArmorToken($data['token'])
				->setCreditCardName($data['name'])
				->setCreditCardExpiration($data['exp'])
				->setAmount($data['amount'])
				->setReferenceNumber($orderId);
		
		$firstdata_process = $firstData->process();
		$firstdata_process = json_decode($firstdata_process);
		/*echo "<pre>";
		print_r($firstdata_process);
		echo "</pre>";*/
		// Check
		if($firstData->isError()) {
			// there was an error
			return "First Data Fail";
		} else {
			return "First Data Sucess";
			// transaction passed
		}

	}
}
 