<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 
/**
 * Code Igniter
 *
 * An open source application development framework for PHP 4.3.2 or newer
 *
 * @package		CodeIgniter
 * @author		Rick Ellis
 * @copyright	Copyright (c) 2006, pMachine, Inc.
 * @license		http://www.codeignitor.com/user_guide/license.html
 * @link		http://www.codeigniter.com
 * @since		Version 1.0
 * @filesource
 */

// ------------------------------------------------------------------------

/**
 * PayPal_Lib Controller Class (Paypal IPN Class)
 *
 * This CI library is based on the Paypal PHP class by Micah Carrick
 * See www.micahcarrick.com for the most recent version of this class
 * along with any applicable sample files and other documentaion.
 *
 * This file provides a neat and simple method to interface with paypal and
 * The paypal Instant Payment Notification (IPN) interface.  This file is
 * NOT intended to make the paypal integration "plug 'n' play". It still
 * requires the developer (that should be you) to understand the paypal
 * process and know the variables you want/need to pass to paypal to
 * achieve what you want.  
 *
 * This class handles the submission of an order to paypal as well as the
 * processing an Instant Payment Notification.
 * This class enables you to mark points and calculate the time difference
 * between them.  Memory consumption can also be displayed.
 *
 * The class requires the use of the PayPal_Lib config file.
 *
 * @package     CodeIgniter
 * @subpackage  Libraries
 * @category    Commerce
 * @author      Ran Aroussi <ran@aroussi.com>
 * @copyright   Copyright (c) 2006, http://aroussi.com/ci/
 *
 */

// ------------------------------------------------------------------------

class Paypal_Lib {

	var $last_error;			// holds the last error encountered
	var $ipn_log;				// bool: log IPN results to text file?

	var $ipn_log_file;			// filename of the IPN log
	var $ipn_response;			// holds the IPN response from paypal	
	var $ipn_data = array();	// array contains the POST values for IPN
	var $fields = array();		// array holds the fields to submit to paypal

	var $submit_btn = '';		// Image/Form button
	var $button_path = '';		// The path of the buttons
	
	var $CI;
	
	function Paypal_Lib()
	{
		$this->CI =& get_instance();
		$this->CI->load->helper('url');
		$this->CI->load->helper('form');
		$this->CI->load->config('paypallib_config');
		
	// 	$this->paypal_url = 'https://www.paypal.com/cgi-bin/webscr';
		$this->paypal_url = 'https://www.sandbox.paypal.com/cgi-bin/webscr';

		$this->last_error = '';
		$this->ipn_response = '';

		$this->ipn_log_file = $this->CI->config->item('paypal_lib_ipn_log_file');
		$this->ipn_log = $this->CI->config->item('paypal_lib_ipn_log'); 
		
		$this->button_path = $this->CI->config->item('paypal_lib_button_path');
		
		// populate $fields array with a few default values.  See the paypal
		// documentation for a list of fields and their data types. These defaul
		// values can be overwritten by the calling script.
		$this->add_field('rm','2');			  // Return method = POST
		//$this->add_field('cmd','_xclick');
		$this->add_field('cmd','_xclick-subscriptions');

		$this->add_field('currency_code', $this->CI->config->item('paypal_lib_currency_code'));
	    $this->add_field('quantity', '1');
		$this->button('Pay Now!');
	}

	function button($value)
	{
		// changes the default caption of the submit button
		$this->submit_btn = form_submit('pp_submit', $value);
	}

	function image($file)
	{
		$this->submit_btn = '<input type="image" name="add" src="' . site_url($this->button_path .'/'. $file) . '" border="0" />';
	}


	function add_field($field, $value) 
	{
		// adds a key=>value pair to the fields array, which is what will be 
		// sent to paypal as POST variables.  If the value is already in the 
		// array, it will be overwritten.
		$this->fields[$field] = $value;
	}

	function paypal_auto_form() 
	{
		// this function actually generates an entire HTML page consisting of
		// a form with hidden elements which is submitted to paypal via the 
		// BODY element's onLoad attribute.  We do this so that you can validate
		// any POST vars from you custom form before submitting to paypal.  So 
		// basically, you'll have your own form which is submitted to your script
		// to validate the data, which in turn calls this function to create
		// another hidden form and submit to paypal.

		$this->button('Click here if you\'re not automatically redirected...');

		echo '<html>' . "\n";
		echo '<head><title>Processing Payment...</title></head>' . "\n";
		echo '<body onLoad="document.forms[\'paypal_auto_form\'].submit();">' . "\n";
		echo '<p>Please wait, your order is being processed and you will be redirected to the paypal website.</p>' . "\n";
		echo $this->paypal_form('paypal_auto_form');
		echo '</body></html>';
	}
	
	/*Paypal Recurring Start*/
	/**
	 * Send HTTP POST Request
	 *
	 * @param	string	The API method name
	 * @param	string	The POST Message fields in &name=value pair format
	 * @return	array	Parsed HTTP Response body
	 */
	function PPHttpPost($methodName_, $nvpStr_) {
		
		$environment = 'sandbox';	// or 'beta-sandbox' or 'live'
	
		$API_UserName = urlencode('waseem.ansari_api1.nerdsmith.com');
		$API_Password = urlencode('1373674510');
		$API_Signature = urlencode('Am4k0oK79ISuVCEh2m7mtji61Ej1Aym5k-CEW1vJ91CUl0egtjtbRLqP');
		
		/*$API_UserName = urlencode('aasemkhan_api1.yahoo.com');
		$API_Password = urlencode('6NPE5FFMKPG5EME7');
		$API_Signature = urlencode('AykD3WYX9sO0GU2FJjJZkQgna9lhAS2dOtqJwDXjDTliWm6-d9y4rY4.');*/
		
		
		$API_Endpoint = "https://api-3t.paypal.com/nvp";
		if("sandbox" === $environment || "beta-sandbox" === $environment) {
			$API_Endpoint = "https://api-3t.$environment.paypal.com/nvp";
		}
		$version = urlencode('94.0');
	
		// setting the curl parameters.
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $API_Endpoint);
		curl_setopt($ch, CURLOPT_VERBOSE, 1);
	
		// turning off the server and peer verification(TrustManager Concept).
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
	
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);
	
		// NVPRequest for submitting to server
		$nvpreq = "METHOD=$methodName_&VERSION=$version&PWD=$API_Password&USER=$API_UserName&SIGNATURE=$API_Signature$nvpStr_";
	
		// setting the nvpreq as POST FIELD to curl
		curl_setopt($ch, CURLOPT_POSTFIELDS, $nvpreq);
	
		// getting response from server
		$httpResponse = curl_exec($ch);
	
		if(!$httpResponse) {
			exit("$methodName_ failed: ".curl_error($ch).'('.curl_errno($ch).')');
		}
	
		// Extract the RefundTransaction response details
		$httpResponseAr = explode("&", $httpResponse);
	
		$httpParsedResponseAr = array();
		foreach ($httpResponseAr as $i => $value) {
			$tmpAr = explode("=", $value);
			if(sizeof($tmpAr) > 1) {
				$httpParsedResponseAr[$tmpAr[0]] = $tmpAr[1];
			}
		}
	
		if((0 == sizeof($httpParsedResponseAr)) || !array_key_exists('ACK', $httpParsedResponseAr)) {
			exit("Invalid HTTP Response for POST request($nvpreq) to $API_Endpoint.");
		}
	
		return $httpParsedResponseAr;
	}
	/*Paypal Recurring End*/

	function paypal_form($form_name='paypal_form') 
	{
		$str = '';
		$str .= '<form method="post" action="'.$this->paypal_url.'" name="'.$form_name.'"/>' . "\n";
		foreach ($this->fields as $name => $value)
			$str .= form_hidden($name, $value) . "\n";
		$str .= '<p>'. $this->submit_btn . '</p>';
		$str .= form_close() . "\n";

		return $str;
	}
	
	function paypal_ecommerceform($form_name='paypal_form') 
	{
		$str = '';
		//$str .= '<form method="post" action="'.$this->paypal_url.'" name="'.$form_name.'"/>' . "\n";
		foreach ($this->fields as $name => $value)
			$str .= form_hidden($name, $value) . "\n";
		//$str .= '<p>'. $this->submit_btn . '</p>';
		//$str .= form_close() . "\n";

		return $str;
	}
	
	function validate_ipn()
	{
		// parse the paypal URL
		$url_parsed = parse_url($this->paypal_url);		  

		// generate the post string from the _POST vars aswell as load the
		// _POST vars into an arry so we can play with them from the calling
		// script.
		$post_string = '';	 
		if ($this->CI->input->post())
		{
			foreach ($this->CI->input->post() as $field=>$value)
			{ 
				$this->ipn_data[$field] = $value;
				$post_string .= $field.'='.urlencode(stripslashes($value)).'&'; 
			}
		}
		
		$post_string.="cmd=_notify-validate"; // append ipn command

		// open the connection to paypal
		$fp = fsockopen($url_parsed['host'],"80",$err_num,$err_str,30); 
		if(!$fp)
		{
			// could not open the connection.  If loggin is on, the error message
			// will be in the log.
			$this->last_error = "fsockopen error no. $errnum: $errstr";
			$this->log_ipn_results(false);		 
			return false;
		} 
		else
		{ 
			// Post the data back to paypal
			fputs($fp, "POST $url_parsed[path] HTTP/1.1\r\n"); 
			fputs($fp, "Host: $url_parsed[host]\r\n"); 
			fputs($fp, "Content-type: application/x-www-form-urlencoded\r\n"); 
			fputs($fp, "Content-length: ".strlen($post_string)."\r\n"); 
			fputs($fp, "Connection: close\r\n\r\n"); 
			fputs($fp, $post_string . "\r\n\r\n"); 

			// loop through the response from the server and append to variable
			while(!feof($fp))
				$this->ipn_response .= fgets($fp, 1024); 

			fclose($fp); // close connection
		}

		if (eregi("VERIFIED",$this->ipn_response))
		{
			// Valid IPN transaction.
			$this->log_ipn_results(true);
			return true;		 
		} 
		else 
		{
			// Invalid IPN transaction.  Check the log for details.
			$this->last_error = 'IPN Validation Failed.';
			$this->log_ipn_results(false);	
			return false;
		}
	}

	function log_ipn_results($success) 
	{
		if (!$this->ipn_log) return;  // is logging turned off?

		// Timestamp
		$text = '['.date('m/d/Y g:i A').'] - '; 

		// Success or failure being logged?
		if ($success) $text .= "SUCCESS!\n";
		else $text .= 'FAIL: '.$this->last_error."\n";

		// Log the POST variables
		$text .= "IPN POST Vars from Paypal:\n";
		foreach ($this->ipn_data as $key=>$value)
			$text .= "$key=$value, ";

		// Log the response from the paypal server
		$text .= "\nIPN Response from Paypal Server:\n ".$this->ipn_response;

		// Write to log
		$fp=fopen($this->ipn_log_file,'a');
		fwrite($fp, $text . "\n\n"); 

		fclose($fp);  // close file
	}


	function dump() 
	{
		// Used for debugging, this function will output all the field/value pairs
		// that are currently defined in the instance of the class using the
		// add_field() function.

		ksort($this->fields);
		echo '<h2>ppal->dump() Output:</h2>' . "\n";
		echo '<code style="font: 12px Monaco, \'Courier New\', Verdana, Sans-serif;  background: #f9f9f9; border: 1px solid #D0D0D0; color: #002166; display: block; margin: 14px 0; padding: 12px 10px;">' . "\n";
		foreach ($this->fields as $key => $value) echo '<strong>'. $key .'</strong>:	'. urldecode($value) .'<br/>';
		echo "</code>\n";
	}
	
	function Dbcreation_back() //(23-01-2013) 
	{
		/***** 
		Developed By Afshan Mukhtar
		admin@wrkmash.com
		**************************/
		$prefix="";
		$path1="";
	//	$db_name=$_SESSION['username'];        //-----TO be Edited-----------//
	
	    $db_name= str_replace(" " , "_" ,$_SESSION['username']);   
		
		$cpanel_user = "oposlive";
		//$cpanel_user = "oposlive";
		// cPanel password (you use to login to cPanel)
		$cpanel_password = "+W3gIe?9=.mZ";
		//$cpanel_password = "onlin3p0$";
		// cPanel domain (example: mysite.com)
		
		$S=$_SESSION['username'];               //-----TO be Edited-----------//
		$P=$_SESSION['password'];                //-----TO be Edited-----------//
		$H="localhost";         //-----TO be Edited-----------//
		$U=$cpanel_user;        //-----TO be Edited-----------//
		$P=$cpanel_password;              //-----TO be Edited-----------//
		//$U="EMPDB_USERNAME";        //-----TO be Edited-----------//
		//$P="EMPDB_PASSWORD";              //-----TO be Edited-----------//
		
		$string=$_SERVER['SERVER_NAME']; 
		
		 if (preg_match("/dev/", $string))
		 {
		$prefix="dev";
		$path="oposdev";
		 }
		 
		 elseif (preg_match("/test/", $string))
		 {
		$prefix="test";
		$path="opostest";
		 }
		 else
		 {
			 $prefix="oposlive";
			 $path="oposlive";
		 }
		
		
		
		$D=$prefix."_".$db_name; //-----TO be Edited-----------//
		$db = $prefix."_".$db_name;
		
		$dir ='/home/'.$path.'/public_html/app/application/config';
		$dir1=$dir."/".$db_name.".php" ;         //-----TO be Edited as per FILE NAME REQUIRED-----------//
		
		//////////////////////////////////////
		/* Code below should not be changed */
		//////////////////////////////////////
		$host = 'localhost';  //-----TO be Edited-----------//
		$user =$cpanel_user;    //-----TO be Edited-----------//
		$pass = $cpanel_password;    //-----TO be Edited-----------//
		//////=====================CREATED DB NAME SHD BE HERE
		
		
		$dbh2 =mysql_connect($host,$user,$pass) or  die(mysql_error());
		
		
		$CU=" create database ".$db;
		if (mysql_query($CU,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		
		
		
		
		mysql_select_db($db,$dbh2) or die('error database selection');
		//======================================================//
		 
		
		
		/*--
		-- Table structure for table `admin`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `admin` (
		  `userid` int(11) NOT NULL AUTO_INCREMENT,
		  `user_name` varchar(255) DEFAULT NULL,
		  `password` varchar(255) DEFAULT NULL,
		  PRIMARY KEY (`userid`)
		) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;";
		
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*
		--
		-- Table structure for table `ost_api_key`
		--*/
		
		$tab = "CREATE TABLE IF NOT EXISTS `ost_api_key` (
		  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
		  `isactive` tinyint(1) NOT NULL DEFAULT '1',
		  `ipaddr` varchar(16) NOT NULL,
		  `apikey` varchar(255) NOT NULL,
		  `updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		   PRIMARY KEY (`id`),
		   UNIQUE KEY `ipaddr` (`ipaddr`)
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2;";
		
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*--
		-- Table structure for table `ost_config`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `ost_config` (
		  `id` tinyint(1) unsigned NOT NULL AUTO_INCREMENT,
		  `isonline` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `timezone_offset` float(3,1) NOT NULL DEFAULT '0.0',
		  `enable_daylight_saving` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `staff_ip_binding` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `staff_max_logins` tinyint(3) unsigned NOT NULL DEFAULT '4',
		  `staff_login_timeout` int(10) unsigned NOT NULL DEFAULT '2',
		  `staff_session_timeout` int(10) unsigned NOT NULL DEFAULT '30',
		  `client_max_logins` tinyint(3) unsigned NOT NULL DEFAULT '4',
		  `client_login_timeout` int(10) unsigned NOT NULL DEFAULT '2',
		  `client_session_timeout` int(10) unsigned NOT NULL DEFAULT '30',
		  `max_page_size` tinyint(3) unsigned NOT NULL DEFAULT '25',
		  `max_open_tickets` tinyint(3) unsigned NOT NULL DEFAULT '0',
		  `max_file_size` int(11) unsigned NOT NULL DEFAULT '1048576',
		  `autolock_minutes` tinyint(3) unsigned NOT NULL DEFAULT '3',
		  `overdue_grace_period` int(10) unsigned NOT NULL DEFAULT '0',
		  `alert_email_id` tinyint(4) unsigned NOT NULL DEFAULT '0',
		  `default_email_id` tinyint(4) unsigned NOT NULL DEFAULT '0',
		  `default_dept_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
		  `default_priority_id` tinyint(2) unsigned NOT NULL DEFAULT '2',
		  `default_template_id` tinyint(4) unsigned NOT NULL DEFAULT '1',
		  `default_smtp_id` tinyint(4) unsigned NOT NULL DEFAULT '0',
		  `spoof_default_smtp` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `clickable_urls` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `allow_priority_change` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `use_email_priority` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `enable_captcha` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `enable_auto_cron` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `enable_mail_fetch` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `enable_email_piping` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `send_sql_errors` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `send_mailparse_errors` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `send_login_errors` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `save_email_headers` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `strip_quoted_reply` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `log_ticket_activity` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `ticket_autoresponder` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `message_autoresponder` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `ticket_notice_active` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `ticket_alert_active` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `ticket_alert_admin` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `ticket_alert_dept_manager` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `ticket_alert_dept_members` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `message_alert_active` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `message_alert_laststaff` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `message_alert_assigned` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `message_alert_dept_manager` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `note_alert_active` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `note_alert_laststaff` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `note_alert_assigned` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `note_alert_dept_manager` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `overdue_alert_active` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `overdue_alert_assigned` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `overdue_alert_dept_manager` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `overdue_alert_dept_members` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `auto_assign_reopened_tickets` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `show_assigned_tickets` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `show_answered_tickets` tinyint(1) NOT NULL DEFAULT '0',
		  `hide_staff_name` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `overlimit_notice_active` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `email_attachments` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `allow_attachments` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `allow_email_attachments` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `allow_online_attachments` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `allow_online_attachments_onlogin` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `random_ticket_ids` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `log_level` tinyint(1) unsigned NOT NULL DEFAULT '2',
		  `log_graceperiod` int(10) unsigned NOT NULL DEFAULT '12',
		  `upload_dir` varchar(255) NOT NULL DEFAULT '',
		  `allowed_filetypes` varchar(255) NOT NULL DEFAULT '.doc, .pdf',
		  `time_format` varchar(32) NOT NULL DEFAULT ' h:i A',
		  `date_format` varchar(32) NOT NULL DEFAULT 'm/d/Y',
		  `datetime_format` varchar(60) NOT NULL DEFAULT 'm/d/Y g:i a',
		  `daydatetime_format` varchar(60) NOT NULL DEFAULT 'D, M j Y g:ia',
		  `reply_separator` varchar(60) NOT NULL DEFAULT '-- do not edit --',
		  `admin_email` varchar(125) NOT NULL DEFAULT '',
		  `helpdesk_title` varchar(255) NOT NULL DEFAULT 'osTicket Support Ticket System',
		  `helpdesk_url` varchar(255) NOT NULL DEFAULT '',
		  `api_passphrase` varchar(125) NOT NULL DEFAULT '',
		  `ostversion` varchar(16) NOT NULL DEFAULT '',
		  `updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
		  PRIMARY KEY (`id`),
		  KEY `isoffline` (`isonline`)
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;";
		
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*
		--
		-- Table structure for table `ost_department`
		--
		*/
		$tab="CREATE TABLE IF NOT EXISTS `ost_department` (
		  `dept_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
		  `tpl_id` int(10) unsigned NOT NULL DEFAULT '0',
		  `email_id` int(10) unsigned NOT NULL DEFAULT '0',
		  `autoresp_email_id` int(10) unsigned NOT NULL DEFAULT '0',
		  `manager_id` int(10) unsigned NOT NULL DEFAULT '0',
		  `dept_name` varchar(32) NOT NULL DEFAULT '',
		  `dept_signature` tinytext NOT NULL,
		  `ispublic` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `ticket_auto_response` tinyint(1) NOT NULL DEFAULT '1',
		  `message_auto_response` tinyint(1) NOT NULL DEFAULT '0',
		  `can_append_signature` tinyint(1) NOT NULL DEFAULT '1',
		  `updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  PRIMARY KEY (`dept_id`),
		  UNIQUE KEY `dept_name` (`dept_name`),
		  KEY `manager_id` (`manager_id`),
		  KEY `autoresp_email_id` (`autoresp_email_id`),
		  KEY `tpl_id` (`tpl_id`)
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;";
		
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*
		--
		-- Table structure for table `ost_email`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `ost_email` (
		  `email_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
		  `noautoresp` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `priority_id` tinyint(3) unsigned NOT NULL DEFAULT '2',
		  `dept_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
		  `email` varchar(125) NOT NULL DEFAULT '',
		  `name` varchar(32) NOT NULL DEFAULT '',
		  `userid` varchar(125) NOT NULL,
		  `userpass` varchar(125) NOT NULL,
		  `mail_active` tinyint(1) NOT NULL DEFAULT '0',
		  `mail_host` varchar(125) NOT NULL,
		  `mail_protocol` enum('POP','IMAP') NOT NULL DEFAULT 'POP',
		  `mail_encryption` enum('NONE','SSL') NOT NULL,
		  `mail_port` int(6) DEFAULT NULL,
		  `mail_fetchfreq` tinyint(3) NOT NULL DEFAULT '5',
		  `mail_fetchmax` tinyint(4) NOT NULL DEFAULT '30',
		  `mail_delete` tinyint(1) NOT NULL DEFAULT '0',
		  `mail_errors` tinyint(3) NOT NULL DEFAULT '0',
		  `mail_lasterror` datetime DEFAULT NULL,
		  `mail_lastfetch` datetime DEFAULT NULL,
		  `smtp_active` tinyint(1) DEFAULT '0',
		  `smtp_host` varchar(125) NOT NULL,
		  `smtp_port` int(6) DEFAULT NULL,
		  `smtp_secure` tinyint(1) NOT NULL DEFAULT '1',
		  `smtp_auth` tinyint(1) NOT NULL DEFAULT '1',
		  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  `updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  PRIMARY KEY (`email_id`),
		  UNIQUE KEY `email` (`email`),
		  KEY `priority_id` (`priority_id`),
		  KEY `dept_id` (`dept_id`)
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;";
		
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*--
		-- Table structure for table `ost_email_banlist`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `ost_email_banlist` (
		  `id` int(11) NOT NULL AUTO_INCREMENT,
		  `email` varchar(255) NOT NULL DEFAULT '',
		  `submitter` varchar(126) NOT NULL DEFAULT '',
		  `added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  PRIMARY KEY (`id`),
		  UNIQUE KEY `email` (`email`)
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;";
		
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*--
		-- Table structure for table `ost_email_template`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `ost_email_template` (
		  `tpl_id` int(11) NOT NULL AUTO_INCREMENT,
		  `cfg_id` int(10) unsigned NOT NULL DEFAULT '0',
		  `name` varchar(32) NOT NULL DEFAULT '',
		  `notes` text,
		  `ticket_autoresp_subj` varchar(255) NOT NULL DEFAULT '',
		  `ticket_autoresp_body` text NOT NULL,
		  `ticket_notice_subj` varchar(255) NOT NULL,
		  `ticket_notice_body` text NOT NULL,
		  `ticket_alert_subj` varchar(255) NOT NULL DEFAULT '',
		  `ticket_alert_body` text NOT NULL,
		  `message_autoresp_subj` varchar(255) NOT NULL DEFAULT '',
		  `message_autoresp_body` text NOT NULL,
		  `message_alert_subj` varchar(255) NOT NULL DEFAULT '',
		  `message_alert_body` text NOT NULL,
		  `note_alert_subj` varchar(255) NOT NULL,
		  `note_alert_body` text NOT NULL,
		  `assigned_alert_subj` varchar(255) NOT NULL DEFAULT '',
		  `assigned_alert_body` text NOT NULL,
		  `ticket_overdue_subj` varchar(255) NOT NULL DEFAULT '',
		  `ticket_overdue_body` text NOT NULL,
		  `ticket_overlimit_subj` varchar(255) NOT NULL DEFAULT '',
		  `ticket_overlimit_body` text NOT NULL,
		  `ticket_reply_subj` varchar(255) NOT NULL DEFAULT '',
		  `ticket_reply_body` text NOT NULL,
		  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  `updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  PRIMARY KEY (`tpl_id`),
		  KEY `cfg_id` (`cfg_id`),
		  FULLTEXT KEY `message_subj` (`ticket_reply_subj`)
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;";
		
		
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*
		--
		-- Table structure for table `ost_groups`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `ost_groups` (
		  `group_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
		  `group_enabled` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `group_name` varchar(50) NOT NULL DEFAULT '',
		  `dept_access` varchar(255) NOT NULL DEFAULT '',
		  `can_create_tickets` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `can_edit_tickets` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `can_delete_tickets` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `can_close_tickets` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `can_transfer_tickets` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `can_ban_emails` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `can_manage_kb` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  `updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  PRIMARY KEY (`group_id`),
		  KEY `group_active` (`group_enabled`)
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*--
		-- Table structure for table `ost_help_topic`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `ost_help_topic` (
		  `topic_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
		  `isactive` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `noautoresp` tinyint(3) unsigned NOT NULL DEFAULT '0',
		  `priority_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
		  `dept_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
		  `topic` varchar(32) NOT NULL DEFAULT '',
		  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  `updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  PRIMARY KEY (`topic_id`),
		  UNIQUE KEY `topic` (`topic`),
		  KEY `priority_id` (`priority_id`),
		  KEY `dept_id` (`dept_id`)
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;";
		
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*
		--
		-- Table structure for table `ost_kb_premade`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `ost_kb_premade` (
		  `premade_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
		  `dept_id` int(10) unsigned NOT NULL DEFAULT '0',
		  `isenabled` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `title` varchar(125) NOT NULL DEFAULT '',
		  `answer` text NOT NULL,
		  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  `updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  PRIMARY KEY (`premade_id`),
		  UNIQUE KEY `title_2` (`title`),
		  KEY `dept_id` (`dept_id`),
		  KEY `active` (`isenabled`),
		  FULLTEXT KEY `title` (`title`,`answer`)
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*
		--
		-- Table structure for table `ost_staff`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `ost_staff` (
		  `staff_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
		  `group_id` int(10) unsigned NOT NULL DEFAULT '0',
		  `dept_id` int(10) unsigned NOT NULL DEFAULT '0',
		  `username` varchar(32) NOT NULL DEFAULT '',
		  `firstname` varchar(32) DEFAULT NULL,
		  `lastname` varchar(32) DEFAULT NULL,
		  `passwd` varchar(128) DEFAULT NULL,
		  `email` varchar(128) DEFAULT NULL,
		  `phone` varchar(24) NOT NULL DEFAULT '',
		  `phone_ext` varchar(6) DEFAULT NULL,
		  `mobile` varchar(24) NOT NULL DEFAULT '',
		  `signature` tinytext NOT NULL,
		  `isactive` tinyint(1) NOT NULL DEFAULT '1',
		  `isadmin` tinyint(1) NOT NULL DEFAULT '0',
		  `isvisible` tinyint(1) unsigned NOT NULL DEFAULT '1',
		  `onvacation` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `daylight_saving` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `append_signature` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `change_passwd` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `timezone_offset` float(3,1) NOT NULL DEFAULT '0.0',
		  `max_page_size` int(11) unsigned NOT NULL DEFAULT '0',
		  `auto_refresh_rate` int(10) unsigned NOT NULL DEFAULT '0',
		  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  `lastlogin` datetime DEFAULT NULL,
		  `updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  PRIMARY KEY (`staff_id`),
		  UNIQUE KEY `username` (`username`),
		  KEY `dept_id` (`dept_id`),
		  KEY `issuperuser` (`isadmin`),
		  KEY `group_id` (`group_id`,`staff_id`)
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;";
		
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*
		--
		-- Table structure for table `ost_syslog`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `ost_syslog` (
		  `log_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
		  `log_type` enum('Debug','Warning','Error') NOT NULL,
		  `title` varchar(255) NOT NULL,
		  `log` text NOT NULL,
		  `logger` varchar(64) NOT NULL,
		  `ip_address` varchar(16) NOT NULL,
		  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  `updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  PRIMARY KEY (`log_id`),
		  KEY `log_type` (`log_type`)
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=14 ;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*--
		-- Table structure for table `ost_ticket`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `ost_ticket` (
		  `ticket_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
		  `ticketID` int(11) unsigned NOT NULL DEFAULT '0',
		  `dept_id` int(10) unsigned NOT NULL DEFAULT '1',
		  `priority_id` int(10) unsigned NOT NULL DEFAULT '2',
		  `topic_id` int(10) unsigned NOT NULL DEFAULT '0',
		  `staff_id` int(10) unsigned NOT NULL DEFAULT '0',
		  `email` varchar(120) NOT NULL DEFAULT '',
		  `name` varchar(32) NOT NULL DEFAULT '',
		  `subject` varchar(64) NOT NULL DEFAULT '[no subject]',
		  `helptopic` varchar(255) DEFAULT NULL,
		  `phone` varchar(16) DEFAULT NULL,
		  `phone_ext` varchar(8) DEFAULT NULL,
		  `ip_address` varchar(16) NOT NULL DEFAULT '',
		  `status` enum('open','closed') NOT NULL DEFAULT 'open',
		  `source` enum('Web','Email','Phone','Other') NOT NULL DEFAULT 'Other',
		  `isoverdue` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `isanswered` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `duedate` datetime DEFAULT NULL,
		  `reopened` datetime DEFAULT NULL,
		  `closed` datetime DEFAULT NULL,
		  `lastmessage` datetime DEFAULT NULL,
		  `lastresponse` datetime DEFAULT NULL,
		  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  `updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  PRIMARY KEY (`ticket_id`),
		  UNIQUE KEY `email_extid` (`ticketID`,`email`),
		  KEY `dept_id` (`dept_id`),
		  KEY `staff_id` (`staff_id`),
		  KEY `status` (`status`),
		  KEY `priority_id` (`priority_id`),
		  KEY `created` (`created`),
		  KEY `closed` (`closed`),
		  KEY `duedate` (`duedate`),
		  KEY `topic_id` (`topic_id`)
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;";
		
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*--
		-- Table structure for table `ost_ticket_attachment`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `ost_ticket_attachment` (
		  `attach_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
		  `ticket_id` int(11) unsigned NOT NULL DEFAULT '0',
		  `ref_id` int(11) unsigned NOT NULL DEFAULT '0',
		  `ref_type` enum('M','R') NOT NULL DEFAULT 'M',
		  `file_size` varchar(32) NOT NULL DEFAULT '',
		  `file_name` varchar(128) NOT NULL DEFAULT '',
		  `file_key` varchar(128) NOT NULL DEFAULT '',
		  `deleted` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  `updated` datetime DEFAULT NULL,
		  PRIMARY KEY (`attach_id`),
		  KEY `ticket_id` (`ticket_id`),
		  KEY `ref_type` (`ref_type`),
		  KEY `ref_id` (`ref_id`)
		) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*--
		-- Table structure for table `ost_ticket_lock`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `ost_ticket_lock` (
		  `lock_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
		  `ticket_id` int(11) unsigned NOT NULL DEFAULT '0',
		  `staff_id` int(10) unsigned NOT NULL DEFAULT '0',
		  `expire` datetime DEFAULT NULL,
		  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  PRIMARY KEY (`lock_id`),
		  UNIQUE KEY `ticket_id` (`ticket_id`),
		  KEY `staff_id` (`staff_id`)
		) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*
		--
		-- Table structure for table `ost_ticket_message`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `ost_ticket_message` (
		  `msg_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
		  `ticket_id` int(11) unsigned NOT NULL DEFAULT '0',
		  `messageId` varchar(255) DEFAULT NULL,
		  `message` text NOT NULL,
		  `headers` text,
		  `source` varchar(16) DEFAULT NULL,
		  `ip_address` varchar(16) DEFAULT NULL,
		  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  `updated` datetime DEFAULT NULL,
		  PRIMARY KEY (`msg_id`),
		  KEY `ticket_id` (`ticket_id`),
		  KEY `msgId` (`messageId`),
		  FULLTEXT KEY `message` (`message`)
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*--
		-- Table structure for table `ost_ticket_note`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `ost_ticket_note` (
		  `note_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
		  `ticket_id` int(11) unsigned NOT NULL DEFAULT '0',
		  `staff_id` int(10) unsigned NOT NULL DEFAULT '0',
		  `source` varchar(32) NOT NULL DEFAULT '',
		  `title` varchar(255) NOT NULL DEFAULT 'Generic Intermal Notes',
		  `note` text NOT NULL,
		  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  PRIMARY KEY (`note_id`),
		  KEY `ticket_id` (`ticket_id`),
		  KEY `staff_id` (`staff_id`),
		  FULLTEXT KEY `note` (`note`)
		) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*--
		-- Table structure for table `ost_ticket_priority`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `ost_ticket_priority` (
		  `priority_id` tinyint(4) NOT NULL AUTO_INCREMENT,
		  `priority` varchar(60) NOT NULL DEFAULT '',
		  `priority_desc` varchar(30) NOT NULL DEFAULT '',
		  `priority_color` varchar(7) NOT NULL DEFAULT '',
		  `priority_urgency` tinyint(1) unsigned NOT NULL DEFAULT '0',
		  `ispublic` tinyint(1) NOT NULL DEFAULT '1',
		  PRIMARY KEY (`priority_id`),
		  UNIQUE KEY `priority` (`priority`),
		  KEY `priority_urgency` (`priority_urgency`),
		  KEY `ispublic` (`ispublic`)
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*--
		-- Table structure for table `ost_ticket_response`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `ost_ticket_response` (
		  `response_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
		  `msg_id` int(11) unsigned NOT NULL DEFAULT '0',
		  `ticket_id` int(11) unsigned NOT NULL DEFAULT '0',
		  `staff_id` int(11) unsigned NOT NULL DEFAULT '0',
		  `staff_name` varchar(32) NOT NULL DEFAULT '',
		  `response` text NOT NULL,
		  `ip_address` varchar(16) NOT NULL DEFAULT '',
		  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  `updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
		  PRIMARY KEY (`response_id`),
		  KEY `ticket_id` (`ticket_id`),
		  KEY `msg_id` (`msg_id`),
		  KEY `staff_id` (`staff_id`),
		  FULLTEXT KEY `response` (`response`)
		) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		
		/*
		--
		-- Table structure for table `ost_timezone`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `ost_timezone` (
		  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
		  `offset` float(3,1) NOT NULL DEFAULT '0.0',
		  `timezone` varchar(255) NOT NULL DEFAULT '',
		  PRIMARY KEY (`id`)
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=31 ;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		  
		/*
		--Table structure for table `phppos_app_config`
		-- 
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `phppos_app_config` (
		  `key` varchar(255) NOT NULL,
		  `value` varchar(255) NOT NULL,
		  PRIMARY KEY (`key`)
		) ENGINE=MyISAM DEFAULT CHARSET=latin1;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		  
		/*--
		-- Inserting data into `phppos_app_config`
		--*/	  
		  
		$tab="INSERT INTO `phppos_app_config` (`key`, `value`) VALUES
		('address', '".$_SESSION['person_data']['address_1']."'),
		('company', '".$_SESSION['employee_data']['username']."'),
		('default_tax_1_name', 'Sales Tax'),
		('default_tax_1_rate', ''),
		('default_tax_2_name', 'Sales Tax 2'),
		('default_tax_2_rate', ''),
		('default_tax_rate', '8'),
		('email', '".$_SESSION['person_data']['email']."'),
		('fax', ''),
		('language', 'english'),
		('phone', '555-555-5555'),
		('print_after_sale', '0'),
		('return_policy', 'Test'),
		('timezone', 'America/Los_Angeles'),
		('version', '10.0'),
		('freports', '0'),
		('website', '');";
		if (mysql_query($tab,$dbh2))
		  {
		 // //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }  
		  
		/*--
		-- Table structure for table `phppos_clients`
		--
		*/
		$tab="CREATE TABLE IF NOT EXISTS `phppos_clients` (
		  `username` varchar(255) NOT NULL,
		  `password` varchar(255) NOT NULL,
		  `person_id` int(10) NOT NULL,
		  `deleted` int(1) NOT NULL DEFAULT '0',
		  UNIQUE KEY `username` (`username`),
		  KEY `person_id` (`person_id`)
		) ENGINE=MyISAM DEFAULT CHARSET=latin1;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		  
		/*--
		-- Table structure for table `phppos_customers`
		--
		*/
		$tab="CREATE TABLE IF NOT EXISTS `phppos_customers` (
		  `person_id` int(10) NOT NULL,
		  `account_number` varchar(255) DEFAULT NULL,
		  `taxable` int(1) NOT NULL DEFAULT '1',
		  `deleted` int(1) NOT NULL DEFAULT '0',
		  UNIQUE KEY `account_number` (`account_number`),
		  KEY `person_id` (`person_id`)
		) ENGINE=MyISAM DEFAULT CHARSET=latin1;";
		
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*
		--
		-- Table structure for table `phppos_employees`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `phppos_employees` (
		  `username` varchar(255) NOT NULL,
		  `password` varchar(255) NOT NULL,
		  `person_id` int(10) NOT NULL,
		  `stores` varchar(255) NOT NULL,
		  `deleted` int(1) NOT NULL DEFAULT '0',
		  `subcribe` int(11) NOT NULL,
		  `id` int(11) NOT NULL AUTO_INCREMENT,
		  PRIMARY KEY (`id`),
		  KEY `person_id` (`person_id`),
		  KEY `username` (`username`)
		) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=121 ;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		
		/*--
		--Query to insert data into phppos_employees table 
		--
		*/
		$dbh2 = mysql_connect($host,$user,$pass) or die(mysql_error());
		//mysql_select_db(DB, $dbh2)  or die(mysql_error());
		
		$CU="INSERT INTO `phppos_employees` (
		`username` ,
		`password` ,
		`person_id` ,
		`deleted` 
		)
		VALUES (
		'".$_SESSION['employee_data']['username']."', '".$_SESSION['employee_data']['password']."', '1', '0'
		);";
		
		if (mysql_query($CU,$dbh2))
		  {
		  ////echo "QUEYR EXECUTED";
		  }
		else
		  {
		  //echo "Error creating database: " . mysql_error();
		  }
		  
		/*--
		-- Table structure for table `phppos_emp_timelog`
		--
		*/  
		  
		$tab="CREATE TABLE IF NOT EXISTS `phppos_emp_timelog` (
		  `id` int(11) NOT NULL AUTO_INCREMENT,
		  `eid` int(11) DEFAULT NULL,
		  `jid` int(11) DEFAULT NULL,
		  `login` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		  `logout` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
		  `salary` decimal(12,2) DEFAULT '0.00',
		  PRIMARY KEY (`id`),
		  KEY `eid_idx` (`eid`)
		) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;";
		
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }    
		 
		/*--
		-- Table structure for table `phppos_gateways`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `phppos_gateways` (
		  `gateway_id` int(11) NOT NULL AUTO_INCREMENT,
		  `gateways_name` varchar(255) NOT NULL,
		  `MUinfo` varchar(255) NOT NULL,
		  `MUkey` varchar(255) NOT NULL,
		  `enable` int(255) NOT NULL,
		  `description` varchar(255) NOT NULL,
		  `default` int(11) NOT NULL,
		  `signature` varchar(255) DEFAULT NULL,
		  PRIMARY KEY (`gateway_id`)
		) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=5 ;";
		
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		  
		 /*--
		-- Insert data into table `phppos_gateways`
		--*/
		 
		  $tab="INSERT INTO `phppos_gateways` (`gateway_id`, `gateways_name`, `MUinfo`, `MUkey`, `enable`, `description`, `default`, `signature`) 
		  VALUES
			(2, 'Authorize', '0', '0', 0, '0', 0, '0'),
			(1, 'paypal', 'sadaf7_1322613389_biz_api1.yahoo.com', '1322613447', 1, 'test account information', 1, 'A2bAiVfoSnT9Tjsf8h7Kb98I7ac5AECgqoB7STMeCUrtWdZZFLIxO7WY '),
			(3, 'linkpoint', 'lkuser', '', 0, '0', 0, '0'),
			(4, 'ipay', 'ipuser', '', 1, '0', 0, '');";
		
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  } 
		  
		/*--
		-- Table structure for table `phppos_giftcards`
		--
		*/
		$tab="CREATE TABLE IF NOT EXISTS `phppos_giftcards` (
		  `giftcard_id` int(11) NOT NULL AUTO_INCREMENT,
		  `giftcard_number` varchar(25) COLLATE utf8_unicode_ci NOT NULL,
		  `value` double(15,2) NOT NULL,
		  `deleted` int(1) NOT NULL DEFAULT '0',
		  PRIMARY KEY (`giftcard_id`),
		  UNIQUE KEY `giftcard_number` (`giftcard_number`)
		) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*
		--
		-- Table structure for table `phppos_inventory`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `phppos_inventory` (
		  `trans_id` int(11) NOT NULL AUTO_INCREMENT,
		  `trans_items` int(11) NOT NULL DEFAULT '0',
		  `trans_user` int(11) NOT NULL DEFAULT '0',
		  `trans_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
		  `trans_comment` text NOT NULL,
		  `trans_inventory` int(11) NOT NULL DEFAULT '0',
		  `trans_price` int(11) NOT NULL,
		  PRIMARY KEY (`trans_id`),
		  KEY `phppos_inventory_ibfk_1` (`trans_items`),
		  KEY `phppos_inventory_ibfk_2` (`trans_user`)
		) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=20 ;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*--
		-- Table structure for table `phppos_items`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `phppos_items` (
		  `name` varchar(255) NOT NULL,
		  `category` varchar(255) NOT NULL,
		  `supplier_id` int(11) DEFAULT NULL,
		  `item_number` varchar(255) DEFAULT NULL,
		  `description` varchar(255) NOT NULL,
		  `cost_price` double(15,2) NOT NULL,
		  `unit_price` double(15,2) NOT NULL,
		  `quantity` double(15,2) NOT NULL DEFAULT '0.00',
		  `reorder_level` double(15,2) NOT NULL DEFAULT '0.00',
		  `item_id` int(10) NOT NULL AUTO_INCREMENT,
		  `allow_alt_description` tinyint(1) NOT NULL,
		  `is_serialized` tinyint(1) NOT NULL,
		  `deleted` int(1) NOT NULL DEFAULT '0',
		  `retailprice` int(11) NOT NULL,
		  `oldprice` int(11) NOT NULL,
		  PRIMARY KEY (`item_id`),
		  UNIQUE KEY `item_number` (`item_number`),
		  KEY `phppos_items_ibfk_1` (`supplier_id`)
		) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=14 ;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*
		--
		-- Table structure for table `phppos_items_taxes`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `phppos_items_taxes` (
		  `item_id` int(10) NOT NULL,
		  `name` varchar(255) NOT NULL,
		  `percent` double(15,2) NOT NULL,
		  `store` varchar(255) NOT NULL,
		  PRIMARY KEY (`item_id`,`name`,`percent`)
		) ENGINE=MyISAM DEFAULT CHARSET=latin1;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		
		/*--
		-- Table structure for table `phppos_modules`
		--
		*/
		$tab="CREATE TABLE IF NOT EXISTS `phppos_modules` (
		  `name_lang_key` varchar(255) NOT NULL,
		  `desc_lang_key` varchar(255) NOT NULL,
		  `sort` int(10) NOT NULL,
		  `module_id` varchar(255) NOT NULL,
		  PRIMARY KEY (`module_id`),
		  UNIQUE KEY `desc_lang_key` (`desc_lang_key`),
		  UNIQUE KEY `name_lang_key` (`name_lang_key`)
		) ENGINE=MyISAM DEFAULT CHARSET=latin1;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		  
		/*--
		-- Insert data into table `phppos_modules`
		--
		*/  
		$tab="INSERT INTO `phppos_modules` (`name_lang_key`, `desc_lang_key`, `sort`, `module_id`) VALUES
		
		('module_customers', 'module_customers_desc', 1, 'customers'),
		('module_items', 'module_items_desc', 2, 'items'),
		('module_reports', 'module_reports_desc', 3, 'reports'),
		('module_suppliers', 'module_suppliers_desc', 4, 'suppliers'),
		('module_receivings', 'module_receivings_desc', 5, 'receivings'),
		('module_sales', 'module_sales_desc', 6, 'sales'),
		('module_employees', 'module_employees_desc', 7, 'employees'),
		('module_config', 'module_config_desc', 8, 'config'),
		('module_giftcards', 'module_giftcards_desc', 9, 'giftcards'),
		('module_clocking', 'module_clocking_desc', 10, 'clocking'),
		('module_chat', 'module_chat _desc', 11, 'chat');";
		
		  if (mysql_query($tab,$dbh2))
		  {
		  ////echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }  
		  
		  
		/*--
		-- Table structure for table `phppos_people`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `phppos_people` (
		  `first_name` varchar(255) NOT NULL,
		  `last_name` varchar(255) NOT NULL,
		  `phone_number` varchar(255) NOT NULL,
		  `email` varchar(255) NOT NULL,
		  `address_1` varchar(255) NOT NULL,
		  `address_2` varchar(255) NOT NULL,
		  `city` varchar(255) NOT NULL,
		  `state` varchar(255) NOT NULL,
		  `zip` varchar(255) NOT NULL,
		  `country` varchar(255) NOT NULL,
		  `comments` text NOT NULL,
		  `curjid` int(11) NOT NULL,
		  `login` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
		  `person_id` int(10) NOT NULL AUTO_INCREMENT,
		  `m_name` text NOT NULL,
		  PRIMARY KEY (`person_id`)
		) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=188 ;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*--
		-- Query for inserting data into table `phppos_people`
		--*/  
		$CU="INSERT INTO `phppos_people` (
		
		`first_name` ,
		`last_name` ,
		`phone_number` ,
		`email` ,
		`address_1` ,
		`address_2` ,
		`city` ,
		`state` ,
		`zip` ,
		`country` ,
		`comments` ,
		`person_id` ,
		`m_name` 
		)
		VALUES (
		'".$_SESSION['person_data']['first_name']."', '".$_SESSION['person_data']['last_name']."', '', '".$_SESSION['person_data']['email']."', '".$_SESSION['person_data']['address_1']."', '".$_SESSION['person_data']['address_2']."', '', '', '', '', '', '1', ''
		) ";
		  
		  
		  if (mysql_query($CU,$dbh2))
		  {
		  ////echo "QUEYR EXECUTED";
		  }
		else
		  {
		  //echo "Error creating database: " . mysql_error();
		  }  
		  
		/*--
		-- Table structure for table `phppos_permissions`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `phppos_permissions` (
		  `module_id` varchar(255) NOT NULL,
		  `person_id` int(10) NOT NULL,
		  PRIMARY KEY (`module_id`,`person_id`),
		  KEY `person_id` (`person_id`)
		) ENGINE=MyISAM DEFAULT CHARSET=latin1;";
		
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*--
		-- Query for inserting data into table `phppos_permissions`
		--*/  
		$tab="INSERT INTO `phppos_permissions` (`module_id`, `person_id`) VALUES
		
		 ('config', 1),
		 ('customers', 1),
		 ('employees', 1),
		 ('gateway', 1),
		 ('items', 1),
		 ('receivings', 1),
		 ('reports', 1),
		 ('sales', 1),
		 ('suppliers', 1),
		 ('clocking', 1),
		 ('giftcards', 1);";
		
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }  
		/*--
		-- Table structure for table `phppos_receivings`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `phppos_receivings` (
		  `receiving_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
		  `supplier_id` int(10) DEFAULT NULL,
		  `employee_id` int(10) NOT NULL DEFAULT '0',
		  `comment` text NOT NULL,
		  `receiving_id` int(10) NOT NULL AUTO_INCREMENT,
		  `payment_type` varchar(20) DEFAULT NULL,
		  PRIMARY KEY (`receiving_id`),
		  KEY `supplier_id` (`supplier_id`),
		  KEY `employee_id` (`employee_id`)
		) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*--
		-- Table structure for table `phppos_receivings_items`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `phppos_receivings_items` (
		  `receiving_id` int(10) NOT NULL DEFAULT '0',
		  `item_id` int(10) NOT NULL DEFAULT '0',
		  `description` varchar(30) DEFAULT NULL,
		  `serialnumber` varchar(30) DEFAULT NULL,
		  `line` int(3) NOT NULL,
		  `quantity_purchased` int(10) NOT NULL DEFAULT '0',
		  `item_cost_price` decimal(15,2) NOT NULL,
		  `item_unit_price` double(15,2) NOT NULL,
		  `discount_percent` int(11) NOT NULL DEFAULT '0',
		  PRIMARY KEY (`receiving_id`,`item_id`,`line`),
		  KEY `item_id` (`item_id`)
		) ENGINE=MyISAM DEFAULT CHARSET=latin1;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*
		--
		-- Table structure for table `phppos_sales`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `phppos_sales` (
		  `sale_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
		  `customer_id` int(10) DEFAULT NULL,
		  `employee_id` int(10) NOT NULL DEFAULT '0',
		  `comment` text NOT NULL,
		  `sale_id` int(10) NOT NULL AUTO_INCREMENT,
		  `payment_type` varchar(512) DEFAULT NULL,
		  `totalCP` varchar(255) DEFAULT NULL,
		  `totalSV` varchar(255) DEFAULT NULL,
		  `profit` varchar(255) DEFAULT NULL,
		  PRIMARY KEY (`sale_id`),
		  KEY `customer_id` (`customer_id`),
		  KEY `employee_id` (`employee_id`)
		) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=4 ;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*
		--
		-- Table structure for table `phppos_sales_items`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `phppos_sales_items` (
		  `sale_id` int(10) NOT NULL DEFAULT '0',
		  `item_id` int(10) NOT NULL DEFAULT '0',
		  `description` varchar(30) DEFAULT NULL,
		  `serialnumber` varchar(30) DEFAULT NULL,
		  `line` int(3) NOT NULL DEFAULT '0',
		  `quantity_purchased` double(15,2) NOT NULL DEFAULT '0.00',
		  `item_cost_price` decimal(15,2) NOT NULL,
		  `item_unit_price` double(15,2) NOT NULL,
		  `discount_percent` int(11) NOT NULL DEFAULT '0',
		  `item_retailprice` int(11) NOT NULL,
		  PRIMARY KEY (`sale_id`,`item_id`,`line`),
		  KEY `item_id` (`item_id`)
		) ENGINE=MyISAM DEFAULT CHARSET=latin1;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*--
		-- Table structure for table `phppos_sales_items_taxes`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `phppos_sales_items_taxes` (
		  `sale_id` int(10) NOT NULL,
		  `item_id` int(10) NOT NULL,
		  `line` int(3) NOT NULL DEFAULT '0',
		  `name` varchar(255) NOT NULL,
		  `percent` double(15,2) NOT NULL,
		  PRIMARY KEY (`sale_id`,`item_id`,`line`,`name`,`percent`),
		  KEY `item_id` (`item_id`)
		) ENGINE=MyISAM DEFAULT CHARSET=latin1;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		
		/*--
		-- Table structure for table `phppos_sales_payments`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `phppos_sales_payments` (
		  `sale_id` int(10) NOT NULL,
		  `payment_type` varchar(40) NOT NULL,
		  `payment_amount` decimal(15,2) NOT NULL,
		  PRIMARY KEY (`sale_id`,`payment_type`)
		) ENGINE=MyISAM DEFAULT CHARSET=latin1;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*--
		-- Table structure for table `phppos_sales_suspended`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `phppos_sales_suspended` (
		  `sale_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
		  `customer_id` int(10) DEFAULT NULL,
		  `employee_id` int(10) NOT NULL DEFAULT '0',
		  `comment` text NOT NULL,
		  `sale_id` int(10) NOT NULL AUTO_INCREMENT,
		  `payment_type` varchar(512) DEFAULT NULL,
		  PRIMARY KEY (`sale_id`),
		  KEY `customer_id` (`customer_id`),
		  KEY `employee_id` (`employee_id`)
		) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*
		--
		-- Table structure for table `phppos_sales_suspended_items`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `phppos_sales_suspended_items` (
		  `sale_id` int(10) NOT NULL DEFAULT '0',
		  `item_id` int(10) NOT NULL DEFAULT '0',
		  `description` varchar(30) DEFAULT NULL,
		  `serialnumber` varchar(30) DEFAULT NULL,
		  `line` int(3) NOT NULL DEFAULT '0',
		  `quantity_purchased` double(15,2) NOT NULL DEFAULT '0.00',
		  `item_cost_price` decimal(15,2) NOT NULL,
		  `item_unit_price` double(15,2) NOT NULL,
		  `discount_percent` int(11) NOT NULL DEFAULT '0',
		  PRIMARY KEY (`sale_id`,`item_id`,`line`),
		  KEY `item_id` (`item_id`)
		) ENGINE=MyISAM DEFAULT CHARSET=latin1;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*
		--
		-- Table structure for table `phppos_sales_suspended_items_taxes`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `phppos_sales_suspended_items_taxes` (
		  `sale_id` int(10) NOT NULL,
		  `item_id` int(10) NOT NULL,
		  `line` int(3) NOT NULL DEFAULT '0',
		  `name` varchar(255) NOT NULL,
		  `percent` double(15,2) NOT NULL,
		  PRIMARY KEY (`sale_id`,`item_id`,`line`,`name`,`percent`),
		  KEY `item_id` (`item_id`)
		) ENGINE=MyISAM DEFAULT CHARSET=latin1;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*
		--
		-- Table structure for table `phppos_sales_suspended_payments`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `phppos_sales_suspended_payments` (
		  `sale_id` int(10) NOT NULL,
		  `payment_type` varchar(40) NOT NULL,
		  `payment_amount` decimal(15,2) NOT NULL,
		  PRIMARY KEY (`sale_id`,`payment_type`)
		) ENGINE=MyISAM DEFAULT CHARSET=latin1;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		/*
		--
		-- Table structure for table `phppos_sessions`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `phppos_sessions` (
		  `session_id` varchar(40) NOT NULL DEFAULT '0',
		  `ip_address` varchar(16) NOT NULL DEFAULT '0',
		  `user_agent` varchar(50) NOT NULL,
		  `last_activity` int(10) unsigned NOT NULL DEFAULT '0',
		  `user_data` text NOT NULL,
		  PRIMARY KEY (`session_id`)
		) ENGINE=MyISAM DEFAULT CHARSET=latin1;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		
		/*--
		-- Table structure for table `phppos_stores`
		--*/  
		$tab_stores="CREATE TABLE IF NOT EXISTS `phppos_stores` (
		  `id` int(11) NOT NULL AUTO_INCREMENT,
		  `person_id` int(11) NOT NULL,
		  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
		  `email` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
		  `phonenumber` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
		  `address` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
		  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		  `status` tinyint(1) NOT NULL DEFAULT '1',
		  PRIMARY KEY (`id`)
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=28 ;";
		
		if (mysql_query($tab_stores,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  } 
		
		       
		/*--
		-- Table structure for table `phppos_suppliers`
		--*/
		
		$tab="CREATE TABLE IF NOT EXISTS `phppos_suppliers` (
		  `person_id` int(10) NOT NULL,
		  `company_name` varchar(255) NOT NULL,
		  `account_number` varchar(255) DEFAULT NULL,
		  `deleted` int(1) NOT NULL DEFAULT '0',
		  UNIQUE KEY `account_number` (`account_number`),
		  KEY `person_id` (`person_id`)
		) ENGINE=MyISAM DEFAULT CHARSET=latin1;";
		
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		  
		/*--
		-- Table structure for table `phppos_users`
		--
		*/
		$tab="CREATE TABLE IF NOT EXISTS `phppos_users` (
		  `user_id` int(11) NOT NULL AUTO_INCREMENT,
		  `sales_code` varchar(255) DEFAULT NULL,
		  `Complete_name` varchar(255) DEFAULT NULL,
		  `email` varchar(255) DEFAULT NULL,
		  `address` varchar(255) DEFAULT NULL,
		  `joining_date` varchar(255) NOT NULL,
		  PRIMARY KEY (`user_id`)
		) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=30 ;";
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }
		  
		//--------------------------------DB POPULATED------------
		
		
		 
		//----------- CREate a config file----------------//
		
		
		
		$test1="default";
		$C="if ( ! defined('BASEPATH')) exit('No direct script access allowed');";
		
		$HOSTNAME="$"."db['default']['hostname']";
		$username="$"."db['default']['username']";
		$password="$"."db['default']['password']";
		$database="$"."db['default']['database']";
		$dbdriver="$"."db['default']['dbdriver']";
		$dbprefix="$"."db['default']['dbprefix']";
		$pconnect="$"."db['default']['pconnect']";
		$db_debug="$"."db['default']['db_debug']";
		$cache_on="$"."db['default']['cache_on']";
		$cachedir="$"."db['default']['cachedir']";
		$char_set="$"."db['default']['char_set']";
		$dbcollat="$"."db['default']['dbcollat']";
		
		
		
		 //$active_group ="$"."active_group"."=";
		
		$string = '<?php '.$C.' 
		
		$active_group = "'. $test1. '";
		
		$active_record = TRUE;
		'.$HOSTNAME .'= "'. $H. '";
		'.$username .'= EMPDB_USERNAME;
		'.$password .'= EMPDB_PASSWORD;
		'.$database .'= "'. $D. '";
		'.$dbdriver .'= "mysql";
		'.$dbprefix .'= "phppos_";
		'.$pconnect .'= FALSE;
		'.$db_debug .'= FALSE;
		'.$cache_on .'= FALSE;
		'.$cachedir .'= "";
		'.$char_set .'= "utf8";
		'.$dbcollat .'= "utf8_general_ci";
		';
		
		
		$fp = fopen($dir1, "w");
		
		fwrite($fp, $string);
		
		fclose($fp);
	}
	
	function Dbcreation() 
	{
		/***** 
		Developed By Afshan Mukhtar
		admin@wrkmash.com
		**************************/
		$prefix="";
		$path1="";
		$db_name=str_replace(" " , "_" ,$_SESSION['username']);        //-----TO be Edited-----------//
		
		$cpanel_user = "oposlive";
		// cPanel password (you use to login to cPanel)
		$cpanel_password = "zCk7D.M@5);7";
		// cPanel domain (example: mysite.com)
		
		$S=$_SESSION['username'];               //-----TO be Edited-----------//
		$P=$_SESSION['password'];                //-----TO be Edited-----------//
		$H="localhost";         //-----TO be Edited-----------//
		$U=$cpanel_user;        //-----TO be Edited-----------//
		$P=$cpanel_password;              //-----TO be Edited-----------//
		
		$string=$_SERVER['SERVER_NAME']; 
		
		 if (preg_match("/dev/", $string))
		 {
			$prefix="dev";
			$path="oposdev";
		 }
		 
		 elseif (preg_match("/test/", $string))
		 {
			$prefix="test";
			$path="opostest";
		 }
		 else
		 {
			 $prefix="oposlive";
			 $path="oposlive";
		 }
		
		
		
		$D=$prefix."_".$db_name; //-----TO be Edited-----------//
		$db = $prefix."_".$db_name;
		
		$dir ='/home/'.$path.'/public_html/app/application/config';
		$dir1=$dir."/".$db_name.".php" ;         //-----TO be Edited as per FILE NAME REQUIRED-----------//
		
		//////////////////////////////////////
		/* Code below should not be changed */
		//////////////////////////////////////
		$host = 'localhost';  //-----TO be Edited-----------//
		$user =$cpanel_user;    //-----TO be Edited-----------//
		$pass = $cpanel_password;    //-----TO be Edited-----------//
		//////=====================CREATED DB NAME SHD BE HERE
		
		
		$dbh2 =mysql_connect($host,$user,$pass) or  die(mysql_error());		
		
		$olddb = "onlinepos_database_schema";
		$newdb = $db;
		$this->DBCloning($olddb,$newdb);//exit;
		//======================================================//
		 
		
		
		/*--
		-- Inserting data into `phppos_app_config`
		--*/	  
		  
		$tab="INSERT INTO `phppos_app_config` (`key`, `value`) VALUES
		('address', '".$_SESSION['person_data']['address_1']."'),
		('company', '".$_SESSION['employee_data']['username']."'),
		('default_tax_1_name', 'Sales Tax'),
		('default_tax_1_rate', ''),
		('default_tax_2_name', 'Sales Tax 2'),
		('default_tax_2_rate', ''),
		('default_tax_rate', '8'),
		('email', '".$_SESSION['person_data']['email']."'),
		('fax', ''),
		('language', 'english'),
		('phone', '555-555-5555'),
		('print_after_sale', '0'),
		('return_policy', 'Test'),
		('timezone', 'America/Los_Angeles'),
		('version', '10.0'),
		('freports', '0'),
		('website', '');";
		if (mysql_query($tab,$dbh2))
		  {
		 // //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }  
		  
		/*--
		--Query to insert data into phppos_employees table 
		--
		*/
		$dbh2 = mysql_connect($host,$user,$pass) or die(mysql_error());
		//mysql_select_db(DB, $dbh2)  or die(mysql_error());
		
		$CU="INSERT INTO `phppos_employees` (
		`username` ,
		`password` ,
		`person_id` ,
		`deleted` 
		)
		VALUES (
		'".$_SESSION['employee_data']['username']."', '".$_SESSION['employee_data']['password']."', '1', '0'
		);";
		
		if (mysql_query($CU,$dbh2))
		  {
		  ////echo "QUEYR EXECUTED";
		  }
		else
		  {
		  //echo "Error creating database: " . mysql_error();
		  }
		  
		
		  
		 /*--
		-- Insert data into table `phppos_gateways`
		--*/
		 
		  $tab="INSERT INTO `phppos_gateways` (`gateway_id`, `gateways_name`, `MUinfo`, `MUkey`, `enable`, `description`, `default`, `signature`) 
		  VALUES
			(2, 'Authorize', '0', '0', 0, '0', 0, '0'),
			(1, 'paypal', 'sadaf7_1322613389_biz_api1.yahoo.com', '1322613447', 1, 'test account information', 1, 'A2bAiVfoSnT9Tjsf8h7Kb98I7ac5AECgqoB7STMeCUrtWdZZFLIxO7WY '),
			(3, 'linkpoint', 'lkuser', '', 0, '0', 0, '0'),
			(4, 'ipay', 'ipuser', '', 1, '0', 0, '');";
		
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  } 
		  
		
		/*--
		-- Insert data into table `phppos_modules`
		--
		*/  
		$tab="INSERT INTO `phppos_modules` (`name_lang_key`, `desc_lang_key`, `sort`, `module_id`) VALUES
		
		('module_customers', 'module_customers_desc', 1, 'customers'),
		('module_items', 'module_items_desc', 2, 'items'),
		('module_reports', 'module_reports_desc', 3, 'reports'),
		('module_suppliers', 'module_suppliers_desc', 4, 'suppliers'),
		('module_receivings', 'module_receivings_desc', 5, 'receivings'),
		('module_sales', 'module_sales_desc', 6, 'sales'),
		('module_employees', 'module_employees_desc', 7, 'employees'),
		('module_config', 'module_config_desc', 8, 'config'),
		('module_giftcards', 'module_giftcards_desc', 9, 'giftcards'),
		('module_clocking', 'module_clocking_desc', 10, 'clocking'),
		('module_chat', 'module_chat _desc', 11, 'chat');";
		
		  if (mysql_query($tab,$dbh2))
		  {
		  ////echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }  
		  
		  
		
		/*--
		-- Query for inserting data into table `phppos_people`
		--*/  
		$CU="INSERT INTO `phppos_people` (
		
		`first_name` ,
		`last_name` ,
		`phone_number` ,
		`email` ,
		`address_1` ,
		`address_2` ,
		`city` ,
		`state` ,
		`zip` ,
		`country` ,
		`comments` ,
		`person_id` ,
		`m_name` 
		)
		VALUES (
		'".$_SESSION['person_data']['first_name']."', '".$_SESSION['person_data']['last_name']."', '', '".$_SESSION['person_data']['email']."', '".$_SESSION['person_data']['address_1']."', '".$_SESSION['person_data']['address_2']."', '', '', '', '', '', '1', ''
		) ";
		  
		  
		  if (mysql_query($CU,$dbh2))
		  {
		  ////echo "QUEYR EXECUTED";
		  }
		else
		  {
		  //echo "Error creating database: " . mysql_error();
		  }  
		  
		
		/*--
		-- Query for inserting data into table `phppos_permissions`
		--*/  
		$tab="INSERT INTO `phppos_permissions` (`module_id`, `person_id`) VALUES
		
		 ('config', 1),
		 ('customers', 1),
		 ('employees', 1),
		 ('gateway', 1),
		 ('items', 1),
		 ('receivings', 1),
		 ('reports', 1),
		 ('sales', 1),
		 ('suppliers', 1),
		 ('clocking', 1),
		 ('giftcards', 1);";
		
		if (mysql_query($tab,$dbh2))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error creating database: " . mysql_error();
		  }  
		
		
		  
		//--------------------------------DB POPULATED------------
		
		
		 
		//----------- CREate a config file----------------//
		
		
		
		$test1="default";
		$C="if ( ! defined('BASEPATH')) exit('No direct script access allowed');";
		
		$HOSTNAME="$"."db['default']['hostname']";
		$username="$"."db['default']['username']";
		$password="$"."db['default']['password']";
		$database="$"."db['default']['database']";
		$dbdriver="$"."db['default']['dbdriver']";
		$dbprefix="$"."db['default']['dbprefix']";
		$pconnect="$"."db['default']['pconnect']";
		$db_debug="$"."db['default']['db_debug']";
		$cache_on="$"."db['default']['cache_on']";
		$cachedir="$"."db['default']['cachedir']";
		$char_set="$"."db['default']['char_set']";
		$dbcollat="$"."db['default']['dbcollat']";
		
		
		
		 //$active_group ="$"."active_group"."=";
		
		$string = '<?php '.$C.' 
		
		$active_group = "'. $test1. '";
		
		$active_record = TRUE;
		'.$HOSTNAME .'= "'. $H. '";
		'.$username .'= EMPDB_USERNAME;
		'.$password .'= EMPDB_PASSWORD;
		'.$database .'= "'. $D. '";
		'.$dbdriver .'= "mysql";
		'.$dbprefix .'= "phppos_";
		'.$pconnect .'= FALSE;
		'.$db_debug .'= FALSE;
		'.$cache_on .'= FALSE;
		'.$cachedir .'= "";
		'.$char_set .'= "utf8";
		'.$dbcollat .'= "utf8_general_ci";
		';
		
		
		$fp = fopen($dir1, "w");
		
		fwrite($fp, $string);
		
		fclose($fp);
	}
	
	function DBCloning($olddb,$newdb){
	//connect_db();	
	//global $admin;
		$db_check = @mysql_select_db ($olddb) or die('error database selection');
		$getTables  =   mysql_query("SHOW TABLES");   
		$tables =   array();
			while($row = mysql_fetch_row($getTables)){
				$tables[]   =   $row[0];
			}
			$createTable = mysql_query("CREATE DATABASE `$newdb` DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;") or die(mysql_error());
			foreach($tables as $cTable){
				$db_check   =   @mysql_select_db ( $newdb );
				$create     =   mysql_query("CREATE TABLE $cTable LIKE ".$olddb.".".$cTable);
				if(!$create) {
				$error  =   true;
				}
				//$insert     =   mysql_query("INSERT INTO $cTable SELECT * FROM ".$olddb.".".$cTable);
			}
		//return !isset($error) ? true : false;
	}
	
	/*Methods Used for Ecommerce*/
	function generateEcommerce()
	{
		
		$shopname = $_SESSION['shopname'];
		/*Code to insert Account Inforamtion*/
		$con = mysql_connect("localhost",EMPDB_USERNAME,EMPDB_PASSWORD) or  die(mysql_error());
		$db = @mysql_select_db ("oposlive_devlive" ,$con) or die('error database selection');
		
		$employee_query = mysql_query("SELECT id,person_id,username,password,iseshop FROM phppos_employees WHERE username = '$shopname'");
		$employee_result = mysql_fetch_assoc($employee_query);
		$shopid = $employee_result['person_id'];
		
		$shopname = str_replace(" ", "_", $shopname);
		$destination_directory = $_SERVER['DOCUMENT_ROOT']."/".$shopname;
		$dbname = "oposlive_".$shopname;
		$source_directory = $_SERVER['DOCUMENT_ROOT']."/eshop_source/";
		if($employee_result['iseshop']!=1)
		{
		$this->copyEshopSource($source_directory."source/",$destination_directory);
		$this->changeEshopSettings($shopid,$shopname,$destination_directory);
		$this->changeDatabaseForEshop($dbname,$source_directory);
		}
		
		
	}
	
		
	function createSiteConfig($dbname,$shopname,$directory)
	{
		
		$directory = $directory ."/includes/configure.php";
		$string = "";
		$string .= "<?php";
		$string .= " 
		/**
		* @package Configuration Settings circa 1.5.0
		* @copyright Copyright 2003-2011 Zen Cart Development Team
		* @copyright Portions Copyright 2003 osCommerce
		* @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
		* File Built by zc_install on 2012-10-16 02:01:08
		*/
			
		/*************** NOTE: This file is similar, but DIFFERENT from the 'admin' version of configure.php. ***********/
		/***************       The 2 files should be kept separate and not used to overwrite each other.      ***********/
		
		// Define the webserver and path parameters
	    // HTTP_SERVER is your Main webserver: eg-http://www.your_domain.com
		// HTTPS_SERVER is your Secure webserver: eg-https://www.your_domain.com";
		$string .= "
		";
		$string .= "define('HTTP_SERVER', 'http://dev.onlinepos.com');";
		$string .= "
		";
		$string .= "define('HTTPS_SERVER', 'http://dev.onlinepos.com');";
		$string .= "
		";
		$string .= "// Use secure webserver for checkout procedure?";
		$string .= "
		";
		$string .= "define('ENABLE_SSL', 'false');";
		$string .= "
		";
		$string .= "// NOTE: be sure to leave the trailing '/' at the end of these lines if you make changes!
		// * DIR_WS_* = Webserver directories (virtual/URL)
  		// these paths are relative to top of your webspace ... (ie: under the public_html or httpdocs folder)";
		$string .= "
		";
		$string .= "define('DIR_WS_CATALOG', '/$shopname/');";
		$string .= "
		";
		$string .= "define('DIR_WS_HTTPS_CATALOG', '/$shopname/');";
		$string .= "
		";
		$string .= "define('DIR_WS_IMAGES', 'images/');";
		$string .= "
		";
		$string .= "define('DIR_WS_INCLUDES', 'includes/');";
		$string .= "
		";
		$string .= "define('DIR_WS_FUNCTIONS', DIR_WS_INCLUDES . 'functions/');";
		$string .= "
		";
		$string .= "define('DIR_WS_CLASSES', DIR_WS_INCLUDES . 'classes/');";
		$string .= "
		";
		$string .= "define('DIR_WS_MODULES', DIR_WS_INCLUDES . 'modules/');";
		$string .= "
		";
		$string .= "define('DIR_WS_LANGUAGES', DIR_WS_INCLUDES . 'languages/');";
		$string .= "
		";
		$string .= "define('DIR_WS_DOWNLOAD_PUBLIC', DIR_WS_CATALOG . 'pub/');";
		$string .= "
		";
		$string .= "define('DIR_WS_TEMPLATES', DIR_WS_INCLUDES . 'templates/');";
		$string .= "
		
		";
		$string .= "define('DIR_WS_PHPBB', '/');";
		$string .= "
		
		";
		$string .= "// * DIR_FS_* = Filesystem directories (local/physical)
  		//the following path is a COMPLETE path to your Zen Cart files. eg: /var/www/vhost/accountname/public_html/store/";
		$string .= "
		
		";
		$string .= "define('DIR_FS_CATALOG', '/home/oposdev/public_html/$shopname/');";
		$string .= "
		";
		$string .= "define('DIR_FS_DOWNLOAD', DIR_FS_CATALOG . 'download/');";
		$string .= "
		";
		$string .= "define('DIR_FS_DOWNLOAD_PUBLIC', DIR_FS_CATALOG . 'pub/');";
		$string .= "
		";
		$string .= "define('DIR_WS_UPLOADS', DIR_WS_IMAGES . 'uploads/');";
		$string .= "
		";
		$string .= "define('DIR_FS_UPLOADS', DIR_FS_CATALOG . DIR_WS_UPLOADS);";
		$string .= "
		";
		$string .= "define('DIR_FS_EMAIL_TEMPLATES', DIR_FS_CATALOG . 'email/');";
		$string .= "
		
		";
		$string .= "// define our database connection";
		$string .= "
		";
		$string .= "define('DB_TYPE', 'mysql');";
		$string .= "
		";
		$string .= "define('DB_PREFIX', '');";
		$string .= "
		";
		$string .= "define('DB_CHARSET', 'utf8');";
		$string .= "
		";
		$string .= "define('DB_SERVER', 'localhost');";
		$string .= "
		";
		$string .= "define('DB_SERVER_USERNAME', 'oposlive_dbroot');";
		$string .= "
		";
		$string .= "define('DB_SERVER_PASSWORD', 'Ovcq{.U~0JXB');";
		$string .= "
		";
		$string .= "define('DB_DATABASE', '$dbname');";
		$string .= "
		
		";
		$string .= "// The next 2 'defines' are for SQL cache support.
		  // For SQL_CACHE_METHOD, you can select from:  none, database, or file
		  // If you choose 'file', then you need to set the DIR_FS_SQL_CACHE to a directory where your apache 
		  // or webserver user has write privileges (chmod 666 or 777). We recommend using the 'cache' folder inside the Zen Cart folder
		  // ie: /path/to/your/webspace/public_html/zen/cache   -- leave no trailing slash  ";
		$string .= "
		";
		$string .= "define('SQL_CACHE_METHOD', 'none'); ";
		$string .= "
		";
		$string .= "define('DIR_FS_SQL_CACHE', '/home/oposdev/public_html/$shopname/cache'); ";
		$string .= "
		";
		
		$string .= "
		";
		$string .= "?>";
		
		
		$fp = fopen($directory, "w");
		
		fwrite($fp, $string);
		
		fclose($fp);
	}
	
	function createAdminConfig($dbname,$shopname,$directory)
	{
		$directory = $directory ."/zadmin/includes/configure.php";
		$string = "";
		$string .= "<?php";
		$string .= " 
		 /**
		 * @package Configuration Settings circa 1.5.0
		 * @copyright Copyright 2003-2011 Zen Cart Development Team
		 * @copyright Portions Copyright 2003 osCommerce
		 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
		 * File Built by zc_install on 2012-10-16 02:01:08
		 */
		
		
		/*************** NOTE: This file is similar, but DIFFERENT from the 'store' version of configure.php. ***********/
		/***************       The 2 files should be kept separate and not used to overwrite each other.      ***********/
		
		/**
		 * WE RECOMMEND THAT YOU USE SSL PROTECTION FOR YOUR ENTIRE ADMIN:
		 * To do that, make sure you use a 'https:' URL for BOTH the HTTP_SERVER and HTTPS_SERVER entries:
		 */";
		$string .= "
		";
		$string .= "define('HTTP_SERVER', 'http://dev.onlinepos.com');";
		$string .= "
		";
		$string .= "define('HTTPS_SERVER', 'http://dev.onlinepos.com');";
		$string .= "
		";
		$string .= "define('HTTP_CATALOG_SERVER', 'http://dev.onlinepos.com');";
		$string .= "
		";
		$string .= "define('HTTPS_CATALOG_SERVER', 'https://dev.onlinepos.com');";
		$string .= "
		";
		$string .= "// secure webserver for admin?  Valid choices are 'true' or 'false' (including quotes).";
		$string .= "
		";
		$string .= "define('ENABLE_SSL_ADMIN', 'false');";
		$string .= "
		";
		$string .= "// secure webserver for storefront?  Valid choices are 'true' or 'false' (including quotes).";
		$string .= "
		";
		$string .= "define('ENABLE_SSL_CATALOG', 'false');";
		$string .= "
		";
		$string .= "// NOTE: be sure to leave the trailing '/' at the end of these lines if you make changes!
		// * DIR_WS_* = Webserver directories (virtual/URL)
  		// these paths are relative to top of your webspace ... (ie: under the public_html or httpdocs folder)";
		$string .= "
		";
		$string .= '$t1 = parse_url(HTTP_SERVER);$p1 = $t1["path"];$t2 = parse_url(HTTPS_SERVER);$p2 = $t2["path"];' ;
		$string .= "
		";
		$string .= 'define("DIR_WS_ADMIN", preg_replace("#^" . str_replace("-", "\-", $p1) . "#", "", dirname($_SERVER["SCRIPT_NAME"])) . "/");';
		$string .= "
		";
		$string .= "define('DIR_WS_CATALOG', '/$shopname/');";
		$string .= "
		";
		$string .= 'define("DIR_WS_HTTPS_ADMIN", preg_replace("#^" . str_replace("-", "\-", $p2) . "#", "", dirname($_SERVER["SCRIPT_NAME"])) . "/");';
		$string .= "
		";
		$string .= "define('DIR_WS_HTTPS_CATALOG', '/$shopname/');";
		$string .= "
		";
		$string .= "define('DIR_WS_IMAGES', 'images/');";
		$string .= "
		";
		$string .= "define('DIR_WS_ICONS', DIR_WS_IMAGES . 'icons/');";
		$string .= "
		";
		$string .= "define('DIR_WS_CATALOG_IMAGES', HTTP_CATALOG_SERVER . DIR_WS_CATALOG . 'images/');";
		$string .= "
		";
		$string .= "define('DIR_WS_CATALOG_TEMPLATE', HTTP_CATALOG_SERVER . DIR_WS_CATALOG . 'includes/templates/');";
		$string .= "
		";
		$string .= "define('DIR_WS_INCLUDES', 'includes/');";
		$string .= "
		";
		$string .= "define('DIR_WS_BOXES', DIR_WS_INCLUDES . 'boxes/');";
		$string .= "
		";
		$string .= "define('DIR_WS_FUNCTIONS', DIR_WS_INCLUDES . 'functions/');";
		$string .= "
		";
		$string .= "define('DIR_WS_CLASSES', DIR_WS_INCLUDES . 'classes/');";
		$string .= "
		";
		$string .= "define('DIR_WS_MODULES', DIR_WS_INCLUDES . 'modules/');";
		$string .= "
		";
		$string .= "define('DIR_WS_LANGUAGES', DIR_WS_INCLUDES . 'languages/');";
		$string .= "
		";
		$string .= "define('DIR_WS_CATALOG_LANGUAGES', HTTP_CATALOG_SERVER . DIR_WS_CATALOG . 'includes/languages/');";
		$string .= "
		";
		$string .= "// * DIR_FS_* = Filesystem directories (local/physical)";
		$string .= "
		";
		$string .= "define('DIR_FS_ADMIN', realpath(dirname(__FILE__) . '/../') . '/');";
		$string .= "
		";
		$string .= "//the following path is a COMPLETE path to your Zen Cart files. eg: /var/www/vhost/accountname/public_html/store/";
		$string .= "
		";
		$string .= "define('DIR_FS_CATALOG', '/home/oposdev/public_html/$shopname/');";
		$string .= "
		";
		$string .= "define('DIR_FS_CATALOG_LANGUAGES', DIR_FS_CATALOG . 'includes/languages/');";
		$string .= "
		";
  		$string .= "define('DIR_FS_CATALOG_IMAGES', DIR_FS_CATALOG . 'images/');";
		$string .= "
		";
  		$string .= "define('DIR_FS_CATALOG_MODULES', DIR_FS_CATALOG . 'includes/modules/');";
		$string .= "
		";
 		$string .= "define('DIR_FS_CATALOG_TEMPLATES', DIR_FS_CATALOG . 'includes/templates/');";
		$string .= "
		";
  		$string .= "define('DIR_FS_BACKUP', DIR_FS_ADMIN . 'backups/');";
		$string .= "
		";
  		$string .= "define('DIR_FS_EMAIL_TEMPLATES', DIR_FS_CATALOG . 'email/');";
		$string .= "
		";
  		$string .= "define('DIR_FS_DOWNLOAD', DIR_FS_CATALOG . 'download/');";
		$string .= "
		";
		$string .= "// define our database connection";
		$string .= "
		";
		$string .= "define('DB_TYPE', 'mysql');";
		$string .= "
		";
		$string .= "define('DB_PREFIX', '');";
		$string .= "
		";
		$string .= "define('DB_CHARSET', 'utf8');";
		$string .= "
		";
		$string .= "define('DB_SERVER', 'localhost');";
		$string .= "
		";
		$string .= "define('DB_SERVER_USERNAME', 'oposlive_dbroot');";
		$string .= "
		";
		$string .= "define('DB_SERVER_PASSWORD', 'Ovcq{.U~0JXB');";
		$string .= "
		";
		$string .= "define('DB_DATABASE', '$dbname');";
		$string .= "
		";		
		$string .= "
		
		";
		$string .= "// The next 2 'defines' are for SQL cache support.
		  // For SQL_CACHE_METHOD, you can select from:  none, database, or file
		  // If you choose 'file', then you need to set the DIR_FS_SQL_CACHE to a directory where your apache 
		  // or webserver user has write privileges (chmod 666 or 777). We recommend using the 'cache' folder inside the Zen Cart folder
		  // ie: /path/to/your/webspace/public_html/zen/cache   -- leave no trailing slash  ";
		$string .= "
		
		";
		$string .= "define('SQL_CACHE_METHOD', 'none'); ";
		$string .= "		
		";
		$string .= "define('DIR_FS_SQL_CACHE', '/home/oposdev/public_html/$shopname/cache');";
		$string .= "
		";
		$string .= "// Define the webserver and path parameters
		  // Main webserver: eg-http://www.your_domain.com - 
		  // HTTP_SERVER is your Main webserver: eg-http://www.your_domain.com
		  // HTTPS_SERVER is your Secure webserver: eg-https://www.your_domain.com
		  // HTTP_CATALOG_SERVER is your Main webserver: eg-http://www.your_domain.com
		  // HTTPS_CATALOG_SERVER is your Secure webserver: eg-https://www.your_domain.com
		  /* 
		   * URLs for your site will be built via:  
		   *     HTTP_SERVER plus DIR_WS_ADMIN or
		   *     HTTPS_SERVER plus DIR_WS_HTTPS_ADMIN or 
		   *     HTTP_SERVER plus DIR_WS_CATALOG or 
		   *     HTTPS_SERVER plus DIR_WS_HTTPS_CATALOG
		   * ...depending on your system configuration settings
		   */
		// EOF";
		$string .= "
		";
		
		$string .= "
		";
		$string .= "?>";
		
		
		$fp = fopen($directory, "w");
		
		fwrite($fp, $string);
		
		fclose($fp);
	}
	
	function createDB($dbname,$source_directory)
	{
		
		$link = mysql_connect("localhost", "oposlive", "zCk7D.M@5);7");//exit;
		if (!$link) 
		{
			die('Problem in database connection. Please try again letter : ' . mysql_error());
		}
		
		$db_selected = mysql_select_db($dbname, $link);
		if (!$db_selected)
		{
			$myFile = $source_directory."db/zencart_db.txt";
			$fh = fopen($myFile, 'r');
			$theData = fread($fh,  filesize($myFile));
			fclose($fh);
			//echo $theData;
			
			if(mysql_query("CREATE DATABASE ".$dbname,$link))
				{
				//echo "Database created";
				$mysqli = new mysqli("localhost", "oposlive", "zCk7D.M@5);7", $dbname);
				//mysql_select_db($dbname, $link);
				//mysql_query($theData) or die("Error in  creating tables:".mysql_error());
				$mysqli->multi_query($theData);
				$mysqli->close();
				}
			
		}
		
		
		if (mysql_query("ALTER TABLE products ADD item_id int(11) NOT NULL",$link))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error: " . mysql_error();
		  } 
		
		
	}
	
	
	function copyZencart( $source, $destination ) 
	{
		
		if ( is_dir( $source ) ) 
			{
			
			@mkdir( $destination );
			$directory = dir( $source );
			while ( FALSE !== ( $readdirectory = $directory->read() ) ) 
				{
				if ( $readdirectory == '.' || $readdirectory == '..' ) 
					{
					continue;
					}
				$PathDir = $source . '/' . $readdirectory; 
				if (is_dir( $PathDir )) 
					{
					$this->copyZencart( $PathDir, $destination . '/' . $readdirectory );
					continue;
					}
				copy( $PathDir, $destination . '/' . $readdirectory );
				}
 
			$directory->close();
			}
		else 
			{
			copy( $source, $destination );
			}
	}
	
	
	/*CODE to Generate Eshop*/
	function copyEshopSource( $source, $destination ) 
	{
		
		if ( is_dir( $source ) ) 
			{
			
			@mkdir( $destination );
			$directory = dir( $source );
			while ( FALSE !== ( $readdirectory = $directory->read() ) ) 
				{
				if ( $readdirectory == '.' || $readdirectory == '..' ) 
					{
					continue;
					}
				$PathDir = $source . '/' . $readdirectory; 
				if (is_dir( $PathDir )) 
					{
					$this->copyEshopSource( $PathDir, $destination . '/' . $readdirectory );
					continue;
					}
				copy( $PathDir, $destination . '/' . $readdirectory );
				}
 
			$directory->close();
			}
		else 
			{
			copy( $source, $destination );
			}
	}
	
	function changeEshopSettings($shopid,$shopname,$directory)
	{
		
		$directory = $directory ."/settings.php";
		$string = "";
		$string .= "<?php
		";
		$string .= "/*Eshop Settings */
		";
		$string .= "define('SHOPID', '$shopid');
		";
		$string .= "define('SHOPNAME', '$shopname');
		";
		$string .= "define('DS', DIRECTORY_SEPARATOR);
		";
		$string .= "define('ESROOT', dirname(dirname(__FILE__)).DS.'eshop_source'.DS);
		";
		$string .= "?>";
		
		
		$fp = fopen($directory, "w");
		
		fwrite($fp, $string);
		
		fclose($fp);
	}
	
	function changeDatabaseForEshop($dbname,$source_directory)
	{
		
		
		$link = mysql_connect("localhost", "oposlive", "zCk7D.M@5);7");//exit;
		if (!$link) 
		{
			die('Problem in database connection. Please try again letter : ' . mysql_error());
		}
		$db_selected = mysql_select_db($dbname, $link);
		
		$myFile = $source_directory."db/db.txt";
		$fh = fopen($myFile, 'r');
		$theData = fread($fh,  filesize($myFile));
		fclose($fh);
		$mysqli = new mysqli("localhost", "oposlive", "zCk7D.M@5);7", $dbname);
		//mysql_select_db($dbname, $link);
		//mysql_query($theData) or die("Error in  creating tables:".mysql_error());
		$mysqli->multi_query($theData);
		
		if (mysql_query("ALTER TABLE `phppos_customers` ADD `plateform` tinyint(1) COMMENT '1 for oppos 2 for eshop' ",$link))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error: " . mysql_error();
		  } 
		  
		if (mysql_query("ALTER TABLE `phppos_sales` ADD `plateform` tinyint(1) COMMENT '1 for oppos 2 for eshop' ",$link))
		  {
		  //echo "QUEYR EXECUTED";
		  }
		else
		  {
		  echo "Error: " . mysql_error();
		  }  
		
		$mysqli->close();
		
	}
	
		
	/*//////////////////////////*/

}

?>