<?php
class Appconfig extends Model  
{
	function exists($key)
	{
		$this->db->from('app_config');	
		$this->db->where('app_config.key',$key);
		$query = $this->db->get();
		
		return ($query->num_rows()==1);
	}
	
	function get_all()
	{
		$this->db->from('app_config');
		$this->db->order_by("key", "asc");
		$query = $this->db->get();
		return $query;	
	}
	
	function get($key)
	{
		$query = $this->db->get_where('app_config', array('key' => $key), 1);
		
		if($query->num_rows()==1)
		{
			return $query->row()->value;
		}
		
		return "";
	}
	
	function save($key,$value)
	{
		$config_data=array(
		'key'=>$key,
		'value'=>$value
		);
				
		if (!$this->exists($key))
		{
			return $this->db->insert('app_config',$config_data);
		}
		
		$this->db->where('key', $key);
		return $this->db->update('app_config',$config_data);		
	}
	
	function batch_save($data)
	{
		$success=true;
		
		//Run these queries as a transaction, we want to make sure we do all or nothing
		$this->db->trans_start();
		foreach($data as $key=>$value)
		{
			if(!$this->save($key,$value))
			{
				$success=false;
				break;
			}
		}
		
		$this->db->trans_complete();		
		return $success;
	}
		
	function delete($key)
	{
		return $this->db->delete('app_config', array('key' => $key)); 
	}
	
	function delete_all()
	{
		return $this->db->empty_table('app_config'); 
	}
	
	function existsStore($name)
	{
		$this->db->from('stores');	
		$this->db->where('stores.name',$name);
		$query = $this->db->get();
		return ($query->num_rows()==1);
	}
	
	function saveStores($store_save_data)
	{  
		if (!$this->existsStore($store_save_data['name']))
		{
			$store_name = $store_save_data['name'];
			$create_store_item="CREATE TABLE IF NOT EXISTS `phppos_".$store_name."_storeitems` 
				  (
				  `name` varchar(255) NOT NULL,
				  `category` varchar(255) NOT NULL,
				  `supplier_id` int(11) DEFAULT NULL,
				  `item_number` varchar(255) DEFAULT NULL,
				  `description` varchar(255) NOT NULL,
				  `cost_price` double(15,2) NOT NULL,
				  `unit_price` double(15,2) NOT NULL,
				  `quantity` double(15,2) NOT NULL DEFAULT '0.00',
				  `reorder_level` double(15,2) NOT NULL DEFAULT '0.00',
				  `item_id` int(10) NOT NULL AUTO_INCREMENT,
				  `allow_alt_description` tinyint(1) NOT NULL,
				  `is_serialized` tinyint(1) NOT NULL,
				  `deleted` int(1) NOT NULL DEFAULT '0',
				  `retailprice` varchar(255) DEFAULT NULL,
				  `source_store_id` int(11) NOT NULL,
				   PRIMARY KEY (`item_id`),
				   UNIQUE KEY `item_number` (`item_number`),
				   KEY `phppos_items_ibfk_1` (`supplier_id`)
				  ) 
				  ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=501 ;";
			
			$this->db->query($create_store_item,false,true);		
			
			$this->db->from('items');
			$this->db->where('deleted',0);
			$this->db->order_by("name", "asc");
			$itemsdata = $this->db->get()->result_array();
			foreach($itemsdata as $eachItem)
			{
				$eachItem_Array=array(
				'name'=>$eachItem['name'],
				'category'=>$eachItem['category'],
				'supplier_id'=>$eachItem['supplier_id'],
				'item_number'=>$eachItem['item_number'],
				'description'=>$eachItem['description'],
				'cost_price'=>$eachItem['cost_price'],
				'unit_price'=>$eachItem['unit_price'],
				'quantity'=>"",
				'reorder_level'=>$eachItem['reorder_level'],
				'item_id'=>$eachItem['item_id'],
				'allow_alt_description'=>$eachItem['allow_alt_description'],
				'is_serialized'=>$eachItem['is_serialized'],
				'deleted'=>$eachItem['deleted'],
				'retailprice'=>$eachItem['retailprice'],
				'item_id'=>$eachItem['item_id']
				);	
				$this->db->insert($store_name.'_storeitems',$eachItem_Array);
			}
			return $this->db->insert('stores',$store_save_data);
		}
	}
	
	function get_allStores()
	{
		$this->db->from('stores');
		//$this->db->where('status',1);
		//$this->db->order_by("name", "asc");
		$this->db->order_by("is_main", "desc");
		return $this->db->get();
	}
		
	function getStore($store_id)
	{
		$this->db->from('stores');
		$this->db->where('id',$store_id);
		$query = $this->db->get();

		if($query->num_rows()==1)
		{
			return $query->row();
		}
		else
		{
			//Get empty base parent object, as $item_id is NOT an item
			$item_obj=new stdClass();

			//Get all the fields from items table
			$fields = $this->db->list_fields('stores');

			foreach ($fields as $field)
			{
				$item_obj->$field='';
			}

			return $item_obj;
		}
	}
	
	function editStore(&$store_data,$store_id=false)
	{
		$this->db->where('id', $store_id);
		return $this->db->update('stores',$store_data);		
	}
	
	function changeStatus(&$store_data,$store_id=false)
	{
		$this->db->where('id', $store_id);
		return $this->db->update('stores',$store_data);		
	}
	
	function  get_theme_by_id($id)
	{
		$this->db->select('*');
		$this->db->from("eshop_theme");
		$this->db->where('id',$id);
		
		$query = $this->db->get();

		if($query->num_rows()==1)
		{
			return $query->row();
		}
		else
		{
			//Get empty base parent object, as $item_id is NOT an item
			$item_obj=new stdClass();

			//Get all the fields from items table
			$fields = $this->db->list_fields($this->store);

			foreach ($fields as $field)
			{
				$item_obj->$field='';
			}

			return $item_obj;
		}
	}
	
	function  get_pages()
	{
		$this->db->select('*');
		$this->db->from("eshop_pages");
		//$this->db->where('id',$id);
		
		$query = $this->db->get();
		return $query->result();
	}
	
	function  get_banner()
	{
		$this->db->select('*');
		$this->db->from("eshop_banners");
		$this->db->where('deleted',0);
		$this->db->order_by("id", "desc");
		
		$query = $this->db->get();
		return $query->result();
	}
	
	function  get_page_by_id($id)
	{
		$this->db->select('*');
		$this->db->from("eshop_pages");
		$this->db->where('id',$id);
		
		$query = $this->db->get();

		if($query->num_rows()==1)
		{
			return $query->row();
		}
		/*else
		{
			//Get empty base parent object, as $item_id is NOT an item
			$item_obj=new stdClass();

			//Get all the fields from items table
			$fields = $this->db->list_fields($this->store);

			foreach ($fields as $field)
			{
				$item_obj->$field='';
			}

			return $item_obj;
		}*/
	}
	
	function  get_eshop_setting()
	{
		$this->db->select('*');
		$this->db->from("eshop_settings");
		//$this->db->where('id',$id);
		
		$query = $this->db->get();
        return $query->result();
	}
	
	function  get_theme()
	{
		$this->db->select('*');
		$this->db->from("eshop_theme");
		//$this->db->where('id',$id);
		
		$query = $this->db->get();
        return $query->result();
	}
	
	/*Start Payment Device Changes*/ 
	/*Get Payment Device*/
	function get_payment_device($device_id="")
	{
		$this->db->select('*');
		$this->db->dbprefix = "settings_"; 
		$this->db->from("payments_devices");
		if(empty($device_id))
		{
			$this->db->where('device_status',1);
		}
		else
		{
			$this->db->where('device_id',$device_id);
		}
		$query = $this->db->get();
		$this->db->dbprefix = "opos_"; 
        return $query->row();
	}
	/*End Payment Device Changes*/ 
}
?>