<?php
class Item extends Model
{
	
	/*
	Set Store Table
	*/
	public $store;
	function setStore($store)
	{
		$this->store=$store;
	}
	/*
	Determines if a given item_id is an item
	*/
	function exists($item_id)
	{
		$this->db->from($this->store);
		$this->db->where('item_id',$item_id);
		$query = $this->db->get();

		return ($query->num_rows()==1);
	}

	/*
	Returns all the items
	*/
	function get_all($limit="",$offset="",$limited=0)
	{
		$this->db->from($this->store);
		$this->db->where('deleted',0);
		$this->db->order_by("name", "asc");
		if($limited==1)$this->db->limit($limit, $offset);
		return $this->db->get();
	}
	
	
	function get_StoreItems($source_store,$limit="",$offset="",$limited=0)
	{
		//$this->db->from($this->store);
		if($source_store=="main")
		{
		$this->db->from($this->store);
		}
		else
		{
		$this->db->from($source_store.'_storeitems');
		//$this->db->join($source_store.'_storeitems', $source_store.'_storeitems.item_id = items.item_id');	
			
		}
		
		$this->db->where('deleted',0);
		$this->db->order_by("name", "asc");
		if($limited==1)$this->db->limit($limit, $offset);
		return $this->db->get();
	}
	
	function getfiltered($low_inventory=0,$is_serialized=0,$no_description,$instock=0,$outstock=0,$negstock=0,$fastmov=0,$slowmov=0,$nonmov=0)
	{
		$this->db->from($this->store);
		
		if ($low_inventory !=0 )
		{
			$this->db->where('quantity <=','reorder_level');
		}
		if ($is_serialized !=0 )
		{
			$this->db->where('is_serialized',1);
		}
		if ($no_description!=0 )
		{
			$this->db->where('description','');
		}
		$this->db->where('deleted',0);
		if($instock!=0)
		{
			
		//$this->db->from('phppos_sales_items,sales');
		$this->db->join('phppos_sales_items','phppos_items.item_id=phppos_sales_items.item_id');
		$this->db->join('phppos_sales','phppos_sales_items.sale_id=phppos_sales.sale_id');
			$this->db->where('phppos_items.quantity >0');
			}
		if($outstock!=0)
		{
		$this->db->join('phppos_sales_items','phppos_items.item_id=phppos_sales_items.item_id');
		$this->db->join('phppos_sales','phppos_sales_items.sale_id=phppos_sales.sale_id');
			$this->db->where('phppos_items.quantity',0);
			}
		
		if($negstock!=0)
		{
		$this->db->join('phppos_sales_items','phppos_items.item_id=phppos_sales_items.item_id');
		$this->db->join('phppos_sales','phppos_sales_items.sale_id=phppos_sales.sale_id');
			$this->db->where('phppos_items.quantity <0');
			}
		if($fastmov!=0)
		{
		$this->db->join('phppos_sales_items','phppos_items.item_id=phppos_sales_items.item_id');
		$this->db->join('phppos_sales','phppos_sales_items.sale_id=phppos_sales.sale_id');
			$this->db->where('datediff(now(),phppos_sales.sale_time)>15');
			}
		if($slowmov!=0)
		{
$this->db->join('phppos_sales_items','phppos_items.item_id=phppos_sales_items.item_id');
		$this->db->join('phppos_sales','phppos_sales_items.sale_id=phppos_sales.sale_id');
			$this->db->where('datediff(now(),phppos_sales.sale_time)<15');
			}
		if($nonmov!=0)
		{
		
	$this->db->join('phppos_sales_items','phppos_items.item_id=phppos_sales_items.item_id');
		$this->db->join('phppos_sales','phppos_sales_items.sale_id=phppos_sales.sale_id');
			$this->db->where('datediff(now(),phppos_sales.sale_time)>=30');
			}
		
		$this->db->order_by("name", "asc");
		
		
		
		return $this->db->get();
		
	}
	function get_all_filtered($low_inventory=0,$is_serialized=0,$no_description)
	{
		$this->db->from($this->store);
		if ($low_inventory !=0 )
		{
			$this->db->where('quantity <=','reorder_level');
		}
		if ($is_serialized !=0 )
		{
			$this->db->where('is_serialized',1);
		}
		if ($no_description!=0 )
		{
			$this->db->where('description','');
		}
		$this->db->where('deleted',0);
		$this->db->order_by("name", "asc");
		return $this->db->get();
	}

	/*
	Gets information about a particular item
	*/
	function get_info($item_id)
	{
		$this->db->from($this->store);
		$this->db->where('item_id',$item_id);
		
		$query = $this->db->get();

		if($query->num_rows()==1)
		{
			return $query->row();
		}
		else
		{
			//Get empty base parent object, as $item_id is NOT an item
			$item_obj=new stdClass();

			//Get all the fields from items table
			$fields = $this->db->list_fields($this->store);

			foreach ($fields as $field)
			{
				$item_obj->$field='';
			}

			return $item_obj;
		}
	}
	
	function get_Store_info($source_store,$item_id)
	{
		$this->db->from($source_store.'_storeitems');
		$this->db->where('item_id',$item_id);
		
		$query = $this->db->get();

		if($query->num_rows()==1)
		{
			return $query->row();
		}
		else
		{
			//Get empty base parent object, as $item_id is NOT an item
			$item_obj=new stdClass();

			//Get all the fields from items table
			$fields = $this->db->list_fields($this->store);

			foreach ($fields as $field)
			{
				$item_obj->$field='';
			}

			return $item_obj;
		}
	}

	/*
	Get an item id given an item number
	*/
	function get_item_id($item_number)
	{
		$this->db->from($this->store);
		//$this->db->where('item_number',$item_number);
		$this->db->where(array('item_number' => $item_number ,'status' => 1));

		$query = $this->db->get();

		if($query->num_rows()==1)
		{
			return $query->row()->item_id;
		}

		return false;
	}

	/*
	Gets information about multiple items
	*/
	function get_multiple_info($item_ids)
	{
		$this->db->from($this->store);
		$this->db->where_in('item_id',$item_ids);
		$this->db->order_by("item", "asc");
		return $this->db->get();
	}

	/*
	Inserts or updates a item
	*/
	function save(&$item_data,$item_id=false,$source_store=false)
	{   	
		$this->db->from("stores");
		$query = $this->db->get();
		$stores = $query->result();
		
		$item_addsubstore = array
					(
						'name'=>$item_data['name'],
						'description'=>$item_data['description'],
						'category'=>$item_data['category'],
						'category_id'=>$item_data['category_id'],
						'supplier_id'=>$item_data['supplier_id'],
						'item_number'=>$item_data['item_number'],
						'cost_price'=>$item_data['cost_price'],
						'retailprice'=>$item_data['retailprice'],
						'attribute_id'=>$item_data['attribute_id'],
						'unit_price'=>$item_data['unit_price'],
						'quantity'=>0,
						'reorder_level'=>$item_data['reorder_level'],
						'allow_alt_description'=>$item_data['allow_alt_description'],
						'is_serialized'=>$item_data['is_serialized']
						
					);	
		$item_editsubstore = array
					(
						'name'=>$item_data['name'],
						'description'=>$item_data['description'],
						'category'=>$item_data['category'],
						'category_id'=>$item_data['category_id'],
						'supplier_id'=>$item_data['supplier_id'],
						'item_number'=>$item_data['item_number'],
						'cost_price'=>$item_data['cost_price'],
						'retailprice'=>$item_data['retailprice'],
						'unit_price'=>$item_data['unit_price'],
						'attribute_id'=>$item_data['attribute_id'],
						'reorder_level'=>$item_data['reorder_level'],
						'allow_alt_description'=>$item_data['allow_alt_description'],
						'is_serialized'=>$item_data['is_serialized']
						
					);				
						
		if (!$source_store || $source_store=="main" || $source_store=="None")
		{
			if (!$item_id or !$this->exists($item_id))
			{
				if($this->db->insert($this->store,$item_data))
				{
				
					$item_data['item_id']=$this->db->insert_id();
					foreach($stores as $store)
					{	
						$this->db->insert($store->name.'_storeitems',$item_addsubstore);
					}
					return true;
				}
				return false;
			}
			 
			foreach($stores as $store)  
			{	
				$this->db->where('item_id', $item_id);
				$this->db->update($store->name.'_storeitems',$item_editsubstore);
			}
			$this->db->where('item_id',$item_id);
			return $this->db->update($this->store,$item_data);
		}
		else
		{
			if (!$item_id or !$this->exists($item_id))
			{
				if($this->db->insert($source_store.'_storeitems',$item_data))
				{
				
					$item_data['item_id']=$this->db->insert_id();
					foreach($stores as $store)
					{	
						$this->db->insert($store->name.'_storeitems',$item_addsubstore);
					}

					return true;
				}
				return false;
			}

			foreach($stores as $store)
			{	
				$this->db->where('item_id', $item_id);
				$this->db->update($store->name.'_storeitems',$item_editsubstore);
			}
			$this->db->where('item_id', $item_id);
			return $this->db->update($this->store,$item_data);
		}
	}
	/*
	Updates sale item
	*/
	function save_sale_item(&$item_data,$item_id=false)
	{   	
		$this->db->where('item_id',$item_id);
		return $this->db->update($this->store,$item_data);
	}
	/*
	Inserts or updates a Import items
	*/
	function save_importdata(&$item_data,$item_number=false,$source_store=false)
	{
		
		if($source_store=="None" || $source_store=="main")$table = $this->store; else $table = $source_store.'_storeitems';
		$this->db->from($table);
		$this->db->where('item_number',$item_number);
		$query = $this->db->get();
		$exist = $query->num_rows();
		if (!$item_number or !$exist)
		{//return "Insert";
			if($this->db->insert($table,$item_data))
			{
			
				$item_data['item_id']=$this->db->insert_id();
				return true;
			}
			return false;
		}
		else
		{
		$this->db->where('item_number', $item_number);
			if($this->db->update($this->store,$item_data))
			{			
			$item_data['item_id']=$this->get_item_id($item_number);
			return true;
			}
			return false;
		}
	}
	/*
	Updates multiple items at once
	*/
	function update_multiple($item_data,$item_ids)
	{
		$this->db->where_in('item_id',$item_ids);
		return $this->db->update($this->store,$item_data);
	}

	/*
	Deletes one item
	*/
	function delete($item_id)
	{
		$this->db->where('item_id', $item_id);
		return $this->db->update($this->store, array('deleted' => 1));
	}

	/*
	Deletes a list of items
	*/
	function delete_list($item_ids)
	{
		$this->db->where_in('item_id',$item_ids);
		return $this->db->update($this->store, array('deleted' => 1));
 	}
	
	
	

 	/*
	Get search suggestions to find items
	*/
	function get_search_suggestions($search,$limit=25)
	{
		$suggestions = array();

		$this->db->from($this->store);
		$this->db->like('name', $search);
		$this->db->where('deleted',0);
		$this->db->order_by("name", "asc");
		$by_name = $this->db->get();
		foreach($by_name->result() as $row)
		{
			$suggestions[]=$row->name;
		}

		$this->db->select('category');
		$this->db->from($this->store);
		$this->db->where('deleted',0);
		$this->db->distinct();
		$this->db->like('category', $search);
		$this->db->order_by("category", "asc");
		$by_category = $this->db->get();
		foreach($by_category->result() as $row)
		{
			$suggestions[]=$row->category;
		}

		$this->db->from($this->store);
		$this->db->like('item_number', $search);
		$this->db->where('deleted',0);
		$this->db->order_by("item_number", "asc");
		$by_item_number = $this->db->get();
		foreach($by_item_number->result() as $row)
		{
			$suggestions[]=$row->item_number;
		}


		//only return $limit suggestions
		if(count($suggestions > $limit))
		{
			$suggestions = array_slice($suggestions, 0,$limit);
		}
		return $suggestions;

	}

	function get_item_search_suggestions($search,$limit=25)
	{
		$suggestions = array();

		$this->db->from($this->store);
		//$this->db->where('deleted',0); // comment this line to sync status(active item of inventory management section with  POS) 
		$this->db->where(array('deleted' => 0 ,'status' => 1));
		$this->db->like('name', $search);
		$this->db->order_by("name", "asc");
		$by_name = $this->db->get();
		foreach($by_name->result() as $row)
		{
			//$suggestions[]=$row->item_id.'|'.$row->name;
			if(!empty($row->name) || !empty($row->item_number))$suggestions[]=$row->item_id.'|'.drop_multiple_slashes($row->name);
		}

		$this->db->from($this->store);
		//$this->db->where('deleted',0); // comment this line to sync status(active item of inventory management section with  POS) 
		$this->db->where(array('deleted' => 0 ,'status' => 1));
		$this->db->like('item_number', $search);
		$this->db->order_by("item_number", "asc");
		$by_item_number = $this->db->get();
		foreach($by_item_number->result() as $row)
		{
			//$suggestions[]=$row->item_id.'|'.$row->item_number;
			if(!empty($row->name) || !empty($row->item_number))$suggestions[]=$row->item_id.'|'.drop_multiple_slashes($row->item_number);
		}

		//only return $limit suggestions
		if(count($suggestions > $limit))
		{
			$suggestions = array_slice($suggestions, 0,$limit);
		}
		return $suggestions;

	}

	function get_category_suggestions($search)
	{
		$suggestions = array();
		$this->db->distinct();
		$this->db->select('category');
		$this->db->from($this->store);
		$this->db->like('category', $search);
		$this->db->where('deleted', 0);
		$this->db->order_by("category", "asc");
		$by_category = $this->db->get();
		foreach($by_category->result() as $row)
		{
			$suggestions[]=$row->category;
		}

		return $suggestions;
	}

	/*
	Preform a search on items
	*/
	function search($search)
	{
		$this->db->from($this->store);
		
		$this->db->where("(name LIKE '%".$this->db->escape_like_str($search)."%' or 
		item_number LIKE '%".$this->db->escape_like_str($search)."%' or 
		category LIKE '%".$this->db->escape_like_str($search)."%') and deleted=0");
		$this->db->order_by("name", "asc");
		return $this->db->get();	
	}
	
	function searchStoreItem($source_store,$search)
	{
		$this->db->from($source_store.'_storeitems');
		$this->db->where("(name LIKE '%".$this->db->escape_like_str($search)."%' or 
		item_number LIKE '%".$this->db->escape_like_str($search)."%' or 
		category LIKE '%".$this->db->escape_like_str($search)."%') and deleted=0");
		$this->db->order_by("name", "asc");
		return $this->db->get();	
	}

	function get_categories()
	{
		$this->db->select('category');
		$this->db->from($this->store);
		$this->db->where('deleted',0);
		$this->db->distinct();
		$this->db->order_by("category", "asc");

		return $this->db->get();
	}
	
	/*
	Returns all the Assign items
	*/
	function get_Assign_Items($source_store,$des_store_one,$des_store_two ,$limit="",$offset="",$limited=0)
	{
		if($source_store=="main")
		{
		$this->db->from($this->store);
		}
		else
		{
		$this->db->from($source_store.'_storeitems');
		//$this->db->join($source_store.'_storeitems', $source_store.'_storeitems.item_id = items.item_id');		
		}
		
		$this->db->where('deleted',0);
		$this->db->order_by("name", "asc");
		if($limited==1)$this->db->limit($limit, $offset);
		return $this->db->get();
	}
	
	function get_Store_Item($store_table,$item_id) 
	{
		if($store_table=="main")$this->db->from($this->store); else $this->db->from($store_table.'_storeitems');
		
		if($this->db->get())
		{
		//$query_All->num_rows();
		if($store_table=="main")$this->db->from($this->store); else $this->db->from($store_table.'_storeitems');
		$this->db->where('item_id',$item_id);
		//return $this->db->get()->result_array();
		
		$query = $this->db->get();

		if($query->num_rows()==1)
		{
			return $query->result_array();
		}
		else
		{
			//Get empty base parent object, as $item_id is NOT an item
			/*$item_obj=new stdClass();

			//Get all the fields from items table
			$fields = $this->db->list_fields($store_table.'_storeitems');

			foreach ($fields as $field)
			{
				$item_obj->$field='';
			}

			return $item_obj;
*/		
			return array();
		}
		
		}
		else
		{
			return array();
		}
		
	}
	
	function existsStoreItem($store_table,$item_id)
	{
		$this->db->from($store_table.'_storeitems');	
		$this->db->where('item_id',$item_id);
		$query = $this->db->get();
		if($query)
		return ($query->num_rows()==1);
	}
	
	function saveStoreQuantity($item_id,$des_store_one,$des_store_two,$item_data_one,$item_data_two) 
	{
		if($this->existsStoreItem($des_store_one,$item_id))
		{
			$this->db->where('item_id', $item_id);
			$store_one_status = $this->db->update($des_store_one.'_storeitems',$item_data_one);
		}
		else
		{
			$store_one_status = $this->db->insert($des_store_one.'_storeitems',$item_data_one);
			
		}
		
		
		if($this->existsStoreItem($des_store_two,$item_id))
		{
			$this->db->where('item_id', $item_id);
			$store_two_status = $this->db->update($des_store_two.'_storeitems',$item_data_two);
		}
		else
		{
			$store_two_status = $this->db->insert($des_store_two.'_storeitems',$item_data_two);
		}
		
		
		return $store_one_status.$store_two_status;
	}
	
	function changeSourceQuantity($item_id,$item_data,$source_store) 
	{
		
		$this->db->where('item_id', $item_id);
		if($source_store=="main")$table=$this->store; else $table=$source_store.'_storeitems';
		return $this->db->update($table,$item_data);
	}
	
	
	
	
	function get_category($limit="",$offset="",$limited=0)
	{
		
		
		
		$this->db->select('*');
		$this->db->from("category");
		$this->db->like('parent',0  );
		$this->db->where('deleted',0);
		
	//	$this->db->distinct();
		$this->db->order_by("id", "asc");
		if($limited==1)$this->db->limit($limit, $offset);

		return $this->db->get();
		
	}
	

	
	
	
	function  get_category_by_id($cate_id)
	{
		$this->db->select('*');
		$this->db->from("category");
		$this->db->where('id',$cate_id);
		
		$query = $this->db->get();

		if($query->num_rows()==1)
		{
			return $query->row();
		}
		else
		{
			//Get empty base parent object, as $item_id is NOT an item
			$item_obj=new stdClass();

			//Get all the fields from items table
			$fields = $this->db->list_fields($this->store);

			foreach ($fields as $field)
			{
				$item_obj->$field='';
			}

			return $item_obj;
		}
	}
	
	
	function deletecate_list($cate_ids)
	{
		//echo "sdsd".$cate_ids;
		
		$this->db->where_in('id',$cate_ids);
		return $this->db->update('category', array('deleted' => 1));
 	}
	
	
	
	function deleteattributes_list($cate_ids)
	{
		//echo "sdsd".$cate_ids;
		
		$this->db->where_in('id',$cate_ids);
		return $this->db->update('attributes', array('deleted' => 1));
 	}
	
	
		function deleteoption_list($cate_ids)
	{
		//echo "sdsd".$cate_ids;
		
		$this->db->where_in('id',$cate_ids);
		return $this->db->update('attributes', array('deleted' => 1));
 	}
	
	
	
	
	function get_subcategory($parent)
	{
		
		$this->db->select('*');
		$this->db->from("category");
		$this->db->like('parent',$parent);
		$this->db->where(array('deleted' => 0 ));
		
		$this->db->order_by("id", "asc");
		return $this->db->get();
		
	}
	
	
	
	
	
	function get_attributes($limit="",$offset="",$limited=0)
	{
		
		
		
		$this->db->select('*');
		$this->db->from("attributes");
	    $this->db->like('parent',0  );
		$this->db->where(array('deleted' => 0 ));
	//	$this->db->distinct();
		$this->db->order_by("id", "asc");
		if($limited==1)$this->db->limit($limit, $offset);

		return $this->db->get();
		
	}
	
		function get_option($parent)
	{  
		
		$this->db->select('*');
		$this->db->from("attributes");
		$this->db->like('parent',$parent);
		$this->db->where(array('deleted' => 0 ));
		
		$this->db->order_by("id", "asc");
		return $this->db->get();
		
	}
	
	/*
	Returns all the images of item
	*/
	function get_item_images($item_id=-1)
	{
		$this->db->from("item_images");
		$this->db->where('item_id',$item_id);
		//$this->db->order_by("name", "asc");
		//if($limited==1)$this->db->limit($limit, $offset);
		return $this->db->get();
	}
	
	
}
?>