<?php
$pay_now_payment_type_cash = $this->lang->line('sales_cash');
$pay_now_payment_type_credit = $this->lang->line('sales_credit');
$pay_now_payment_type_giftcard = $this->lang->line('sales_giftcard');

$card_info_available = false;
if($mode == "sale")
{
    $card_info = $this->Gateways->get_default_gateway()->result();

    if(count($card_info) > 0)
    {
        $card_info = $card_info[0];
        if(($card_info->enable == 1 && $card_info->MUinfo != "" && $card_info->MUkey != "") && ($card_info->gateway_id == 2 || $card_info->gateway_id == 7))
            $card_info_available = true;
    }
}
?>
<div class="cp-modal">
	<div id="pay_now_modal" class="modal fade" role="dialog">
    	<div class="modal-dialog modal-md">
        	<div class="modal-content">
            	<!-- Modal body-->
            	<div class="modal-body">
                	<div class="row">
                        <div class="col-md-12 text-right mb-3">
                       		<div class="form-group">
                				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                            </div>    
                        </div>
                    </div>  
              		<div class="row">
                        <div class="pos-box-outer-container">
                            <ul class="cards cards-pos-box-container">
                                <li class="cards-item <?=($card_info_available ? '':'disabled_payment_type')?>">
                                    <!--<div class="card pay_now_payment_type"  data-pay_now_payment_type="credit">-->
                                    <div class="card pay_now_payment_type <?=($card_info_available ? '':'disabled')?>" data-pay_now_payment_type="<?=$pay_now_payment_type_credit?>" data-pay_now_payment_type_box="credit">
                                        <div class="pos-icon-container">
                                            <img class="img-responsive" src="<?=RDIR;?>images/panel_images/card.png"/>
                                        </div>
                                        <div class="card-content">
                                            <div class="card-title">
                                                Card
                                            </div>
                                        </div>
                                    </div>
                                </li> 
                                <li class="cards-item">
                                    <!--<div class="card pay_now_payment_type"  data-pay_now_payment_type="cash">-->
                                    <div class="card pay_now_payment_type" data-pay_now_payment_type="<?=$pay_now_payment_type_cash?>" data-pay_now_payment_type_box="cash">
                                        <div class="pos-icon-container">
                                            <img class="img-responsive" src="<?=RDIR;?>images/panel_images/cash.png"/>
                                        </div>
                                        <div class="card-content">
                                            <div class="card-title">
                                                Cash
                                            </div>
                                        </div>
                                    </div>
                                </li> 
                                <!-- <li class="cards__item">
                                    <div class="card pay_now_payment_type" data-pay_now_payment_type="<?=$pay_now_payment_type_giftcard?>" data-pay_now_payment_type_box="gift">
                                        <div class="pos-icon-container">
                                            <img class="img-responsive" src="<?=RDIR;?>images/panel_images/gift.png"/>
                                        </div>
                                        <div class="card__content">
                                            <div class="card__title">
                                                Gift
                                            </div>
                                        </div>
                                    </div>
                                </li>  --> 
                            </ul>
                        </div>
              		</div>
                    <!--<div class="row">&nbsp;</div>-->
                    <div class="row pay_now_total_amount_value_box">
                        <div class="col-md-12 text-center">
                            <h2 id="pay_now_total_amount_value" data-pay_now_total_amount_value="<?=$total_amount?>"><?php echo to_currency($total_amount); ?></h2>
                            <h4>Amount Due</h4>
                        </div>
                    </div>  
                    <div class="row text-center hidden pay_now_payment_type_box pay_now_payment_type_credit">
                        <?php
                        if($gateway_id == 7)
                        {
                        ?>
                        <div class="col-md-12 text-success pay_now_payment_type_credit_process pay_now_payment_type_credit_before_process pay_now_payment_type_credit_processing hidden"><i class="fas fa-spinner fa-spin"></i> Processing ...</span></div>
                        <div class="col-md-12 text-success pay_now_payment_type_credit_process pay_now_payment_type_credit_after_process pay_now_payment_type_credit_processing_response hidden">
                        </div>
                        <div class="col-md-12 pay_now_payment_type_credit_process pay_now_payment_type_credit_processing_newsale_and_tryagain_btn hidden">
                            <div class="row">
                                <div class="col-md-6">
                                    <button type="button" class="btn btn-default btn btn-default mt-3 mb-3" id="pay_now_payment_type_show_all_payment_buttons">Try Again</button>
                                </div>
                                <div class="col-md-6">
                                    <button type="button" class="btn btn-default btn btn-default mt-3 mb-3" id="pay_now_payment_type_start_new_sale">New Sale</button>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-12 text-body text-light pay_now_payment_type_credit_process pay_now_payment_type_credit_before_process pay_now_payment_type_credit_card_actions hidden">Insert , Swipe or Tap Payment</div>
                        <div class="col-md-12 text-body text-light pay_now_payment_type_credit_process pay_now_payment_type_credit_after_process pay_now_payment_type_credit_other_options">
                            <div class="row">
                                <div class="col-md-12 pay_now_payment_type_credit_chose_device">
                                    <div class="">
                                        <button type="button" class="btn btn-default btn-block pay_now_payment_type_credit_initiate_manual_payment">Manual Payment</button>
                                    </div>
                                	<?php
									if($this->Gateways->get_gateway_devices($gateway_id)->num_rows()>0)
									{
									?>
										<!-- <div class="row d-flex justify-content-center"> -->
										<?php
										foreach ($this->Gateways->get_gateway_devices($gateway_id)->result() as $gateway_device){
											$device_id = $gateway_device->device_id;
											$device_name = $gateway_device->device_name;
											?>
											<div class="">
												<button type="button" class="btn btn-default btn-block pay_now_payment_type_credit_initiate_device" data-pay_now_payment_type_credit_device_id="<?=$device_id?>" data-pay_now_payment_type_credit_device_name="<?=$device_name?>"><?=$device_name?></button>
											</div>
											<?php
										}
										?>
										<!-- </div> -->
									<?php
									}
									else
									{
									?>
                                    	<!-- <button type="button" class="btn btn-default btn btn-default mt-3 mb-3" id="pay_now_payment_type_credit_retry_transaction">Try Again</button> -->
                                    <?php
									}
									?>
                                </div>
                                <!-- <div class="col-md-12 pay_now_payment_type_credit_manual_entry">
                                    <div class="row">
                                        <div class="col-md-12">
                                        	<form name="pay_now_payment_type_credit_manual_entry_form" id="pay_now_payment_type_credit_manual_entry_form"  method="post" class="pay_now_payment_type_credit_manual_entry_form" role="form" >
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="form-group pay_now_payment_type_credit_manual_entry_containers pay_now_payment_type_credit_manual_entry_card_number_container h-75" id="cardNumberContainer">
                                                        <label for="cardNumberContainer" class="w-100 text-left">Card Number</label>	
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group pay_now_payment_type_credit_manual_entry_containers pay_now_payment_type_credit_manual_entry_card_expiration_date_container h-75" id="expirationDateContainer">
                                                        <label for="expirationDateContainer" class="w-100 text-left">Card Expiration Date <small>(mm/dd)</small></label>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group pay_now_payment_type_credit_manual_entry_containers pay_now_payment_type_credit_manual_entry_card_security_code_container h-75" id="securityCodeContainer">
                                                        <label for="securityCodeContainer" class="w-100 text-left">Card Security Code</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-12">
                                                	<div class="form-group pay_now_payment_type_credit_manual_entry_containers pay_now_payment_type_credit_manual_entry_amount_container" id="amountContainer"></div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <button type="button" class="btn btn-default pay_now_payment_type_credit_manual_entry_button" id="pay_now_payment_type_credit_manual_entry_button">Pay</button>
                                                    </div>
                                                </div>
                                            </div>
                                            </form>
                                        </div>
                                    </div>
                                </div> -->
                            </div>
                        </div>
                        <div class="col-md-12 mb-2 pay_now_payment_type_credit_process pay_now_payment_type_credit_after_process pay_now_payment_type_credit_amount_charged hidden"><h5>Amount Charged : <?php echo to_currency($total_amount); ?></h5></div>
                        <?php
						if($this->Appconfig->get('sales_tips'))
						{
						?>
                        <div class="col-md-12 mb-3 pay_now_payment_type_credit_process pay_now_payment_type_credit_after_process pay_now_payment_type_credit_tips hidden">
                            <div class="row d-flex justify-content-center">
                            <?php
                            foreach ($this->Sale->get_tips()->result() as $tip){
                                $tip_id = $tip->id;
                                $tip_name = $tip->name;
                                $tip_value = $tip->value;
                                $tip_status = $tip->status;
								$tip_amount = ($total_amount*$tip_value)/100;
                                ?>
                                <div class="col-md-3 col-6">
                                    <!--<div class="card p-2 d-flex justify-content-center">-->
                                    <button type="button" class="btn btn-light" data-pay_now_payment_type_credit_tip_value="<?=$tip_value?>" data-pay_now_payment_type_credit_tip_amount="<?=$tip_amount?>">
                                    <?=$tip_name?>
                                    <?php
									if(!empty($tip_value))
									{
										?>
										<br />
										<?=to_currency($tip_amount)?>
										<?php
									}
									?>
                                    <!--</div>-->
                                    </button>
                                </div>
                                <?php
                            }
                            ?>
                            </div>
                        </div>
                        <div class="col-md-12 pay_now_payment_type_credit_process pay_now_payment_type_credit_total_amount_charged hidden"><h5>Total Amount Charged : <span class="pay_now_total_amount_charged_value"><?php echo to_currency($total_amount); ?></span></h5></div>
                        <?php
						}
						?>
                        <div class="col-md-12 pay_now_payment_type_credit_process pay_now_payment_type_credit_after_process pay_now_payment_type_credit_accept hidden">
                            <div class="form-group">
                                <button type="button" class="btn btn-default pay_now_complete_sale_button" id="pay_now_complete_sale_button">Accept</button>                            </div>
                        </div>
                        <?php
                        }
                        else if($gateway_id == 2)
                        {
                        ?>
                        <div class="col-lg-10 offset-lg-1 text-left">
                            <hr>
                            <div class="row">
                                <div class="col-lg-8 text-left">
                                    <label style="margin-top:10px" class="control-label">
                                    <img src="https://resto-support.lightspeedhq.com/hc/article_attachments/360013404934/idynamo.jpeg" width="40px">
                                    <b>Scan Card Via iDynamo?</b> 
                                    </label>
                                </div>
                                <div class="col-lg-4 text-right">
                                    <button type="submit" class="btn btn-block btn-default scan_card_via_idynamo">Scan</button>

                                    <label class="control-label idynamo_scanning_area text-success hidden" style="margin-top: 10px;">
                                        <i class="fas fa-spinner fa-spin"></i> Scanning...
                                    </label>
                                </div>
                            </div>
                            <hr>

                            <form id="idynamo_form">
                            <div class="row">
                                <div class="col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label" for="cc_no">Card Number</label>
                                        <?php echo form_input(array('name'=>'','class'=>'form-control','style'=>'','id'=>'idynamo_form_field_ccno_mask','value'=>''),'','');?>
                                        <input type="hidden" name="cc_no" id="idynamo_form_field_ccno">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <?php
                                $cc_months = array(""=>"Month","01"=>"01","02"=>"02","03"=>"03","04"=>"04","05"=>"05","06"=>"06","07"=>"07","08"=>"08","09"=>"09","10"=>"10","11"=>"11","12"=>"12");
                                ?>
                                <div class="col-xs-6">
                                    <div class="form-group">
                                        <label class="control-label" for="cc_year_month">Card Expiry</label>
                                        <?php echo form_dropdown('cc_month',$cc_months,'','class="form-control" style="" id="" '); ?>
                                        <!-- <div style="clear:both" id="cc_expiry_month_error"></div> -->
                                    </div>
                                </div>

                                <?php
                                //$cc_years = array(""=>"Year","01"=>"01","02"=>"02","03"=>"03","04"=>"04","05"=>"05","06"=>"06","07"=>"07","08"=>"08","09"=>"09","10"=>"10","11"=>"11","12"=>"12");
                                $cc_years = array();
                                $cc_years[""]="Year";
                                $year = date("Y")-1;
                                $year_display = date("Y")-1;
                                //if($gateway_id==1 || $gateway_id==6){$year = date("Y")-1;}else {$year = date("y")-1;} 
                                for ($i = 1; $i <= 11; $i++) {$year++;$year_display++;$cc_years[$year]=$year_display;}
                                ?>
                                <div class="col-xs-6">
                                    <div class="form-group">
                                        <label class="control-label" for="cc_year_month">&nbsp;</label>
                                        <?php echo form_dropdown('cc_year',$cc_years,'','class="form-control" style="" id="" ');?>
                                        <!-- <div style="clear:both" id="cc_expiry_year_error"></div> -->
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="control-label" for="cc_cvv">Card CVV</label>
                                        <?php echo form_input(array('name'=>'cc_cvv','class'=>'form-control','style'=>'','id'=>'','value'=>''),'','');?>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <button type="button" class="btn btn-block btn-default cancel_idynamo_payment">Cancel</button> 
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-block btn-default" id="paynow_via_idynamo_payment">Pay</button> 
                                    </div>
                                </div>                                
                            </div>

                            </form>
                        </div>
                        <?php
                        }
                        ?>
                    </div>
                    <div class="row hidden pay_now_payment_type_box pay_now_payment_type_cash">
                        <div class="col-md-4 text-center pay_now_payment_type_cash_key_pad pay_now_payment_type_cash_amount_pad">
                            <div class="row">
                                <div class="col-md-12">
                                    <button type="button" class="btn">$ 5</button>
                                    <button type="button" class="btn">$ 10</button>
                                </div>
                            </div>
                            <div class="row mt-1">
                                <div class="col-md-12">
                                    <button type="button" class="btn">$ 20</button>
                                    <button type="button" class="btn">$ 50</button>
                                </div>
                            </div>
                            <div class="row mt-1">
                                <div class="col-md-12">
                                    <div class="form-group">	
                                        <button type="button" class="btn">$ 100</button>
                                    </div>
                                </div>
                            </div>
                            <?php 
                            if(!$open_cash_drawer_after_alltransaction)
                            {
                            ?>
                            <div class="row mt-1">
                                <div class="col-md-12">
                                    <div class="form-group">    
                                        <button type="button" class="btn btn-block pay_now_modal_open_cash_drawer_btn" style="width:100%">Cash Drawer</button>
                                    </div>
                                </div>
                            </div>
                            <?php
                            }
                            ?>
                        </div>
                        <div class="col-md-4 text-center pay_now_payment_type_cash_key_pad pay_now_payment_type_cash_number_pad">
                            <div class="row">
                                <div class="col-md-12">
                                    <button type="button" class="btn">1</button>
                                    <button type="button" class="btn">2</button>
                                    <button type="button" class="btn">3</button>
                                </div>
                            </div>
                            <div class="row mt-1">
                                <div class="col-md-12">
                                    <button type="button" class="btn">4</button>
                                    <button type="button" class="btn">5</button>
                                    <button type="button" class="btn">6</button>
                                </div>
                            </div>
                            <div class="row mt-1">
                                <div class="col-md-12">
                                    <button type="button" class="btn">7</button>
                                    <button type="button" class="btn">8</button>
                                    <button type="button" class="btn">9</button>
                                </div>
                            </div>
                            <div class="row mt-1">
                                <div class="col-md-12">
                                    <div class="form-group">	
                                        <button type="button" class="btn">.</button>
                                        <button type="button" class="btn" style="">0</button>
                                        <button type="button" class="btn pay_now_payment_type_cash_backspace"><img src="<?=ZCPPATH?>source/images/clear-symbol.png"></button>
                                    </div>
                                </div>
                            </div>
                        </div>            
                        <div class="col-md-4 text-center">
                            <div class="row">
                                <div class="col-md-12">
                                    <h4 class="pay_now_payment_type_cash_due_amount_value">Due : <?php echo to_currency($total_amount); ?></h4>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <?php /*?><input type="number" class="form-control pay_now_payment_type_cash_received  <?php echo $amount_tendered_class; ?>" id="pay_now_payment_type_cash_amount_tendered" name="pay_now_payment_type_cash_amount_tendered" value="<?php echo $amount_tendered_value; ?>"><?php */?>
                                        <input type="text" class="form-control pay_now_payment_type_cash_received  <?php echo $amount_tendered_class; ?>" id="pay_now_payment_type_cash_amount_tendered" name="pay_now_payment_type_cash_amount_tendered" value="<?php echo $amount_tendered_value; ?>">
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <h4>Change : <span class="pay_now_payment_type_cash_change_amount_value"><?php echo to_currency(0); ?></span></h4>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <button type="button" class="btn btn-block btn-default pay_now_complete_sale_button" id="pay_now_complete_sale_button">Pay</button> 
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- <div class="row hidden text-center pay_now_payment_type_box pay_now_payment_type_gift">
                        <div class="col-md-12 text-body text-light">Swipe Gift Card</div>
                    </div> -->
                    <div class="row hidden pay_now_payment_type_box pay_now_payment_type_gift text-center">
                        <div class="col-md-12 text-left">
                            <div class="form-group">
                                <label for="pay_now_payment_type_gift_card_number">Gift Card Number</label>
                                <input type="text" class="form-control" placeholder="Enter Card Number" name="pay_now_payment_type_gift_card_number" id="pay_now_payment_type_gift_card_number">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <button type="button" class="btn btn-default pay_now_complete_sale_button" id="pay_now_complete_sale_button">Pay</button>
                            </div>  	
                        </div>
                    </div>   
                    <div class="row hidden text-center pay_now_payment_complete_box">
                        <div class="col-md-12 text-success"><i class="fas fa-check"></i> Approved</div>
                        <div class="col-md-12 hide"><h5>Amount Charged : <span class="pay_now_total_amount_charged_value"><?php echo to_currency($total_amount); ?></span></h5></div>
                        <?php 
						if(($device_detect_type!="computer") && ($loginfromcp==2))
                        {
                        ?>
                        <script src="<?php echo base_url();?>js/cardiojs/main.js?<?=time()?>" type="text/javascript" language="javascript" charset="UTF-8"></script>
                        <?php
                        $sale_id_array = explode(" ",$sale_id);
                        }
                        ?>
                        <div class="col-md-12">
                        	<div class="form-group">
                            	<!--<a href="<?=base_url()."sales/receipt/-1"?>">-->
                                <?php if(($device_detect_type!="computer") && ($loginfromcp==2))
                                {?>
                                <a href="" id="pay_now_payment_complete_ios_print_button" ><button type="button" class="btn btn-default pay_now_payment_complete_button" >Print</button></a>
                              <?php 
							  }else{ ?>  
                              	<button type="button" class="btn btn-default pay_now_payment_complete_button" id="pay_now_payment_complete_print_button">Print</button>
							  <?php } ?>  
                                <!--</a> -->
                            </div>
                            <div class="form-group">
                            	<!--<button type="button" class="btn btn-default pay_now_payment_complete_button" id="pay_now_payment_complete_email_button">Email</button> -->
                                <?php if(isset($customer)){ ?>
                                 <a href="<?=base_url()?>sales/paynow_send_email/" id="pay_now_email_send" class="btn btn-default" data-toggle="tooltip" title="<?=$this->lang->line("Send Email")?>" style="margin-top:5px;">Email</a>
                                <?php } else{ ?>
                                <button type="button" class="btn btn-default" id="pay_now_payment_complete_email_button">Email</button>
                                <?php } ?>
                            </div>
                            <div class="form-group">
                            	<!--<a href="<?=base_url()."sales"?>">-->
                                	<button type="button" class="btn btn-default <?php /*?>pay_now_payment_complete_button<?php */?>" id="pay_now_payment_complete_skip_button">Skip</button>
                               <!-- </a> -->
                            </div>	
                        </div>
                    </div>
                   <!-- <div class="row paynow_cashsale_print hidden">  
                      <div class="col-md-12" id="paynow_cashsale_print_results"></div>
                    </div>-->
                    <div class="row hidden text-center pay_now_payment_complete_email_box">
                        <div class="col-md-12 text-success">Thank You !</div>
                        <div class="col-md-12">
                        	<form name="pay_now_payment_complete_email_form" id="pay_now_payment_complete_email_form"  method="post" class="pay_now_payment_complete_email_form" role="form" >
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6 text-left">
                                                <div class="form-group">
                                                    <label for="">First Name</label>
                                                    <input type="text" class="form-control" id="pay_now_customer_first_name" name="pay_now_customer_first_name" placeholder="First Name ...">
                                                </div>
                                            </div>
                                            <div class="col-md-6 text-left">
                                                <div class="form-group">
                                                    <label for="">Last Name</label>
                                                    <input type="text" class="form-control" id="pay_now_customer_last_name" name="pay_now_customer_last_name" placeholder="Last Name ...">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-lg-6 text-left">
                                                <div class="form-group addeditcustomer_group_error" id="phone_number_group">
                                                    <label class="control-label" for="pay_now_customer_phone">Phone Number</label>
                                                    <input type="text" class="form-control cp_text_fields" name="pay_now_customer_phone" id="pay_now_customer_phone" placeholder="Phone Number ...">
                                                </div>
                                            </div>
                                            <div class="col-md-6 text-left">
                                                <div class="form-group">
                                                    <label for="">Email Address</label>
                                                    <input type="text" class="form-control" id="pay_now_customer_email_address" name="pay_now_customer_email_address" placeholder="Email Address ...">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <button type="button" class="btn btn-default" id="pay_now_customer_email_send_button">Send</button>
                                        </div>
                                    </div>
                                    <div class="col-md-12 hidden">
                                        <div class="form-group form-check">
                                          <label class="form-check-label">
                                            <input class="form-check-input" type="checkbox" id="pay_now_customer_deals_and_promotions" name="pay_now_customer_deals_and_promotions"> 
                                            Deals and Promotions
                                          </label>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>   
            	</div>
          	</div>
            <div class="response-overlay hidden" id="pay_now_overlay"><i class="fa fa-refresh fa-spin"></i></div>
            <!-- /.modal-content -->
      	</div>
        <!-- /.modal-dialog -->
  	</div>
    <!-- /.modal -->
</div>
<!-- /.cp-modal -->

<!-- Manual payment modal start here -->
<div class="modal fade bd-example-modal-sm" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" id="pay_now_manual_payment_modal">
<div class="modal-dialog" role="document">
<div class="modal-content">
  <div class="modal-header">
    <h5 class="modal-title" id="exampleModalLabel">Manual Payment</h5>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
  </div>
  <div class="modal-body">
    <div class="col-md-12 pay_now_payment_type_credit_manual_entry text-center">
        <div class="row">
            <div class="col-md-12">
                <form name="pay_now_payment_type_credit_manual_entry_form" id="pay_now_payment_type_credit_manual_entry_form"  method="post" class="pay_now_payment_type_credit_manual_entry_form" role="form" >
                <div class="row" style="height:85px">
                    <div class="col-md-12">
                        <div class="form-group pay_now_payment_type_credit_manual_entry_containers pay_now_payment_type_credit_manual_entry_card_number_container h-75" id="cardNumberContainer">
                            <label for="cardNumberContainer" class="w-100">Card Number</label>    
                        </div>
                    </div>
                </div>
                <div class="row" style="height:85px">
                    <div class="col-md-12">
                        <div class="form-group pay_now_payment_type_credit_manual_entry_containers pay_now_payment_type_credit_manual_entry_card_expiration_date_container h-75" id="expirationDateContainer">
                            <label for="expirationDateContainer" class="w-100">Card Expiration Date <small>(mm/yy)</small></label>
                        </div>
                    </div>
                </div>
                <div class="row" style="height:85px">
                    <div class="col-md-12">
                        <div class="form-group pay_now_payment_type_credit_manual_entry_containers pay_now_payment_type_credit_manual_entry_card_security_code_container h-75" id="securityCodeContainer">
                            <label for="securityCodeContainer" class="w-100">Card Security Code</label>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group pay_now_payment_type_credit_manual_entry_containers pay_now_payment_type_credit_manual_entry_amount_container" id="amountContainer"></div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class=" pay_now_payment_type_credit_process hidden pay_now_payment_type_credit_processing_response_manual_payment"></div>
                    </div>
                </div>
                <div class="row mt-2">
                    <!-- <div class="col-md-6 offset-md-3">
                        <div class="form-group">
                            <button type="button" class="btn btn-default btn-block pay_now_payment_type_credit_manual_entry_button" id="pay_now_payment_type_credit_manual_entry_button">Pay</button>
                        </div>
                    </div> -->
                    <div class="col-md-5 offset-md-1">
						<div class="form-group">
						    <button type="button" class="btn btn-default btn-block" data-dismiss="modal" aria-label="Close">Cancel</button>
						</div>
					</div>
					<div class="col-md-5">
					    <div class="form-group">
					        <button type="button" class="btn btn-default btn-block pay_now_payment_type_credit_manual_entry_button" id="pay_now_payment_type_credit_manual_entry_button">Pay</button>
					    </div>
					</div>
                </div>
                </form>
            </div>
        </div>
    </div>
  </div>
    <div class="response-overlay hidden" id="pay_now_manual_payment_modal_overlay"><i class="fa fa-refresh fa-spin"></i></div>
    </div>
  </div>
</div>
<!-- manual payment modal end here -->

<script type="text/javascript">
$(document).ready(function(){
    if($(".pay_now_payment_type[data-pay_now_payment_type_box=credit]").hasClass("disabled"))
    {
        $(".pay_now_payment_type[data-pay_now_payment_type_box=cash]").trigger("click");
    }
})


function lockPaymentModal(mode)
{
    if(mode)
    {
        //payment main modal
        $("#pay_now_modal").find(".close").addClass("hidden");
        if(typeof $("#pay_now_modal").data('bs.modal') != 'undefined')
            $("#pay_now_modal").data('bs.modal')._config.backdrop = 'static';

        //manual payment modal
        $("#pay_now_manual_payment_modal").find(".close").addClass("hidden");
        if(typeof $("#pay_now_manual_payment_modal").data('bs.modal') != 'undefined')
            $("#pay_now_manual_payment_modal").data('bs.modal')._config.backdrop = 'static';
    }
    else
    {
        //payment main modal
        $("#pay_now_modal").find(".close").removeClass("hidden");
        if(typeof $("#pay_now_modal").data('bs.modal') != 'undefined')
            $("#pay_now_modal").data('bs.modal')._config.backdrop = 'true';

        //manual payment modal
        $("#pay_now_manual_payment_modal").find(".close").removeClass("hidden");
        if(typeof $("#pay_now_manual_payment_modal").data('bs.modal') != 'undefined')
            $("#pay_now_manual_payment_modal").data('bs.modal')._config.backdrop = 'true';
    }
}

function processPaymentFromModal()
{
    lockPaymentModal(true)
    $(".pay_now_payment_complete_box .text-success").addClass("hide");
    if("<?=$open_cash_drawer_after_alltransaction?>" == 1)
    {
        openCashDrawer();   
    }
    $(".pay_now_payment_type").addClass('disabled');
    <?php /*?><?php if( ($this->sale_lib->get_customer()=='-1')   && ($this->sale_lib->get_cmandatory()=='1')){?>
    $('#finish_sale_button1').trigger('click');
    <?php } else if((isset($customer))){?>
    $('#finish_sale_button').trigger('click');
    <?php } else {?>
    $('#finish_sale_button2').trigger('click');
    <?php } ?><?php */?>
    post_finish_sale_form();
}

$(document).on("click",".pay_now_payment_type",function(){
	//if(!$(this).hasClass("active"))
	if(!$(this).hasClass("active") && !$(this).hasClass("disabled"))
	{
		$('#amount_tendered').val(0);
		$("#pay_now_payment_type_cash_amount_tendered").val(0);
		$(".pay_now_payment_complete_box").addClass('hidden');
		$(".pay_now_payment_complete_email_box").addClass('hidden');
		$(".pay_now_payment_type_credit_process").addClass('hidden');
		var pay_now_payment_type = $(this).data("pay_now_payment_type");
		$(".pay_now_payment_type_credit_tips button").removeClass("active");
		//var pay_now_total_amount = $("#pay_now_total_amount_value").html();
		var pay_now_payment_type_box = $(this).data("pay_now_payment_type_box");
		$(".pay_now_payment_type").removeClass("active");$(this).addClass("active");
		var pay_now_total_amount = $("#pay_now_total_amount_value").data("pay_now_total_amount_value");
		
		if(pay_now_payment_type == "<?=$pay_now_payment_type_cash?>")
		{
			var pay_now_payment_type_value = 1;
			//$(".pay_now_payment_type_cash_due_amount_value").html("Due : "+pay_now_total_amount);
		}
		
		if(pay_now_payment_type == "<?=$pay_now_payment_type_credit?>" || pay_now_payment_type == "<?=$pay_now_payment_type_giftcard?>")
		{
			$('#amount_tendered').val(pay_now_total_amount);
			$("#pay_now_payment_type_cash_amount_tendered").val(0);
			
			if(pay_now_payment_type == "<?=$pay_now_payment_type_credit?>")
			{
				var pay_now_payment_type_value = 5;
				$("input[name='gateway_transaction_check']").val(0);
				$(".pay_now_payment_type_credit_other_options").removeClass('hidden');
			}

			if(pay_now_payment_type == "<?=$pay_now_payment_type_giftcard?>")
			{
				var pay_now_payment_type_value = 3;
			}		
		}
		
		//alert(pay_now_payment_type);
		//alert(pay_now_payment_type_value);
		//$(".pay_now_payment_type_box").hide();
		//$(".pay_now_total_amount_value_box").hide();
        $("input[name='gateway_transaction_check']").val(pay_now_payment_type_value);
		$("#payment_types").val(pay_now_payment_type);
		$(".pay_now_payment_type_box").addClass("hidden");
		$(".pay_now_total_amount_value_box").addClass("hidden");
		$("input[name='payment_type_value']").val(pay_now_payment_type_value);
		$(".pay_now_payment_type_"+pay_now_payment_type_box).removeClass("hidden");
	
		if(pay_now_payment_type_value == 5)
		{
			//$('#start_sale_button').trigger('click');
			//processGravityPaymentsTransaction();
		}
	}
})

$(document).off("click",".pay_now_payment_type_credit_tips button").on("click",".pay_now_payment_type_credit_tips button",function()
{
	pay_now_total_amount = $("#pay_now_total_amount_value").data("pay_now_total_amount_value");
	pay_now_payment_type_credit_tip_value = $(this).data("pay_now_payment_type_credit_tip_value");
	pay_now_payment_type_credit_tip_amount = $(this).data("pay_now_payment_type_credit_tip_amount");
	$(".pay_now_payment_type_credit_tips button").removeClass("active");$(this).addClass("active");
	pay_now_total_amount = parseFloat(parseFloat(pay_now_total_amount)+parseFloat(pay_now_payment_type_credit_tip_amount)).toFixed(2);
	//pay_now_total_amount = parseFloat(parseFloat(pay_now_total_amount)*parseFloat(pay_now_payment_type_credit_tip_value))/parseFloat(100);
	$('#amount_tendered').val(pay_now_total_amount);$('.pay_now_payment_type_credit_total_amount_charged').removeClass("hidden");$('.pay_now_total_amount_charged_value').html("$"+pay_now_total_amount);
	var url = "<?php echo base_url();?>index.php/sales/add_tips";
	$.post(url, { value: pay_now_payment_type_credit_tip_value, amount: pay_now_payment_type_credit_tip_amount },
	function(response) {
		console.log(response);
	})
})

$(document).off("click",".pay_now_payment_type_cash_amount_pad button:not(.pay_now_modal_open_cash_drawer_btn)").on("click",".pay_now_payment_type_cash_amount_pad button:not(.pay_now_modal_open_cash_drawer_btn)",function()
{
	pay_now_payment_type_cash_tip = $(this).html().replace("$ ","");
	$('#amount_tendered').val(pay_now_payment_type_cash_tip);
	$(".pay_now_payment_type_cash_received").val(pay_now_payment_type_cash_tip);
    $(".pay_now_payment_type_cash_received").trigger("keyup");
})

$(document).off("click",".pay_now_payment_type_cash_number_pad button:not(.pay_now_payment_type_cash_backspace)").on("click",".pay_now_payment_type_cash_number_pad button:not(.pay_now_payment_type_cash_backspace)",function()
{
	pay_now_payment_type_cash_number_pad = $(this).html();
	var pay_now_payment_type_cash_number_pad_current_value = $(".pay_now_payment_type_cash_received").val();
	if(pay_now_payment_type_cash_number_pad_current_value == 0)pay_now_payment_type_cash_number_pad_current_value = "";
	var pay_now_payment_type_cash_number_pad_new_value = pay_now_payment_type_cash_number_pad_current_value+pay_now_payment_type_cash_number_pad;
	if((pay_now_payment_type_cash_number_pad == ".") && (pay_now_payment_type_cash_number_pad_current_value == "" || pay_now_payment_type_cash_number_pad_current_value == "$" || pay_now_payment_type_cash_number_pad_current_value.indexOf(".") != -1))
        return false;
	$('#amount_tendered').val(pay_now_payment_type_cash_number_pad_new_value);
	$(".pay_now_payment_type_cash_received").val(pay_now_payment_type_cash_number_pad_new_value);
    $(".pay_now_payment_type_cash_received").trigger("keyup");
})

$(document).off("click",".pay_now_payment_type_cash_backspace").on("click",".pay_now_payment_type_cash_backspace",function()
{
    var val = $(".pay_now_payment_type_cash_received").val();
    val = val.substring(0, val.length - 1);
    $(".pay_now_payment_type_cash_received").val(val); 
    $(".pay_now_payment_type_cash_received").trigger("keyup");
})

$(document.body).on('keyup','.pay_now_payment_type_cash_received',function()
{
    var total_amount = parseFloat($("#pay_now_total_amount_value").data("pay_now_total_amount_value"));
    var amount_received = $(this).val();
    amount_received = amount_received == "" ? 0 : parseFloat(amount_received);
    var amount_change = amount_received - total_amount;
    amount_change = amount_change.toFixed(2);
    $(".pay_now_payment_type_cash_change_amount_value").html("$"+amount_change);
})

$(document.body).on('focus','.pay_now_payment_type_cash_received',function()
{
    var val = $(this).val();
    if(val == 0)
    {
        $(this).val("");
    }
})

$(document.body).on('click','.pay_now_modal_open_cash_drawer_btn',function()
{
    openCashDrawer();
})

$(document.body).on('focusout','#pay_now_payment_type_cash_amount_tendered',function()
{
	$('#amount_tendered').val($('#pay_now_payment_type_cash_amount_tendered').val());
	
}).on('keypress','#pay_now_payment_type_cash_amount_tendered',function(e)
{
	$('#amount_tendered').val($('#pay_now_payment_type_cash_amount_tendered').val());	
		
}).on('paste','#pay_now_payment_type_cash_amount_tendered',function(e)
{
	$('#amount_tendered').val($('#pay_now_payment_type_cash_amount_tendered').val());
});

$(document.body).on('focusout','#pay_now_payment_type_gift_card_number',function()
{
	$('#amount_tendered').val($('#pay_now_payment_type_gift_card_number').val());
	
}).on('keypress','#pay_now_payment_type_gift_card_number',function(e)
{
	$('#amount_tendered').val($('#pay_now_payment_type_gift_card_number').val());	
		
}).on('paste','#pay_now_payment_type_gift_card_number',function(e)
{
	$('#amount_tendered').val($('#pay_now_payment_type_gift_card_number').val());
});

$(document).on("click","#pay_now_complete_sale_button",function()
{
    processPaymentFromModal();
})

$(document).on("click","#pay_now_payment_type_credit_retry_transaction",function()
{
	//processGravityPaymentsTransaction();
})

// manual payment
$(document).off("click",".pay_now_payment_type_credit_initiate_manual_payment").on("click",".pay_now_payment_type_credit_initiate_manual_payment",function()
{
    if($(".pay_now_payment_type_credit_manual_entry_containers iframe").length == 0)
        $("#pay_now_manual_payment_modal_overlay").removeClass("hidden");
    $("#pay_now_manual_payment_modal").modal("show");
	if($("#pay_now_manual_payment_modal").find("iframe").length == 0)
    loadGravityPaymentsTransactionManualEntry();
})

$(document).on("click",".pay_now_payment_type_credit_initiate_device",function()
{
    lockPaymentModal(true)
    $(".pay_now_payment_type_credit_other_options").addClass('hidden');
    $(".pay_now_payment_type_credit_processing").removeClass("hidden");
    var device_name = $(this).data("pay_now_payment_type_credit_device_name");
    processGravityPaymentsTransaction(device_name);
})

$(document).on("click","#pay_now_payment_type_show_all_payment_buttons",function()
{
    $(".pay_now_payment_type_credit_process").addClass('hidden');
    $(".pay_now_payment_type_credit_other_options").removeClass('hidden');
})

$(document).on("click","#pay_now_payment_type_start_new_sale",function()
{
    $("#new_sale_button").trigger("click");
})

$(document).on("click","#pay_now_payment_complete_print_button",function()
{
	window.print();
	document.location.href = "<?php echo site_url('sales/new_sale');?>"; 
})

$(document).on("click","#pay_now_payment_complete_skip_button",function()
{
    document.location.href = "<?php echo site_url('sales/new_sale');?>";
})

//idynamo code start here
var scanIdynamo = "";

$(document).off("click","#paynow_via_idynamo_payment").on("click","#paynow_via_idynamo_payment",function()
{
    $("#idynamo_form").validate({
        errorElement: "div",
        submitHandler: function(form) 
        { 
            $("#pay_now_overlay").removeClass("hidden");
            if(scanIdynamo != "")
            {
                clearInterval(scanIdynamo);
                $(".idynamo_scanning_area").addClass("hidden");
                $(".scan_card_via_idynamo").removeClass("hidden");                    
            }
            processPaymentFromModal();
        },
        wrapper: "div",
        rules: 
            {
                cc_no: {
                  required: true,
                  creditcard: true
                },
                cc_month: {
                  required: true,
                  number: true
                },
                cc_year: {
                  required: true,
                  number: true
                },
                cc_cvv: "required",
            },
            messages: 
            {
                cc_month: {
                  required: "Enter debit/credit card month",
                  number: "Enter valid debit/credit card month"
                },
                cc_year: {
                  required: "Enter debit/credit card year",
                  number: "Enter valid debit/credit card year"
                },
                cc_cvv: "Enter debit/credit card cvv code",
                // cc_name: "Enter debit/credit card name"               
            }
     });
})

$(document).off("click",".scan_card_via_idynamo").on("click",".scan_card_via_idynamo",function()
{   
    lockPaymentModal(true)
    $(".pay_now_payment_type").addClass('disabled');

    $(".scan_card_via_idynamo").addClass("hidden");
    $(".idynamo_scanning_area").removeClass("hidden");

    var d = new Date();
    var token = "<?php echo rand()."_".time(); ?>_"+d.getTime();
    initializeIdynamoDevice("<?=$account_name?>",token);
    var scanCounter = 0;
    scanIdynamo = setInterval(function(){
        scanCounter ++;
        var dataString = 'token='+token
        var url = "<?php echo base_url();?>index.php/sales/scan_idynamo";
        $.post(url, dataString,
            function(response) 
            {
                response = JSON.parse(response);
                if(response.result_found == 1)
                {
                    var card_details = response.result;
                    clearInterval(scanIdynamo);
                    $(".idynamo_scanning_area").addClass("hidden");
                    $(".scan_card_via_idynamo").removeClass("hidden");

                    //show maked card no on field
                    var maskedCardNo = "************"+card_details.cc_no.substr(card_details.cc_no.length - 4);
                    $("#idynamo_form_field_ccno_mask").val(maskedCardNo);

                    $("#idynamo_form [name=cc_no]").val(card_details.cc_no);
                    $("#idynamo_form [name=cc_month]").val(card_details.cc_month);
                    /*$("#idynamo_form [name=cc_year]").val(card_details.cc_year);*/
					var cc_year = card_details.cc_year;
					if(cc_year.length == 2)
						cc_year = "20"+cc_year;
					$("#idynamo_form [name=cc_year]").val(cc_year);
                    $("#idynamo_form [name=cc_cvv]").val(card_details.cc_cvv);
                    $("#paynow_via_idynamo_payment").trigger("click");
                }
            }
        )

        /*if(scanCounter >= 30)
        {
            clearInterval(scanIdynamo);
            $(".idynamo_scanning_area").addClass("hidden");
            $(".scan_card_via_idynamo").removeClass("hidden");
            lockPaymentModal(false);
            $(".pay_now_payment_type").removeClass('disabled');
        }    */  
    },2000)  
})

$(document).on("change","#idynamo_form_field_ccno_mask",function()
{ 
    var val = $("#idynamo_form_field_ccno_mask").val();
    $("#idynamo_form_field_ccno").val(val);
})

$(document).on("keyup","#idynamo_form_field_ccno_mask",function()
{ 
    var val = $("#idynamo_form_field_ccno_mask").val();
    $("#idynamo_form_field_ccno").val(val);
})

$(document).off("click",".cancel_idynamo_payment").on("click",".cancel_idynamo_payment",function()
{ 
    if(scanIdynamo != "")
    {
        clearInterval(scanIdynamo);
        $(".idynamo_scanning_area").addClass("hidden");
        $(".scan_card_via_idynamo").removeClass("hidden");    
    }
    lockPaymentModal(false);
    $(".pay_now_payment_type").removeClass('disabled');
    $("#pay_now_modal").trigger("click");
})
</script>

<style type="text/css">
.pay_now_modal_open_cash_drawer_btn
{
    width: 100% !important;
}
@media screen {
   /*.paynow_cashsale_print {display: none}*/
}
@media print {
  /*.content-wrapper {
    visibility: hidden;
  }
  .paynow_cashsale_print * {
    visibility: visible;
  }
  .paynow_cashsale_print {
    position: absolute;
    left: 0;
    top: 0;
  }*/
}
</style>
