<?php
class CashDrawers extends Main{
	
private $conn;
private $tableprefix;
	
public function  __construct()
	{
		$this->conn = $this->connect(DBHOST, DBUSER, DBPASSWORD);
        $this->usedatabase(CUSTOMERDB);
	}

public function getAvailableDrawers($saved_cash_drawer_id)
	{
		$tbl_cashdrawers = TBLPREFIX_OPOS."cashdrawers";
		$tbl_cashdrawers_assigning = TBLPREFIX_OPOS."cashdrawers_assigning";
		$fields = "*";
		$active_drawers =  $this->getRows($fields,$tbl_cashdrawers, " where status = 1 ");
		$available_drawers = array();
		foreach ($active_drawers as $active_drawer) 
		{
			$is_assigned = $this->getRow($fields,$tbl_cashdrawers_assigning, " where cashdrawer_id  = '".$active_drawer['id']."' and status = 1" );
			if($is_assigned == 0 || $saved_cash_drawer_id == $active_drawer['id'])
			{
				array_push($available_drawers, $active_drawer);
			}
		}
		return $available_drawers;
	}	
	
public function openShift($userid,$drawerid,$openingbalance)
{
	$data = array('user_id'=>$userid,'cashdrawer_id'=>$drawerid,'opening_balance'=>$openingbalance);
	$this->addData($data,TBLPREFIX_OPOS."cashdrawers_balance");
	return 1;
}

public function closeShift($userid,$drawerid,$closingbalance)
{
	$tbl_cashdrawers_balance = TBLPREFIX_OPOS."cashdrawers_balance";
	$balance_row = $this->getRow("*",$tbl_cashdrawers_balance, " where closing_balance = 0 and user_id  = '".$userid."' and cashdrawer_id = ".$drawerid );
	$this->updateData($balance_row['id'],array('closing_balance'=>$closingbalance,'closing_time'=>date('Y-m-d H:i:s')),$tbl_cashdrawers_balance,"id");
	return $this->generateReport($balance_row['id'],$drawerid);
	// return 1;
}

public function generateReport($drawerbalanceid,$drawerid)
{
	$tbl_sales =TBLPREFIX_OPOS."sales";
	$tbl_cashdrawer_balance = TBLPREFIX_OPOS."cashdrawers_balance";
	
	$drawer = $this->getRow("*",$tbl_cashdrawer_balance, " where id = ".$drawerbalanceid );
	
	$saleReport = $this->getRow("count(sale_id) as total_sales, sum(total_sale_amount) as total_amount",$tbl_sales, ' where drawer_id = '.$drawerid.' and mode = "sale" and drawer_balance_id = '.$drawerbalanceid.' and payment_type like "%Cash%"');

	$returnReport = $this->getRow("count(sale_id) as total_return, sum(total_sale_amount) as total_amount",$tbl_sales, ' where drawer_id = '.$drawerid.' and mode = "return" and drawer_balance_id = '.$drawerbalanceid.' and return_gateway_id = 0');

	$totalNoSale = $this->getRow("count(id) as total_no_sales",TBLPREFIX_OPOS."cashdrawer_log", ' where drawer_balance_id = '.$drawerbalanceid);

	$net_amount = $drawer['opening_balance'] + ($saleReport['total_amount'] + $returnReport['total_amount']);
	$difference = $drawer['closing_balance'] - $net_amount;

	$returnReport['total_amount'] = ($returnReport['total_amount'] * -1);

	$result = array(
					'opening_amount' => '$'.$drawer['opening_balance'],
					'closing_amount' => '$'.$drawer['closing_balance'],
					'drawer_open_counter' => $totalNoSale['total_no_sales'],
					'net_amount' => '$'.$net_amount,
					'difference' => '$'.$difference,
					'total_sales' => $saleReport['total_sales'],
					'sales_total_amount' => '$'.($saleReport['total_amount'] == "" ? 0 : $saleReport['total_amount']),
					'total_return' => $returnReport['total_return'],
					'return_total_amount' => '$'.($returnReport['total_amount'] == "" ? 0 : $returnReport['total_amount'])
					);
	return $result;
}


public function viewReportBeforeClose($userid,$drawerid)
{
	$tbl_cashdrawers_balance = TBLPREFIX_OPOS."cashdrawers_balance";
	$balance_row = $this->getRow("*",$tbl_cashdrawers_balance , " where closing_balance = 0 and user_id  = '".$userid."' and cashdrawer_id = ".$drawerid );
	$reportData = $this->generateReport($balance_row['id'],$drawerid);
	$reportData['difference'] = 'N/A';
	$reportData['closing_amount'] = 'Not Closed Yet';
	return $reportData;
}


public function checkShiftStatus($userid,$drawerid)
{
	$shift_row = $this->getRow("*",TBLPREFIX_OPOS."cashdrawers_balance", " where closing_balance = 0 and user_id  = '".$userid."' and cashdrawer_id = ".$drawerid );
	if($shift_row == 0)
		return 0;
	else
		return $shift_row['id'];
}

public function assignUnassignDrawer($drawerid,$store_id,$previous_drawer_id)
{
	$tbl_cashdrawers_assigning = TBLPREFIX_OPOS."cashdrawers_assigning";
	$is_assigned = 0;
	if($drawerid != "")
		$is_assigned = $this->getRow("*",$tbl_cashdrawers_assigning, " where cashdrawer_id  = ".$drawerid." and status = 1" );
	if($is_assigned == 0)
	{
		if($drawerid != "")
		{
			$assign_data = array('status'=>1,'cashdrawer_id'=>$drawerid,'store_id'=>$store_id);
			$this->addData($assign_data,$tbl_cashdrawers_assigning);
		}

		if($previous_drawer_id != "" && $previous_drawer_id != "null")
		{
			$assigned_row = $this->getRow("*",$tbl_cashdrawers_assigning, " where cashdrawer_id  = '".$previous_drawer_id."' and status = 1 and store_id = ". $store_id);
			$this->updateData($assigned_row['id'],array('status'=>0),$tbl_cashdrawers_assigning,"id");			
		}
		return 1;
	}
	else
	{
		return 0;
	}	
}

public function noSale($userid,$drawerid)
{
	$tbl_cashdrawers_balance = TBLPREFIX_OPOS."cashdrawers_balance";
	$balance_row = $this->getRow("*",$tbl_cashdrawers_balance , " where closing_balance = 0 and user_id  = '".$userid."' and cashdrawer_id = ".$drawerid );

	$data = array('drawer_balance_id'=>$balance_row['id'],'ts'=>date('Y-m-d H:i:s'));
	$this->addData($data,TBLPREFIX_OPOS."cashdrawer_log");
}
}
?>