<?php
include(CLASSES."Report.class.php");

class  Dashboard extends Report{

private $conn;

public function  __construct()
	{
		 $this->conn = $this->connect(DBHOST, DBUSER, DBPASSWORD);
		 $this->usedatabase(CUSTOMERDB);

		 /*
		 Create Temporary Tables for 
		 Sales and Receivings And Expenses
		 */
		 $this->create_sales_items_temp_table(); 
		 $this->create_receivings_items_temp_table(); 
		 $this->create_accounts_expenses_temp_table(); 
	}

/*Function to Get Dashboard Reports*/
public function getDashboardReports($where="",$orderby="",$limit="")
	{
		$fields =  "*";
		$dashboard_reports =  $this->getRows($fields,TBLPREFIX_SETTINGS."dashboard",  "  ".$where." ".$orderby." ".$limit);	
		return $dashboard_reports;
	}
	
/*Function to get Sales*/	
public function getSales($fields="*",$where="",$orderby="",$limit="")
	{
		$sales =  $this->getRows($fields,TBLPREFIX_OPOS."sales_items_temp","  ".$where." ".$orderby." ".$limit);
		return $sales;
	}
	
/*Function to get Expenses*/	
public function getExpenses($fields="*",$where="",$orderby="",$limit="")
	{
		$expenses =  $this->getRows($fields,TBLPREFIX_ACCOUNTING."accounts_expenses_temp","  ".$where." ".$orderby." ".$limit);
		return $expenses;
	}	
	
/*Function to get Customers*/	
public function getCustomers($fields = "*",$where="",$orderby="",$limit="")
	{
	    $tbl_people = TBLPREFIX_OPOS."people";
		$tbl_customer = TBLPREFIX_OPOS."customers";
	    $join_customers = " LEFT JOIN $tbl_people ON $tbl_customer.person_id = $tbl_people.person_id ";
		$customers = $this->getRows($fields,$tbl_customer, " ".$join_customers." WHERE deleted = 0 ".$where." ".$orderby." ".$limit." ");
		return $customers;	
	}
	
/*Function to get Sales Customers*/	
public function getSalesCustomers($fields =  "*",$where="",$orderby="",$limit="")
	{
		$tbl_people = TBLPREFIX_OPOS."people";
		$tbl_sales_items_temp = TBLPREFIX_OPOS."sales_items_temp";
		$join_salecustomers  = " INNER JOIN $tbl_people as customer ON $tbl_sales_items_temp.customer_id = customer.person_id ";
		$selling_customers =  $this->getRows($fields,$tbl_sales_items_temp," ".$join_salecustomers."  ".$where." ".$orderby." ".$limit);	
		return $selling_customers;	
	}
	
/*Function to get Sales Items*/	
public function getSalesItems($fields = "*",$where="",$orderby="",$limit="")
	{
		$tbl_items = TBLPREFIX_OPOS."items";
		$tbl_sales_items_temp = TBLPREFIX_OPOS."sales_items_temp";
		$join_sales_items  = " INNER JOIN $tbl_items ON $tbl_sales_items_temp.item_id = $tbl_items.item_id ";
		$selling_items =  $this->getRows($fields,$tbl_sales_items_temp," ".$join_sales_items."  ".$where." ".$orderby." ".$limit);	
		return $selling_items;	
	}				

/*Function to Get Top Sales*/
public function getTopSales($where="",$orderby="",$limit="")
	{
		/*$tbl_items = TBLPREFIX_OPOS."items";
		$tbl_sales_items = TBLPREFIX_OPOS."sales_items";
		$tbl_sales_items_taxes = TBLPREFIX_OPOS."sales_items_taxes";
	    $fields = "
	    $tbl_items.item_id,
		$tbl_items.name,
		$tbl_sales_items.line as line,
	    $tbl_sales_items.quantity_purchased as quantity_purchased, 
	    $tbl_sales_items.item_cost_price as item_cost_price, 
	    $tbl_sales_items.item_unit_price as item_unit_price,
	    $tbl_sales_items.discount_percent as discount_percent,
	    $tbl_sales_items.discount_amount as discount_amount,
		$tbl_sales_items.sale_id as sale_id,
		SUM($tbl_sales_items.quantity_purchased) as total_quantity_purchased, 
	    ROUND(item_unit_price*quantity_purchased-(item_unit_price*quantity_purchased*discount_percent/100)-discount_amount) as subtotal,	               
		ROUND((item_unit_price*quantity_purchased-(item_unit_price*quantity_purchased*discount_percent/100)-discount_amount)*(1+(SUM(percent)/100)),2) as total,
		ROUND((item_unit_price*quantity_purchased-(item_unit_price*quantity_purchased*discount_percent/100)-discount_amount)*(SUM(percent)/100),2) as tax,
	    ROUND(item_unit_price*quantity_purchased-(item_unit_price*quantity_purchased*discount_percent/100)-discount_amount) - (item_cost_price*quantity_purchased) as profit";
		$join_sales_items  = " INNER JOIN $tbl_items ON $tbl_sales_items.item_id = $tbl_items.item_id ";
		$join_sales_items .= " LEFT OUTER JOIN $tbl_sales_items_taxes ON $tbl_sales_items.sale_id = $tbl_sales_items_taxes.sale_id AND $tbl_sales_items.item_id = $tbl_sales_items_taxes.item_id AND $tbl_sales_items.line = $tbl_sales_items_taxes.line GROUP BY sale_id,item_id,line ";
		//$join_saleemployees = " left JOIN $tblemployee as employee ON $tble_tempSale.employee_id = employee.person_id  ";
		$sales =  $this->getRows($fields,$tbl_sales_items," ".$join_sales_items." " .$where." ".$orderby." ".$limit);*/
		$tbl_items = TBLPREFIX_OPOS."items";
		$tbl_sales_items_temp = TBLPREFIX_OPOS."sales_items_temp";
		$fields =  "*";
		$join_sales_items  = " INNER JOIN $tbl_items ON $tbl_sales_items_temp.item_id = $tbl_items.item_id ";
		$selling_items =  $this->getRows($fields,$tbl_sales_items_temp," ".$join_sales_items."  ".$where." ".$orderby." ORDER BY total DESC ".$limit);	
		return $selling_items;	
	}

/*Function to Get Top Sales Customers*/
public function getTopSalesCustomers($where="",$orderby="",$limit="")
	{
		/*$tbl_sales = TBLPREFIX_OPOS."sales";
	    $tbl_people = TBLPREFIX_OPOS."people";
		//$tbl_customers = TBLPREFIX_OPOS."customers";
		
		$fields = "$tbl_sales.sale_id,
				   $tbl_sales.customer_id,
				   $tbl_sales.employee_id,
				   $tbl_sales.plateform,
				   COUNT($tbl_sales.sale_id) as total_sale,
			       SUM($tbl_sales.totalSV) as total_sale_value,
			       SUM($tbl_sales.profit) as total_profit,
				   $tbl_people.person_id,
				   $tbl_people.first_name as first_name,
				   $tbl_people.m_name as middle_name,
				   $tbl_people.last_name as last_name,
				   $tbl_people.email as pos_email";

		//$join_salecustomers = " LEFT JOIN $tbl_customers ON $tbl_customers.person_id = $tbl_sales.customer_id ";
		$join_salecustomers = " INNER JOIN $tbl_people ON $tbl_people.person_id = $tbl_sales.customer_id AND $tbl_people.first_name IS NOT NULL ";
		//return "SELECT ".$fields." FROM ".$tbl_customers_applications. " ".$join_applications." ".$condition." ".$limit;	   
		$selling_customers = $this->getRows($fields,$tbl_sales, " ".$join_salecustomers." ".$where." WHERE $tbl_sales.customer_id IS NOT NULL AND $tbl_sales.customer_id!=0 AND $tbl_sales.plateform!=0 ".$orderby." GROUP BY $tbl_sales.customer_id ORDER BY total_sale_value DESC ".$limit);
		return $selling_customers;*/
		
		$tbl_people = TBLPREFIX_OPOS."people";
		$tbl_sales_items_temp = TBLPREFIX_OPOS."sales_items_temp";
		//$fields =  "*";
		$fields='sale_id, sale_date,customer_id,
				 COUNT(sale_id) as total_sale,
				 CONCAT(customer.first_name," ",customer.last_name) as customer_name,
				 SUM(subtotal) as subtotal, SUM(total) as total, SUM(tax) as tax,
				 SUM(profit) as profit';
		$join_salecustomers  = " INNER JOIN $tbl_people as customer ON $tbl_sales_items_temp.customer_id = customer.person_id AND customer.first_name IS NOT NULL ";
		$selling_customers =  $this->getRows($fields,$tbl_sales_items_temp," ".$join_salecustomers."  ".$where." WHERE $tbl_sales_items_temp.customer_id IS NOT NULL AND $tbl_sales_items_temp.customer_id!=0 AND $tbl_sales_items_temp.plateform!=0 ".$orderby." GROUP BY $tbl_sales_items_temp.customer_id ORDER BY total DESC ".$limit);	
		return $selling_customers;	
	}
	
/*Function to get Latest Items*/	
public function getLatestItems($where="",$orderby="",$limit="")
	{
		$fields =  "*";
		$latest_items =  $this->getRows($fields,TBLPREFIX_OPOS."items","  ".$where." ".$orderby." ".$limit);
		return $latest_items;
	}

/*Function to get Latest Customers*/	
public function getLatestCustomers($where="",$orderby="",$limit="")
	{
		$tbl_customer = TBLPREFIX_OPOS."customers";
	    $tbl_people = TBLPREFIX_OPOS."people";
	    $fields = "$tbl_customer.person_id,
				   $tbl_customer.ts,
				   $tbl_people.first_name,
				   $tbl_people.last_name,
				   $tbl_people.phone_number,
				   $tbl_people.email,
				   $tbl_people.address_1,
				   $tbl_people.address_2,
				   $tbl_people.city,
				   $tbl_people.state,
				   $tbl_people.zip,
				   $tbl_people.country,
				   $tbl_people.m_name";
		$join_customers = " LEFT JOIN $tbl_people ON $tbl_customer.person_id = $tbl_people.person_id ";
		//return "SELECT ".$fields." FROM ".$tbl_customers_applications. " ".$join_applications." ".$condition." ".$limit;	   
		$latest_customers = $this->getRows($fields,$tbl_customer, " ".$join_customers." WHERE deleted = 0 ".$where." ".$orderby." ".$limit." ");
		return $latest_customers;	
	}
	
/*Function to get Recent Activities*/	
public function getRecentActivities($where="",$orderby="",$limit="")
	{
		$fields = "*";
		$recent_activities = $this->getRows($fields,TBLPREFIX_USERMANAGEMENT."users_activitylog","  ".$where." ".$orderby." ".$limit);
		return $recent_activities;
	}
	
/*Function to get Sales Years*/	
public function getSalesYears($where="",$orderby="",$limit="")
	{
		$fields = " DISTINCT(YEAR(sale_time)) as year ";
		$sales_years = $this->getRows($fields,TBLPREFIX_OPOS."sales","  ".$where." ".$orderby." ".$limit);
		return $sales_years;
	}	
	
/*Function to get Total Orders*/	
public function getTotalOrders()
	{
		//$sales =  $this->getRows("COUNT(*) as total_orders",TBLPREFIX_OPOS."sales","WHERE plateform=2");
		if(checkTableFromDB(TBLPREFIX_SITEBUILDERCMS."VividStoreOrders",$this)==1)
		{
			$sales =  $this->getRows("COUNT(DISTINCT(oID)) as total_orders",TBLPREFIX_SITEBUILDERCMS."VividStoreOrders","");
			return $sales[0]['total_orders'];
		}
		else
		{
			return 0;
		}
		
	}
	
/*Function to get Total Sales*/	
public function getTotalSales()
	{
		//$sales = $this->getRows("COUNT(*) as total_sales",TBLPREFIX_OPOS."sales","WHERE plateform=1");
		//$sales = $this->getRows("COUNT(DISTINCT(sale_id)) as total_sales",TBLPREFIX_OPOS."sales_items_temp"," ");
		$sales = $this->getRow("SUM(total) as total_sales",TBLPREFIX_OPOS."sales_items_temp"," ");
		return $sales['total_sales'];
	}
	
/*Function to get Total Expenses*/	
public function getTotalExpenses()
	{
		$expenses = $this->getRow("SUM(amount) as total_expenses",TBLPREFIX_ACCOUNTING."accounts_expenses_temp"," ".$condition);
		return $expenses['total_expenses'];
	}	
	
/*Function to get Total Customers*/	
public function getTotalCustomers()
	{
		$customers = $this->getRow("COUNT(*) as total_customers",TBLPREFIX_OPOS."customers","");
		return $customers['total_customers'];
	}

/*Function to get Total Sales Customers*/	
public function getTotalSalesCustomers()
	{
		$tbl_sales_items_temp = TBLPREFIX_OPOS."sales_items_temp";
		$selling_customers = $this->getRow(" COUNT(DISTINCT(customer_id)) as total_customer ",TBLPREFIX_OPOS."sales_items_temp"," ");	
		return $selling_customers['total_customer'];	
	}
	
/*Function to get Total Items*/	
public function getTotalItems()
	{
		$items = $this->getRow("COUNT(*) as total_items",TBLPREFIX_OPOS."items","");
		return $items['total_items'];
	}	
	
/*Function to get Total Sales Items*/	
public function getTotalSalesItems()
	{
		$selling_items =  $this->getRow(" SUM(quantity_purchased) as total_sold_items ",TBLPREFIX_OPOS."sales_items_temp"," ");
		return $selling_items['total_sold_items'];
	}										
	
/*Function to Close Database Connection*/
public function close()
	{
		$this->close_db($this->conn);
	}

}
?>