<?php
class EcommerceCheckout extends Main{
	
private $conn;
private $account_name;
private $session_secure_checkout_data;
private $hash_string_letters = 'abcefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
	
public function  __construct($account_name)
	 {
		 $this->conn = $this->connect(DBHOST, DBUSER, DBPASSWORD);
		 if(!empty($account_name))
		 {
			 $this->account_name = $account_name;
			 $this->usedatabase(CUSTOMERDB_PREFIX.$account_name);
			 
			 /*Check C5 Customer Login and Session*/
			 if(isset($_COOKIE['secure_checkout_session']) && !empty($_COOKIE['secure_checkout_session']))
			 {
				 $secure_checkout_session = json_decode(base64_decode($_COOKIE['secure_checkout_session']));//print_r($secure_checkout_session);
				 if (!empty($secure_checkout_session)) 
				 {
					  if (!empty($secure_checkout_session->customer_is_login) && $secure_checkout_session->customer_is_login==1) 
					  {
						  $checkC5Users = $this->getUserData($secure_checkout_session->customer_uID);
						  if (!empty($checkC5Users)) 
						  {
							  $_SESSION[$account_name]['secure_checkout_data']['uID'] = $checkC5Users['uID'];
							  $_SESSION[$account_name]['secure_checkout_data']['checkout_customer_option'] = "login";
							  //print "<meta http-equiv=\"refresh\" content=\"0; url=\">";//exit();
						  }
					  }
					  else
					  {
						  unset($_SESSION[$account_name]['secure_checkout_data']['uID']);
						  //unset($_SESSION[$account_name]['secure_checkout_data']['checkout_customer_option']);
						  if($_SESSION[$account_name]['secure_checkout_data']['checkout_customer_option']!="guest")	
						  {unset($_SESSION[$account_name]['secure_checkout_data']['checkout_customer_option']);}
						  unset($_SESSION[$account_name]['secure_checkout_data']['checkout_selected_pane']);
					  }
					  unset($_COOKIE['secure_checkout_session']);
					  setcookie("secure_checkout_session", NULL, time() - 3600,"/checkout/");
				 }
			 }
			 
			 global $page_url;//print_r($page_url);
			 if(!empty($page_url) && !empty($page_url[2]) && ($page_url[2] == "logout"))
			 {
				 unset($_SESSION[$account_name]['secure_checkout_data']['uID']);
				 unset($_SESSION[$account_name]['secure_checkout_data']['checkout_customer_option']);
				 unset($_SESSION[$account_name]['secure_checkout_data']['checkout_selected_pane']);
				 unset($_COOKIE['secure_checkout_session']);
				 setcookie("secure_checkout_session", NULL, time() - 3600,"/checkout/");
				 $c5_logout_url = json_decode(base64_decode($page_url[3]));
				 /*if (isset($_SERVER['HTTPS']) && ($_SERVER["HTTPS"]==="on" || $_SERVER["HTTPS"]===1))
				 {$c5_logout_url = str_replace("http://","https://",$c5_logout_url);}*/
				 //$c5_logout_url = str_replace("http://","//",$c5_logout_url);
				 $c5_logout_url = ZBPATH."sitebuilder/".$account_name."/index.php";
				 $checkout_return_url = (DOMAIN."checkout/".$page_url[0]."/".$page_url[1]);
				 echo("<meta http-equiv='X-UA-Compatible' content='IE=edge'>");
				 echo("<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'> ");
				 echo '<link rel="stylesheet" href="'.PUBDIR.'bootstrap/source/css/bootstrap.css">';
				 echo '<script src="'.PUBDIR.'bootstrap/plugins/jQuery/jquery-2.2.3.min.js"></script>';
				 echo '<script>$(function(){$("#container_sitebuilder_logout").load("'.$c5_logout_url.'/login/cp_logout",function(responseTxt, statusTxt, xhr){if(statusTxt == "success"){window.location = "'.$checkout_return_url.'";}});})</script>';
				 echo("<br><br><br>");
				 echo("<div class='lockscreen-logo text-center'><img class='img-responsive' style='display:initial;' src='".RDIR."images/logout.gif'></div>");
				 echo("<div class='lockscreen-name text-center'>");
				 echo("<h5>Logging Out .....<h5>");
				 echo("</div>");
				 echo '<div id="container_sitebuilder_logout" style="display:none;height:0px;width:0px;overflow:hidden"></div>';
				 /*$c5_logout_results = cpGetCurl($c5_logout_url."/login/cp_logout");//echo $c5_logout_results[1];
				 if($c5_logout_results[1] == 1)
				 {
				 	print "<meta http-equiv=\"refresh\" content=\"0; url=$checkout_return_url\" />";
				 }*/
				 exit();
			 }
			 
			 $this->session_secure_checkout_data = $_SESSION[$account_name]['secure_checkout_data'];
		 }
	 }

/*Check Customer Store Activation*/	
public function checkCustomerStoreActivation()
	{
		/*Check Packages Table for Sitebuilder*/
		if(checkTableFromDB("Packages",$this)==1)
		{
			/*Check Ecommerce Activation in Sitebuilder(Concrete5)*/
			$checkPackageEcommerce = $this->getRow("*","Packages"," WHERE pkgHandle='vivid_store' ");
			if(!empty($checkPackageEcommerce))
			{
				return true;	
			}
			else
			{
				return false;
			}
		}
		else
		{
			return false;
		}
	}
	
/*Get Secure Checkout Data */
public function getSecureCheckoutData($secure_checkout_id)
	{
		if(!empty($secure_checkout_id))
		{
			return $getSecureCheckoutData = $this->getRow("*","VividStoreSecureCheckout"," WHERE scID='$secure_checkout_id' ");
		}
		else
		{
			return false;
		}
	}
	
/*Remove Secure Checkout Data */
public function removeSecureCheckoutData($secure_checkout_id)
	{
		if(!empty($secure_checkout_id))
		{
			return $this->removeData(" WHERE scID='$secure_checkout_id' ","VividStoreSecureCheckout");
		}
		else
		{
			return false;
		}
	}	
	
/*Get Secure Checkout Product Data */
public function getSCProductData($pID)
	{
		if(!empty($pID))
		{
			return $getSCProductData = $this->getRow("*","VividStoreProducts"," WHERE pID='$pID' ");
		}
		else
		{
			return false;
		}
	}
	
/*Get Secure Checkout Product Data */
public function getSCProductOptionGroup($pogID)
	{
		if(!empty($pogID))
		{
			return $getSCProductOptionGroup = $this->getRow("*","VividStoreProductOptionGroups"," WHERE pogID='$pogID' ");
		}
		else
		{
			return false;
		}
	}
	
/*Get Secure Checkout Product Data */
public function getSCProductOptionItem($poiID)
	{
		if(!empty($poiID))
		{
			return $getSCProductOptionItem = $this->getRow("*","VividStoreProductOptionItems"," WHERE poiID='$poiID' ");
		}
		else
		{
			return false;
		}
	}	
	
/*Get Customer Billing and Shipping Information*/
function getCustomerValue($type,$key)
	{
		//$_SESSION_SECURE_CHECKOUT_DATA = $_SESSION[$this->account_name]['secure_checkout_data'];
		$session_billing_shipping = $this->session_secure_checkout_data[$type."_information"];
		if(!empty($session_billing_shipping[$key]))
		{
			return $session_billing_shipping[$key];
		}
		else
		{
			$usersearchindexattributes_data = $this->getUserSearchIndexAttributes($this->session_secure_checkout_data['uID']);
			if(!empty($usersearchindexattributes_data[$key]))
			{
				return $usersearchindexattributes_data[$key];
			}
			else
			{
				return false;
			}
		}
	}
	
/*Get Data from User Data*/
public function getUserData($uID)
	{
		if(!empty($uID))
		{
			return $Users = $this->getRow("*","Users"," WHERE uID='$uID' ");
		}
		else
		{
			return false;
		}
	}

/*Get Data from UserSearchIndexAttributes*/
public function getUserSearchIndexAttributes($uID)
	{
		if(!empty($uID))
		{
			return $getUserSearchIndexAttributes = $this->getRow("*","UserSearchIndexAttributes"," WHERE uID='$uID' ");
		}
		else
		{
			return false;
		}
	}
	
/*Get User Validation Hash*/
public function getUserValidationHash($uID)
	{
		$table_c5_uservalidationhashes = "UserValidationHashes";
		$checkUserHash = $this->getRow("uHash",$table_c5_uservalidationhashes," WHERE uID='$uID' ORDER BY uDateGenerated DESC ");
        if (!empty($checkUserHash)) {
            return $checkUserHash['uHash'];
        } else {
			$uHash = $this->generateUserValidationHash($table_c5_uservalidationhashes, $column='uHash');
			$data_c5_usersvalidationhashes = array();
			$data_c5_usersvalidationhashes['uID'] = $uID;
			$data_c5_usersvalidationhashes['uHash'] = $uHash;
			$data_c5_usersvalidationhashes['uDateGenerated'] = time();
			$this->addData($data_c5_usersvalidationhashes,$table_c5_uservalidationhashes);
            return $uHash;
        }
	}		

/*Get Secure Checkout Configs */
public function getSCConfigs($data)
	{
		if(!empty($data['secure_checkout_id']))
		{
			$params = array();
			$params['action'] = "getConfigs";
			$params['account_name'] = $this->account_name;
			$params['secure_checkout_id'] = $data['secure_checkout_id'];
			return cpPostCurl($data['secure_checkout_url'],$params);
		}
		else
		{
			return false;
		}
	}

/*Get Secure Checkout Shipping Methods */
public function getSCShippingMethods($data)
	{
		if(!empty($data['secure_checkout_id']))
		{
			$params = array();
			$params['action'] = "getShippingMethods";
			$params['account_name'] = $this->account_name;
			$params['secure_checkout_id'] = $data['secure_checkout_id'];
			$params['shipping_information'] = json_encode($this->session_secure_checkout_data['shipping_information']);
			return cpPostCurl($data['secure_checkout_url'],$params);
		}
		else
		{
			return false;
		}
	}
	
/*Get Secure Checkout Payment Methods */
public function getSCPaymentMethods($data)
	{
		if(!empty($data['secure_checkout_id']))
		{
			$params = array();
			$params['action'] = "getPaymentMethods";
			$params['account_name'] = $this->account_name;
			$params['secure_checkout_id'] = $data['secure_checkout_id'];
			return cpPostCurl($data['secure_checkout_url'],$params);
		}
		else
		{
			return false;
		}
	}
	
/*Get Secure Checkout Payment Method Settings */
public function getSCPaymentMethodSettings($data)
	{
		if(!empty($data['secure_checkout_id']))
		{
			$params = array();
			$params['action'] = "getPaymentMethodSettings";
			$params['account_name'] = $this->account_name;
			$params['payment_method'] = $data['payment_method'];
			$params['secure_checkout_id'] = $data['secure_checkout_id'];
			return cpPostCurl($data['secure_checkout_url'],$params);
		}
		else
		{
			return false;
		}
	}		
	
/*Get Secure Checkout Taxes */
public function getSCTaxes($data)
	{
		if(!empty($data['secure_checkout_id']))
		{
			$params = array();
			$params['action'] = "getTaxes";
			$params['account_name'] = $this->account_name;
			$params['secure_checkout_id'] = $data['secure_checkout_id'];
			$params['shipping_method_id'] = $this->session_secure_checkout_data['checkout_shipping_method_id'];
			$params['billing_address_city'] = getBillingInformation("ak_billing_address_city");
			$params['billing_address_state_province'] = getBillingInformation("ak_billing_address_state_province");
			$params['billing_address_country'] = getBillingInformation("ak_billing_address_country");
			$params['shipping_address_city'] = getShippingInformation("ak_shipping_address_city");
			$params['shipping_address_state_province'] = getShippingInformation("ak_shipping_address_state_province");
			$params['shipping_address_country'] = getShippingInformation("ak_shipping_address_country");
			return cpPostCurl($data['secure_checkout_url'],$params);
		}
		else
		{
			return false;
		}
	}
	
/*Get Secure Checkout Shipping Total */
public function getSCShippingTotal($data)
	{
		if(!empty($data['secure_checkout_id']))
		{
			$params = array();
			$params['action'] = "getShippingTotal";
			$params['account_name'] = $this->account_name;
			$params['secure_checkout_id'] = $data['secure_checkout_id'];
			$params['shipping_method_id'] = $this->session_secure_checkout_data['checkout_shipping_method_id'];
			return cpPostCurl($data['secure_checkout_url'],$params);
		}
		else
		{
			return false;
		}
	}		

/*Get Secure Checkout Discounts */
public function getSCDiscounts($data)
	{
		if(!empty($data['secure_checkout_id']))
		{
			$params = array();
			$params['action'] = "getDiscounts";
			$params['account_name'] = $this->account_name;
			$params['secure_checkout_id'] = $data['secure_checkout_id'];
			return cpPostCurl($data['secure_checkout_url'],$params);
		}
		else
		{
			return false;
		}
	}

/*Get Secure Checkout Total */
public function getSCTotal($data)
	{
		if(!empty($data['secure_checkout_id']))
		{
			$params = array();
			$params['action'] = "getTotal";
			$params['account_name'] = $this->account_name;
			$params['secure_checkout_id'] = $data['secure_checkout_id'];
			$params['shipping_method_id'] = $this->session_secure_checkout_data['checkout_shipping_method_id'];
			$params['billing_address_city'] = getBillingInformation("ak_billing_address_city");
			$params['billing_address_state_province'] = getBillingInformation("ak_billing_address_state_province");
			$params['billing_address_country'] = getBillingInformation("ak_billing_address_country");
			$params['shipping_address_city'] = getShippingInformation("ak_shipping_address_city");
			$params['shipping_address_state_province'] = getShippingInformation("ak_shipping_address_state_province");
			$params['shipping_address_country'] = getShippingInformation("ak_shipping_address_country");
			return cpPostCurl($data['secure_checkout_url'],$params);
		}
		else
		{
			return false;
		}
	}	
	
/*Get Secure Checkout Totals */
public function getSCTotals($data)
	{
		if(!empty($data['secure_checkout_id']))
		{
			$params = array();
			$params['action'] = "getTotals";
			$params['account_name'] = $this->account_name;
			$params['secure_checkout_id'] = $data['secure_checkout_id'];
			$params['shipping_method_id'] = $this->session_secure_checkout_data['checkout_shipping_method_id'];
			$params['billing_address_city'] = getBillingInformation("ak_billing_address_city");
			$params['billing_address_state_province'] = getBillingInformation("ak_billing_address_state_province");
			$params['billing_address_country'] = getBillingInformation("ak_billing_address_country");
			$params['shipping_address_city'] = getShippingInformation("ak_shipping_address_city");
			$params['shipping_address_state_province'] = getShippingInformation("ak_shipping_address_state_province");
			$params['shipping_address_country'] = getShippingInformation("ak_shipping_address_country");
			return cpPostCurl($data['secure_checkout_url'],$params);
		}
		else
		{
			return false;
		}
	}
	
/*Complete Secure Checkout Order Process*/
public function completeSCOrder($data)
	{
		if(!empty($data['secure_checkout_id']))
		{
			$params = array();
			$params['action'] = "completeSecureCheckout";
			$params['account_name'] = $this->account_name;
			$params['secure_checkout_id'] = $data['secure_checkout_id'];
			$params['payment_method'] = $data['payment_method'];
			$params['payment_method_card_number'] = $data['payment_method_card_number'];
			$params['payment_method_card_name'] = $data['payment_method_card_name'];
			$params['payment_method_card_exp_month'] = $data['payment_method_card_exp_month'];
			$params['payment_method_card_exp_year'] = $data['payment_method_card_exp_year'];
			$params['payment_method_card_cvv_code'] = $data['payment_method_card_cvv_code'];
			$params['uID'] = $this->session_secure_checkout_data['uID'];
			$params['billing_information'] = json_encode($this->session_secure_checkout_data['billing_information']);
			$params['shipping_information'] = json_encode($this->session_secure_checkout_data['shipping_information']);
			$params['shipping_method_id'] = $this->session_secure_checkout_data['checkout_shipping_method_id'];

			$params['client_ip_address'] = $_SERVER['REMOTE_ADDR'];

			return cpPostCurl($data['secure_checkout_url'],$params);
		}
		else
		{
			return false;
		}
	}
	
/*Get Secure Checkout Order Data*/
public function getSCOrderData($oID)
	{
		if(!empty($oID))
		{
			return $getSCOrderData = $this->getRow("*","VividStoreOrders"," WHERE oID='$oID' ");
		}
		else
		{
			return false;
		}
	}
	
/*Get Secure Checkout Order Items Data*/
public function getSCOrderItemsData($oID)
	{
		if(!empty($oID))
		{
			return $getSCOrderItemsData = $this->getRows("*","VividStoreOrderItems"," WHERE oID='$oID' ");
		}
		else
		{
			return false;
		}
	}	
	
/*Get Secure Checkout Recurring Payments Data*/
public function getSCRecurringPaymentsData($rpoID)
	{
		if(!empty($rpoID))
		{
			return $getSCOrderItemsData = $this->getRows("*","VividStoreRecurringPayments"," WHERE rpoID='$rpoID' ");
		}
		else
		{
			return false;
		}
	}			
	
/*Update Secure Checkout Recurring Payments Data*/
public function updateSCRecurringPayment($data)
	{
		if(!empty($data['secure_checkout_id']))
		{
			/*Check VividStoreRecurringPayments table in Concrete5*/
			if(checkTableFromDB("VividStoreRecurringPayments",$this)==1)
			{
				/*Save Data in VividStoreRecurringPayments table in Concrete5*/
				/*$data_c5_recurring_payments['rpoID'] = $data['oID'];
				$data_c5_recurring_payments['rpuID'] = $data['uID'];
				$data_c5_recurring_payments['rpPaymentMethod'] = $data_c5['pmID'];
				$data_c5_recurring_payments['rpPeriod'] = $data_c5['uIsActive'];
				$data_c5_recurring_payments['uDateAdded'] = $data_c5['uDateAdded'];
				$data_c5_recurring_payments['uLastPasswordChange'] = $data_c5['uLastPasswordChange'];//print_r($data_c5_users);exit();*/
				$this->addData($data,"VividStoreRecurringPayments");
			}
		}
		else
		{
			return false;
		}
	}						
	
/*Create C5 User Data*/
public function createC5User($data_c5)
	{
		if(!empty($data_c5))
		{
			//print_r($data_c5);exit();
			$data_c5_users = array();
			
			/*Save Data in Users*/
			$data_c5_users['uName'] = $data_c5['uName'];
			$data_c5_users['uEmail'] = $data_c5['uEmail'];
			$data_c5_users['uPassword'] = $data_c5['uPassword'];
			$data_c5_users['uIsActive'] = $data_c5['uIsActive'];
			if (isset($data_c5['uIsValidated']) && $data_c5['uIsValidated'] == 1) {
				$data_c5_users['uIsValidated'] = 1;
			} elseif (isset($data_c5['uIsValidated']) && $data_c5['uIsValidated'] == 0) {
				$data_c5_users['uIsValidated'] = 0;
			} else {
				$data_c5_users['uIsValidated'] = -1;
			}
			$data_c5_users['uDateAdded'] = $data_c5['uDateAdded'];
			$data_c5_users['uLastPasswordChange'] = $data_c5['uLastPasswordChange'];//print_r($data_c5_users);exit();
			$uID = $this->addData($data_c5_users,"Users");
			
			/*Save Data in AttributeValues*/
			/*Save Profile Private Messages Enabled value in AttributeValues*/
			$data_c5_attribute_values = array();
			$data_c5_attribute_values['akID'] = 12;
			$data_c5_attribute_values['avDateAdded'] = TimeStamp();
			$data_c5_attribute_values['uID'] = $uID;
			$data_c5_attribute_values['atID'] = 3;
			$avID = $this->addData($data_c5_attribute_values,"AttributeValues");
			
			/*Save Profile Private Messages Enabled value in UserAttributeValues*/
			$data_c5_user_attribute_values = array();
			$data_c5_user_attribute_values['uID'] = $uID;
			$data_c5_user_attribute_values['akID'] = 12;
			$data_c5_user_attribute_values['avID'] = $avID;
			$this->addData($data_c5_user_attribute_values,"UserAttributeValues");
			
			/*Save Profile Private Messages Notification Enabled value in AttributeValues*/
			$data_c5_attribute_values = array();
			$data_c5_attribute_values['akID'] = 13;
			$data_c5_attribute_values['avDateAdded'] = TimeStamp();
			$data_c5_attribute_values['uID'] = $uID;
			$data_c5_attribute_values['atID'] = 3;
			$avID = $this->addData($data_c5_attribute_values,"AttributeValues");
			
			/*Save Profile Private Messages Notification Enabled value in UserAttributeValues*/
			$data_c5_user_attribute_values = array();
			$data_c5_user_attribute_values['uID'] = $uID;
			$data_c5_user_attribute_values['akID'] = 13;
			$data_c5_user_attribute_values['avID'] = $avID;
			$this->addData($data_c5_user_attribute_values,"UserAttributeValues");
			
			/*Save Data in UserGroups*/
			$data_c5_usergroups = array();
			$data_c5_usergroups['uID'] = $uID;
			$data_c5_usergroups['gID'] = 4;
			$data_c5_usergroups['ugEntered'] = TimeStamp();
			$this->addData($data_c5_usergroups,"UserGroups");
			
			/*Save Data in UserSearchIndexAttributes*/
			$data_c5_usersearchindexattributes = array();
			$data_c5_usersearchindexattributes['uID'] = $uID;
			$data_c5_usersearchindexattributes['ak_profile_private_messages_enabled'] = 1;
			$data_c5_usersearchindexattributes['ak_profile_private_messages_notification_enabled'] = 1;
			$this->addData($data_c5_usersearchindexattributes,"UserSearchIndexAttributes");
			
			/*Save Data in UserValidationHashes*/
			/*$data_c5_usersvalidationhashes = array();
			$data_c5_usersvalidationhashes['uID'] = $uID;
			$data_c5_usersvalidationhashes['uHash'] = generateUserValidationHash("UserValidationHashes", "uHash");
			$data_c5_usersvalidationhashes['uDateGenerated'] = time();
			$this->addData($data_c5_usersvalidationhashes,"UserValidationHashes");*/
			
			return $uID;
		}
		else
		{
			return false;
		}
	}				

/*Generate User Validation Hash*/
public function generateUserValidationHash($table, $column, $length = 12, $lowercase = false)
	{
		//$letters = 'abcefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
		$letters = $this->hash_string_letters;
		$foundHash = false;
		while ($foundHash == false) {
			$str = str_repeat($letters, 10);
			$hash_string = substr(str_shuffle($str), 0, $length);
			if ($lowercase) {
				$hash_string = strtolower($hash_string);
			}
			$cnt = countTableRows($table,$column,$where=" WHERE `$column`='$hash_string' ");
			if ($cnt < 1) {
				$foundHash = true;
			}
		}
		return $hash_string;
	}
	
/*Add User Validation Hash*/
public function addUserValidationHash($uID, $type, $singeHashAllowed = false, $hashLength = 64)
	{
		$letters = $this->hash_string_letters;
		$str = str_repeat($letters, 10);
		$hash_string = substr(str_shuffle($str), 0, $hashLength);
		$table_c5_uservalidationhashes = 'UserValidationHashes';
		if ($singeHashAllowed) {
			$this->removeData(" WHERE uID='$uID' AND `type`='$type' ",$table_c5_uservalidationhashes);
        }
        $data_c5_usersvalidationhashes = array();
		$data_c5_usersvalidationhashes['uID'] = $uID;
		$data_c5_usersvalidationhashes['uHash'] = $hash_string;
		$data_c5_usersvalidationhashes['uDateGenerated'] = time();
		$data_c5_usersvalidationhashes['type'] = intval($type);
		$this->addData($data_c5_usersvalidationhashes,$table_c5_uservalidationhashes);
		return $hash_string;
	}		
	
public function close()
	{
		$this->close_db($this->conn);
	}
	
}

/*Initialize Ecommerce Checkout Class*/
$sqlECClass = new EcommerceCheckout($account_name);

/*Get Billing Information*/
function getBillingInformation($key)
{
	/*global $_SESSION_SECURE_CHECKOUT_DATA;
	if(!empty($_SESSION_SECURE_CHECKOUT_DATA[$key]))
	{
		return $_SESSION_SECURE_CHECKOUT_DATA[$key];
	}
	else
	{
		global $usersearchindexattributes_data;
		if(!empty($usersearchindexattributes_data[$key]))
		{
			return $usersearchindexattributes_data[$key];
		}
		else
		{
			return false;
		}
	}*/
	global $sqlECClass;
	return $sqlECClass->getCustomerValue("billing",$key);
}

/*Get Shipping Information*/
function getShippingInformation($key)
{
	/*global $_SESSION_SECURE_CHECKOUT_DATA;
	if(!empty($_SESSION_SECURE_CHECKOUT_DATA[$key]))
	{
		return $_SESSION_SECURE_CHECKOUT_DATA[$key];
	}
	else
	{
		global $usersearchindexattributes_data;
		if(!empty($usersearchindexattributes_data[$key]))
		{
			return $usersearchindexattributes_data[$key];
		}
		else
		{
			return false;
		}
	}*/
	global $sqlECClass;
	return $sqlECClass->getCustomerValue("shipping",$key);
}
?>