<?php
include('InventoryManagement.class.php');
class IMRecieving extends InventoryManagement{
	
private $conn;
public $store;

	
public function  __construct()
	 {
		 $this->conn = $this->connect(DBHOST, DBUSER, DBPASSWORD);
		 $this->usedatabase(CUSTOMERDB);
		 
		 if(!getSession('recv_store'))
		 $this->store = "items";
		 else
		 $this->store = getSession('recv_store');

	 }
	 
public function get_cart()
	{
		if(!getSession('cartRecv'))
			$this->set_cart(array());

		return getSession('cartRecv');
	}

public function set_cart($cart_data)
	{
		setSession('cartRecv',$cart_data);
	}

public function get_supplier()
	{
		if(!getSession('supplier'))
			$this->set_supplier(-1);

		return getSession('supplier');
	}

public function set_supplier($supplier_id)
	{
		setSession('supplier',$supplier_id);
	}	 
	 
public function get_store()
	{
		if(!getSession('recv_store'))
			$this->set_store("items");

		return getSession('recv_store');
	}

public function set_store($store)
	{
		setSession('recv_store',$store);
	}

public function get_mode()
	{
		if(!getSession('recv_mode'))
			$this->set_mode(1);

		return getSession('recv_mode');
	}

public function set_mode($mode)
	{
		setSession('recv_mode',$mode);
	}	 
	 
public function get_item_search_suggestions($search_value,$limit=25){
	
	$suggestions = array();
	$tbl_items = TBLPREFIX_OPOS.$this->store;  
	$fields = "*";
	$by_name =  $this->getRows($fields,$tbl_items,  " WHERE deleted=0 AND status=1 AND ( name LIKE '%$search_value%') ORDER BY name ASC ");
	foreach($by_name as $row)
		{
			$suggestions[] = $row['item_id'].'|'.$row['name'];
		}
		
    $item_number =  $this->getRows($fields,$tbl_items,  " WHERE deleted=0 AND status=1 AND ( item_number LIKE '%$search_value%') ORDER BY item_number ASC ");
	foreach($item_number as $row)
		{
			$suggestions[] = $row['item_id'].'|'.$row['item_number'];  
		}
		
	if($this->get_mode() == 2)
	{
		$search_value = str_replace("recv ","",$search_value);
		$receivings = $this->getRows("*",TBLPREFIX_OPOS."receivings"," WHERE receiving_id LIKE '%$search_value%' ");
		foreach($receivings as $row)
			{
				$suggestions[] = "RECV ".$row['receiving_id'].'| RECV '.$row['receiving_id'];  
			}
	}
    
	if(count($suggestions > $limit))
		{
			$suggestions = array_slice($suggestions, 0,$limit);
		}
	return $suggestions;		
			
}

public function get_suppliers_search_suggestions($search_value,$limit=25){
	
	$suggestions = array();
	$tbl_suppliers    = TBLPREFIX_OPOS."suppliers";  
	$tbl_people    = TBLPREFIX_OPOS."people";  
	$left_join=" INNER JOIN $tbl_people ON $tbl_suppliers.person_id = $tbl_people.person_id AND $tbl_suppliers.status=1 AND $tbl_suppliers.deleted=0";
	$fields = "*";
	/*$condition = " WHERE deleted=0 AND status=1 AND 
	              ( 
				  	(company_name LIKE '%$search_value%') OR
					(first_name LIKE '%$search_value%') OR
					(last_name LIKE '%$search_value%') OR
					(CONCAT(`first_name`,' ',`last_name`) LIKE '%$search_value%')
				  ) 
				  ";*/
	$condition = " WHERE deleted=0 AND status=1 AND $tbl_suppliers.person_id!=0 AND 
	              ( 
				  	(company_name LIKE '%$search_value%')
				  ) 
				  ";			  
	$by_company_name = $this->getRows($fields,$tbl_suppliers,$left_join.$condition." ORDER BY first_name ASC ");
	foreach($by_company_name as $row)
		{
			$suggestions[] = $row['person_id'].'|'.$row['company_name'];
			//$suggestions[] = $row['person_id'].'|'.$row['first_name']." ".$row['last_name'];
		}
		
    $by_name =  $this->getRows($fields,$tbl_suppliers,$left_join.  " WHERE $tbl_suppliers.person_id!=0 AND ( first_name LIKE '%$search_value%') OR
	                          ( last_name LIKE '%$search_value%') OR
	                          ( CONCAT(`first_name`,' ',`last_name`) LIKE '%$search_value%')ORDER BY last_name ASC ");
	foreach($by_name as $row)
		{
			$suggestions[] = $row['person_id'].'|'.$row['first_name']." ".$row['last_name'];
		}
		
    /*$by_email =  $this->getRows($fields,$tbl_suppliers,$left_join.  " WHERE deleted=0 AND ( email LIKE '%$search_value%') ORDER BY email ASC ");
	foreach($by_email as $row)
		{
			$suggestions[] = $row['person_id'].'|'.$row['email'];
		
		}
		
    $by_phone =  $this->getRows($fields,$tbl_suppliers,$left_join.  " WHERE deleted=0 AND ( phone_number LIKE '%$search_value%') ORDER BY phone_number ASC ");
	foreach($by_phone as $row)
		{
			$suggestions[] = $row['person_id'].'|'.$row['phone_number'];
		
		}
		
    $by_account_number =  $this->getRows($fields,$tbl_suppliers,$left_join.  " WHERE deleted=0 AND ( account_number LIKE '%$search_value%') ORDER BY account_number ASC ");
	foreach($by_account_number as $row)
		{
			$suggestions[] = $row['person_id'].'|'.$row['account_number'];
		
		}*/				
    
	if(count($suggestions > $limit))
		{
			$suggestions = array_slice($suggestions, 0,$limit);
		}
	return $suggestions;		
			
}

public function create_receivings_items_temp_table()
	{
		$this->dbqueryexe("CREATE TEMPORARY TABLE ".TBLPREFIX_OPOS."receivings_items_temp
		(SELECT DATE(receiving_time) as receiving_date, ".TBLPREFIX_OPOS."receivings_items.receiving_id, comment,payment_type, employee_id, 
		".TBLPREFIX_OPOS."items.item_id, ".TBLPREFIX_OPOS."receivings.supplier_id, quantity_purchased, item_cost_price, item_unit_price,
		discount_percent, (item_unit_price*quantity_purchased-item_unit_price*quantity_purchased*discount_percent/100) as subtotal,
		".TBLPREFIX_OPOS."receivings_items.line as line, serialnumber, ".TBLPREFIX_OPOS."receivings_items.description as description,
		ROUND((item_unit_price*quantity_purchased-item_unit_price*quantity_purchased*discount_percent/100),2) as total,
		(item_unit_price*quantity_purchased-item_unit_price*quantity_purchased*discount_percent/100) - (item_cost_price*quantity_purchased) as profit
		FROM ".TBLPREFIX_OPOS."receivings_items INNER JOIN ".TBLPREFIX_OPOS."receivings ON  ".TBLPREFIX_OPOS."receivings_items.receiving_id=".TBLPREFIX_OPOS."receivings.receiving_id
		INNER JOIN ".TBLPREFIX_OPOS."items ON  ".TBLPREFIX_OPOS."receivings_items.item_id=".TBLPREFIX_OPOS."items.item_id
		GROUP BY receiving_id, item_id, line)");
	}
	
	
public function is_valid_receipt($receipt_receiving_id)
	{
		//RECV #
		$pieces = explode(' ',$receipt_receiving_id);
		
		if(count($pieces)==2)
		{
			//return $this->CI->Receiving->exists($pieces[1]);
			$checkRecieving = $this->getRow("*",TBLPREFIX_OPOS."receivings"," WHERE receiving_id='".$pieces[1]."' ");
		    //print_r($checkRecieving);
		    if(!empty($checkRecieving) && $checkRecieving['receiving_id'] == $pieces[1])
		    {
				return 1;
		    }
		}

		return false;
	}

public function return_entire_receiving($receipt_receiving_id)
	{
		//POS #
		$pieces = explode(' ',$receipt_receiving_id);
		$receiving_id = $pieces[1];

		$this->empty_cart();
		$this->delete_supplier();
		
		$receiving_items = $this->get_receiving_items($receiving_id);
		foreach($receiving_items as $row)
		{
			$this->add_item($row['item_id'],-$row['quantity_purchased'],$row['discount_percent'],$row['item_unit_price'],$row['description'],$row['serialnumber']);
		}
		
		/*Get Supplier Information*/
		$getSupplier = $this->getRow("*",TBLPREFIX_OPOS."receivings"," WHERE receiving_id='".$receiving_id."' ");
		$this->set_supplier($getSupplier['person_id']);
	}

public function copy_entire_receiving($receiving_id)
	{
		$this->empty_cart();
		$this->delete_supplier();

		$receiving_items = $this->get_receiving_items($receiving_id);
		foreach($receiving_items as $row)
		{
			//$this->add_item($row->item_id,$row->quantity_purchased,$row->discount_percent,$row->item_unit_price,$row->description,$row->serialnumber);
			$this->add_item($row['item_id'],-$row['quantity_purchased'],$row['discount_percent'],$row['item_unit_price'],$row['description'],$row['serialnumber']);
		}
		/*Get Supplier Information*/
		$getSupplier = $this->getRow("*",TBLPREFIX_OPOS."receivings"," WHERE receiving_id='".$receiving_id."' ");
		$this->set_supplier($getSupplier['person_id']);

	}
	
public function get_receiving_items($receiving_id)
	{
		return $receivings_items = $this->getRow("*",TBLPREFIX_OPOS."receivings_items", " WHERE receiving_id='$receiving_id' ");
	}
	
public function add_item($item_id,$quantity=1,$discount=0,$price=NULL,$description=NULL,$serialnumber=NULL)
	{
		//make sure item exists in database.
		$checkItem = $this->getRow("*",TBLPREFIX_OPOS.$this->store," WHERE item_id='".$item_id."' ");
		//print_r($checkCustomer);
		if(empty($checkItem) && $checkItem['item_id'] != $item_id)
		{
			//try to get item id given an item_number
			$checkItemNumber = $this->getRow("*",TBLPREFIX_OPOS.$this->store," WHERE item_number='".$item_id."' ");
			$item_id = $checkItemNumber['item_id'];
			if(!$item_id)
				return false;
		}
		
		//Get items in the receiving so far.
		$items = $this->get_cart();
		//print_r($items);
		//We need to loop through all items in the cart.
        //If the item is already there, get it's key($updatekey).
        //We also need to get the next key that we are going to use in case we need to add the
        //item to the list. Since items can be deleted, we can't use a count. we use the highest key + 1.

        $maxkey=0;                       //Highest key so far
        $itemalreadyinsale=FALSE;        //We did not find the item yet.
		$insertkey=0;                    //Key to use for new entry.
		$updatekey=0;                    //Key to use to update(quantity)

		foreach ($items as $item)
		{
            //We primed the loop so maxkey is 0 the first time.
            //Also, we have stored the key in the element itself so we can compare.
            //There is an array function to get the associated key for an element, but I like it better
            //like that!

			if($maxkey <= $item['line'])
			{
				$maxkey = $item['line'];
			}

			if($item['item_id']==$item_id)
			{
				$itemalreadyinsale=TRUE;
				$updatekey=$item['line'];
			}
		}

		$insertkey=$maxkey+1;
		
		//array records are identified by $insertkey and item_id is just another field.
		$item = array(($insertkey)=>
		array(
			'item_id'=>$item_id,
			'line'=>$insertkey,
			'name'=>$checkItem['name'],
			'description'=>$description!=NULL ? $description: $checkItem['description'],
			'serialnumber'=>$serialnumber!=NULL ? $serialnumber: '',
			'allow_alt_description'=>$checkItem['allow_alt_description'],
			'is_serialized'=>$checkItem['is_serialized'],
			'quantity'=>$quantity,
            'discount'=>$discount,
			'price'=>$price!=NULL ? $price: $checkItem['cost_price']
			)
		);

		//Item already exists
		if($itemalreadyinsale)
		{
			$items[$updatekey]['quantity']+=$quantity;
		}
		else
		{
			//add to existing array
			$items+=$item;
		}
		
		/*echo "<pre>";
		print_r($items);
		echo "</pre>";*/
		$this->set_cart($items);
		return true;
		
	}
	
public function edit_item($line,$quantity,$discount,$price,$description=NULL,$serialnumber=NULL)
	{
		$items = $this->get_cart();
		if(isset($items[$line]))
		{
			if($description!=NULL)$items[$line]['description'] = $description;
			if($serialnumber!=NULL)$items[$line]['serialnumber'] = $serialnumber;
			$items[$line]['quantity'] = $quantity;
			$items[$line]['discount'] = $discount;
			$items[$line]['price'] = $price;
			$this->set_cart($items);
		}

		return false;
	}	
	

public function delete_item($line)
	{
		$items = $this->get_cart();
		unset($items[$line]);
		$this->set_cart($items);
	}
	
public function get_total()
	{
		$total = 0;
		foreach($this->get_cart() as $item)
		{
            $total+=($item['price']*$item['quantity']-$item['price']*$item['quantity']*$item['discount']/100);
		}
		
		return $total;
	}
	
public function saveReceiving ($items,$supplier_id,$employee_id,$comment,$payment_type,$amount_tendered,$receiving_id=false)
	{
		if(count($items)==0)
			return -1;

		$suppl_info = $this->getRow("*",TBLPREFIX_OPOS."suppliers", " WHERE person_id='$supplier_id' ");//print_r($suppl_info);exit();
		$receivings_data = array(
			'supplier_id'=> !empty($suppl_info) ? $supplier_id : NULL,
			'employee_id'=>$employee_id,
			'payment_type'=>$payment_type,
			'amount_tendered'=>$amount_tendered,
			'comment'=>$comment
		);

		//Run these queries as a transaction, we want to make sure we do all or nothing
		//$this->db->trans_start();

		//$this->db->insert('receivings',$receivings_data);
	    $receiving_id = $this->addData($receivings_data,TBLPREFIX_OPOS."receivings"); 
		//$receiving_id = $this->db->insert_id();


		foreach($items as $line=>$item)
		{
			//$cur_item_info = $this->Item->get_info($item['item_id']);
			$cur_item_info = $this->getRow("*",TBLPREFIX_OPOS.$this->store, " WHERE item_id='".$item['item_id']."' ");//print_r($cur_item_info);exit();

			$receivings_items_data = array
			(
				'receiving_id'=>$receiving_id,
				'item_id'=>$item['item_id'],
				'line'=>$item['line'],
				'description'=>$item['description'],
				'serialnumber'=>$item['serialnumber'],
				'quantity_purchased'=>$item['quantity'],
				'discount_percent'=>$item['discount'],
				'item_cost_price' => $cur_item_info['cost_price'],
				'item_unit_price'=>$item['price']
			);

			//$this->db->insert('receivings_items',$receivings_items_data);
			$this->addData($receivings_items_data,TBLPREFIX_OPOS."receivings_items"); 

			//Update stock quantity
			$item_data = array('quantity'=>$cur_item_info['quantity'] + $item['quantity']);
			//$this->Item->save($item_data,$item['item_id']);
			$this->updateData($item['item_id'],$item_data,TBLPREFIX_OPOS.$this->store,"item_id");
			
			$qty_recv = $item['quantity'];
			$recv_remarks = 'RECV '.$receiving_id;
			if($this->store == "items"){$store = "main";}else{$store = $this->store;}
			$inv_data = array
			(
				'trans_date'=>date('Y-m-d H:i:s'),
				'trans_items'=>$item['item_id'],
				'trans_user'=>$employee_id,
				'trans_comment'=>$recv_remarks,
				'trans_inventory'=>$qty_recv,
				'store'=>$store
			);
			//$this->Inventory->insert($inv_data);
			$this->addData($inv_data,TBLPREFIX_OPOS."inventory"); 

			//$supplier = $this->Supplier->get_info($supplier_id);
		}
		/*$this->db->trans_complete();
		
		if ($this->db->trans_status() === FALSE)
		{
			return -1;
		}*/

		return $receiving_id;
	}						
	
public function empty_cart()
	{
		clearSession("cartRecv");
	}
	
public function delete_supplier()
	{
		clearSession("supplier");
	}
	
public function clear_mode()
	{
		clearSession("mode");
	}
	
public function clear_all()
	{
		$this->empty_cart();
		$this->delete_supplier();
		$this->clear_mode();
	}			
	

public function close()
	{
		$this->close_db($this->conn);
	}
	
}
?>