<?php include(ZBROOT."includes.inc.php");?>
<?php
/*Set Variables For Page Title and Meta Tags*/
$title = (!empty($applicationsModulesArray[$application_id][$module_id]['module_title']))?$applicationsModulesArray[$application_id][$module_id]['module_title']:APPLICATION_NAME." :: "."Accounting - Reports | COGS Report";
$description = (!empty($applicationsModulesArray[$application_id][$module_id]['module_keywords']))?$applicationsModulesArray[$application_id][$module_id]['module_keywords']:APPLICATION_NAME." :: "."Accounting - Reports | COGS Report";
$keywords = (!empty($applicationsModulesArray[$application_id][$module_id]['module_description']))?$applicationsModulesArray[$application_id][$module_id]['module_description']:APPLICATION_NAME." ::"."Accounting - Reports | COGS Report";
?>
<!-- Header Start -->
<?php include(ZBROOT."header_internal.php");?>
<!-- Header End -->

<!-- Left Menu Start -->
<?php include(ROOT.'includes'.DS.'left_menus.php'); ?>

<!-- Left Menu End --> 
<?php
include(CLASSES .'Accounting.class.php');
$accountingClass = new Accounting();

$select_duration =  !empty($_REQUEST['select_duration']) ? cleanSQL($_REQUEST['select_duration']) : 3;
$report_from_date =  !empty($_REQUEST['report_from_date']) ? cleanSQL($_REQUEST['report_from_date']) : "";
$report_to_date =  !empty($_REQUEST['report_to_date']) ? cleanSQL($_REQUEST['report_to_date']) : "";

include(ZBROOT."reports/accounting/accounting_reports_cogs_data.php");
?>     
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1>
     Reports <small>COGS Report</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="<?=ZBPATH?>dashboard"><i class="fa fa-dashboard"></i> Dashboard</a></li>
      <li><?=$application_title?></li>
      <li>Reports</li>
      <li class="active">COGS Report</a></li>
    </ol>
  </section>
  
  <!-- Main content -->
  <section class="content">
	<div class="row">
      <div class="col-md-12">
        <form id="accounting_reports_form" name="accounting_reports_form" action="<?=ZBPATH?>accounting/reports/cogs" method="post" role="form" class="no-print">
           <?php include(ROOT."accounting/reports_searchbox.php");?>  
        </form>
        <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title">COGS Report</h3>
            <div class="box-tools pull-right no-print">
                <button type="button" class="btn btn-sm btn-box-tool print_cogs_report"><i class="fa fa-print"></i>&nbsp;Print</button>
            	<a href="<?=ZBPATH?>accounting/reports/cogs/export/csv/<?=$select_duration?>/<?=$report_from_date?>/<?=$report_to_date?>">
                	<button type="button" class="btn btn-sm btn-box-tool"><i class="fa fa-file-excel-o"></i>&nbsp;Export as CSV</button>
                </a>
			</div>
          </div>
          <div class="box-body">
              <div class="box-body no-padding">
				<table id="inventory_list_table"class="table responsive">
				 <thead>
				    <tr style="height:40px;">
					  <th class="valign-center text-left">Title</th>
					  <th class="valign-center text-right">Cost</th>
				    </tr>
				 </thead> 
				 <tbody>
					<tr> 
                      <td class="valign-center text-left"><?=$xtitle?></td>
                      <td class="valign-center text-right"><?php echo $control_panel_currency_code." "?><?php if(!empty($xcost)){echo numberFormatDsiplay($xcost);}else{echo "0.00";}?></td>
					</tr>
					<tr>
                      <td class="valign-center text-left"><?=$ytitle?></td>
                      <td class="valign-center text-right"><?php echo $control_panel_currency_code." "?><?php if(!empty($ycost)){echo numberFormatDsiplay($ycost);}else{echo "0.00";}?></td>
					</tr>
					<tr>
                      <td class="valign-center text-left"><?=$ztitle?></td>
                      <td class="valign-center text-right"><?php echo $control_panel_currency_code." "?><?php if(!empty($zcost)){echo numberFormatDsiplay($zcost);}else{echo "0.00";}?></td>
					</tr>
					
				 </tbody>
                 <tfoot>
                 	<tr>
                      <td class="valign-center text-left text-bold">COGS</td>
                      <td class="valign-center text-right text-bold"><?php echo $control_panel_currency_code." ".numberFormatDsiplay(($xcost + $ycost) - $zcost) ;?></td>
				   </tr>
                 </tfoot>
			   </table>
              </div>
          </div>
        </div>  
      </div> 
    </div>  
  </section>  
</div>

<!-- JS Includes Start -->
<?php include(ZBROOT.'includes/footer_internal_includes.php'); ?> 
<!-- JS Includes Start -->

<script type="text/javascript">
$(function () {
  $('.footable').footable({
	calculateWidthOverride: function() {
	  return { width: $(window).width() };
	}
  });
  
  /*Print Expense Report*/
  $(document.body).on('click','.print_cogs_report',function(){	
	  window.print();	
  })
});
</script>                 
<script type="text/javascript">
$(document).ready(function() 
{
  $(document.body).on('change','#select_duration',function()
  {
	  //alert();
	  var select_duration = $("#select_duration").val();
	  if(select_duration==6)
	  {
		  $(".duration_by_date_div").css('display','block');
	  }
	  else
	  {
		  $(".duration_by_date_div").css('display','none');
		  $("#accounting_reports_form").submit();
	  }
	  
  });
  
  $(document.body).on('click','#search_sale_by_date',function()
  {
	  $("#accounting_reports_form").submit();		
  });
  
  $("#report_from_date").datepicker({
	  format: 'dd-mm-yyyy',
	  autoclose: true,
  }).on('changeDate', function (selected) {
	  var startDate = new Date(selected.date.valueOf());
	  $('#report_to_date').datepicker('setStartDate', startDate);
  }).on('clearDate', function (selected) {
	  $('#report_to_date').datepicker('setStartDate', null);
  });
  
  $("#report_to_date").datepicker({
	  format: 'dd-mm-yyyy',
	  autoclose: true,
  }).on('changeDate', function (selected) {
	  var endDate = new Date(selected.date.valueOf());
	  $('#report_from_date').datepicker('setEndDate', endDate);
  }).on('clearDate', function (selected) {
	  $('#report_from_date').datepicker('setEndDate', null);
  });
  
})
</script> 
<style>
@media print {
	.box {border-top: none;}
	.box-header.with-border,.box-body {border-bottom: none;}
}
</style>     
<!-- Footer Start -->  
<?php include(ZBROOT."footer_internal.php"); ?>
<!-- Footer End -->  
